/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptorBuilder;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.metadata.AbstractMetadataMethod;
import org.firebirdsql.jdbc.metadata.Clause;
import org.firebirdsql.jdbc.metadata.DbMetadataMediator;
import org.firebirdsql.jdbc.metadata.RowValueBuilder;
import org.firebirdsql.util.FirebirdSupportInfo;

public abstract class GetProcedures
extends AbstractMetadataMethod {
    private static final RowDescriptor ROW_DESCRIPTOR = new RowDescriptorBuilder(9, DbMetadataMediator.datatypeCoder).at(0).simple(449, 63, "PROCEDURE_CAT", "PROCEDURES").addField().at(1).simple(449, 63, "PROCEDURE_SCHEM", "ROCEDURES").addField().at(2).simple(448, 63, "PROCEDURE_NAME", "PROCEDURES").addField().at(3).simple(448, 31, "FUTURE1", "PROCEDURES").addField().at(4).simple(448, 31, "FUTURE2", "PROCEDURES").addField().at(5).simple(448, 31, "FUTURE3", "PROCEDURES").addField().at(6).simple(448, Integer.MAX_VALUE, "REMARKS", "PROCEDURES").addField().at(7).simple(500, 0, "PROCEDURE_TYPE", "PROCEDURES").addField().at(8).simple(448, 63, "SPECIFIC_NAME", "PROCEDURES").addField().toRowDescriptor();

    private GetProcedures(DbMetadataMediator mediator) {
        super(ROW_DESCRIPTOR, mediator);
    }

    public final ResultSet getProcedures(String procedureNamePattern) throws SQLException {
        if ("".equals(procedureNamePattern)) {
            return this.createEmpty();
        }
        DbMetadataMediator.MetadataQuery metadataQuery = this.createGetProceduresQuery(procedureNamePattern);
        return this.createMetaDataResultSet(metadataQuery);
    }

    @Override
    final RowValue createMetadataRow(ResultSet rs, RowValueBuilder valueBuilder) throws SQLException {
        return valueBuilder.at(2).setString(rs.getString("PROCEDURE_NAME")).at(6).setString(rs.getString("REMARKS")).at(7).setShort(rs.getShort("PROCEDURE_TYPE") == 0 ? 1 : 2).at(8).set(valueBuilder.get(2)).toRowValue(true);
    }

    abstract DbMetadataMediator.MetadataQuery createGetProceduresQuery(String var1);

    public static GetProcedures create(DbMetadataMediator mediator) {
        FirebirdSupportInfo firebirdSupportInfo = mediator.getFirebirdSupportInfo();
        if (firebirdSupportInfo.isVersionEqualOrAbove(3, 0)) {
            return FB3.createInstance(mediator);
        }
        return FB2_5.createInstance(mediator);
    }

    private static final class FB3
    extends GetProcedures {
        private static final String GET_PROCEDURES_FRAGMENT_3 = "select\n  trim(trailing from RDB$PROCEDURE_NAME) as PROCEDURE_NAME,\n  RDB$DESCRIPTION as REMARKS,\n  RDB$PROCEDURE_OUTPUTS as PROCEDURE_TYPE\nfrom RDB$PROCEDURES\nwhere RDB$PACKAGE_NAME is null\n";
        private static final String GET_PROCEDURES_ORDER_BY_3 = "order by RDB$PACKAGE_NAME, RDB$PROCEDURE_NAME";

        private FB3(DbMetadataMediator mediator) {
            super(mediator);
        }

        private static GetProcedures createInstance(DbMetadataMediator mediator) {
            return new FB3(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetProceduresQuery(String procedureNamePattern) {
            Clause procedureNameClause = new Clause("RDB$PROCEDURE_NAME", procedureNamePattern);
            String queryText = GET_PROCEDURES_FRAGMENT_3 + procedureNameClause.getCondition("and ", "\n") + GET_PROCEDURES_ORDER_BY_3;
            return new DbMetadataMediator.MetadataQuery(queryText, Clause.parameters(procedureNameClause));
        }
    }

    private static final class FB2_5
    extends GetProcedures {
        private static final String GET_PROCEDURES_FRAGMENT_2_5 = "select\n  RDB$PROCEDURE_NAME as PROCEDURE_NAME,\n  RDB$DESCRIPTION as REMARKS,\n  RDB$PROCEDURE_OUTPUTS as PROCEDURE_TYPE\nfrom RDB$PROCEDURES\n";
        private static final String GET_PROCEDURES_ORDER_BY_2_5 = "order by RDB$PROCEDURE_NAME";

        private FB2_5(DbMetadataMediator mediator) {
            super(mediator);
        }

        private static GetProcedures createInstance(DbMetadataMediator mediator) {
            return new FB2_5(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetProceduresQuery(String procedureNamePattern) {
            Clause procedureNameClause = new Clause("RDB$PROCEDURE_NAME", procedureNamePattern);
            String queryText = GET_PROCEDURES_FRAGMENT_2_5 + procedureNameClause.getCondition("where ", "\n") + GET_PROCEDURES_ORDER_BY_2_5;
            return new DbMetadataMediator.MetadataQuery(queryText, Clause.parameters(procedureNameClause));
        }
    }
}

