/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.counts;

import java.util.Objects;
import schemacrawler.schema.Table;

public final class TableRowCountsUtility {
    private static final int UNKNOWN_TABLE_ROW_COUNT = -1;
    private static final String TABLE_ROW_COUNT_KEY = "schemacrawler.table.row_count";

    public static long getRowCount(Table table) {
        if (table == null) {
            return -1L;
        }
        return table.getAttribute(TABLE_ROW_COUNT_KEY, -1L);
    }

    public static String getRowCountMessage(Number number) {
        Objects.requireNonNull(number, "No number provided");
        long longValue = number.longValue();
        if (longValue <= 0L) {
            return "empty";
        }
        return "%,d rows".formatted(longValue);
    }

    public static String getRowCountMessage(Table table) {
        return TableRowCountsUtility.getRowCountMessage(TableRowCountsUtility.getRowCount(table));
    }

    public static boolean hasRowCount(Table table) {
        return table != null && table.hasAttribute(TABLE_ROW_COUNT_KEY);
    }

    static void addRowCountToTable(Table table, long rowCount) {
        if (table != null) {
            if (rowCount >= 0L) {
                table.setAttribute(TABLE_ROW_COUNT_KEY, rowCount);
            } else {
                table.removeAttribute(TABLE_ROW_COUNT_KEY);
            }
        }
    }

    private TableRowCountsUtility() {
    }
}

