/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jna.fbclient;

import com.sun.jna.Structure;
import org.firebirdsql.jna.fbclient.XSQLVAR;

@Structure.FieldOrder(value={"version", "sqldaid", "sqldabc", "sqln", "sqld", "sqlvar"})
public class XSQLDA
extends Structure {
    public short version = 1;
    public byte[] sqldaid = new byte[8];
    public int sqldabc;
    public short sqln;
    public short sqld;
    public XSQLVAR[] sqlvar;

    public XSQLDA() {
        this(1);
    }

    public XSQLDA(int size) {
        this.sqld = this.sqln = (short)size;
        this.sqlvar = (XSQLVAR[])new XSQLVAR().toArray(size);
        this.allocateMemory();
    }

    public XSQLDA(short version, byte[] sqldaid, int sqldabc, short sqln, short sqld, XSQLVAR[] sqlvar) {
        this.version = version;
        if (sqldaid.length != this.sqldaid.length) {
            throw new IllegalArgumentException("Wrong array size !");
        }
        this.sqldaid = sqldaid;
        this.sqldabc = sqldabc;
        this.sqln = sqln;
        this.sqld = sqld;
        if (sqlvar.length != this.sqln) {
            throw new IllegalArgumentException("Wrong array size !");
        }
        this.sqlvar = (XSQLVAR[])new XSQLVAR().toArray(sqlvar);
        this.allocateMemory();
    }

    public static class ByValue
    extends XSQLDA
    implements Structure.ByValue {
    }

    public static class ByReference
    extends XSQLDA
    implements Structure.ByReference {
    }
}

