/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.range;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.range.PRange;

public final class PIntRange
extends PRange {
    private final int start;
    private final int stop;
    private final int step;
    private final int length;

    public PIntRange(PythonLanguage lang, int start, int stop, int step, int length) {
        super(lang);
        this.start = start;
        this.stop = stop;
        this.step = step;
        this.length = length;
    }

    @Override
    public Object getStart() {
        return this.getIntStart();
    }

    @Override
    public Object getStep() {
        return this.getIntStep();
    }

    @Override
    public Object getStop() {
        return this.getIntStop();
    }

    @Override
    public Object getLength() {
        return this.getIntLength();
    }

    public int getIntStart() {
        return this.start;
    }

    public int getIntStep() {
        return this.step;
    }

    public int getIntStop() {
        return this.stop;
    }

    public int getIntLength() {
        return this.length;
    }

    public int getIntItemNormalized(int index) {
        assert (index < this.length);
        return index * this.step + this.start;
    }

    @Override
    protected boolean withStep() {
        return this.step != 1;
    }
}

