/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib.fastpath;

import com.oracle.graal.python.builtins.objects.ints.IntBuiltins;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.truffle.PythonIntegerTypes;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;

@GenerateCached(value=false)
@TypeSystemReference(value=PythonIntegerTypes.class)
@ImportStatic(value={IntBuiltins.TrueDivNode.class})
public abstract class PyNumberTrueDivideFastPathsBase
extends BinaryOpNode {
    @Specialization(guards={"!isZero(right)"})
    public static double doDD(double left, double right) {
        return left / right;
    }

    @Specialization(guards={"right != 0"})
    public static double doDL(double left, long right) {
        return PyNumberTrueDivideFastPathsBase.doDD(left, right);
    }

    @Specialization(guards={"!isZero(right)"})
    public static double doLD(long left, double right) {
        return PyNumberTrueDivideFastPathsBase.doDD(left, right);
    }

    @Specialization(guards={"right != 0"})
    public static double doII(int left, int right) {
        return PyNumberTrueDivideFastPathsBase.doDD(left, right);
    }

    @Specialization(guards={"right != 0", "fitsIntoDouble(left)", "fitsIntoDouble(right)"})
    public static double doLL(long left, long right) {
        return PyNumberTrueDivideFastPathsBase.doDD(left, right);
    }

    public static boolean isZero(double right) {
        return right == 0.0;
    }
}

