/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.truffle;

import com.oracle.graal.python.nodes.truffle.PythonIntegerTypes;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.UnexpectedResultException;

@GeneratedBy(value=PythonIntegerTypes.class)
public final class PythonIntegerTypesGen
extends PythonIntegerTypes {
    protected PythonIntegerTypesGen() {
    }

    public static int expectImplicitInteger(int state, Object value) throws UnexpectedResultException {
        if ((state & 1) != 0 && value instanceof Integer) {
            return (Integer)value;
        }
        if ((state & 2) != 0 && value instanceof Boolean) {
            return PythonIntegerTypesGen.booleanToInt((Boolean)value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isImplicitInteger(int state, Object value) {
        return (state & 1) != 0 && value instanceof Integer || (state & 2) != 0 && value instanceof Boolean;
    }

    public static boolean isImplicitInteger(Object value) {
        return value instanceof Integer || value instanceof Boolean;
    }

    public static int asImplicitInteger(int state, Object value) {
        if (HostCompilerDirectives.inInterpreterFastPath()) {
            return PythonIntegerTypesGen.asImplicitInteger(value);
        }
        if ((state & 1) != 0 && value instanceof Integer) {
            return (Integer)value;
        }
        if ((state & 2) != 0 && value instanceof Boolean) {
            return PythonIntegerTypesGen.booleanToInt((Boolean)value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalArgumentException("Illegal implicit source type.");
    }

    public static int asImplicitInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Boolean) {
            return PythonIntegerTypesGen.booleanToInt((Boolean)value);
        }
        throw new IllegalArgumentException("Illegal implicit source type.");
    }

    public static int specializeImplicitInteger(Object value) {
        if (value instanceof Integer) {
            return 1;
        }
        if (value instanceof Boolean) {
            return 2;
        }
        return 0;
    }

    public static long expectImplicitLong(int state, Object value) throws UnexpectedResultException {
        if ((state & 1) != 0 && value instanceof Long) {
            return (Long)value;
        }
        if ((state & 2) != 0 && value instanceof Boolean) {
            return PythonIntegerTypesGen.booleanToLong((Boolean)value);
        }
        if ((state & 4) != 0 && value instanceof Integer) {
            return PythonIntegerTypesGen.intToLong((Integer)value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnexpectedResultException(value);
    }

    public static boolean isImplicitLong(int state, Object value) {
        return (state & 1) != 0 && value instanceof Long || (state & 2) != 0 && value instanceof Boolean || (state & 4) != 0 && value instanceof Integer;
    }

    public static boolean isImplicitLong(Object value) {
        return value instanceof Long || value instanceof Boolean || value instanceof Integer;
    }

    public static long asImplicitLong(int state, Object value) {
        if (HostCompilerDirectives.inInterpreterFastPath()) {
            return PythonIntegerTypesGen.asImplicitLong(value);
        }
        if ((state & 1) != 0 && value instanceof Long) {
            return (Long)value;
        }
        if ((state & 2) != 0 && value instanceof Boolean) {
            return PythonIntegerTypesGen.booleanToLong((Boolean)value);
        }
        if ((state & 4) != 0 && value instanceof Integer) {
            return PythonIntegerTypesGen.intToLong((Integer)value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalArgumentException("Illegal implicit source type.");
    }

    public static long asImplicitLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Boolean) {
            return PythonIntegerTypesGen.booleanToLong((Boolean)value);
        }
        if (value instanceof Integer) {
            return PythonIntegerTypesGen.intToLong((Integer)value);
        }
        throw new IllegalArgumentException("Illegal implicit source type.");
    }

    public static int specializeImplicitLong(Object value) {
        if (value instanceof Long) {
            return 1;
        }
        if (value instanceof Boolean) {
            return 2;
        }
        if (value instanceof Integer) {
            return 4;
        }
        return 0;
    }
}

