/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.automaton;

import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.ImmutableSortedListOfRanges;
import com.oracle.truffle.regex.tregex.automaton.AbstractState;
import com.oracle.truffle.regex.tregex.automaton.AbstractTransition;
import com.oracle.truffle.regex.tregex.automaton.BasicState;
import com.oracle.truffle.regex.tregex.automaton.StateIndex;
import com.oracle.truffle.regex.tregex.automaton.StateSet;
import com.oracle.truffle.regex.tregex.automaton.TransitionBuilder;
import com.oracle.truffle.regex.tregex.automaton.TransitionConstraint;
import com.oracle.truffle.regex.tregex.automaton.TransitionSet;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.buffer.IntArrayBuffer;
import com.oracle.truffle.regex.tregex.buffer.LongArrayBuffer;
import com.oracle.truffle.regex.tregex.buffer.ObjectArrayBuffer;
import com.oracle.truffle.regex.util.EmptyArrays;
import com.oracle.truffle.regex.util.TBitSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.IntFunction;
import org.graalvm.collections.EconomicSet;

public abstract class StateTransitionCanonicalizer<SI extends StateIndex<? super S>, S extends AbstractState<S, T>, T extends AbstractTransition<S, T>, TB extends TransitionBuilder<SI, S, T>> {
    private final ObjectArrayBuffer<T> argTransitions = new ObjectArrayBuffer();
    private final ObjectArrayBuffer<CodePointSet> argCharSets = new ObjectArrayBuffer();
    private final ObjectArrayBuffer<long[]> argConstraints = new ObjectArrayBuffer();
    private final ObjectArrayBuffer<long[]> argOperations = new ObjectArrayBuffer();
    private boolean anyArgConstraints;
    private final IntArrayBuffer stack = new IntArrayBuffer();
    private final IntArrayBuffer skipStack = new IntArrayBuffer();
    private final EconomicSet<ConstraintDeduplicationKey> constraintDeduplicationSet = EconomicSet.create();
    private static final int INITIAL_CAPACITY = 8;
    private TBitSet[] intersectingArgs = new TBitSet[8];
    private CodePointSet[] matcherBuilders = new CodePointSet[8];
    private long[][] constraintBuilder = new long[8][];
    private StateSet<SI, S>[] targetStateSets = new StateSet[8];
    private ObjectArrayBuffer<T>[] transitionLists = new ObjectArrayBuffer[8];
    private LongArrayBuffer[] operationLists = new LongArrayBuffer[8];
    private final TBitSet leadsToFinalState = new TBitSet(8);
    private int resultLength = 0;
    private int resultLengthStage1 = 0;
    private final SI stateIndex;
    private final boolean forward;
    private final boolean prioritySensitive;
    private final boolean booleanMatch;

    public StateTransitionCanonicalizer(SI stateIndex, boolean forward, boolean prioritySensitive, boolean booleanMatch) {
        this.stateIndex = stateIndex;
        this.forward = forward;
        this.prioritySensitive = prioritySensitive;
        this.booleanMatch = booleanMatch;
    }

    protected boolean isPrioritySensitive() {
        return this.prioritySensitive;
    }

    protected boolean isBooleanMatch() {
        return this.booleanMatch;
    }

    protected boolean shouldPruneAfterFinalState() {
        return this.isBooleanMatch() || this.isPrioritySensitive();
    }

    public void addArgument(T transition, CodePointSet charSet, long[] constraintsArg, long[] operations) {
        long[] constraints = constraintsArg;
        if (!TransitionConstraint.isNormalized(constraints)) {
            LongArrayBuffer temp = new LongArrayBuffer(constraints.length);
            temp.addAll(constraints);
            constraints = TransitionConstraint.normalize(temp);
        }
        assert (TransitionConstraint.isNormalized(constraints));
        this.argTransitions.add(transition);
        this.argCharSets.add(charSet);
        this.argConstraints.add(constraints);
        this.argOperations.add(operations);
        this.anyArgConstraints |= constraints.length > 0;
    }

    private void addToStack(T transition, CodePointSet charSet, long[] constraints, long[] operations, int j) {
        this.argTransitions.add(transition);
        this.argCharSets.add(charSet);
        this.argConstraints.add(constraints);
        this.argOperations.add(operations);
        this.stack.add(this.argTransitions.length() - 1);
        this.skipStack.add(j);
    }

    public TB[] run(CompilationBuffer compilationBuffer) {
        this.calcDisjointTransitions(compilationBuffer);
        TransitionBuilder[] result = this.mergeSameTargets(compilationBuffer);
        this.resultLength = 0;
        this.leadsToFinalState.clear();
        this.argTransitions.clear();
        this.argCharSets.clear();
        this.argConstraints.clear();
        this.argOperations.clear();
        this.anyArgConstraints = false;
        return result;
    }

    private void calcDisjointTransitions(CompilationBuffer compilationBuffer) {
        for (int i = 0; i < this.argTransitions.length(); ++i) {
            AbstractTransition argTransition = (AbstractTransition)this.argTransitions.get(i);
            CodePointSet argCharSet = this.argCharSets.get(i);
            long[] argOps = this.argOperations.get(i);
            int currentResultLength = this.resultLength;
            for (int j = 0; j < currentResultLength; ++j) {
                ImmutableSortedListOfRanges.IntersectAndSubtractResult<CodePointSet> result = this.matcherBuilders[j].intersectAndSubtract(argCharSet, compilationBuffer);
                CodePointSet rSubtractedMatcher = (CodePointSet)result.subtractedA;
                CodePointSet eSubtractedMatcher = (CodePointSet)result.subtractedB;
                CodePointSet intersection = (CodePointSet)result.intersection;
                if (!intersection.matchesSomething()) continue;
                if (rSubtractedMatcher.matchesNothing()) {
                    this.addTransitionToStage1(i, j, argTransition, argOps);
                } else {
                    this.matcherBuilders[j] = rSubtractedMatcher;
                    this.duplicateSlot(j, intersection, EmptyArrays.LONG);
                    this.intersectingArgs[this.resultLength].union(this.intersectingArgs[j]);
                    this.addTransitionToStage1(i, this.resultLength, argTransition, argOps);
                    ++this.resultLength;
                }
                argCharSet = eSubtractedMatcher;
                if (eSubtractedMatcher.matchesNothing()) break;
            }
            if (!argCharSet.matchesSomething()) continue;
            this.createSlot();
            this.targetStateSets[this.resultLength] = StateSet.create(this.stateIndex);
            this.matcherBuilders[this.resultLength] = argCharSet;
            this.addTransitionToStage1(i, this.resultLength, argTransition, argOps);
            ++this.resultLength;
        }
        if (!this.anyArgConstraints) {
            this.resultLengthStage1 = 0;
            return;
        }
        this.resultLengthStage1 = this.resultLength;
        for (int iStage1 = 0; iStage1 < this.resultLengthStage1; ++iStage1) {
            CodePointSet matcher = this.matcherBuilders[iStage1];
            PrimitiveIterator.OfInt argCharSet = this.intersectingArgs[iStage1].iterator();
            while (argCharSet.hasNext()) {
                int i = (Integer)argCharSet.next();
                this.addToStack((AbstractTransition)this.argTransitions.get(i), matcher, this.argConstraints.get(i), this.argOperations.get(i), this.resultLength);
            }
            this.constraintDeduplicationSet.clear();
            block4: while (!this.stack.isEmpty()) {
                int initial;
                int i = this.stack.pop();
                AbstractTransition argTransition = (AbstractTransition)this.argTransitions.get(i);
                long[] argConstraint = this.argConstraints.get(i);
                long[] argOperation = this.argOperations.get(i);
                assert (this.argCharSets.get(i).equals(matcher));
                int currentResultLength = this.resultLength;
                for (int j = initial = this.skipStack.pop(); j < currentResultLength; ++j) {
                    TransitionConstraint.MergeResult constraintMerge = TransitionConstraint.intersectAndSubtract(this.constraintBuilder[j], argConstraint);
                    if (constraintMerge == null) continue;
                    if (!this.shouldPruneAfterFinalState() || !this.leadsToFinalState.get(j)) {
                        if (constraintMerge.lhs().length == 0) {
                            this.addTransitionTo(j, argTransition, argOperation);
                        } else {
                            assert (TransitionConstraint.isNormalized(constraintMerge.lhs()[0]));
                            this.constraintBuilder[j] = constraintMerge.lhs()[0];
                            for (int k = 1; k < constraintMerge.lhs().length; ++k) {
                                this.duplicateSlot(j, matcher, constraintMerge.lhs()[k]);
                                ++this.resultLength;
                            }
                            this.duplicateSlot(j, matcher, constraintMerge.middle());
                            this.addTransitionTo(this.resultLength, argTransition, argOperation);
                            ++this.resultLength;
                        }
                    }
                    for (long[] rhs : constraintMerge.rhs()) {
                        if (!this.constraintDeduplicationSet.add((Object)new ConstraintDeduplicationKey(argTransition.getId(), rhs))) continue;
                        this.addToStack(argTransition, matcher, rhs, argOperation, j + 1);
                    }
                    continue block4;
                }
                assert (TransitionConstraint.isNormalized(argConstraint));
                this.createSlot();
                this.matcherBuilders[this.resultLength] = matcher;
                this.constraintBuilder[this.resultLength] = argConstraint;
                this.targetStateSets[this.resultLength] = StateSet.create(this.stateIndex);
                this.addTransitionTo(this.resultLength, argTransition, argOperation);
                ++this.resultLength;
            }
        }
    }

    private void duplicateSlot(int i, CodePointSet matcher, long[] constraints) {
        assert (TransitionConstraint.isNormalized(constraints));
        this.createSlot();
        this.targetStateSets[this.resultLength] = this.targetStateSets[i].copy();
        this.transitionLists[this.resultLength].addAll(this.transitionLists[i]);
        this.operationLists[this.resultLength].addAll(this.operationLists[i]);
        this.matcherBuilders[this.resultLength] = matcher;
        this.constraintBuilder[this.resultLength] = constraints;
        if (this.shouldPruneAfterFinalState() && this.leadsToFinalState.get(i)) {
            this.leadsToFinalState.set(this.resultLength);
        }
    }

    private void createSlot() {
        if (this.matcherBuilders.length <= this.resultLength) {
            this.transitionLists = Arrays.copyOf(this.transitionLists, this.resultLength * 2);
            this.operationLists = Arrays.copyOf(this.operationLists, this.resultLength * 2);
            this.targetStateSets = Arrays.copyOf(this.targetStateSets, this.resultLength * 2);
            this.matcherBuilders = Arrays.copyOf(this.matcherBuilders, this.resultLength * 2);
            this.constraintBuilder = (long[][])Arrays.copyOf(this.constraintBuilder, this.resultLength * 2);
            this.intersectingArgs = Arrays.copyOf(this.intersectingArgs, this.resultLength * 2);
        }
        if (this.transitionLists[this.resultLength] == null) {
            this.transitionLists[this.resultLength] = new ObjectArrayBuffer();
        }
        this.transitionLists[this.resultLength].clear();
        this.constraintBuilder[this.resultLength] = EmptyArrays.LONG;
        if (this.operationLists[this.resultLength] == null) {
            this.operationLists[this.resultLength] = new LongArrayBuffer();
        }
        this.operationLists[this.resultLength].clear();
        if (this.intersectingArgs[this.resultLength] == null) {
            this.intersectingArgs[this.resultLength] = new TBitSet(8);
        }
        this.intersectingArgs[this.resultLength].clear();
    }

    private void addTransitionToStage1(int iArg, int i, T transition, long[] operations) {
        if (this.anyArgConstraints) {
            this.intersectingArgs[i].set(iArg);
        } else {
            this.addTransitionTo(i, transition, operations);
        }
    }

    private void addTransitionTo(int i, T transition, long[] operations) {
        if (this.shouldPruneAfterFinalState() && this.leadsToFinalState.get(i)) {
            return;
        }
        this.operationLists[i].addAll(operations);
        Object target = transition.getTarget(this.forward);
        if (this.targetStateSets[i].add(target)) {
            this.transitionLists[i].add(transition);
            if (this.shouldPruneAfterFinalState()) {
                BasicState targetState = (BasicState)target;
                if (this.forward ? targetState.hasUnGuardedTransitionToUnAnchoredFinalState(true) : targetState.isUnAnchoredFinalState(false)) {
                    this.leadsToFinalState.set(i);
                }
            }
        }
    }

    private TB[] mergeSameTargets(CompilationBuffer compilationBuffer) {
        ObjectArrayBuffer<TransitionBuilder> resultBuffer1 = compilationBuffer.getObjectBuffer1();
        resultBuffer1.ensureCapacity(this.resultLength);
        for (int i = this.resultLengthStage1; i < this.resultLength; ++i) {
            resultBuffer1.add(this.createTransitionBuilder((AbstractTransition[])this.transitionLists[i].toArray((IntFunction<AbstractTransition[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, createTransitionArray(int ), (I)[Lcom/oracle/truffle/regex/tregex/automaton/AbstractTransition;)((StateTransitionCanonicalizer)this)), this.targetStateSets[i], this.matcherBuilders[i], this.constraintBuilder[i], this.operationLists[i].toArray()));
        }
        if (this.shouldPruneAfterFinalState() && this.leadsToFinalState.isEmpty() || this.anyArgConstraints) {
            return resultBuffer1.toArray(this.createResultArray(resultBuffer1.length()));
        }
        resultBuffer1.sort((o1, o2) -> {
            TransitionSet t1 = o1.getTransitionSet();
            TransitionSet t2 = o2.getTransitionSet();
            int cmp = t1.size() - t2.size();
            if (cmp != 0) {
                return cmp;
            }
            if (this.isPrioritySensitive()) {
                for (int i = 0; i < t1.size(); ++i) {
                    cmp = t1.getTransition(i).getTarget(this.forward).getId() - t2.getTransition(i).getTarget(this.forward).getId();
                    if (cmp == 0) continue;
                    return cmp;
                }
                return cmp;
            }
            Iterator i1 = t1.getTargetStateSet().iterator();
            Iterator i2 = t2.getTargetStateSet().iterator();
            while (i1.hasNext()) {
                assert (i2.hasNext());
                cmp = ((AbstractState)i1.next()).getId() - ((AbstractState)i2.next()).getId();
                if (cmp == 0) continue;
                return cmp;
            }
            return cmp;
        });
        ObjectArrayBuffer<TransitionBuilder> resultBuffer2 = compilationBuffer.getObjectBuffer2();
        TransitionBuilder last = null;
        for (TransitionBuilder tb : resultBuffer1) {
            if (last != null && this.canMerge(last, tb)) {
                last.setMatcherBuilder(last.getCodePointSet().union(tb.getCodePointSet(), compilationBuffer));
                continue;
            }
            resultBuffer2.add(tb);
            last = tb;
        }
        return resultBuffer2.toArray(this.createResultArray(resultBuffer2.length()));
    }

    protected abstract TB createTransitionBuilder(T[] var1, StateSet<SI, S> var2, CodePointSet var3, long[] var4, long[] var5);

    protected abstract boolean canMerge(TB var1, TB var2);

    protected abstract T[] createTransitionArray(int var1);

    protected abstract TB[] createResultArray(int var1);

    private record ConstraintDeduplicationKey(int transitionID, long[] constraints) {
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ConstraintDeduplicationKey)) {
                return false;
            }
            ConstraintDeduplicationKey o = (ConstraintDeduplicationKey)obj;
            return this.transitionID == o.transitionID && Arrays.equals(this.constraints, o.constraints);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.transitionID, Arrays.hashCode(this.constraints));
        }
    }
}

