/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.ClassNode;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.ImportNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.LiteralNode;
import com.oracle.js.parser.ir.NamedExportsNode;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.PropertyKey;
import com.oracle.js.parser.ir.VarNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Map;

public class ExportNode
extends Node {
    private final NamedExportsNode namedExports;
    private final LiteralNode<TruffleString> moduleSpecifier;
    private final PropertyKey exportIdent;
    private final VarNode var;
    private final Expression expression;
    private final boolean isDefault;
    private final Map<TruffleString, TruffleString> attributes;

    public ExportNode(long token, int start, int finish, PropertyKey ident, LiteralNode<TruffleString> moduleSpecifier, Map<TruffleString, TruffleString> attributes) {
        this(token, start, finish, null, moduleSpecifier, ident, null, null, false, attributes);
    }

    public ExportNode(long token, int start, int finish, NamedExportsNode exportClause, LiteralNode<TruffleString> moduleSpecifier, Map<TruffleString, TruffleString> attributes) {
        this(token, start, finish, exportClause, moduleSpecifier, null, null, null, false, attributes);
    }

    public ExportNode(long token, int start, int finish, PropertyKey ident, Expression expression, boolean isDefault) {
        this(token, start, finish, null, null, ident, null, expression, isDefault, Map.of());
    }

    public ExportNode(long token, int start, int finish, PropertyKey ident, VarNode var) {
        this(token, start, finish, null, null, ident, var, null, false, Map.of());
    }

    private ExportNode(long token, int start, int finish, NamedExportsNode namedExports, LiteralNode<TruffleString> moduleSpecifier, PropertyKey exportIdent, VarNode var, Expression expression, boolean isDefault, Map<TruffleString, TruffleString> attributes) {
        super(token, start, finish);
        this.namedExports = namedExports;
        this.moduleSpecifier = moduleSpecifier;
        this.exportIdent = exportIdent;
        this.var = var;
        this.expression = expression;
        this.isDefault = isDefault;
        this.attributes = Map.copyOf(attributes);
        assert (namedExports == null || exportIdent == null);
        assert (!isDefault || namedExports == null && moduleSpecifier == null);
        assert (var == null && expression == null || isDefault || exportIdent != null && exportIdent == ExportNode.getIdent(var, expression));
    }

    private ExportNode(ExportNode node, NamedExportsNode namedExports, LiteralNode<TruffleString> moduleSpecifier, PropertyKey exportIdent, VarNode var, Expression expression, Map<TruffleString, TruffleString> attributes) {
        super(node);
        this.isDefault = node.isDefault;
        this.namedExports = namedExports;
        this.moduleSpecifier = moduleSpecifier;
        this.exportIdent = exportIdent;
        this.var = var;
        this.expression = expression;
        this.attributes = Map.copyOf(attributes);
    }

    public NamedExportsNode getNamedExports() {
        return this.namedExports;
    }

    public LiteralNode<TruffleString> getModuleSpecifier() {
        return this.moduleSpecifier;
    }

    public PropertyKey getExportIdentifier() {
        return this.exportIdent;
    }

    public VarNode getVar() {
        return this.var;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public Map<TruffleString, TruffleString> getAttributes() {
        return this.attributes;
    }

    public ExportNode setExportClause(NamedExportsNode exportClause) {
        assert (this.exportIdent == null);
        if (this.namedExports == exportClause) {
            return this;
        }
        return new ExportNode(this, exportClause, this.moduleSpecifier, this.exportIdent, this.var, this.expression, this.attributes);
    }

    public ExportNode setFromSpecifier(LiteralNode<TruffleString> from) {
        assert (this.exportIdent == null);
        if (this.moduleSpecifier == from) {
            return this;
        }
        return new ExportNode(this, this.namedExports, from, this.exportIdent, this.var, this.expression, this.attributes);
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterExportNode(this)) {
            NamedExportsNode newExportClause = this.namedExports == null ? null : (NamedExportsNode)this.namedExports.accept(visitor);
            LiteralNode newFrom = this.moduleSpecifier == null ? null : (LiteralNode)this.moduleSpecifier.accept(visitor);
            VarNode newVar = this.var == null ? null : (VarNode)this.var.accept(visitor);
            Expression newExpression = this.expression == null ? null : (Expression)this.expression.accept(visitor);
            PropertyKey newIdent = this.exportIdent == null || this.isDefault() ? this.exportIdent : ExportNode.getIdent(newVar, newExpression);
            ExportNode newNode = this.namedExports == newExportClause && this.moduleSpecifier == newFrom && this.exportIdent == newIdent && this.var == newVar && this.expression == newExpression ? this : new ExportNode(this, this.namedExports, this.moduleSpecifier, this.exportIdent, this.var, this.expression, this.attributes);
            return visitor.leaveExportNode(newNode);
        }
        return this;
    }

    private static IdentNode getIdent(VarNode newVar, Expression newExpression) {
        if (newVar != null) {
            return newVar.getName();
        }
        if (newExpression instanceof FunctionNode) {
            return ((FunctionNode)newExpression).getIdent();
        }
        if (newExpression instanceof ClassNode) {
            return ((ClassNode)newExpression).getIdent();
        }
        return null;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> visitor) {
        return visitor.enterExportNode(this);
    }

    @Override
    public void toString(StringBuilder sb, boolean printType) {
        sb.append("export ");
        if (this.isDefault) {
            sb.append("default ");
        }
        if (this.expression != null) {
            this.expression.toString(sb, printType);
            if (this.expression.isAssignment()) {
                sb.append(';');
            }
        } else if (this.var != null) {
            this.var.toString(sb, printType);
            sb.append(';');
        } else {
            if (this.namedExports == null) {
                sb.append("* ");
                if (this.exportIdent != null) {
                    sb.append("as ").append(this.exportIdent);
                }
            } else {
                this.namedExports.toString(sb, printType);
            }
            if (this.moduleSpecifier != null) {
                sb.append(' ');
                sb.append("from");
                sb.append(' ');
                this.moduleSpecifier.toString(sb, printType);
                if (!this.attributes.isEmpty()) {
                    sb.append(" with ");
                    ImportNode.attributesToString(this.attributes, sb);
                }
            }
            sb.append(';');
        }
    }
}

