/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.datasource;

import java.sql.Connection;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.SQLRuntimeException;
import us.fatehi.utility.Utility;
import us.fatehi.utility.datasource.AbstractDatabaseConnectionSource;
import us.fatehi.utility.datasource.PooledConnectionUtility;
import us.fatehi.utility.datasource.UserCredentials;
import us.fatehi.utility.string.StringFormat;

final class SingleDatabaseConnectionSource
extends AbstractDatabaseConnectionSource {
    private static final Logger LOGGER = Logger.getLogger(SingleDatabaseConnectionSource.class.getName());
    private final Connection connection;

    SingleDatabaseConnectionSource(String connectionUrl, Map<String, String> connectionProperties, UserCredentials userCredentials, Consumer<Connection> connectionInitializer) {
        super(connectionInitializer);
        Utility.requireNotBlank(connectionUrl, "No database connection URL provided");
        Objects.requireNonNull(userCredentials, "No user credentials provided");
        String user = userCredentials.user();
        String password = userCredentials.password();
        Properties jdbcConnectionProperties = SingleDatabaseConnectionSource.createConnectionProperties(connectionUrl, connectionProperties, user, password);
        this.connection = SingleDatabaseConnectionSource.getConnection(connectionUrl, jdbcConnectionProperties);
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
    }

    @Override
    public Connection get() {
        this.connectionInitializer.accept(this.connection);
        LOGGER.log(Level.FINE, new StringFormat("Initialized database connection <%s> with <%s>", this.connection, this.connectionInitializer));
        return PooledConnectionUtility.newPooledConnection(this.connection, this);
    }

    @Override
    public boolean releaseConnection(Connection connection) {
        return true;
    }

    protected void finalize() throws Throwable {
        if (!this.connection.isClosed()) {
            throw new SQLRuntimeException("Connection pool is not closed");
        }
        super.finalize();
    }
}

