/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.cloud.impl;

import com.intellij.util.Url;
import com.intellij.util.Urls;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.cloud.QodanaCloudDefaultUrls;
import org.jetbrains.qodana.cloud.StateManager;
import org.jetbrains.qodana.cloud.UserState;
import org.jetbrains.qodana.cloud.impl.AuthorizingImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/qodana/cloud/impl/NotAuthorizedImpl;", "Lorg/jetbrains/qodana/cloud/UserState$NotAuthorized;", "stateManager", "Lorg/jetbrains/qodana/cloud/StateManager;", "Lorg/jetbrains/qodana/cloud/UserState;", "initialSelfHostedFrontendUrl", "Lcom/intellij/util/Url;", "<init>", "(Lorg/jetbrains/qodana/cloud/StateManager;Lcom/intellij/util/Url;)V", "defaultQodanaCloudFrontendUrl", "getDefaultQodanaCloudFrontendUrl", "()Lcom/intellij/util/Url;", "selfHostedFrontendUrl", "getSelfHostedFrontendUrl", "authorize", "Lorg/jetbrains/qodana/cloud/UserState$Authorizing;", "selfHostedUrl", "intellij.qodana"})
public final class NotAuthorizedImpl
implements UserState.NotAuthorized {
    @NotNull
    private final StateManager<UserState> stateManager;
    @Nullable
    private final Url selfHostedFrontendUrl;

    public NotAuthorizedImpl(@NotNull StateManager<UserState> stateManager, @Nullable Url initialSelfHostedFrontendUrl) {
        Intrinsics.checkNotNullParameter(stateManager, (String)"stateManager");
        this.stateManager = stateManager;
        this.selfHostedFrontendUrl = Intrinsics.areEqual((Object)this.getDefaultQodanaCloudFrontendUrl(), (Object)initialSelfHostedFrontendUrl) ? null : initialSelfHostedFrontendUrl;
    }

    private final Url getDefaultQodanaCloudFrontendUrl() {
        return Urls.newFromEncoded((String)QodanaCloudDefaultUrls.INSTANCE.getWebsiteUrl());
    }

    @Override
    @Nullable
    public Url getSelfHostedFrontendUrl() {
        return this.selfHostedFrontendUrl;
    }

    @Override
    @Nullable
    public UserState.Authorizing authorize(@Nullable Url selfHostedUrl) {
        Url correctedSelfHostedFrontendUrl = Intrinsics.areEqual((Object)selfHostedUrl, (Object)this.getDefaultQodanaCloudFrontendUrl()) ? null : selfHostedUrl;
        AuthorizingImpl authorizing = new AuthorizingImpl(this.stateManager, correctedSelfHostedFrontendUrl);
        return this.stateManager.changeState(this, authorizing);
    }
}

