/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.events.EventDefinition;
import io.ktor.events.Events;
import io.ktor.events.EventsKt;
import io.ktor.http.HttpStatusCode;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.DefaultApplicationEventsKt;
import io.ktor.server.application.ServerConfig;
import io.ktor.server.config.ApplicationConfigValue;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineFactory;
import io.ktor.server.engine.ClassLoadersKt;
import io.ktor.server.engine.EmbeddedServerJvmKt;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.OverridingClassLoader;
import io.ktor.server.engine.ServerHostUtilsKt;
import io.ktor.server.engine.ShutdownHookKt;
import io.ktor.server.engine.internal.AutoReloadUtilsKt;
import io.ktor.server.engine.internal.CallableUtilsKt;
import io.ktor.server.engine.internal.EngineUtilsJvmKt;
import io.ktor.server.engine.internal.ReloadingException;
import io.ktor.util.Attributes;
import io.ktor.util.pipeline.Pipeline;
import io.ktor.utils.io.ByteReadChannel;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.io.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u0001*\b\b\u0001\u0010\u0004*\u00020\u00032\u00020\u0005B>\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0019\b\u0002\u0010\r\u001a\u0013\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\b\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001b\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ%\u0010\u001e\u001a\u00020\u000b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001b2\u0006\u0010\u001d\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b \u0010\u0011J\u001d\u0010$\u001a\u00020\u000b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002\u00a2\u0006\u0004\b$\u0010%J#\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010'\u001a\u00020&\u00a2\u0006\u0004\b(\u0010)J%\u0010/\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*2\u0006\u0010.\u001a\u00020-\u00a2\u0006\u0004\b/\u00100J!\u0010/\u001a\u00020\u000b2\b\b\u0002\u00101\u001a\u00020*2\b\b\u0002\u00102\u001a\u00020*\u00a2\u0006\u0004\b/\u00103J\u0017\u00105\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b5\u00106J'\u0010:\u001a\u00020\u000b2\u0006\u00108\u001a\u0002072\u0006\u00104\u001a\u00020\u00162\u0006\u00109\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b:\u0010;J\u001d\u0010>\u001a\u00020\u000b2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u000b0<H\u0002\u00a2\u0006\u0004\b>\u0010?J%\u0010A\u001a\u00020\u000b2\u0006\u0010@\u001a\u0002072\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u000b0<H\u0002\u00a2\u0006\u0004\bA\u0010BJ\u000f\u0010C\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\bC\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010DR\u0017\u0010F\u001a\u00020E8\u0006\u00a2\u0006\f\n\u0004\bF\u0010G\u001a\u0004\bH\u0010IR\u0017\u0010K\u001a\u00020J8\u0006\u00a2\u0006\f\n\u0004\bK\u0010L\u001a\u0004\bM\u0010NR\u0011\u0010\u001d\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\bO\u0010\u0014R\u0017\u0010P\u001a\u00028\u00018\u0006\u00a2\u0006\f\n\u0004\bP\u0010Q\u001a\u0004\bR\u0010SR\u0014\u0010U\u001a\u00020T8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bU\u0010VR\u0016\u0010W\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bW\u0010XR\u0018\u0010Y\u001a\u0004\u0018\u00010\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bY\u0010ZR\u001c\u0010\\\u001a\b\u0012\u0004\u0012\u00020[0!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\\\u0010]R\u001a\u0010^\u001a\b\u0012\u0004\u0012\u0002070!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b^\u0010]R\u001a\u0010_\u001a\b\u0012\u0004\u0012\u0002070!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b_\u0010]R\u001a\u0010`\u001a\b\u0012\u0004\u0012\u0002070!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b`\u0010]R\u001a\u0010a\u001a\b\u0012\u0004\u0012\u0002070!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\ba\u0010]R\u0018\u0010b\u001a\u0004\u0018\u00010\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bb\u0010cR\u0017\u0010d\u001a\u00028\u00008\u0006\u00a2\u0006\f\n\u0004\bd\u0010e\u001a\u0004\bf\u0010gR\u001d\u0010m\u001a\u0004\u0018\u00010h8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bi\u0010j\u001a\u0004\bk\u0010l\u00a8\u0006n"}, d2={"Lio/ktor/server/engine/EmbeddedServer;", "Lio/ktor/server/engine/ApplicationEngine;", "TEngine", "Lio/ktor/server/engine/ApplicationEngine$Configuration;", "TConfiguration", "", "Lio/ktor/server/application/ServerConfig;", "rootConfig", "Lio/ktor/server/engine/ApplicationEngineFactory;", "engineFactory", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "engineConfigBlock", "<init>", "(Lio/ktor/server/application/ServerConfig;Lio/ktor/server/engine/ApplicationEngineFactory;Lkotlin/jvm/functions/Function1;)V", "reload", "()V", "Lio/ktor/server/application/Application;", "currentApplication", "()Lio/ktor/server/application/Application;", "Lkotlin/Pair;", "Ljava/lang/ClassLoader;", "createApplication", "()Lkotlin/Pair;", "createClassLoader", "()Ljava/lang/ClassLoader;", "Lio/ktor/events/EventDefinition;", "event", "application", "safeRaiseEvent", "(Lio/ktor/events/EventDefinition;Lio/ktor/server/application/Application;)V", "destroyApplication", "", "Ljava/net/URL;", "urls", "watchUrls", "(Ljava/util/List;)V", "", "wait", "start", "(Z)Lio/ktor/server/engine/EmbeddedServer;", "", "shutdownGracePeriod", "shutdownTimeout", "Ljava/util/concurrent/TimeUnit;", "timeUnit", "stop", "(JJLjava/util/concurrent/TimeUnit;)V", "gracePeriodMillis", "timeoutMillis", "(JJ)V", "currentClassLoader", "instantiateAndConfigureApplication", "(Ljava/lang/ClassLoader;)Lio/ktor/server/application/Application;", "", "name", "newInstance", "launchModuleByName", "(Ljava/lang/String;Ljava/lang/ClassLoader;Lio/ktor/server/application/Application;)V", "Lkotlin/Function0;", "block", "avoidingDoubleStartup", "(Lkotlin/jvm/functions/Function0;)V", "fqName", "avoidingDoubleStartupFor", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "cleanupWatcher", "Lio/ktor/server/application/ServerConfig;", "Lio/ktor/events/Events;", "monitor", "Lio/ktor/events/Events;", "getMonitor", "()Lio/ktor/events/Events;", "Lio/ktor/server/application/ApplicationEnvironment;", "environment", "Lio/ktor/server/application/ApplicationEnvironment;", "getEnvironment", "()Lio/ktor/server/application/ApplicationEnvironment;", "getApplication", "engineConfig", "Lio/ktor/server/engine/ApplicationEngine$Configuration;", "getEngineConfig", "()Lio/ktor/server/engine/ApplicationEngine$Configuration;", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "applicationInstanceLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "recreateInstance", "Z", "_applicationClassLoader", "Ljava/lang/ClassLoader;", "Ljava/nio/file/WatchKey;", "packageWatchKeys", "Ljava/util/List;", "configuredWatchPath", "watchPatterns", "configModulesNames", "modulesNames", "_applicationInstance", "Lio/ktor/server/application/Application;", "engine", "Lio/ktor/server/engine/ApplicationEngine;", "getEngine", "()Lio/ktor/server/engine/ApplicationEngine;", "Ljava/nio/file/WatchService;", "watcher$delegate", "Lkotlin/Lazy;", "getWatcher", "()Ljava/nio/file/WatchService;", "watcher", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nEmbeddedServerJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbeddedServerJvm.kt\nio/ktor/server/engine/EmbeddedServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,397:1\n1368#2:398\n1454#2,5:399\n1368#2:404\n1454#2,5:405\n1863#2,2:410\n1557#2:412\n1628#2,3:413\n774#2:416\n865#2,2:417\n1619#2:419\n1863#2:420\n1864#2:422\n1620#2:423\n774#2:424\n865#2:425\n1755#2,3:426\n866#2:429\n1863#2,2:430\n1863#2,2:433\n1611#2,9:435\n1863#2:444\n1864#2:446\n1620#2:447\n1863#2,2:449\n1863#2,2:451\n1#3:421\n1#3:432\n1#3:445\n1#3:448\n*S KotlinDebug\n*F\n+ 1 EmbeddedServerJvm.kt\nio/ktor/server/engine/EmbeddedServer\n*L\n103#1:398\n103#1:399,5\n113#1:404\n113#1:405,5\n123#1:410,2\n164#1:412\n164#1:413,3\n166#1:416\n166#1:417,2\n179#1:419\n179#1:420\n179#1:422\n179#1:423\n181#1:424\n181#1:425\n182#1:426,3\n181#1:429\n218#1:430,2\n254#1:433,2\n259#1:435,9\n259#1:444\n259#1:446\n259#1:447\n333#1:449,2\n337#1:451,2\n179#1:421\n259#1:445\n*E\n"})
public final class EmbeddedServer<TEngine extends ApplicationEngine, TConfiguration extends ApplicationEngine.Configuration> {
    @NotNull
    private final ServerConfig rootConfig;
    @NotNull
    private final Events monitor;
    @NotNull
    private final ApplicationEnvironment environment;
    @NotNull
    private final TConfiguration engineConfig;
    @NotNull
    private final ReentrantReadWriteLock applicationInstanceLock;
    private boolean recreateInstance;
    @Nullable
    private ClassLoader _applicationClassLoader;
    @NotNull
    private List<? extends WatchKey> packageWatchKeys;
    @NotNull
    private final List<String> configuredWatchPath;
    @NotNull
    private final List<String> watchPatterns;
    @NotNull
    private final List<String> configModulesNames;
    @NotNull
    private final List<String> modulesNames;
    @Nullable
    private Application _applicationInstance;
    @NotNull
    private final TEngine engine;
    @NotNull
    private final Lazy watcher$delegate;

    /*
     * WARNING - void declaration
     */
    public EmbeddedServer(@NotNull ServerConfig rootConfig, @NotNull ApplicationEngineFactory<? extends TEngine, TConfiguration> engineFactory, @NotNull Function1<? super TConfiguration, Unit> engineConfigBlock) {
        void $this$configModulesNames_u24lambda_u241;
        Intrinsics.checkNotNullParameter((Object)rootConfig, (String)"rootConfig");
        Intrinsics.checkNotNullParameter(engineFactory, (String)"engineFactory");
        Intrinsics.checkNotNullParameter(engineConfigBlock, (String)"engineConfigBlock");
        this.rootConfig = rootConfig;
        this.monitor = this.rootConfig.getEnvironment().getMonitor();
        this.environment = this.rootConfig.getEnvironment();
        this.engineConfig = engineFactory.configuration(engineConfigBlock);
        this.applicationInstanceLock = new ReentrantReadWriteLock();
        this.packageWatchKeys = CollectionsKt.emptyList();
        ApplicationConfigValue applicationConfigValue = this.environment.getConfig().propertyOrNull("ktor.deployment.watch");
        List list = applicationConfigValue != null ? applicationConfigValue.getList() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        this.configuredWatchPath = list;
        this.watchPatterns = CollectionsKt.plus((Collection)this.configuredWatchPath, (Iterable)this.rootConfig.getWatchPaths$ktor_server_core());
        EmbeddedServer embeddedServer = this;
        EmbeddedServer embeddedServer2 = this;
        boolean bl = false;
        Object object = $this$configModulesNames_u24lambda_u241.environment.getConfig().propertyOrNull("ktor.application.modules");
        if (object == null || (object = object.getList()) == null) {
            object = CollectionsKt.emptyList();
        }
        embeddedServer2.configModulesNames = object;
        this.modulesNames = this.configModulesNames;
        this._applicationInstance = new Application(this.environment, this.rootConfig.getDevelopmentMode(), this.rootConfig.getRootPath(), this.monitor, this.rootConfig.getParentCoroutineContext(), (Function0<? extends ApplicationEngine>)((Function0)new PropertyReference0Impl(this){

            public Object get() {
                return ((EmbeddedServer)this.receiver).getEngine();
            }
        }));
        this.engine = engineFactory.create(this.environment, this.monitor, this.rootConfig.getDevelopmentMode(), this.engineConfig, (Function0<Application>)((Function0)new Function0<Application>((Object)this){

            public final Application invoke() {
                return EmbeddedServer.access$currentApplication((EmbeddedServer)this.receiver);
            }
        }));
        this.watcher$delegate = LazyKt.lazy(EmbeddedServer::watcher_delegate$lambda$2);
    }

    public /* synthetic */ EmbeddedServer(ServerConfig serverConfig, ApplicationEngineFactory applicationEngineFactory, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = EmbeddedServer::_init_$lambda$0;
        }
        this(serverConfig, applicationEngineFactory, function1);
    }

    @NotNull
    public final Events getMonitor() {
        return this.monitor;
    }

    @NotNull
    public final ApplicationEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final Application getApplication() {
        return this.currentApplication();
    }

    @NotNull
    public final TConfiguration getEngineConfig() {
        return this.engineConfig;
    }

    @NotNull
    public final TEngine getEngine() {
        return this.engine;
    }

    private final WatchService getWatcher() {
        Lazy lazy = this.watcher$delegate;
        return (WatchService)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reload() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.applicationInstanceLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.destroyApplication();
            Pair<Application, ClassLoader> pair = this.createApplication();
            Application application = (Application)((Object)pair.component1());
            ClassLoader classLoader = (ClassLoader)pair.component2();
            this._applicationInstance = application;
            this._applicationClassLoader = classLoader;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Application currentApplication() {
        Application application;
        ReentrantReadWriteLock.ReadLock readLock = this.applicationInstanceLock.readLock();
        readLock.lock();
        try {
            Application application2;
            boolean bl = false;
            Application application3 = this._applicationInstance;
            if (application3 == null) {
                throw new IllegalStateException("EmbeddedServer was stopped".toString());
            }
            Application currentApplication = application3;
            if (!this.rootConfig.getDevelopmentMode()) {
                application2 = currentApplication;
            } else {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = this.packageWatchKeys;
                boolean $i$f$flatMap = false;
                Object object = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    WatchKey it = (WatchKey)element$iv$iv;
                    boolean bl2 = false;
                    List<WatchEvent<?>> list = it.pollEvents();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"pollEvents(...)");
                    Iterable list$iv$iv = list;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List changes = (List)destination$iv$iv;
                if (changes.isEmpty()) {
                    application2 = currentApplication;
                } else {
                    this.environment.getLog().info("Changes in application detected.");
                    int count = changes.size();
                    while (true) {
                        void $this$flatMapTo$iv$iv2;
                        Thread.sleep(200L);
                        Iterable $this$flatMap$iv2 = this.packageWatchKeys;
                        boolean $i$f$flatMap2 = false;
                        Iterable $i$f$flatMapTo2 = $this$flatMap$iv2;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$flatMapTo3 = false;
                        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                            WatchKey it = (WatchKey)element$iv$iv;
                            boolean bl3 = false;
                            List<WatchEvent<?>> list = it.pollEvents();
                            Intrinsics.checkNotNullExpressionValue(list, (String)"pollEvents(...)");
                            Iterable list$iv$iv = list;
                            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                        }
                        List moreChanges = (List)destination$iv$iv2;
                        if (moreChanges.isEmpty()) break;
                        this.environment.getLog().debug("Waiting for more changes.");
                        count += moreChanges.size();
                    }
                    this.environment.getLog().debug("Changes to " + count + " files caused application restart.");
                    Iterable $this$forEach$iv = CollectionsKt.take((Iterable)changes, (int)5);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        WatchEvent it = (WatchEvent)element$iv;
                        boolean bl4 = false;
                        this.environment.getLog().debug("...  " + it.context());
                    }
                    ReentrantReadWriteLock reentrantReadWriteLock = this.applicationInstanceLock;
                    object = reentrantReadWriteLock.readLock();
                    int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                    for (int i = 0; i < n; ++i) {
                        ((ReentrantReadWriteLock.ReadLock)object).unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                    writeLock.lock();
                    try {
                        boolean bl5 = false;
                        this.destroyApplication();
                        Pair<Application, ClassLoader> pair = this.createApplication();
                        Application application4 = (Application)((Object)pair.component1());
                        ClassLoader classLoader = (ClassLoader)pair.component2();
                        this._applicationInstance = application4;
                        this._applicationClassLoader = classLoader;
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        for (int i = 0; i < n; ++i) {
                            ((ReentrantReadWriteLock.ReadLock)object).lock();
                        }
                        writeLock.unlock();
                    }
                    application2 = this._applicationInstance;
                    if (application2 == null) {
                        throw new IllegalStateException("EmbeddedServer was stopped".toString());
                    }
                }
            }
            application = application2;
        }
        finally {
            readLock.unlock();
        }
        return application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<Application, ClassLoader> createApplication() {
        ClassLoader classLoader = this.createClassLoader();
        Thread currentThread = Thread.currentThread();
        ClassLoader oldThreadClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(classLoader);
        try {
            Pair pair = TuplesKt.to((Object)((Object)this.instantiateAndConfigureApplication(classLoader)), (Object)classLoader);
            return pair;
        }
        finally {
            currentThread.setContextClassLoader(oldThreadClassLoader);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ClassLoader createClassLoader() {
        baseClassLoader = this.environment.getClassLoader();
        if (!this.rootConfig.getDevelopmentMode()) {
            this.environment.getLog().info("Autoreload is disabled because the development mode is off.");
            return baseClassLoader;
        }
        watchPatterns = this.watchPatterns;
        if (watchPatterns.isEmpty()) {
            this.environment.getLog().info("No ktor.deployment.watch patterns specified, automatic reload is not active.");
            return baseClassLoader;
        }
        allUrls = ClassLoadersKt.allURLs(baseClassLoader);
        jre = new File(System.getProperty("java.home")).getParent();
        $this$map$iv = allUrls;
        $i$f$map = false;
        var8_8 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var13_18 = (URL)item$iv$iv;
            var23_22 = destination$iv$iv;
            $i$a$-map-EmbeddedServer$createClassLoader$debugUrls$1 = false;
            var23_22.add(it.getFile());
        }
        debugUrls = (List)destination$iv$iv;
        this.environment.getLog().debug("Java Home: " + jre);
        $this$map$iv = debugUrls;
        var24_24 = new StringBuilder().append("Class Loader: ").append(baseClassLoader).append(": ");
        var23_22 = this.environment.getLog();
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            $i$a$-filter-EmbeddedServer$createClassLoader$1 = false;
            v0 = it.toString();
            Intrinsics.checkNotNull((Object)jre);
            if (!(StringsKt.startsWith$default((String)v0, (String)jre, (boolean)false, (int)2, null) == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        var25_25 = (List)destination$iv$iv;
        var23_22.debug(var24_24.append(var25_25).toString());
        $i$f$filter /* !! */  = new Class[]{ApplicationEnvironment.class, Pipeline.class, HttpStatusCode.class, Function1.class, Logger.class, ByteReadChannel.class, Source.class, Attributes.class};
        $i$f$filter /* !! */  = CollectionsKt.listOf((Object[])$i$f$filter /* !! */ );
        destination$iv = new HashSet<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        $i$f$forEach = false;
        element$iv$iv = $this$forEach$iv$iv.iterator();
        while (element$iv$iv.hasNext()) {
            element$iv = element$iv$iv = element$iv$iv.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv = false;
            it = (Class)element$iv;
            $i$a$-mapNotNullTo-EmbeddedServer$createClassLoader$coreUrls$1 = false;
            if (it.getProtectionDomain().getCodeSource().getLocation() == null) continue;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv = false;
            destination$iv.add(it$iv);
        }
        coreUrls = (HashSet)destination$iv;
        $this$filter$iv = allUrls;
        $i$f$filter = false;
        $this$forEach$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            block13: {
                url = (URL)element$iv$iv;
                $i$a$-filter-EmbeddedServer$createClassLoader$watchUrls$1 = false;
                if (coreUrls.contains(url)) ** GOTO lbl-1000
                $this$any$iv = watchPatterns;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        pattern = (String)element$iv;
                        $i$a$-any-EmbeddedServer$createClassLoader$watchUrls$1$1 = false;
                        if (!EmbeddedServerJvmKt.checkUrlMatches(url, pattern)) continue;
                        v1 = true;
                        break block13;
                    }
                    v1 = false;
                }
            }
            if (!v1) ** GOTO lbl-1000
            v2 = url.getPath();
            if (v2 == null) {
                v2 = "";
            }
            Intrinsics.checkNotNull((Object)jre);
            if (!StringsKt.startsWith$default((String)v2, (String)jre, (boolean)false, (int)2, null)) {
                v3 = true;
            } else lbl-1000:
            // 3 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        watchUrls = (List)destination$iv$iv;
        if (watchUrls.isEmpty()) {
            this.environment.getLog().info("No ktor.deployment.watch patterns match classpath entries, automatic reload is not active");
            return baseClassLoader;
        }
        this.watchUrls(watchUrls);
        return new OverridingClassLoader(watchUrls, baseClassLoader);
    }

    private final void safeRaiseEvent(EventDefinition<Application> event, Application application) {
        EventsKt.raiseCatching$default((Events)this.monitor, event, (Object)((Object)application), null, (int)4, null);
    }

    private final void destroyApplication() {
        Application currentApplication = this._applicationInstance;
        ClassLoader applicationClassLoader = this._applicationClassLoader;
        this._applicationInstance = null;
        this._applicationClassLoader = null;
        if (currentApplication != null) {
            this.safeRaiseEvent(DefaultApplicationEventsKt.getApplicationStopping(), currentApplication);
            try {
                currentApplication.dispose();
                OverridingClassLoader overridingClassLoader = applicationClassLoader instanceof OverridingClassLoader ? (OverridingClassLoader)applicationClassLoader : null;
                if (overridingClassLoader != null) {
                    overridingClassLoader.close();
                }
            }
            catch (Throwable e) {
                this.environment.getLog().error("Failed to destroy application instance.", e);
            }
            this.safeRaiseEvent(DefaultApplicationEventsKt.getApplicationStopped(), currentApplication);
        }
        Iterable $this$forEach$iv = this.packageWatchKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WatchKey it = (WatchKey)element$iv;
            boolean bl = false;
            it.cancel();
        }
        this.packageWatchKeys = new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    private final void watchUrls(List<URL> urls) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        WatchEvent.Modifier[] modifierArray;
        Object element$iv2;
        WatchEvent.Modifier[] modifierArray2;
        HashSet<Path> paths2 = new HashSet<Path>();
        for (URL url2 : urls) {
            Path folder;
            Object $this$watchUrls_u24lambda_u2415;
            Object path;
            if (url2.getPath() == null) continue;
            String decodedPath = URLDecoder.decode((String)path, "utf-8");
            modifierArray2 = this;
            try {
                $this$watchUrls_u24lambda_u2415 = modifierArray2;
                boolean bl = false;
                $this$watchUrls_u24lambda_u2415 = Result.constructor-impl((Object)new File(decodedPath).toPath());
            }
            catch (Throwable throwable) {
                $this$watchUrls_u24lambda_u2415 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            modifierArray2 = $this$watchUrls_u24lambda_u2415;
            if ((Path)(Result.isFailure-impl((Object)modifierArray2) ? null : modifierArray2) == null || !Files.exists(folder, new LinkOption[0])) continue;
            SimpleFileVisitor<Path> visitor2 = new SimpleFileVisitor<Path>(paths2){
                final /* synthetic */ HashSet<Path> $paths;
                {
                    this.$paths = $paths;
                }

                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                    Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                    this.$paths.add(dir);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) {
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                    Path dir = file2.getParent();
                    if (dir != null) {
                        this.$paths.add(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }
            };
            if (!Files.isDirectory(folder, new LinkOption[0])) continue;
            Files.walkFileTree(folder, (FileVisitor<? super Path>)visitor2);
        }
        Iterable $this$forEach$iv = paths2;
        boolean $i$f$forEach22 = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Path path = (Path)element$iv2;
            boolean bl = false;
            this.environment.getLog().debug("Watching " + path + " for changes.");
        }
        WatchEvent.Modifier modifier2 = AutoReloadUtilsKt.get_com_sun_nio_file_SensitivityWatchEventModifier_HIGH();
        if (modifier2 != null) {
            WatchEvent.Modifier it = modifier2;
            boolean bl = false;
            modifierArray2 = new WatchEvent.Modifier[]{it};
            modifierArray = modifierArray2;
        } else {
            modifierArray = new WatchEvent.Modifier[]{};
        }
        WatchEvent.Modifier[] modifiers = modifierArray;
        Iterable $i$f$forEach22 = paths2;
        WatchEvent.Modifier[] modifierArray3 = this;
        boolean $i$f$mapNotNull = false;
        element$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            WatchKey watchKey;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Path path = (Path)element$iv$iv;
            boolean bl2 = false;
            if (super.getWatcher() != null) {
                WatchService it;
                boolean bl3 = false;
                WatchEvent.Kind[] kindArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
                watchKey = path.register(it, kindArray, Arrays.copyOf(modifiers, modifiers.length));
            } else {
                watchKey = null;
            }
            if (watchKey == null) continue;
            WatchKey it$iv$iv = watchKey;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        modifierArray3.packageWatchKeys = (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final EmbeddedServer<TEngine, TConfiguration> start(boolean wait) {
        ShutdownHookKt.addShutdownHook(this, (Function0<Unit>)((Function0)() -> EmbeddedServer.start$lambda$20(this)));
        ReentrantReadWriteLock reentrantReadWriteLock = this.applicationInstanceLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            Pair<Application, ClassLoader> pair;
            boolean bl = false;
            try {
                pair = this.createApplication();
            }
            catch (Throwable cause) {
                this.destroyApplication();
                if (!((Collection)this.watchPatterns).isEmpty()) {
                    this.cleanupWatcher();
                }
                throw cause;
            }
            Pair<Application, ClassLoader> pair2 = pair;
            Application application = (Application)((Object)pair2.component1());
            ClassLoader classLoader = (ClassLoader)pair2.component2();
            this._applicationInstance = application;
            this._applicationClassLoader = classLoader;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.getApplication().getCoroutineContext()), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ EmbeddedServer<TEngine, TConfiguration> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.getEngine().resolvedConnectors((Continuation<List<EngineConnectorConfig>>)((Continuation)this));
                        if (v0 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var2_3 = (Iterable)v0;
                        var3_4 = this.this$0;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (EngineConnectorConfig)element$iv;
                            $i$a$-forEach-EmbeddedServer$start$3$1 = false;
                            host = EngineUtilsJvmKt.escapeHostname(it.getHost());
                            v1 = var3_4.getEnvironment().getLog();
                            v2 = new StringBuilder().append("Responding at ");
                            v3 = it.getType().getName().toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toLowerCase(...)");
                            v1.info(v2.append(v3).append("://").append(host).append(':').append(it.getPort()).toString());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.engine.start(wait);
        return this;
    }

    public static /* synthetic */ EmbeddedServer start$default(EmbeddedServer embeddedServer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return embeddedServer.start(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(long shutdownGracePeriod, long shutdownTimeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        try {
            this.engine.stop(timeUnit.toMillis(shutdownGracePeriod), timeUnit.toMillis(shutdownTimeout));
        }
        catch (Exception e) {
            this.environment.getLog().warn("Exception occurred during engine shutdown", (Throwable)e);
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.applicationInstanceLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.destroyApplication();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        if (!((Collection)this.watchPatterns).isEmpty()) {
            this.cleanupWatcher();
        }
    }

    public final void stop(long gracePeriodMillis, long timeoutMillis) {
        this.stop(gracePeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public static /* synthetic */ void stop$default(EmbeddedServer embeddedServer, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            l = ((ApplicationEngine.Configuration)embeddedServer.engineConfig).getShutdownGracePeriod();
        }
        if ((n & 2) != 0) {
            l2 = ((ApplicationEngine.Configuration)embeddedServer.engineConfig).getShutdownGracePeriod();
        }
        embeddedServer.stop(l, l2);
    }

    private final Application instantiateAndConfigureApplication(ClassLoader currentClassLoader) {
        Application application;
        if (this.recreateInstance || this._applicationInstance == null) {
            application = new Application(this.environment, this.rootConfig.getDevelopmentMode(), this.rootConfig.getRootPath(), this.monitor, this.rootConfig.getParentCoroutineContext(), (Function0<? extends ApplicationEngine>)((Function0)new PropertyReference0Impl(this){

                public Object get() {
                    return ((EmbeddedServer)this.receiver).getEngine();
                }
            }));
        } else {
            this.recreateInstance = true;
            Application application2 = this._applicationInstance;
            application = application2;
            Intrinsics.checkNotNull((Object)((Object)application2));
        }
        Application newInstance2 = application;
        this.safeRaiseEvent(DefaultApplicationEventsKt.getApplicationStarting(), newInstance2);
        this.avoidingDoubleStartup((Function0<Unit>)((Function0)() -> EmbeddedServer.instantiateAndConfigureApplication$lambda$25(this, currentClassLoader, newInstance2)));
        this.safeRaiseEvent(DefaultApplicationEventsKt.getApplicationStarted(), newInstance2);
        return newInstance2;
    }

    private final void launchModuleByName(String name, ClassLoader currentClassLoader, Application newInstance2) {
        this.avoidingDoubleStartupFor(name, (Function0<Unit>)((Function0)() -> EmbeddedServer.launchModuleByName$lambda$26(currentClassLoader, name, newInstance2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void avoidingDoubleStartup(Function0<Unit> block) {
        try {
            block.invoke();
        }
        finally {
            List<String> list = AutoReloadUtilsKt.getCurrentStartupModules().get();
            if (list != null) {
                List<String> it = list;
                boolean bl = false;
                if (it.isEmpty()) {
                    AutoReloadUtilsKt.getCurrentStartupModules().remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void avoidingDoubleStartupFor(String fqName, Function0<Unit> block) {
        List modules;
        ThreadLocal<List<String>> threadLocal = AutoReloadUtilsKt.getCurrentStartupModules();
        List list = threadLocal.get();
        if (list == null) {
            boolean bl = false;
            List list2 = bl = (List)new ArrayList(1);
            threadLocal.set(list2);
            list = bl;
        }
        if (!(!(modules = list).contains(fqName))) {
            boolean bl = false;
            String string = "Module startup is already in progress for function " + fqName + " (recursive module startup from module main?)";
            throw new IllegalStateException(string.toString());
        }
        modules.add((String)fqName);
        try {
            block.invoke();
        }
        finally {
            modules.remove(fqName);
        }
    }

    private final void cleanupWatcher() {
        try {
            WatchService watchService = this.getWatcher();
            if (watchService != null) {
                watchService.close();
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private static final Unit _init_$lambda$0(ApplicationEngine.Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final WatchService watcher_delegate$lambda$2() {
        WatchService watchService;
        try {
            watchService = FileSystems.getDefault().newWatchService();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            watchService = null;
        }
        return watchService;
    }

    private static final Unit start$lambda$20(EmbeddedServer this$0) {
        EmbeddedServer.stop$default(this$0, 0L, 0L, 3, null);
        return Unit.INSTANCE;
    }

    private static final Unit instantiateAndConfigureApplication$lambda$25(EmbeddedServer this$0, ClassLoader $currentClassLoader, Application $newInstance) {
        Iterable $this$forEach$iv = this$0.modulesNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name = (String)element$iv;
            boolean bl = false;
            this$0.launchModuleByName(name, $currentClassLoader, $newInstance);
        }
        $this$forEach$iv = this$0.rootConfig.getModules$ktor_server_core();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 module = (Function1)element$iv;
            boolean bl = false;
            String name = ServerHostUtilsKt.methodName((Function)module);
            try {
                this$0.launchModuleByName(name, $currentClassLoader, $newInstance);
            }
            catch (ReloadingException reloadingException) {
                module.invoke((Object)$newInstance);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit launchModuleByName$lambda$26(ClassLoader $currentClassLoader, String $name, Application $newInstance) {
        CallableUtilsKt.executeModuleFunction($currentClassLoader, $name, $newInstance);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Application access$currentApplication(EmbeddedServer $this) {
        return $this.currentApplication();
    }
}

