# Contributing

If you are considering to contribute to Logos, then this place it for you!

First, we really appreciate people that can help this project grow, and we
would like to guide you through the standard contribution process.

There are many ways to help us, and here is a short list of some of them:

+ fixing an [BUG](https://github.com/maciejhirsz/logos/labels/bug), by providing
  a patch (or suggesting in the comments how one could fix it);
+ correcting some typos in the documentation, the book, or anywhere else;
+ raising an issue about a problem (i.e.,
  [opening an issue](https://github.com/maciejhirsz/logos/issues/new) on GitHub);
+ proposing new features (either with
  [an issue](https://github.com/maciejhirsz/logos/issues/new) or
  [a pull request](https://github.com/maciejhirsz/logos/pulls) on GitHub);
+ or improving the documentation (either in the crate or in the book).

In any case, GitHub is the place-to-go for anything related to contributing.

Below, we provide a few help pages (or links) to contents that can help you
understand Logos' internals and how you can create submit a contribution.

+ If you are new to GitHub or git, please consider reading those two guides:
  + [GitHub’s Hello World](https://docs.github.com/en/get-started/quickstart/hello-world);
  + and [GitHub Pull Request in 100 Seconds](https://www.youtube.com/watch?v=8lGpZkjnkt4&ab_channel=Fireship)
    (video).
+ To setup and test your code locally, see the [Setup](./contributing/setup.md)
  page.
+ To know a bit more how Logos works, check the
  [Internals](./contributing/internals.md).
