//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/unichar?language=objc)
pub type unichar = c_ushort;

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringcompareoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSStringCompareOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSStringCompareOptions: NSUInteger {
        #[doc(alias = "NSCaseInsensitiveSearch")]
        const CaseInsensitiveSearch = 1;
        #[doc(alias = "NSLiteralSearch")]
        const LiteralSearch = 2;
        #[doc(alias = "NSBackwardsSearch")]
        const BackwardsSearch = 4;
        #[doc(alias = "NSAnchoredSearch")]
        const AnchoredSearch = 8;
        #[doc(alias = "NSNumericSearch")]
        const NumericSearch = 64;
        #[doc(alias = "NSDiacriticInsensitiveSearch")]
        const DiacriticInsensitiveSearch = 128;
        #[doc(alias = "NSWidthInsensitiveSearch")]
        const WidthInsensitiveSearch = 256;
        #[doc(alias = "NSForcedOrderingSearch")]
        const ForcedOrderingSearch = 512;
        #[doc(alias = "NSRegularExpressionSearch")]
        const RegularExpressionSearch = 1024;
    }
}

unsafe impl Encode for NSStringCompareOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSStringCompareOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringencoding?language=objc)
pub type NSStringEncoding = NSUInteger;

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsasciistringencoding?language=objc)
pub const NSASCIIStringEncoding: NSStringEncoding = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsnextstepstringencoding?language=objc)
pub const NSNEXTSTEPStringEncoding: NSStringEncoding = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsjapaneseeucstringencoding?language=objc)
pub const NSJapaneseEUCStringEncoding: NSStringEncoding = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsutf8stringencoding?language=objc)
pub const NSUTF8StringEncoding: NSStringEncoding = 4;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsisolatin1stringencoding?language=objc)
pub const NSISOLatin1StringEncoding: NSStringEncoding = 5;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nssymbolstringencoding?language=objc)
pub const NSSymbolStringEncoding: NSStringEncoding = 6;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsnonlossyasciistringencoding?language=objc)
pub const NSNonLossyASCIIStringEncoding: NSStringEncoding = 7;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsshiftjisstringencoding?language=objc)
pub const NSShiftJISStringEncoding: NSStringEncoding = 8;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsisolatin2stringencoding?language=objc)
pub const NSISOLatin2StringEncoding: NSStringEncoding = 9;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsunicodestringencoding?language=objc)
pub const NSUnicodeStringEncoding: NSStringEncoding = 10;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nswindowscp1251stringencoding?language=objc)
pub const NSWindowsCP1251StringEncoding: NSStringEncoding = 11;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nswindowscp1252stringencoding?language=objc)
pub const NSWindowsCP1252StringEncoding: NSStringEncoding = 12;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nswindowscp1253stringencoding?language=objc)
pub const NSWindowsCP1253StringEncoding: NSStringEncoding = 13;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nswindowscp1254stringencoding?language=objc)
pub const NSWindowsCP1254StringEncoding: NSStringEncoding = 14;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nswindowscp1250stringencoding?language=objc)
pub const NSWindowsCP1250StringEncoding: NSStringEncoding = 15;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsiso2022jpstringencoding?language=objc)
pub const NSISO2022JPStringEncoding: NSStringEncoding = 21;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsmacosromanstringencoding?language=objc)
pub const NSMacOSRomanStringEncoding: NSStringEncoding = 30;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsutf16stringencoding?language=objc)
pub const NSUTF16StringEncoding: NSStringEncoding = NSUnicodeStringEncoding;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsutf16bigendianstringencoding?language=objc)
pub const NSUTF16BigEndianStringEncoding: NSStringEncoding = 0x90000100;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsutf16littleendianstringencoding?language=objc)
pub const NSUTF16LittleEndianStringEncoding: NSStringEncoding = 0x94000100;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsutf32stringencoding?language=objc)
pub const NSUTF32StringEncoding: NSStringEncoding = 0x8c000100;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsutf32bigendianstringencoding?language=objc)
pub const NSUTF32BigEndianStringEncoding: NSStringEncoding = 0x98000100;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsutf32littleendianstringencoding?language=objc)
pub const NSUTF32LittleEndianStringEncoding: NSStringEncoding = 0x9c000100;

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringencodingconversionoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSStringEncodingConversionOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSStringEncodingConversionOptions: NSUInteger {
        #[doc(alias = "NSStringEncodingConversionAllowLossy")]
        const AllowLossy = 1;
        #[doc(alias = "NSStringEncodingConversionExternalRepresentation")]
        const ExternalRepresentation = 2;
    }
}

unsafe impl Encode for NSStringEncodingConversionOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSStringEncodingConversionOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstring?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(PartialEq, Eq, Hash)]
    pub struct NSString;
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCoding for NSString {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCopying for NSString {}
);

#[cfg(feature = "NSObject")]
unsafe impl CopyingHelper for NSString {
    type Result = Self;
}

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSMutableCopying for NSString {}
);

#[cfg(feature = "NSObject")]
unsafe impl MutableCopyingHelper for NSString {
    type Result = NSMutableString;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSString {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSSecureCoding for NSString {}
);

impl NSString {
    extern_methods!(
        #[unsafe(method(length))]
        #[unsafe(method_family = none)]
        pub fn length(&self) -> NSUInteger;

        #[unsafe(method(characterAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn characterAtIndex(&self, index: NSUInteger) -> unichar;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "NSCoder")]
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSString {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSString {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringenumerationoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSStringEnumerationOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSStringEnumerationOptions: NSUInteger {
        #[doc(alias = "NSStringEnumerationByLines")]
        const ByLines = 0;
        #[doc(alias = "NSStringEnumerationByParagraphs")]
        const ByParagraphs = 1;
        #[doc(alias = "NSStringEnumerationByComposedCharacterSequences")]
        const ByComposedCharacterSequences = 2;
        #[doc(alias = "NSStringEnumerationByWords")]
        const ByWords = 3;
        #[doc(alias = "NSStringEnumerationBySentences")]
        const BySentences = 4;
        #[doc(alias = "NSStringEnumerationByCaretPositions")]
        const ByCaretPositions = 5;
        #[doc(alias = "NSStringEnumerationByDeletionClusters")]
        const ByDeletionClusters = 6;
        #[doc(alias = "NSStringEnumerationReverse")]
        const Reverse = 1<<8;
        #[doc(alias = "NSStringEnumerationSubstringNotRequired")]
        const SubstringNotRequired = 1<<9;
        #[doc(alias = "NSStringEnumerationLocalized")]
        const Localized = 1<<10;
    }
}

unsafe impl Encode for NSStringEnumerationOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSStringEnumerationOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringtransform?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
pub type NSStringTransform = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringtransformlatintokatakana?language=objc)
    pub static NSStringTransformLatinToKatakana: &'static NSStringTransform;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringtransformlatintohiragana?language=objc)
    pub static NSStringTransformLatinToHiragana: &'static NSStringTransform;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringtransformlatintohangul?language=objc)
    pub static NSStringTransformLatinToHangul: &'static NSStringTransform;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringtransformlatintoarabic?language=objc)
    pub static NSStringTransformLatinToArabic: &'static NSStringTransform;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringtransformlatintohebrew?language=objc)
    pub static NSStringTransformLatinToHebrew: &'static NSStringTransform;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringtransformlatintothai?language=objc)
    pub static NSStringTransformLatinToThai: &'static NSStringTransform;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringtransformlatintocyrillic?language=objc)
    pub static NSStringTransformLatinToCyrillic: &'static NSStringTransform;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringtransformlatintogreek?language=objc)
    pub static NSStringTransformLatinToGreek: &'static NSStringTransform;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringtransformtolatin?language=objc)
    pub static NSStringTransformToLatin: &'static NSStringTransform;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringtransformmandarintolatin?language=objc)
    pub static NSStringTransformMandarinToLatin: &'static NSStringTransform;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringtransformhiraganatokatakana?language=objc)
    pub static NSStringTransformHiraganaToKatakana: &'static NSStringTransform;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringtransformfullwidthtohalfwidth?language=objc)
    pub static NSStringTransformFullwidthToHalfwidth: &'static NSStringTransform;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringtransformtoxmlhex?language=objc)
    pub static NSStringTransformToXMLHex: &'static NSStringTransform;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringtransformtounicodename?language=objc)
    pub static NSStringTransformToUnicodeName: &'static NSStringTransform;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringtransformstripcombiningmarks?language=objc)
    pub static NSStringTransformStripCombiningMarks: &'static NSStringTransform;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringtransformstripdiacritics?language=objc)
    pub static NSStringTransformStripDiacritics: &'static NSStringTransform;
}

/// NSStringExtensionMethods.
impl NSString {
    extern_methods!(
        #[unsafe(method(substringFromIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn substringFromIndex(&self, from: NSUInteger) -> Retained<NSString>;

        #[unsafe(method(substringToIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn substringToIndex(&self, to: NSUInteger) -> Retained<NSString>;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(substringWithRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn substringWithRange(&self, range: NSRange) -> Retained<NSString>;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(getCharacters:range:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getCharacters_range(&self, buffer: NonNull<unichar>, range: NSRange);

        #[cfg(feature = "NSObjCRuntime")]
        #[unsafe(method(compare:))]
        #[unsafe(method_family = none)]
        pub fn compare(&self, string: &NSString) -> NSComparisonResult;

        #[cfg(feature = "NSObjCRuntime")]
        #[unsafe(method(compare:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn compare_options(
            &self,
            string: &NSString,
            mask: NSStringCompareOptions,
        ) -> NSComparisonResult;

        #[cfg(all(feature = "NSObjCRuntime", feature = "NSRange"))]
        #[unsafe(method(compare:options:range:))]
        #[unsafe(method_family = none)]
        pub unsafe fn compare_options_range(
            &self,
            string: &NSString,
            mask: NSStringCompareOptions,
            range_of_receiver_to_compare: NSRange,
        ) -> NSComparisonResult;

        #[cfg(all(feature = "NSObjCRuntime", feature = "NSRange"))]
        #[unsafe(method(compare:options:range:locale:))]
        #[unsafe(method_family = none)]
        pub unsafe fn compare_options_range_locale(
            &self,
            string: &NSString,
            mask: NSStringCompareOptions,
            range_of_receiver_to_compare: NSRange,
            locale: Option<&AnyObject>,
        ) -> NSComparisonResult;

        #[cfg(feature = "NSObjCRuntime")]
        #[unsafe(method(caseInsensitiveCompare:))]
        #[unsafe(method_family = none)]
        pub unsafe fn caseInsensitiveCompare(&self, string: &NSString) -> NSComparisonResult;

        #[cfg(feature = "NSObjCRuntime")]
        #[unsafe(method(localizedCompare:))]
        #[unsafe(method_family = none)]
        pub unsafe fn localizedCompare(&self, string: &NSString) -> NSComparisonResult;

        #[cfg(feature = "NSObjCRuntime")]
        #[unsafe(method(localizedCaseInsensitiveCompare:))]
        #[unsafe(method_family = none)]
        pub unsafe fn localizedCaseInsensitiveCompare(
            &self,
            string: &NSString,
        ) -> NSComparisonResult;

        #[cfg(feature = "NSObjCRuntime")]
        #[unsafe(method(localizedStandardCompare:))]
        #[unsafe(method_family = none)]
        pub unsafe fn localizedStandardCompare(&self, string: &NSString) -> NSComparisonResult;

        #[unsafe(method(isEqualToString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn isEqualToString(&self, a_string: &NSString) -> bool;

        #[unsafe(method(hasPrefix:))]
        #[unsafe(method_family = none)]
        pub fn hasPrefix(&self, str: &NSString) -> bool;

        #[unsafe(method(hasSuffix:))]
        #[unsafe(method_family = none)]
        pub fn hasSuffix(&self, str: &NSString) -> bool;

        #[unsafe(method(commonPrefixWithString:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn commonPrefixWithString_options(
            &self,
            str: &NSString,
            mask: NSStringCompareOptions,
        ) -> Retained<NSString>;

        #[unsafe(method(containsString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn containsString(&self, str: &NSString) -> bool;

        #[unsafe(method(localizedCaseInsensitiveContainsString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn localizedCaseInsensitiveContainsString(&self, str: &NSString) -> bool;

        #[unsafe(method(localizedStandardContainsString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn localizedStandardContainsString(&self, str: &NSString) -> bool;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(localizedStandardRangeOfString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn localizedStandardRangeOfString(&self, str: &NSString) -> NSRange;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(rangeOfString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeOfString(&self, search_string: &NSString) -> NSRange;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(rangeOfString:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeOfString_options(
            &self,
            search_string: &NSString,
            mask: NSStringCompareOptions,
        ) -> NSRange;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(rangeOfString:options:range:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeOfString_options_range(
            &self,
            search_string: &NSString,
            mask: NSStringCompareOptions,
            range_of_receiver_to_search: NSRange,
        ) -> NSRange;

        #[cfg(all(feature = "NSLocale", feature = "NSRange"))]
        #[unsafe(method(rangeOfString:options:range:locale:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeOfString_options_range_locale(
            &self,
            search_string: &NSString,
            mask: NSStringCompareOptions,
            range_of_receiver_to_search: NSRange,
            locale: Option<&NSLocale>,
        ) -> NSRange;

        #[cfg(all(feature = "NSCharacterSet", feature = "NSRange"))]
        #[unsafe(method(rangeOfCharacterFromSet:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeOfCharacterFromSet(&self, search_set: &NSCharacterSet) -> NSRange;

        #[cfg(all(feature = "NSCharacterSet", feature = "NSRange"))]
        #[unsafe(method(rangeOfCharacterFromSet:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeOfCharacterFromSet_options(
            &self,
            search_set: &NSCharacterSet,
            mask: NSStringCompareOptions,
        ) -> NSRange;

        #[cfg(all(feature = "NSCharacterSet", feature = "NSRange"))]
        #[unsafe(method(rangeOfCharacterFromSet:options:range:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeOfCharacterFromSet_options_range(
            &self,
            search_set: &NSCharacterSet,
            mask: NSStringCompareOptions,
            range_of_receiver_to_search: NSRange,
        ) -> NSRange;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(rangeOfComposedCharacterSequenceAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeOfComposedCharacterSequenceAtIndex(&self, index: NSUInteger) -> NSRange;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(rangeOfComposedCharacterSequencesForRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn rangeOfComposedCharacterSequencesForRange(&self, range: NSRange) -> NSRange;

        #[unsafe(method(stringByAppendingString:))]
        #[unsafe(method_family = none)]
        pub fn stringByAppendingString(&self, a_string: &NSString) -> Retained<NSString>;

        #[unsafe(method(doubleValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn doubleValue(&self) -> c_double;

        #[unsafe(method(floatValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn floatValue(&self) -> c_float;

        #[unsafe(method(intValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn intValue(&self) -> c_int;

        #[unsafe(method(integerValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn integerValue(&self) -> NSInteger;

        #[unsafe(method(longLongValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn longLongValue(&self) -> c_longlong;

        #[unsafe(method(boolValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn boolValue(&self) -> bool;

        #[unsafe(method(uppercaseString))]
        #[unsafe(method_family = none)]
        pub unsafe fn uppercaseString(&self) -> Retained<NSString>;

        #[unsafe(method(lowercaseString))]
        #[unsafe(method_family = none)]
        pub unsafe fn lowercaseString(&self) -> Retained<NSString>;

        #[unsafe(method(capitalizedString))]
        #[unsafe(method_family = none)]
        pub unsafe fn capitalizedString(&self) -> Retained<NSString>;

        #[unsafe(method(localizedUppercaseString))]
        #[unsafe(method_family = none)]
        pub unsafe fn localizedUppercaseString(&self) -> Retained<NSString>;

        #[unsafe(method(localizedLowercaseString))]
        #[unsafe(method_family = none)]
        pub unsafe fn localizedLowercaseString(&self) -> Retained<NSString>;

        #[unsafe(method(localizedCapitalizedString))]
        #[unsafe(method_family = none)]
        pub unsafe fn localizedCapitalizedString(&self) -> Retained<NSString>;

        #[cfg(feature = "NSLocale")]
        #[unsafe(method(uppercaseStringWithLocale:))]
        #[unsafe(method_family = none)]
        pub unsafe fn uppercaseStringWithLocale(
            &self,
            locale: Option<&NSLocale>,
        ) -> Retained<NSString>;

        #[cfg(feature = "NSLocale")]
        #[unsafe(method(lowercaseStringWithLocale:))]
        #[unsafe(method_family = none)]
        pub unsafe fn lowercaseStringWithLocale(
            &self,
            locale: Option<&NSLocale>,
        ) -> Retained<NSString>;

        #[cfg(feature = "NSLocale")]
        #[unsafe(method(capitalizedStringWithLocale:))]
        #[unsafe(method_family = none)]
        pub unsafe fn capitalizedStringWithLocale(
            &self,
            locale: Option<&NSLocale>,
        ) -> Retained<NSString>;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(getLineStart:end:contentsEnd:forRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getLineStart_end_contentsEnd_forRange(
            &self,
            start_ptr: *mut NSUInteger,
            line_end_ptr: *mut NSUInteger,
            contents_end_ptr: *mut NSUInteger,
            range: NSRange,
        );

        #[cfg(feature = "NSRange")]
        #[unsafe(method(lineRangeForRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn lineRangeForRange(&self, range: NSRange) -> NSRange;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(getParagraphStart:end:contentsEnd:forRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getParagraphStart_end_contentsEnd_forRange(
            &self,
            start_ptr: *mut NSUInteger,
            par_end_ptr: *mut NSUInteger,
            contents_end_ptr: *mut NSUInteger,
            range: NSRange,
        );

        #[cfg(feature = "NSRange")]
        #[unsafe(method(paragraphRangeForRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn paragraphRangeForRange(&self, range: NSRange) -> NSRange;

        #[cfg(all(feature = "NSRange", feature = "block2"))]
        #[unsafe(method(enumerateSubstringsInRange:options:usingBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn enumerateSubstringsInRange_options_usingBlock(
            &self,
            range: NSRange,
            opts: NSStringEnumerationOptions,
            block: &block2::DynBlock<dyn Fn(*mut NSString, NSRange, NSRange, NonNull<Bool>)>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(enumerateLinesUsingBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn enumerateLinesUsingBlock(
            &self,
            block: &block2::DynBlock<dyn Fn(NonNull<NSString>, NonNull<Bool>)>,
        );

        #[unsafe(method(UTF8String))]
        #[unsafe(method_family = none)]
        pub fn UTF8String(&self) -> *const c_char;

        #[unsafe(method(fastestEncoding))]
        #[unsafe(method_family = none)]
        pub unsafe fn fastestEncoding(&self) -> NSStringEncoding;

        #[unsafe(method(smallestEncoding))]
        #[unsafe(method_family = none)]
        pub unsafe fn smallestEncoding(&self) -> NSStringEncoding;

        #[cfg(feature = "NSData")]
        #[unsafe(method(dataUsingEncoding:allowLossyConversion:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataUsingEncoding_allowLossyConversion(
            &self,
            encoding: NSStringEncoding,
            lossy: bool,
        ) -> Option<Retained<NSData>>;

        #[cfg(feature = "NSData")]
        #[unsafe(method(dataUsingEncoding:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataUsingEncoding(
            &self,
            encoding: NSStringEncoding,
        ) -> Option<Retained<NSData>>;

        #[unsafe(method(canBeConvertedToEncoding:))]
        #[unsafe(method_family = none)]
        pub unsafe fn canBeConvertedToEncoding(&self, encoding: NSStringEncoding) -> bool;

        #[unsafe(method(cStringUsingEncoding:))]
        #[unsafe(method_family = none)]
        pub unsafe fn cStringUsingEncoding(&self, encoding: NSStringEncoding) -> *const c_char;

        #[unsafe(method(getCString:maxLength:encoding:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getCString_maxLength_encoding(
            &self,
            buffer: NonNull<c_char>,
            max_buffer_count: NSUInteger,
            encoding: NSStringEncoding,
        ) -> bool;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(getBytes:maxLength:usedLength:encoding:options:range:remainingRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getBytes_maxLength_usedLength_encoding_options_range_remainingRange(
            &self,
            buffer: *mut c_void,
            max_buffer_count: NSUInteger,
            used_buffer_count: *mut NSUInteger,
            encoding: NSStringEncoding,
            options: NSStringEncodingConversionOptions,
            range: NSRange,
            leftover: NSRangePointer,
        ) -> bool;

        #[unsafe(method(maximumLengthOfBytesUsingEncoding:))]
        #[unsafe(method_family = none)]
        pub unsafe fn maximumLengthOfBytesUsingEncoding(&self, enc: NSStringEncoding)
            -> NSUInteger;

        #[unsafe(method(lengthOfBytesUsingEncoding:))]
        #[unsafe(method_family = none)]
        pub fn lengthOfBytesUsingEncoding(&self, enc: NSStringEncoding) -> NSUInteger;

        #[unsafe(method(availableStringEncodings))]
        #[unsafe(method_family = none)]
        pub unsafe fn availableStringEncodings() -> NonNull<NSStringEncoding>;

        #[unsafe(method(localizedNameOfStringEncoding:))]
        #[unsafe(method_family = none)]
        pub unsafe fn localizedNameOfStringEncoding(
            encoding: NSStringEncoding,
        ) -> Retained<NSString>;

        #[unsafe(method(defaultCStringEncoding))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultCStringEncoding() -> NSStringEncoding;

        #[unsafe(method(decomposedStringWithCanonicalMapping))]
        #[unsafe(method_family = none)]
        pub unsafe fn decomposedStringWithCanonicalMapping(&self) -> Retained<NSString>;

        #[unsafe(method(precomposedStringWithCanonicalMapping))]
        #[unsafe(method_family = none)]
        pub unsafe fn precomposedStringWithCanonicalMapping(&self) -> Retained<NSString>;

        #[unsafe(method(decomposedStringWithCompatibilityMapping))]
        #[unsafe(method_family = none)]
        pub unsafe fn decomposedStringWithCompatibilityMapping(&self) -> Retained<NSString>;

        #[unsafe(method(precomposedStringWithCompatibilityMapping))]
        #[unsafe(method_family = none)]
        pub unsafe fn precomposedStringWithCompatibilityMapping(&self) -> Retained<NSString>;

        #[cfg(feature = "NSArray")]
        #[unsafe(method(componentsSeparatedByString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn componentsSeparatedByString(
            &self,
            separator: &NSString,
        ) -> Retained<NSArray<NSString>>;

        #[cfg(all(feature = "NSArray", feature = "NSCharacterSet"))]
        #[unsafe(method(componentsSeparatedByCharactersInSet:))]
        #[unsafe(method_family = none)]
        pub unsafe fn componentsSeparatedByCharactersInSet(
            &self,
            separator: &NSCharacterSet,
        ) -> Retained<NSArray<NSString>>;

        #[cfg(feature = "NSCharacterSet")]
        #[unsafe(method(stringByTrimmingCharactersInSet:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringByTrimmingCharactersInSet(
            &self,
            set: &NSCharacterSet,
        ) -> Retained<NSString>;

        #[unsafe(method(stringByPaddingToLength:withString:startingAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringByPaddingToLength_withString_startingAtIndex(
            &self,
            new_length: NSUInteger,
            pad_string: &NSString,
            pad_index: NSUInteger,
        ) -> Retained<NSString>;

        #[cfg(feature = "NSLocale")]
        #[unsafe(method(stringByFoldingWithOptions:locale:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringByFoldingWithOptions_locale(
            &self,
            options: NSStringCompareOptions,
            locale: Option<&NSLocale>,
        ) -> Retained<NSString>;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(stringByReplacingOccurrencesOfString:withString:options:range:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringByReplacingOccurrencesOfString_withString_options_range(
            &self,
            target: &NSString,
            replacement: &NSString,
            options: NSStringCompareOptions,
            search_range: NSRange,
        ) -> Retained<NSString>;

        #[unsafe(method(stringByReplacingOccurrencesOfString:withString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringByReplacingOccurrencesOfString_withString(
            &self,
            target: &NSString,
            replacement: &NSString,
        ) -> Retained<NSString>;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(stringByReplacingCharactersInRange:withString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringByReplacingCharactersInRange_withString(
            &self,
            range: NSRange,
            replacement: &NSString,
        ) -> Retained<NSString>;

        #[unsafe(method(stringByApplyingTransform:reverse:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringByApplyingTransform_reverse(
            &self,
            transform: &NSStringTransform,
            reverse: bool,
        ) -> Option<Retained<NSString>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(writeToURL:atomically:encoding:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeToURL_atomically_encoding_error(
            &self,
            url: &NSURL,
            use_auxiliary_file: bool,
            enc: NSStringEncoding,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[unsafe(method(writeToFile:atomically:encoding:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeToFile_atomically_encoding_error(
            &self,
            path: &NSString,
            use_auxiliary_file: bool,
            enc: NSStringEncoding,
        ) -> Result<(), Retained<NSError>>;

        #[unsafe(method(description))]
        #[unsafe(method_family = none)]
        pub unsafe fn description(&self) -> Retained<NSString>;

        #[unsafe(method(hash))]
        #[unsafe(method_family = none)]
        pub unsafe fn hash(&self) -> NSUInteger;

        #[unsafe(method(initWithCharactersNoCopy:length:freeWhenDone:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCharactersNoCopy_length_freeWhenDone(
            this: Allocated<Self>,
            characters: NonNull<unichar>,
            length: NSUInteger,
            free_buffer: bool,
        ) -> Retained<Self>;

        #[cfg(feature = "block2")]
        #[unsafe(method(initWithCharactersNoCopy:length:deallocator:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCharactersNoCopy_length_deallocator(
            this: Allocated<Self>,
            chars: NonNull<unichar>,
            len: NSUInteger,
            deallocator: Option<&block2::DynBlock<dyn Fn(NonNull<unichar>, NSUInteger)>>,
        ) -> Retained<Self>;

        #[unsafe(method(initWithCharacters:length:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCharacters_length(
            this: Allocated<Self>,
            characters: NonNull<unichar>,
            length: NSUInteger,
        ) -> Retained<Self>;

        #[unsafe(method(initWithUTF8String:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithUTF8String(
            this: Allocated<Self>,
            null_terminated_c_string: NonNull<c_char>,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(initWithString:))]
        #[unsafe(method_family = init)]
        pub fn initWithString(this: Allocated<Self>, a_string: &NSString) -> Retained<Self>;

        #[cfg(feature = "NSData")]
        #[unsafe(method(initWithData:encoding:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithData_encoding(
            this: Allocated<Self>,
            data: &NSData,
            encoding: NSStringEncoding,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(initWithBytes:length:encoding:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBytes_length_encoding(
            this: Allocated<Self>,
            bytes: NonNull<c_void>,
            len: NSUInteger,
            encoding: NSStringEncoding,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(initWithBytesNoCopy:length:encoding:freeWhenDone:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBytesNoCopy_length_encoding_freeWhenDone(
            this: Allocated<Self>,
            bytes: NonNull<c_void>,
            len: NSUInteger,
            encoding: NSStringEncoding,
            free_buffer: bool,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "block2")]
        #[unsafe(method(initWithBytesNoCopy:length:encoding:deallocator:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBytesNoCopy_length_encoding_deallocator(
            this: Allocated<Self>,
            bytes: NonNull<c_void>,
            len: NSUInteger,
            encoding: NSStringEncoding,
            deallocator: Option<&block2::DynBlock<dyn Fn(NonNull<c_void>, NSUInteger)>>,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(string))]
        #[unsafe(method_family = none)]
        pub unsafe fn string() -> Retained<Self>;

        #[unsafe(method(stringWithString:))]
        #[unsafe(method_family = none)]
        pub fn stringWithString(string: &NSString) -> Retained<Self>;

        #[unsafe(method(stringWithCharacters:length:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringWithCharacters_length(
            characters: NonNull<unichar>,
            length: NSUInteger,
        ) -> Retained<Self>;

        #[unsafe(method(stringWithUTF8String:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringWithUTF8String(
            null_terminated_c_string: NonNull<c_char>,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(initWithCString:encoding:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCString_encoding(
            this: Allocated<Self>,
            null_terminated_c_string: NonNull<c_char>,
            encoding: NSStringEncoding,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(stringWithCString:encoding:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringWithCString_encoding(
            c_string: NonNull<c_char>,
            enc: NSStringEncoding,
        ) -> Option<Retained<Self>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(initWithContentsOfURL:encoding:error:_))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentsOfURL_encoding_error(
            this: Allocated<Self>,
            url: &NSURL,
            enc: NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[unsafe(method(initWithContentsOfFile:encoding:error:_))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentsOfFile_encoding_error(
            this: Allocated<Self>,
            path: &NSString,
            enc: NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(stringWithContentsOfURL:encoding:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringWithContentsOfURL_encoding_error(
            url: &NSURL,
            enc: NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[unsafe(method(stringWithContentsOfFile:encoding:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringWithContentsOfFile_encoding_error(
            path: &NSString,
            enc: NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(initWithContentsOfURL:usedEncoding:error:_))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentsOfURL_usedEncoding_error(
            this: Allocated<Self>,
            url: &NSURL,
            enc: *mut NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[unsafe(method(initWithContentsOfFile:usedEncoding:error:_))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentsOfFile_usedEncoding_error(
            this: Allocated<Self>,
            path: &NSString,
            enc: *mut NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(stringWithContentsOfURL:usedEncoding:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringWithContentsOfURL_usedEncoding_error(
            url: &NSURL,
            enc: *mut NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[unsafe(method(stringWithContentsOfFile:usedEncoding:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringWithContentsOfFile_usedEncoding_error(
            path: &NSString,
            enc: *mut NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;
    );
}

/// Methods declared on superclass `NSString`.
///
/// NSStringExtensionMethods.
impl NSMutableString {
    extern_methods!(
        #[unsafe(method(initWithCharactersNoCopy:length:freeWhenDone:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCharactersNoCopy_length_freeWhenDone(
            this: Allocated<Self>,
            characters: NonNull<unichar>,
            length: NSUInteger,
            free_buffer: bool,
        ) -> Retained<Self>;

        #[cfg(feature = "block2")]
        #[unsafe(method(initWithCharactersNoCopy:length:deallocator:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCharactersNoCopy_length_deallocator(
            this: Allocated<Self>,
            chars: NonNull<unichar>,
            len: NSUInteger,
            deallocator: Option<&block2::DynBlock<dyn Fn(NonNull<unichar>, NSUInteger)>>,
        ) -> Retained<Self>;

        #[unsafe(method(initWithCharacters:length:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCharacters_length(
            this: Allocated<Self>,
            characters: NonNull<unichar>,
            length: NSUInteger,
        ) -> Retained<Self>;

        #[unsafe(method(initWithUTF8String:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithUTF8String(
            this: Allocated<Self>,
            null_terminated_c_string: NonNull<c_char>,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(initWithString:))]
        #[unsafe(method_family = init)]
        pub fn initWithString(this: Allocated<Self>, a_string: &NSString) -> Retained<Self>;

        #[cfg(feature = "NSData")]
        #[unsafe(method(initWithData:encoding:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithData_encoding(
            this: Allocated<Self>,
            data: &NSData,
            encoding: NSStringEncoding,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(initWithBytes:length:encoding:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBytes_length_encoding(
            this: Allocated<Self>,
            bytes: NonNull<c_void>,
            len: NSUInteger,
            encoding: NSStringEncoding,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(initWithBytesNoCopy:length:encoding:freeWhenDone:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBytesNoCopy_length_encoding_freeWhenDone(
            this: Allocated<Self>,
            bytes: NonNull<c_void>,
            len: NSUInteger,
            encoding: NSStringEncoding,
            free_buffer: bool,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "block2")]
        #[unsafe(method(initWithBytesNoCopy:length:encoding:deallocator:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBytesNoCopy_length_encoding_deallocator(
            this: Allocated<Self>,
            bytes: NonNull<c_void>,
            len: NSUInteger,
            encoding: NSStringEncoding,
            deallocator: Option<&block2::DynBlock<dyn Fn(NonNull<c_void>, NSUInteger)>>,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(string))]
        #[unsafe(method_family = none)]
        pub unsafe fn string() -> Retained<Self>;

        #[unsafe(method(stringWithString:))]
        #[unsafe(method_family = none)]
        pub fn stringWithString(string: &NSString) -> Retained<Self>;

        #[unsafe(method(stringWithCharacters:length:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringWithCharacters_length(
            characters: NonNull<unichar>,
            length: NSUInteger,
        ) -> Retained<Self>;

        #[unsafe(method(stringWithUTF8String:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringWithUTF8String(
            null_terminated_c_string: NonNull<c_char>,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(initWithCString:encoding:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCString_encoding(
            this: Allocated<Self>,
            null_terminated_c_string: NonNull<c_char>,
            encoding: NSStringEncoding,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(stringWithCString:encoding:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringWithCString_encoding(
            c_string: NonNull<c_char>,
            enc: NSStringEncoding,
        ) -> Option<Retained<Self>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(initWithContentsOfURL:encoding:error:_))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentsOfURL_encoding_error(
            this: Allocated<Self>,
            url: &NSURL,
            enc: NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[unsafe(method(initWithContentsOfFile:encoding:error:_))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentsOfFile_encoding_error(
            this: Allocated<Self>,
            path: &NSString,
            enc: NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(stringWithContentsOfURL:encoding:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringWithContentsOfURL_encoding_error(
            url: &NSURL,
            enc: NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[unsafe(method(stringWithContentsOfFile:encoding:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringWithContentsOfFile_encoding_error(
            path: &NSString,
            enc: NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(initWithContentsOfURL:usedEncoding:error:_))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentsOfURL_usedEncoding_error(
            this: Allocated<Self>,
            url: &NSURL,
            enc: *mut NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[unsafe(method(initWithContentsOfFile:usedEncoding:error:_))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentsOfFile_usedEncoding_error(
            this: Allocated<Self>,
            path: &NSString,
            enc: *mut NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(stringWithContentsOfURL:usedEncoding:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringWithContentsOfURL_usedEncoding_error(
            url: &NSURL,
            enc: *mut NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[unsafe(method(stringWithContentsOfFile:usedEncoding:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringWithContentsOfFile_usedEncoding_error(
            path: &NSString,
            enc: *mut NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringencodingdetectionoptionskey?language=objc)
// NS_TYPED_ENUM
pub type NSStringEncodingDetectionOptionsKey = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringencodingdetectionsuggestedencodingskey?language=objc)
    pub static NSStringEncodingDetectionSuggestedEncodingsKey:
        &'static NSStringEncodingDetectionOptionsKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringencodingdetectiondisallowedencodingskey?language=objc)
    pub static NSStringEncodingDetectionDisallowedEncodingsKey:
        &'static NSStringEncodingDetectionOptionsKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringencodingdetectionuseonlysuggestedencodingskey?language=objc)
    pub static NSStringEncodingDetectionUseOnlySuggestedEncodingsKey:
        &'static NSStringEncodingDetectionOptionsKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringencodingdetectionallowlossykey?language=objc)
    pub static NSStringEncodingDetectionAllowLossyKey: &'static NSStringEncodingDetectionOptionsKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringencodingdetectionfromwindowskey?language=objc)
    pub static NSStringEncodingDetectionFromWindowsKey:
        &'static NSStringEncodingDetectionOptionsKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringencodingdetectionlossysubstitutionkey?language=objc)
    pub static NSStringEncodingDetectionLossySubstitutionKey:
        &'static NSStringEncodingDetectionOptionsKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstringencodingdetectionlikelylanguagekey?language=objc)
    pub static NSStringEncodingDetectionLikelyLanguageKey:
        &'static NSStringEncodingDetectionOptionsKey;
}

/// NSStringEncodingDetection.
impl NSString {
    extern_methods!(
        #[cfg(all(feature = "NSData", feature = "NSDictionary"))]
        #[unsafe(method(stringEncodingForData:encodingOptions:convertedString:usedLossyConversion:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringEncodingForData_encodingOptions_convertedString_usedLossyConversion(
            data: &NSData,
            opts: Option<&NSDictionary<NSStringEncodingDetectionOptionsKey, AnyObject>>,
            string: Option<&mut Option<Retained<NSString>>>,
            used_lossy_conversion: *mut Bool,
        ) -> NSStringEncoding;
    );
}

/// NSItemProvider.
impl NSString {
    extern_methods!();
}

#[cfg(feature = "NSItemProvider")]
extern_conformance!(
    unsafe impl NSItemProviderReading for NSString {}
);

#[cfg(feature = "NSItemProvider")]
extern_conformance!(
    unsafe impl NSItemProviderWriting for NSString {}
);

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsmutablestring?language=objc)
    #[unsafe(super(NSString, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSMutableString;
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCoding for NSMutableString {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCopying for NSMutableString {}
);

#[cfg(feature = "NSObject")]
unsafe impl CopyingHelper for NSMutableString {
    type Result = NSString;
}

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSMutableCopying for NSMutableString {}
);

#[cfg(feature = "NSObject")]
unsafe impl MutableCopyingHelper for NSMutableString {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSMutableString {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSSecureCoding for NSMutableString {}
);

impl NSMutableString {
    extern_methods!(
        #[cfg(feature = "NSRange")]
        #[unsafe(method(replaceCharactersInRange:withString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn replaceCharactersInRange_withString(
            &self,
            range: NSRange,
            a_string: &NSString,
        );
    );
}

/// Methods declared on superclass `NSString`.
impl NSMutableString {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "NSCoder")]
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSMutableString {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSMutableString {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

/// NSMutableStringExtensionMethods.
impl NSMutableString {
    extern_methods!(
        #[unsafe(method(insertString:atIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn insertString_atIndex(&self, a_string: &NSString, loc: NSUInteger);

        #[cfg(feature = "NSRange")]
        #[unsafe(method(deleteCharactersInRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn deleteCharactersInRange(&self, range: NSRange);

        #[unsafe(method(appendString:))]
        #[unsafe(method_family = none)]
        pub fn appendString(&self, a_string: &NSString);

        #[unsafe(method(setString:))]
        #[unsafe(method_family = none)]
        pub fn setString(&self, a_string: &NSString);

        #[cfg(feature = "NSRange")]
        #[unsafe(method(replaceOccurrencesOfString:withString:options:range:))]
        #[unsafe(method_family = none)]
        pub unsafe fn replaceOccurrencesOfString_withString_options_range(
            &self,
            target: &NSString,
            replacement: &NSString,
            options: NSStringCompareOptions,
            search_range: NSRange,
        ) -> NSUInteger;

        #[cfg(feature = "NSRange")]
        #[unsafe(method(applyTransform:reverse:range:updatedRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn applyTransform_reverse_range_updatedRange(
            &self,
            transform: &NSStringTransform,
            reverse: bool,
            range: NSRange,
            resulting_range: NSRangePointer,
        ) -> bool;

        #[unsafe(method(initWithCapacity:))]
        #[unsafe(method_family = init)]
        pub fn initWithCapacity(
            this: Allocated<Self>,
            capacity: NSUInteger,
        ) -> Retained<NSMutableString>;

        #[unsafe(method(stringWithCapacity:))]
        #[unsafe(method_family = none)]
        pub fn stringWithCapacity(capacity: NSUInteger) -> Retained<NSMutableString>;
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nscharacterconversionexception?language=objc)
    #[cfg(feature = "NSObjCRuntime")]
    pub static NSCharacterConversionException: &'static NSExceptionName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsparseerrorexception?language=objc)
    #[cfg(feature = "NSObjCRuntime")]
    pub static NSParseErrorException: &'static NSExceptionName;
}

/// NSExtendedStringPropertyListParsing.
impl NSString {
    extern_methods!(
        #[unsafe(method(propertyList))]
        #[unsafe(method_family = none)]
        pub unsafe fn propertyList(&self) -> Retained<AnyObject>;

        #[cfg(feature = "NSDictionary")]
        #[unsafe(method(propertyListFromStringsFileFormat))]
        #[unsafe(method_family = none)]
        pub unsafe fn propertyListFromStringsFileFormat(&self) -> Option<Retained<NSDictionary>>;
    );
}

/// NSStringDeprecated.
impl NSString {
    extern_methods!(
        #[deprecated = "Use -cStringUsingEncoding: instead"]
        #[unsafe(method(cString))]
        #[unsafe(method_family = none)]
        pub unsafe fn cString(&self) -> *const c_char;

        #[deprecated = "Use -cStringUsingEncoding: instead"]
        #[unsafe(method(lossyCString))]
        #[unsafe(method_family = none)]
        pub unsafe fn lossyCString(&self) -> *const c_char;

        #[deprecated = "Use -lengthOfBytesUsingEncoding: instead"]
        #[unsafe(method(cStringLength))]
        #[unsafe(method_family = none)]
        pub unsafe fn cStringLength(&self) -> NSUInteger;

        #[deprecated = "Use -getCString:maxLength:encoding: instead"]
        #[unsafe(method(getCString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getCString(&self, bytes: NonNull<c_char>);

        #[deprecated = "Use -getCString:maxLength:encoding: instead"]
        #[unsafe(method(getCString:maxLength:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getCString_maxLength(&self, bytes: NonNull<c_char>, max_length: NSUInteger);

        #[cfg(feature = "NSRange")]
        #[deprecated = "Use -getCString:maxLength:encoding: instead"]
        #[unsafe(method(getCString:maxLength:range:remainingRange:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getCString_maxLength_range_remainingRange(
            &self,
            bytes: NonNull<c_char>,
            max_length: NSUInteger,
            a_range: NSRange,
            leftover_range: NSRangePointer,
        );

        #[deprecated = "Use -writeToFile:atomically:encoding:error: instead"]
        #[unsafe(method(writeToFile:atomically:))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeToFile_atomically(
            &self,
            path: &NSString,
            use_auxiliary_file: bool,
        ) -> bool;

        #[cfg(feature = "NSURL")]
        #[deprecated = "Use -writeToURL:atomically:encoding:error: instead"]
        #[unsafe(method(writeToURL:atomically:))]
        #[unsafe(method_family = none)]
        pub unsafe fn writeToURL_atomically(&self, url: &NSURL, atomically: bool) -> bool;

        #[deprecated = "Use -initWithContentsOfFile:encoding:error: instead"]
        #[unsafe(method(initWithContentsOfFile:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentsOfFile(
            this: Allocated<Self>,
            path: &NSString,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSURL")]
        #[deprecated = "Use -initWithContentsOfURL:encoding:error: instead"]
        #[unsafe(method(initWithContentsOfURL:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentsOfURL(
            this: Allocated<Self>,
            url: &NSURL,
        ) -> Option<Retained<Self>>;

        #[deprecated = "Use +stringWithContentsOfFile:encoding:error: instead"]
        #[unsafe(method(stringWithContentsOfFile:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringWithContentsOfFile(path: &NSString) -> Option<Retained<AnyObject>>;

        #[cfg(feature = "NSURL")]
        #[deprecated = "Use +stringWithContentsOfURL:encoding:error: instead"]
        #[unsafe(method(stringWithContentsOfURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringWithContentsOfURL(url: &NSURL) -> Option<Retained<AnyObject>>;

        #[deprecated = "Use -initWithCString:encoding: instead"]
        #[unsafe(method(initWithCStringNoCopy:length:freeWhenDone:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCStringNoCopy_length_freeWhenDone(
            this: Allocated<Self>,
            bytes: NonNull<c_char>,
            length: NSUInteger,
            free_buffer: bool,
        ) -> Option<Retained<Self>>;

        #[deprecated = "Use -initWithCString:encoding: instead"]
        #[unsafe(method(initWithCString:length:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCString_length(
            this: Allocated<Self>,
            bytes: NonNull<c_char>,
            length: NSUInteger,
        ) -> Option<Retained<Self>>;

        #[deprecated = "Use -initWithCString:encoding: instead"]
        #[unsafe(method(initWithCString:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCString(
            this: Allocated<Self>,
            bytes: NonNull<c_char>,
        ) -> Option<Retained<Self>>;

        #[deprecated = "Use +stringWithCString:encoding:"]
        #[unsafe(method(stringWithCString:length:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringWithCString_length(
            bytes: NonNull<c_char>,
            length: NSUInteger,
        ) -> Option<Retained<AnyObject>>;

        #[deprecated = "Use +stringWithCString:encoding: instead"]
        #[unsafe(method(stringWithCString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringWithCString(bytes: NonNull<c_char>) -> Option<Retained<AnyObject>>;

        #[unsafe(method(getCharacters:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getCharacters(&self, buffer: NonNull<unichar>);
    );
}

/// Methods declared on superclass `NSString`.
///
/// NSStringDeprecated.
impl NSMutableString {
    extern_methods!(
        #[deprecated = "Use -initWithContentsOfFile:encoding:error: instead"]
        #[unsafe(method(initWithContentsOfFile:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentsOfFile(
            this: Allocated<Self>,
            path: &NSString,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSURL")]
        #[deprecated = "Use -initWithContentsOfURL:encoding:error: instead"]
        #[unsafe(method(initWithContentsOfURL:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentsOfURL(
            this: Allocated<Self>,
            url: &NSURL,
        ) -> Option<Retained<Self>>;

        #[deprecated = "Use -initWithCString:encoding: instead"]
        #[unsafe(method(initWithCStringNoCopy:length:freeWhenDone:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCStringNoCopy_length_freeWhenDone(
            this: Allocated<Self>,
            bytes: NonNull<c_char>,
            length: NSUInteger,
            free_buffer: bool,
        ) -> Option<Retained<Self>>;

        #[deprecated = "Use -initWithCString:encoding: instead"]
        #[unsafe(method(initWithCString:length:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCString_length(
            this: Allocated<Self>,
            bytes: NonNull<c_char>,
            length: NSUInteger,
        ) -> Option<Retained<Self>>;

        #[deprecated = "Use -initWithCString:encoding: instead"]
        #[unsafe(method(initWithCString:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCString(
            this: Allocated<Self>,
            bytes: NonNull<c_char>,
        ) -> Option<Retained<Self>>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nssimplecstring?language=objc)
    #[unsafe(super(NSString, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSSimpleCString;
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCoding for NSSimpleCString {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSSimpleCString {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSSecureCoding for NSSimpleCString {}
);

impl NSSimpleCString {
    extern_methods!();
}

/// Methods declared on superclass `NSString`.
impl NSSimpleCString {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "NSCoder")]
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSSimpleCString {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsconstantstring?language=objc)
    #[unsafe(super(NSSimpleCString, NSString, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSConstantString;
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCoding for NSConstantString {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSConstantString {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSSecureCoding for NSConstantString {}
);

impl NSConstantString {
    extern_methods!();
}

/// Methods declared on superclass `NSString`.
impl NSConstantString {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "NSCoder")]
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSConstantString {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
