//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// A class to set functions to be linked.
    ///
    /// All functions set on this object must have unique names.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtllinkedfunctions?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLLinkedFunctions;
);

extern_conformance!(
    unsafe impl NSCopying for MTLLinkedFunctions {}
);

unsafe impl CopyingHelper for MTLLinkedFunctions {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLLinkedFunctions {}
);

impl MTLLinkedFunctions {
    extern_methods!(
        /// Create an autoreleased MTLLinkedFunctions object.
        #[unsafe(method(linkedFunctions))]
        #[unsafe(method_family = none)]
        pub fn linkedFunctions() -> Retained<MTLLinkedFunctions>;

        #[cfg(feature = "MTLLibrary")]
        /// The array of functions to be AIR linked.
        #[unsafe(method(functions))]
        #[unsafe(method_family = none)]
        pub fn functions(&self) -> Option<Retained<NSArray<ProtocolObject<dyn MTLFunction>>>>;

        #[cfg(feature = "MTLLibrary")]
        /// Setter for [`functions`][Self::functions].
        #[unsafe(method(setFunctions:))]
        #[unsafe(method_family = none)]
        pub fn setFunctions(&self, functions: Option<&NSArray<ProtocolObject<dyn MTLFunction>>>);

        #[cfg(feature = "MTLLibrary")]
        /// The array of functions compiled to binary to be linked.
        #[unsafe(method(binaryFunctions))]
        #[unsafe(method_family = none)]
        pub fn binaryFunctions(&self)
            -> Option<Retained<NSArray<ProtocolObject<dyn MTLFunction>>>>;

        #[cfg(feature = "MTLLibrary")]
        /// Setter for [`binaryFunctions`][Self::binaryFunctions].
        #[unsafe(method(setBinaryFunctions:))]
        #[unsafe(method_family = none)]
        pub fn setBinaryFunctions(
            &self,
            binary_functions: Option<&NSArray<ProtocolObject<dyn MTLFunction>>>,
        );

        #[cfg(feature = "MTLLibrary")]
        /// Groups of functions, grouped to match callsites in the shader code.
        #[unsafe(method(groups))]
        #[unsafe(method_family = none)]
        pub fn groups(
            &self,
        ) -> Option<Retained<NSDictionary<NSString, NSArray<ProtocolObject<dyn MTLFunction>>>>>;

        #[cfg(feature = "MTLLibrary")]
        /// Setter for [`groups`][Self::groups].
        #[unsafe(method(setGroups:))]
        #[unsafe(method_family = none)]
        pub fn setGroups(
            &self,
            groups: Option<&NSDictionary<NSString, NSArray<ProtocolObject<dyn MTLFunction>>>>,
        );

        #[cfg(feature = "MTLLibrary")]
        /// The array of functions to be AIR linked.
        ///
        /// These functions are not exported by the pipeline state as MTLFunctionHandle objects.
        /// Function pointer support is not required to link private functions.
        #[unsafe(method(privateFunctions))]
        #[unsafe(method_family = none)]
        pub fn privateFunctions(
            &self,
        ) -> Option<Retained<NSArray<ProtocolObject<dyn MTLFunction>>>>;

        #[cfg(feature = "MTLLibrary")]
        /// Setter for [`privateFunctions`][Self::privateFunctions].
        #[unsafe(method(setPrivateFunctions:))]
        #[unsafe(method_family = none)]
        pub fn setPrivateFunctions(
            &self,
            private_functions: Option<&NSArray<ProtocolObject<dyn MTLFunction>>>,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLLinkedFunctions {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for MTLLinkedFunctions {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}
