//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uilargecontentvieweritem?language=objc)
    pub unsafe trait UILargeContentViewerItem: NSObjectProtocol + MainThreadOnly {
        /// Returns whether the item shows the large content viewer.
        /// In general, only views that cannot scale for the full range of Dynamic Type sizes should return YES.
        /// For this property to take effect, the item or an ancestor view must have a UILargeContentViewerInteraction.
        #[unsafe(method(showsLargeContentViewer))]
        #[unsafe(method_family = none)]
        unsafe fn showsLargeContentViewer(&self) -> bool;

        /// Returns a title that should be shown in the large content viewer.
        #[unsafe(method(largeContentTitle))]
        #[unsafe(method_family = none)]
        unsafe fn largeContentTitle(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "UIImage")]
        /// Returns an image that should be shown in the large content viewer.
        #[unsafe(method(largeContentImage))]
        #[unsafe(method_family = none)]
        unsafe fn largeContentImage(&self) -> Option<Retained<UIImage>>;

        /// Returns whether the image should be scaled to a larger size appropriate for the viewer.
        /// If not, the image will be shown at its intrinsic size.
        /// For best results when scaling, use a PDF asset with its "Preserve Vector Data" checkbox checked.
        #[unsafe(method(scalesLargeContentImage))]
        #[unsafe(method_family = none)]
        unsafe fn scalesLargeContentImage(&self) -> bool;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// Returns insets appropriate for positioning the image in the viewer so that it appears visually centered.
        #[unsafe(method(largeContentImageInsets))]
        #[unsafe(method_family = none)]
        unsafe fn largeContentImageInsets(&self) -> UIEdgeInsets;
    }
);

/// UILargeContentViewer.
#[cfg(all(feature = "UIResponder", feature = "UIView"))]
impl UIView {
    extern_methods!(
        #[unsafe(method(showsLargeContentViewer))]
        #[unsafe(method_family = none)]
        pub unsafe fn showsLargeContentViewer(&self) -> bool;

        /// Setter for [`showsLargeContentViewer`][Self::showsLargeContentViewer].
        #[unsafe(method(setShowsLargeContentViewer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShowsLargeContentViewer(&self, shows_large_content_viewer: bool);

        #[unsafe(method(largeContentTitle))]
        #[unsafe(method_family = none)]
        pub unsafe fn largeContentTitle(&self) -> Option<Retained<NSString>>;

        /// Setter for [`largeContentTitle`][Self::largeContentTitle].
        #[unsafe(method(setLargeContentTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setLargeContentTitle(&self, large_content_title: Option<&NSString>);

        #[cfg(feature = "UIImage")]
        #[unsafe(method(largeContentImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn largeContentImage(&self) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UIImage")]
        /// Setter for [`largeContentImage`][Self::largeContentImage].
        #[unsafe(method(setLargeContentImage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setLargeContentImage(&self, large_content_image: Option<&UIImage>);

        #[unsafe(method(scalesLargeContentImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn scalesLargeContentImage(&self) -> bool;

        /// Setter for [`scalesLargeContentImage`][Self::scalesLargeContentImage].
        #[unsafe(method(setScalesLargeContentImage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setScalesLargeContentImage(&self, scales_large_content_image: bool);

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(largeContentImageInsets))]
        #[unsafe(method_family = none)]
        pub unsafe fn largeContentImageInsets(&self) -> UIEdgeInsets;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// Setter for [`largeContentImageInsets`][Self::largeContentImageInsets].
        #[unsafe(method(setLargeContentImageInsets:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setLargeContentImageInsets(&self, large_content_image_insets: UIEdgeInsets);
    );
}

#[cfg(all(feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UILargeContentViewerItem for UIView {}
);

extern_class!(
    /// UILargeContentViewerInteraction enables a gesture to present and dismiss the large content viewer on a device with relevant settings.
    /// Use methods in
    /// <UIKit
    /// /UIInteraction.h> to add the interaction to an appropriate view, such as a custom tab bar.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uilargecontentviewerinteraction?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UILargeContentViewerInteraction;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UILargeContentViewerInteraction {}
);

#[cfg(feature = "UIInteraction")]
extern_conformance!(
    unsafe impl UIInteraction for UILargeContentViewerInteraction {}
);

impl UILargeContentViewerInteraction {
    extern_methods!(
        #[unsafe(method(initWithDelegate:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithDelegate(
            this: Allocated<Self>,
            delegate: Option<&ProtocolObject<dyn UILargeContentViewerInteractionDelegate>>,
        ) -> Retained<Self>;

        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn UILargeContentViewerInteractionDelegate>>>;

        #[cfg(feature = "UIGestureRecognizer")]
        /// Returns a gesture recognizer that can be used to set up simultaneous recognition or failure relationships with other gesture recognizers.
        #[unsafe(method(gestureRecognizerForExclusionRelationship))]
        #[unsafe(method_family = none)]
        pub unsafe fn gestureRecognizerForExclusionRelationship(
            &self,
        ) -> Retained<UIGestureRecognizer>;

        /// Returns whether the large content viewer is enabled on the device.
        /// It is not necessary to check this value before adding a UILargeContentViewerInteraction to a view,
        /// but it may be helpful if you need to adjust the behavior of coexisting gesture handlers.
        /// For example, a button with a long press handler might increase its long press duration,
        /// so that a user can read text in the large content viewer first.
        #[unsafe(method(isEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isEnabled(mtm: MainThreadMarker) -> bool;
    );
}

/// Methods declared on superclass `NSObject`.
impl UILargeContentViewerInteraction {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uilargecontentviewerinteractiondelegate?language=objc)
    pub unsafe trait UILargeContentViewerInteractionDelegate:
        NSObjectProtocol + MainThreadOnly
    {
        #[cfg(feature = "objc2-core-foundation")]
        /// Performs an action when the large content viewer gesture ends at the location of the given item.
        /// (The point in the interaction's view's coordinate system is also provided.)
        /// For example, you may wish to perform the action that would have occurred if the user had tapped on that item.
        /// If you don’t implement this method and are using standard UIKit controls, the system performs a default action, such as sending a touchUpInside event to the control.
        /// This method is called only if the gesture ends successfully (not if it fails or gets canceled).
        #[optional]
        #[unsafe(method(largeContentViewerInteraction:didEndOnItem:atPoint:))]
        #[unsafe(method_family = none)]
        unsafe fn largeContentViewerInteraction_didEndOnItem_atPoint(
            &self,
            interaction: &UILargeContentViewerInteraction,
            item: Option<&ProtocolObject<dyn UILargeContentViewerItem>>,
            point: CGPoint,
        );

        #[cfg(feature = "objc2-core-foundation")]
        /// Returns the item at a given point in the interaction's view's coordinate system.
        /// If this is not implemented, -[UIView pointInside:withEvent:] will be called recursively on the interaction's view to find an appropriate view.
        #[optional]
        #[unsafe(method(largeContentViewerInteraction:itemAtPoint:))]
        #[unsafe(method_family = none)]
        unsafe fn largeContentViewerInteraction_itemAtPoint(
            &self,
            interaction: &UILargeContentViewerInteraction,
            point: CGPoint,
        ) -> Option<Retained<ProtocolObject<dyn UILargeContentViewerItem>>>;

        #[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
        /// Returns the view controller whose region of the screen should be used to display the large content viewer.
        /// If this is not implemented, a view controller that contains the interaction's view will be chosen.
        #[optional]
        #[unsafe(method(viewControllerForLargeContentViewerInteraction:))]
        #[unsafe(method_family = none)]
        unsafe fn viewControllerForLargeContentViewerInteraction(
            &self,
            interaction: &UILargeContentViewerInteraction,
        ) -> Retained<UIViewController>;
    }
);

extern "C" {
    /// Posted when the large content viewer gets enabled or disabled on the device.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uilargecontentviewerinteractionenabledstatusdidchangenotification?language=objc)
    pub static UILargeContentViewerInteractionEnabledStatusDidChangeNotification:
        &'static NSNotificationName;
}
