SYD-AES(1)

# NAME

*syd-aes* - AES-CTR encryption and decryption utility

# SYNOPSIS

*syd-aes* _[-hv]_ _-e|-d_ _-k <key-serial>_ _-i <iv-hex>_

# DESCRIPTION

The *syd-aes* utility uses the Linux Kernel Cryptography API to encrypt
and decrypt data using AES-CTR mode using _keyrings_(7) to select the
encryption/decryption key to use without copying key material into
userspace. It supports both encryption and decryption operations, with
the key serial provided as a 32-bit ID and IV provided as a hexadecimal
string. Given data from standard input, *syd-aes* performs the specified
operation and outputs the result to standard output. *syd-aes* uses
pipes and _splice_(2) to transfer data using zero-copy, and therefore
able to encrypt/decrypt files of arbitrary size.

# OPTIONS

|[ *-h*
:< Display help.
|[ *-v*
:< Enable verbose mode. If standard error is a terminal, print progress
   updates periodically, similar to *dd*(1).
|[ *-e*
:< Encrypt the input data.
|[ *-d*
:< Decrypt the input data.
|[ *-k <key-serial>*
:< Key serial ID (32-bit integer).
|[
:< The kernel key that *syd-aes* (via ALG_SET_KEY_BY_KEY_SERIAL) will read must grant the caller
|[
:< *search* permission -- i.e. have the KEY_(POS|USR|GRP|OTH)\_SEARCH permission bit(s) set
|[
:< so the kernel can locate and copy the key data into the crypto API;
|[
:< otherwise the operation will be denied (EPERM: "Operation not permitted").
|[ *-i <iv>*
:< Hex-encoded IV (128 bits).

# SEE ALSO

_syd_(1), _syd_(2), _syd_(5), _syd-key_(1), _splice_(2), _keyrings_(7)

*syd* homepage: https://sydbox.exherbo.org/

# AUTHORS

Maintained by Ali Polatel. Up-to-date sources can be found at
https://gitlab.exherbo.org/sydbox/sydbox.git and bugs/patches can be
submitted to https://gitlab.exherbo.org/groups/sydbox/-/issues. Discuss
in #sydbox on Libera Chat or in #sydbox:mailstation.de on Matrix.
