SYD-LS(1)

# NAME

*syd-ls* - List unsafe directories, capabilities, system calls, environment variables, ioctl requests, personalities, and prctl options

# SYNOPSIS

*syd-ls* _[set]_

# DESCRIPTION

The *syd-ls* utility prints the names of the system calls which belong
to the given set. Available sets are *cpu*, *dead*, *deny*, *ebpf*,
*futex*, *hook*, *nice*, *noop*, *pkey*, *ptrace*, *safe*, *setid*,
*time*, and *uring*.

If set is *drop*, *syd-ls* prints the list of Linux _capabilities_(7) that are
dropped at startup.

If set is *env*, *syd-ls* prints the list of unsafe environment variables.

If set is *ioctl*, *syd-ls* prints the list of allowed ioctl requests.

If set is *prctl*, *syd-ls* prints the list of allowed prctl options.

If set is *personality*, *syd-ls* prints the list of allowed personalities.

Given no set, *syd-ls* lists all files in the current working directory.
In this mode, getdents64(2) is used directly. Use to list files in
untrusted directories with huge number of files. File names are printed
hex-encoded, delimited by newline, use _syd-hex_(1) to decode. See
EXAMPLES section for more information.

# EXAMPLES

```
[alip@caissa tmp]$ mkdir test; cd test
[alip@caissa test]$ for i in {1..10000000}; do :>$i; done
[alip@caissa test]$ df -i .
Filesystem       Inodes    IUsed IFree IUse% Mounted on
tmpfs          10048576 10000228 48348  100% /tmp
[alip@caissa test]$ syd-ls | head -n5 | syd-hex -dfs
.
..
10000000
9999999
9999998
[alip@caissa test]$ for ls in syd-ls gls 9ls 'busybox ls'; do
> sync
> sudo sh -c 'echo 3 > /proc/sys/vm/drop_caches'
> echo "[*] $ls"
> time $ls >/dev/null
> done
[*] syd-ls
syd-ls: Listed 10000002 files in 2.882764582 seconds.

real    0m2.889s
user    0m0.883s
sys     0m1.995s
[*] gls

real    0m7.548s
user    0m5.724s
sys     0m1.803s
[*] 9ls

real    0m15.306s
user    0m2.523s
sys     0m12.743s
[*] busybox ls

real    0m18.011s
user    0m11.178s
sys     0m6.786s
[alip@caissa test]$ gls --version | head -n1
ls (GNU coreutils) 9.6
[alip@caissa test]$ pacman -Ss 9base | head -n1
extra/9base 6-9 [installed]
[alip@caissa test]$ busybox | head -n1
BusyBox v1.36.1 () multi-call binary.
```

# SEE ALSO

_syd_(1), _syd_(2), _syd_(5), _syd-hex_(1), _getdents_(2)

*syd* homepage: https://sydbox.exherbo.org/

# AUTHORS

Maintained by Ali Polatel. Up-to-date sources can be found at
https://gitlab.exherbo.org/sydbox/sydbox.git and bugs/patches can be
submitted to https://gitlab.exherbo.org/groups/sydbox/-/issues. Discuss
in #sydbox on Libera Chat or in #sydbox:mailstation.de on Matrix.
