/*
 * Copyright (C) 2021 Andreas Steffen
 *
 * Copyright (C) secunet Security Networks AG
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 */

#include "test_suite.h"

#include <plugins/plugin_feature.h>

typedef struct rsa_oaep_test_t rsa_oaep_test_t;

struct rsa_oaep_test_t {
	chunk_t msg;
	chunk_t label;
	chunk_t ct;
};

/**
 * Private RSA key to load
 */
static chunk_t rsa_2048_key = chunk_from_chars( /* PKCS#8 format */
		0x30,0x82,0x04,0xbc,0x02,0x01,0x00,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,
		0x0d,0x01,0x01,0x01,0x05,0x00,0x04,0x82,0x04,0xa6,0x30,0x82,0x04,0xa2,0x02,0x01,
		0x00,0x02,0x82,0x01,0x01,0x00,0xc2,0xc4,0xa8,0x60,0x23,0x6d,0x3c,0x90,0x96,0xa0,
		0x76,0xd6,0xba,0x51,0x07,0xe0,0xf7,0xbd,0x81,0xe1,0xba,0x91,0x6f,0x73,0x75,0x72,
		0x4b,0xd2,0xb0,0xb0,0xb6,0x39,0x56,0x81,0x37,0x15,0xa3,0x45,0x7a,0xb0,0x45,0x8b,
		0x71,0xfb,0x35,0xa4,0x5b,0x27,0xf9,0xef,0x7a,0xc3,0xe5,0x79,0xde,0xa4,0x5d,0xfb,
		0xfd,0x07,0x81,0x9e,0xd6,0xb7,0x02,0x1a,0xa5,0x33,0x6c,0x58,0x44,0x2a,0xad,0xd9,
		0x6c,0xa9,0xee,0x9d,0x32,0x47,0x3e,0x9d,0x92,0x78,0x56,0x2b,0x4d,0x10,0x25,0x8a,
		0xde,0x6a,0x98,0xfb,0x1c,0x7c,0xfd,0xc3,0xb3,0x71,0x6e,0xf5,0xde,0xc5,0x8c,0xf7,
		0x3b,0x35,0x9f,0x38,0x95,0x99,0xb4,0xb5,0x86,0x5a,0x98,0x63,0x51,0x9e,0xb0,0x01,
		0xc3,0x24,0x38,0x7d,0xa7,0x55,0x45,0x0d,0xb3,0x41,0x30,0x93,0x60,0xe3,0x80,0x7c,
		0x05,0x65,0xb8,0xe2,0xc4,0x4f,0xbd,0x5e,0x6e,0x8d,0x04,0xd0,0x06,0xd7,0xee,0x76,
		0x8b,0x8e,0x84,0x36,0x08,0x2a,0x90,0xfa,0x0e,0x83,0x7f,0x32,0xf4,0x60,0x87,0xab,
		0x4a,0x0d,0x9b,0xe2,0x8a,0xa7,0xda,0x17,0x94,0xce,0xb0,0x17,0x2a,0x7f,0x50,0xed,
		0x20,0xf6,0xdf,0x64,0x1e,0xfb,0xcb,0xfd,0x2a,0xac,0x89,0x77,0x5c,0x76,0x1a,0x73,
		0x10,0x09,0x3c,0x67,0x1c,0x97,0x7f,0xa1,0x8b,0x0d,0x6e,0x01,0xfb,0x25,0xf7,0xa4,
		0x32,0xb4,0x2c,0x65,0x35,0x97,0x84,0xc6,0x89,0x20,0x57,0x19,0xc1,0xcf,0x6e,0x3a,
		0x65,0xda,0xe2,0xda,0x43,0x4c,0x32,0x6d,0xde,0x81,0xbb,0x6f,0xff,0xfb,0xdb,0xf6,
		0xde,0x5c,0x16,0xbb,0xa7,0x49,0x02,0x03,0x01,0x00,0x01,0x02,0x82,0x01,0x00,0x0a,
		0x5c,0x27,0x90,0xa5,0x91,0xc3,0xec,0xf4,0xf6,0x28,0x1c,0x17,0xe1,0x03,0x88,0x45,
		0xe5,0x40,0xa9,0x5f,0x21,0x29,0x4a,0x7c,0xee,0xcd,0x75,0xb1,0x8c,0x54,0xc5,0x0c,
		0x02,0xe7,0x89,0x31,0x1c,0x1b,0x00,0x91,0x52,0x6f,0x87,0xab,0x3c,0xc8,0xd4,0x81,
		0x88,0xe9,0x80,0xce,0x0e,0x03,0x77,0xbe,0xc0,0x0e,0x9f,0x7d,0x97,0x93,0x58,0x3c,
		0xb6,0x6a,0x1f,0x28,0x1e,0x31,0xd2,0x0b,0x59,0x4b,0x5c,0x66,0xa2,0xd9,0xef,0xcc,
		0x36,0xd9,0x79,0xa9,0x2b,0xb8,0x77,0xa9,0x67,0x8f,0x99,0x1f,0xf6,0x0b,0x77,0xe2,
		0x8f,0xac,0x55,0xd6,0x4f,0x21,0xc0,0x64,0x55,0x2a,0x43,0x19,0xeb,0x0a,0x9a,0x18,
		0x70,0xa7,0x6a,0xde,0x3c,0x3a,0x35,0x34,0xab,0x83,0x53,0xc3,0xe5,0x7b,0x27,0x08,
		0x36,0x38,0x59,0xad,0x3a,0x63,0x37,0xfc,0x15,0xff,0xb9,0x09,0x80,0xd9,0x37,0x43,
		0xf9,0x72,0xd7,0x43,0xc3,0xdc,0x6f,0xdd,0xb4,0x42,0x79,0x07,0x9a,0x80,0x9a,0xbe,
		0xc8,0x11,0x3a,0x6f,0x98,0x7f,0x71,0x74,0x8c,0x03,0x6a,0x4d,0xaf,0x35,0x3b,0x27,
		0xa8,0x1e,0x69,0x83,0xd5,0x6a,0x2d,0x65,0xb7,0x1b,0x93,0x12,0x8d,0x55,0x69,0x49,
		0x9d,0x10,0xad,0x13,0x96,0xf0,0x94,0xee,0xd7,0x7c,0x04,0x4e,0x3c,0xe9,0xef,0x82,
		0xf0,0x01,0x4c,0x25,0xba,0x69,0x39,0x28,0xc0,0x0b,0x50,0x43,0xb6,0x41,0xb0,0x16,
		0xe3,0x56,0x9b,0x4b,0xd8,0x4d,0x68,0x33,0x72,0x53,0x86,0x71,0x30,0x73,0x21,0xc2,
		0x5e,0x59,0x0f,0x14,0xbe,0xf2,0x41,0xe6,0xd8,0xed,0xf2,0x4f,0xf3,0x98,0x59,0x02,
		0x81,0x81,0x00,0xe7,0x4a,0x12,0x47,0x59,0xa1,0x74,0xde,0x33,0x18,0x59,0x96,0xb3,
		0xb4,0x37,0xc2,0x4e,0xd2,0x48,0x20,0x3d,0x67,0x4a,0x87,0xbc,0xc2,0xe7,0x6a,0x66,
		0x7b,0xe3,0xf5,0x4a,0xc1,0x5e,0x8f,0x04,0xe4,0xc5,0xe5,0x40,0xf4,0xe1,0x9f,0x40,
		0x2a,0x71,0xd3,0x7d,0x39,0x75,0x6d,0xce,0xfb,0xfa,0xef,0xb3,0x80,0x09,0x5b,0x6c,
		0xfb,0xdf,0x4d,0x78,0xdd,0x20,0xcf,0x08,0x5a,0x1f,0x12,0x76,0x10,0xe3,0xb7,0x10,
		0x2c,0xa6,0xbd,0xe1,0x82,0x59,0x41,0xab,0x60,0x2e,0x9b,0x72,0xc0,0x8e,0x45,0x33,
		0xac,0x50,0x31,0x71,0x38,0xe1,0x0b,0xf7,0xed,0xfe,0xa3,0x0f,0x52,0xee,0x91,0xea,
		0x66,0x28,0xc2,0xcc,0x65,0xe7,0x6b,0xaf,0xc0,0x2e,0xb9,0xd2,0x1a,0xb6,0x6a,0xd3,
		0x74,0xef,0x27,0x02,0x81,0x81,0x00,0xd7,0x93,0xb4,0xf5,0x51,0x49,0x21,0xbf,0xbc,
		0x47,0xa1,0xe4,0x5f,0xaa,0x04,0x3e,0xea,0x03,0xf0,0x52,0xbc,0xe6,0x00,0xec,0x4f,
		0x5c,0x62,0xb0,0x14,0xa7,0xc4,0x5a,0xeb,0x3f,0x4b,0xc0,0x21,0x60,0xe7,0xb1,0x2d,
		0xee,0x13,0x5e,0x44,0xb2,0x27,0xa3,0x18,0x54,0xca,0x83,0x3a,0xc7,0x06,0xd1,0x46,
		0x70,0xab,0x59,0x32,0xa2,0x69,0xc9,0xb6,0xf9,0x18,0x8a,0xcb,0x93,0xe6,0x98,0xb4,
		0xa7,0xdf,0xf6,0x5b,0xb9,0xc9,0x63,0xc2,0xe0,0x2b,0x2c,0xea,0x3f,0x2d,0x5c,0xb2,
		0x54,0xe0,0x7b,0x61,0x67,0x92,0x89,0x6e,0x37,0x55,0x0c,0xb3,0x81,0x71,0xc4,0xc3,
		0x2e,0x0a,0x65,0x43,0xbb,0xe6,0xac,0xd4,0xe9,0x9a,0xbe,0xab,0xa1,0x34,0x0a,0x96,
		0x10,0x17,0x41,0x2b,0x57,0xbc,0x0f,0x02,0x81,0x80,0x4d,0xd4,0x02,0x04,0x9a,0x67,
		0x97,0x30,0xf2,0x16,0x9e,0x86,0xf4,0x9f,0x8f,0x27,0xc6,0x68,0x42,0x36,0xff,0x12,
		0x93,0xe4,0xcb,0x22,0xf6,0xc6,0x3a,0x08,0x34,0x74,0x25,0x1c,0x9e,0x9a,0x17,0xb6,
		0x77,0xd5,0x26,0x1f,0x81,0x10,0x9a,0x81,0xed,0xdd,0x91,0xc4,0xd4,0xfc,0x07,0x6b,
		0x89,0x4c,0x41,0xa5,0xb3,0x00,0x5d,0xd2,0xff,0x98,0x4d,0x34,0x73,0xc6,0xd6,0xf3,
		0xa4,0x83,0x0c,0xd1,0xb0,0x1e,0xb8,0xc5,0x9d,0xb2,0x45,0x81,0x1c,0x51,0xd9,0xbe,
		0x3a,0xd0,0xba,0x33,0x8b,0x6c,0x43,0xf0,0x16,0xe8,0x1c,0x46,0x5c,0x8c,0x2f,0x78,
		0x99,0x77,0xfb,0x3f,0x17,0xe2,0x67,0xf2,0xca,0x82,0x8a,0x4f,0x3c,0x29,0x63,0x71,
		0x93,0x07,0x9a,0x68,0xbc,0xbb,0x83,0xbe,0x54,0x7f,0x02,0x81,0x80,0x76,0x7a,0x35,
		0x2f,0xc5,0xd6,0xbd,0x77,0x94,0xd0,0x81,0x86,0xf3,0x94,0x8a,0xf4,0xd0,0xc4,0x0d,
		0x66,0x4b,0x6e,0xd4,0xff,0x0a,0xb6,0xa9,0x7e,0x40,0x3b,0xdb,0xcc,0x64,0x11,0xcb,
		0x5d,0xf2,0x7a,0x41,0x9b,0xbc,0xb4,0x65,0x6c,0x9f,0xb0,0x91,0xdc,0x2e,0xd9,0x1a,
		0xdb,0x78,0x88,0x3d,0x94,0xf2,0x73,0xa5,0x98,0x46,0x1d,0xc0,0xaa,0x1d,0xa7,0x54,
		0xf7,0xa2,0xde,0xcc,0x13,0x0c,0xe6,0x5e,0x4e,0x15,0x27,0x4c,0x29,0x49,0xc6,0xcd,
		0xb3,0xc7,0xa1,0xa5,0x1a,0x96,0xdf,0xd2,0xe7,0xbc,0x26,0xa2,0x00,0x69,0xd4,0x7b,
		0x27,0x99,0xd8,0x00,0x60,0xb5,0x2c,0x2e,0x86,0x6c,0xed,0x6d,0xdf,0x7a,0xbc,0x50,
		0x51,0x8e,0x1d,0xf0,0x6e,0x08,0xff,0x1a,0xe8,0xb4,0x1b,0x69,0xbd,0x02,0x81,0x80,
		0x54,0x79,0xdd,0xa3,0x0f,0xc0,0x6b,0x63,0xcb,0x5f,0x77,0xe2,0x0b,0xb2,0x9d,0xb7,
		0xee,0xc7,0xa6,0xb3,0x7a,0x50,0x07,0xf9,0x65,0x1a,0x46,0xff,0xb6,0x6c,0x90,0x16,
		0x0b,0xe5,0x70,0x01,0x45,0xc6,0xa0,0x8d,0x97,0x37,0xa9,0x8c,0x5f,0x7b,0xa0,0xdc,
		0xef,0x39,0x35,0x2c,0xc5,0xd8,0x61,0x2d,0x94,0xfd,0x02,0x38,0x3b,0x8e,0x09,0x31,
		0x15,0x37,0x6b,0x15,0x4f,0xa1,0xce,0xbd,0xf9,0x15,0xdd,0xc0,0x51,0xa7,0x01,0x7d,
		0x67,0xa2,0x38,0xfb,0x43,0x76,0x74,0x9c,0xed,0x94,0x71,0x2b,0x11,0x7a,0x1d,0x0c,
		0xa3,0x1c,0xd6,0x53,0xa1,0x95,0x5d,0xd5,0x47,0x34,0x6d,0x03,0xb2,0x1e,0xb0,0xad,
		0x3c,0x12,0x3f,0xb8,0x5e,0x92,0xc8,0xaf,0x50,0xa9,0x85,0xdb,0x10,0xeb,0xa7,0x9b);

static chunk_t rsa_4096_key = chunk_from_chars( /* PKCS#8 format */
		0x30,0x82,0x09,0x43,0x02,0x01,0x00,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,
		0x0d,0x01,0x01,0x01,0x05,0x00,0x04,0x82,0x09,0x2d,0x30,0x82,0x09,0x29,0x02,0x01,
		0x00,0x02,0x82,0x02,0x01,0x00,0xc9,0xa7,0x65,0xc2,0x66,0x1b,0x46,0x74,0xcf,0xf3,
		0x48,0x0e,0x9a,0x5e,0x46,0x2a,0xd0,0xad,0x2f,0xc9,0xbc,0x6f,0xbe,0xf6,0x28,0x47,
		0xb3,0x11,0x3d,0x20,0x99,0x1f,0x65,0x39,0x67,0x97,0x1c,0x28,0x25,0x27,0x53,0xf5,
		0xfb,0xac,0xce,0x01,0x2c,0x2a,0x8a,0xb5,0x92,0x91,0x4d,0x26,0x9e,0xfa,0xfa,0x72,
		0x4f,0xa4,0xb9,0x20,0xe3,0x40,0x93,0x0c,0x10,0x6f,0x7b,0x36,0xf7,0x9c,0xeb,0xf0,
		0xe6,0x2e,0x88,0xe0,0xe4,0x76,0x88,0x8e,0x9f,0x0e,0x22,0x18,0x6a,0xcd,0xb6,0xc4,
		0x52,0x3a,0x23,0x2b,0x65,0xb4,0xff,0x2c,0xc2,0x2d,0xc4,0x4f,0x8a,0x55,0x95,0x27,
		0xd7,0x9d,0x7c,0xd7,0xdc,0xf3,0x77,0x32,0x12,0xf7,0xbb,0x9a,0xa1,0x33,0xc3,0x11,
		0x65,0xcc,0x66,0x36,0x90,0xbf,0x12,0x3d,0x73,0x92,0x3c,0x83,0x89,0x29,0xcc,0xaf,
		0xee,0x59,0xd6,0xc7,0x09,0x5b,0x8d,0x4a,0x74,0xba,0xf2,0xd1,0x92,0xc9,0xa4,0xe8,
		0x7c,0x4e,0x12,0xbc,0x58,0x01,0x30,0x78,0xb2,0x8a,0x77,0x89,0xe8,0x2e,0x9f,0x31,
		0xde,0x1f,0x4d,0x6a,0x2a,0xa6,0xe8,0x06,0x32,0xbe,0x8e,0x4b,0xdf,0x26,0x3e,0x8d,
		0x49,0xb0,0x94,0x16,0xfb,0x19,0xc4,0x88,0xc0,0x7a,0xd8,0xaf,0x72,0x2a,0xb7,0x91,
		0x82,0xb2,0x30,0x28,0xa7,0x1e,0x06,0x5d,0x02,0x41,0x2a,0x9e,0xeb,0xc4,0x6d,0x7d,
		0x8f,0x4e,0x03,0xd7,0x92,0x38,0xd8,0xc0,0xcb,0x4a,0x97,0xa9,0xa1,0x20,0x0e,0xbb,
		0x6e,0xc6,0x40,0x42,0xeb,0xec,0xca,0xd9,0x56,0x75,0x26,0xee,0xef,0x12,0xc1,0x7d,
		0x94,0xc1,0x04,0x9c,0x88,0x99,0x70,0xb9,0x6e,0x94,0xcc,0x35,0x31,0x72,0xa2,0x68,
		0xa4,0x9c,0x5e,0x8b,0xee,0x13,0xc1,0x5b,0x39,0xde,0xc4,0x4f,0x2c,0x7a,0x1a,0xa3,
		0x7a,0x7a,0x0b,0x6f,0x72,0x29,0x0a,0xca,0xda,0x32,0xb1,0xd8,0xaf,0x1f,0xc3,0xdc,
		0x8a,0x89,0x48,0x7b,0xa8,0x13,0x47,0xcb,0xeb,0x13,0x50,0x92,0x5d,0x30,0xf9,0x23,
		0x95,0x81,0x06,0xb4,0x99,0x59,0xc8,0x71,0xe7,0xc1,0xdb,0xa5,0x5d,0xa0,0x77,0x2e,
		0x36,0x2c,0xf8,0x62,0x1d,0x78,0x61,0x08,0x68,0xb8,0x94,0xe1,0x6e,0x5d,0xfe,0xc9,
		0x68,0x74,0xa9,0x3a,0x4c,0xf3,0x79,0xb4,0x7e,0x7e,0x31,0x8c,0xe3,0x15,0x06,0x6d,
		0x70,0xee,0x39,0x38,0x14,0x0a,0x60,0x14,0x8f,0x20,0x50,0x85,0xce,0xf8,0xa7,0x70,
		0x0c,0xa3,0xc5,0x3d,0x52,0xa5,0x75,0x6a,0x63,0xb3,0xb1,0x6f,0x15,0x30,0x62,0xb6,
		0x12,0x62,0xa6,0x84,0x96,0x21,0x0c,0x8b,0xe4,0xef,0x3f,0x90,0x29,0xca,0x0e,0xa0,
		0xe3,0xb3,0xa0,0xd5,0xd6,0xd2,0x26,0xed,0xbb,0xf4,0x4d,0xaf,0x8f,0x04,0x5d,0xc2,
		0x86,0xde,0xd3,0xc4,0xec,0x4d,0xb6,0xb4,0x53,0x47,0x07,0x9f,0x33,0xea,0xf9,0x8e,
		0x3c,0x95,0xb4,0xb6,0x0e,0x79,0xef,0x4a,0x30,0x93,0xfe,0xec,0x54,0x37,0x03,0x42,
		0x2b,0xa7,0x4a,0x11,0x85,0x11,0xc2,0x19,0x3b,0x54,0xfe,0x8b,0x63,0x38,0x66,0xed,
		0x2c,0x70,0x5c,0xcb,0xc6,0xe7,0xd9,0xd3,0x65,0x68,0x09,0xec,0x3d,0x33,0x56,0xe7,
		0x40,0x0a,0x96,0x48,0xec,0x37,0x50,0x50,0x41,0xe3,0xe3,0x1a,0xf1,0xc0,0x2e,0xef,
		0xe9,0x24,0xa6,0x70,0x47,0xd3,0x02,0x03,0x01,0x00,0x01,0x02,0x82,0x02,0x00,0x7b,
		0xb0,0xb1,0x4b,0x4f,0xa4,0x35,0x50,0x5b,0x69,0x87,0x6e,0x65,0xa3,0xa3,0xf8,0x89,
		0x2d,0x61,0xdd,0xa5,0x37,0x09,0xf4,0x25,0x7a,0xed,0x4c,0x8a,0xa9,0x1f,0x23,0x51,
		0xcc,0xa7,0x4c,0xda,0x19,0x89,0xc8,0x98,0xc8,0x8e,0x4a,0x4d,0xc6,0x0c,0x58,0x3f,
		0xe2,0xe5,0xf7,0x38,0x52,0x93,0x3b,0xb1,0x39,0x42,0xbe,0xf0,0x4b,0x4a,0xf9,0x85,
		0xf8,0xe5,0x6f,0xec,0x2d,0x28,0x2e,0xd9,0xce,0x56,0xf2,0x7e,0x45,0x2b,0xfd,0xc4,
		0xff,0x6e,0x72,0x95,0xd9,0x52,0x51,0xc2,0x64,0xa3,0x67,0x43,0xc1,0x4f,0xce,0x78,
		0xa2,0xf4,0xac,0x6b,0xf8,0xba,0x0a,0x8a,0xc5,0xf8,0x8c,0x82,0x52,0x4a,0x16,0x10,
		0xab,0xe7,0x54,0x8b,0x7f,0x6a,0x97,0xbc,0x74,0x44,0x73,0xde,0xd2,0x63,0x70,0xbf,
		0xf8,0x6f,0x96,0x68,0x85,0xea,0x31,0x78,0x7b,0x05,0x81,0x97,0xab,0x58,0x83,0x0e,
		0xa4,0x77,0xfb,0x60,0x0b,0xca,0xb4,0xe2,0xf1,0x33,0xa6,0x13,0xf9,0xf1,0x25,0x31,
		0x9d,0x27,0x2e,0xa5,0xea,0x32,0x3f,0xbe,0xa8,0x30,0xee,0x14,0x67,0x25,0xa8,0x61,
		0x33,0xc4,0x16,0x7c,0x63,0xef,0x89,0x9e,0xde,0xbd,0x2f,0x91,0x76,0x93,0x29,0x18,
		0x13,0x25,0xb5,0x74,0x8a,0x11,0x46,0x40,0x79,0x01,0xa8,0xd8,0xbf,0x66,0xda,0x94,
		0xde,0xa2,0x0e,0x64,0xdd,0x3c,0x12,0xad,0x72,0x51,0xdf,0x71,0x9d,0xdd,0xf3,0xfe,
		0x88,0x2b,0x6a,0x22,0xa3,0x0a,0xd1,0x06,0x18,0x53,0xf7,0x48,0xdd,0x83,0xa7,0x28,
		0x39,0xad,0xbd,0x88,0x57,0x10,0xcf,0xf9,0x5d,0x55,0x4c,0x1b,0xcf,0x04,0x3d,0xbb,
		0x3f,0xee,0xf1,0x9d,0x49,0x8e,0x7d,0x8d,0xb5,0xca,0xed,0x36,0xbd,0x0d,0x44,0x47,
		0x0f,0xe7,0xd7,0xd1,0xa1,0xb0,0xeb,0x4c,0x39,0x1a,0x07,0x36,0xbb,0xfe,0x04,0x84,
		0x6a,0xc9,0x8d,0x62,0x43,0xa4,0xe3,0xe5,0x8b,0x57,0x54,0x9f,0xf7,0xf5,0x4c,0x92,
		0xf1,0x03,0xb3,0x3c,0x9d,0xb0,0x4f,0xbc,0x6b,0x36,0xfd,0xf5,0x19,0x15,0x67,0xa7,
		0x9b,0xb3,0x5a,0x0b,0xe9,0x4a,0x45,0x48,0x0c,0xfc,0x28,0xd3,0x77,0xbe,0x27,0xda,
		0x9c,0x2c,0x3c,0xc0,0xbb,0x2a,0x4e,0x91,0x0a,0xe4,0x42,0x33,0x30,0x5a,0xf6,0xa8,
		0x73,0x87,0xaa,0xb7,0x62,0xc6,0x3d,0x96,0x97,0x14,0xbe,0x53,0xc0,0xb8,0xa2,0x6b,
		0xd2,0x0c,0xd6,0x37,0x61,0xb3,0x73,0xb8,0x15,0x33,0x0e,0xb9,0x2a,0x1f,0xa7,0xe6,
		0xab,0x82,0x72,0x76,0x33,0x5d,0xfe,0xc9,0x41,0x46,0x54,0x8d,0x07,0x3e,0xc8,0x28,
		0xf3,0x79,0x3a,0x84,0xca,0xfa,0x12,0x12,0x61,0x96,0xa3,0x3f,0x5f,0xa2,0xf4,0xf2,
		0xf6,0x47,0x00,0x93,0xe9,0x9b,0x2b,0x2d,0x91,0xf2,0xff,0x92,0x40,0x58,0x09,0x65,
		0x48,0x0d,0x56,0xc7,0x4b,0xe3,0x9b,0xf4,0x24,0x08,0xa0,0xe4,0x1e,0xf6,0x0d,0xc0,
		0x80,0x89,0x8c,0xe3,0xeb,0x53,0x0d,0x87,0xb4,0xda,0x46,0x73,0x97,0x70,0x55,0xe8,
		0x3d,0x65,0x04,0xa8,0x9d,0x60,0xfb,0x2f,0x49,0x70,0x39,0x36,0xa2,0xfb,0x39,0x1f,
		0xdc,0x39,0xd5,0x96,0x08,0xd5,0x00,0x87,0x05,0x11,0xb4,0x58,0xc9,0xe4,0x5e,0x53,
		0x39,0x8d,0xb1,0x52,0xd3,0x87,0x1f,0x18,0xd6,0x1b,0x9a,0xfa,0x44,0x35,0xc9,0x02,
		0x82,0x01,0x01,0x00,0xe9,0x7a,0xcd,0x5f,0x64,0xc4,0x60,0xb2,0xcd,0x51,0xcb,0xd7,
		0x0a,0xf5,0xb4,0xca,0xa2,0x88,0x2b,0xf6,0x03,0x3a,0x92,0xa2,0x3e,0xd8,0x0f,0x03,
		0x9e,0x8a,0x32,0xc8,0xa4,0xc4,0x83,0xf9,0x4e,0xe1,0xbb,0x89,0xc1,0xdc,0x1f,0x6d,
		0x04,0x36,0x0a,0x1c,0x3f,0x65,0x42,0x51,0xad,0x72,0xeb,0x39,0xcc,0xcb,0xfc,0x38,
		0xb0,0x72,0x05,0x4b,0xb0,0xf2,0x1b,0x9d,0x51,0x6e,0xf2,0x72,0xe7,0xcf,0x86,0xf8,
		0xa8,0xf8,0x38,0xeb,0xa8,0x29,0xe7,0xfe,0x9d,0x80,0x3d,0x46,0x9a,0x18,0x10,0xfc,
		0x5b,0x37,0x47,0x63,0x33,0xdd,0xfc,0x0c,0xb6,0xf0,0x0e,0x99,0x67,0x97,0x0b,0x4e,
		0x47,0x4e,0x04,0x37,0x3f,0x8d,0xc9,0x2d,0xf5,0x0f,0xa1,0x55,0xe3,0x13,0x9b,0xfe,
		0xbf,0x4e,0x1c,0xd2,0x74,0x70,0x55,0x51,0xf2,0xe9,0x02,0x20,0x29,0xbe,0xa4,0xb8,
		0x66,0x64,0x63,0x3d,0x13,0xfd,0x90,0xeb,0xdd,0x0b,0x72,0xd9,0x5a,0x65,0x08,0xb6,
		0xb4,0x35,0x4e,0x64,0xb1,0x87,0xfd,0x81,0xd2,0x1a,0x0b,0x1e,0x4a,0x85,0x3c,0x27,
		0xdf,0x11,0xd7,0xfe,0x6c,0x89,0x53,0xcf,0xf6,0x34,0x4f,0x50,0xeb,0xae,0xd2,0x51,
		0x3d,0xc0,0x37,0x61,0xe8,0x87,0x7c,0x71,0xff,0xa8,0x00,0x53,0x31,0x04,0x30,0x27,
		0xb8,0xdf,0xdb,0xa9,0x7c,0xae,0x03,0x7f,0xd5,0xd1,0xfd,0xa1,0xf1,0x45,0xa2,0x00,
		0xc0,0xd2,0x0f,0x8d,0xcc,0xd6,0x2e,0x5c,0x48,0x9e,0xea,0x8a,0xe8,0x27,0x91,0x0d,
		0x3f,0x48,0xbd,0xdf,0x0b,0x18,0xdc,0x30,0x89,0x06,0x9f,0x96,0xd8,0x00,0xde,0x47,
		0x03,0x68,0x59,0x55,0x02,0x82,0x01,0x01,0x00,0xdd,0x1a,0xbc,0x95,0x1f,0xf1,0x47,
		0x4e,0xbf,0xb7,0x08,0x07,0xb1,0x60,0xb1,0x10,0xb1,0xec,0xce,0xf4,0x29,0xc8,0xfc,
		0x85,0x35,0xab,0x0a,0xa9,0x83,0x76,0xa8,0x2d,0x3d,0x33,0xaf,0x90,0x6f,0xb0,0x39,
		0x57,0x50,0xb9,0xaa,0xcc,0xd8,0x72,0x3c,0xf7,0x3a,0x8c,0x3a,0x6a,0xd5,0xc3,0xa0,
		0x92,0x91,0x78,0xac,0x55,0xe1,0xbd,0x1b,0xa1,0xbf,0x5d,0xa4,0xf7,0x69,0x8d,0xbf,
		0x09,0xe8,0x7c,0x84,0xc4,0x5e,0xcb,0xbe,0x8f,0x12,0xd3,0xed,0x10,0x91,0xbc,0x47,
		0x0e,0xb2,0xc7,0x33,0xc3,0x1f,0x8d,0x27,0xeb,0xa9,0x71,0x8e,0xe7,0x8d,0xb8,0x87,
		0x38,0x5b,0xff,0x6b,0x67,0x95,0x0b,0x79,0x52,0x44,0x82,0xc5,0x0d,0xae,0xad,0x4d,
		0xb0,0xf5,0x67,0x6e,0x4b,0x92,0x87,0x5b,0x5b,0xe3,0x83,0xab,0x1c,0xd7,0x5e,0x1c,
		0xad,0xb5,0x9c,0xfb,0x57,0x94,0xc1,0x72,0x20,0x15,0x4a,0xca,0x80,0x8f,0x73,0x3a,
		0x63,0x6d,0x28,0xc0,0x16,0xd9,0x84,0x39,0x40,0xbf,0x44,0xbb,0x15,0xed,0x19,0x1f,
		0x53,0x44,0x9b,0x16,0x51,0xb7,0x95,0x54,0xc2,0x3e,0x00,0x6a,0x56,0xdc,0x02,0x32,
		0xcc,0xa2,0x09,0xbf,0x2d,0x3c,0x12,0xcb,0xbc,0x0e,0xd8,0xb3,0x11,0x0a,0xab,0xd3,
		0x65,0xb6,0x03,0xea,0x8c,0xdf,0x15,0xe8,0xb9,0xac,0x78,0x11,0x55,0xf9,0x2f,0x39,
		0xdb,0xf9,0x74,0x9f,0x70,0xdf,0x00,0x31,0x95,0xa6,0xbb,0x16,0x9e,0xa0,0xe0,0xd6,
		0x9e,0xb3,0xa1,0x8c,0xe8,0xfb,0xca,0xc9,0xbe,0x3c,0x71,0x0e,0x79,0x7a,0xcb,0x5c,
		0x05,0xa3,0x99,0xc2,0xf1,0x02,0x94,0x7c,0x87,0x02,0x82,0x01,0x00,0x62,0xf2,0x56,
		0x22,0xfd,0x53,0x74,0x1f,0x92,0x7f,0xfd,0xc1,0x0e,0xb5,0xfe,0x7e,0x79,0xce,0xf7,
		0xc2,0x74,0xaf,0xd8,0x00,0xc6,0x5d,0x4e,0x4f,0x9c,0x5a,0xb9,0x16,0xeb,0x2d,0x15,
		0x39,0x0c,0xc3,0x01,0x75,0x6a,0x20,0xdd,0x78,0x97,0xf6,0x46,0xe6,0x9d,0xbf,0x4e,
		0x11,0xcb,0x4e,0x0e,0x7e,0x1a,0x5a,0xc0,0x73,0x4d,0xe3,0xa4,0x76,0xe5,0x70,0x55,
		0x5f,0xa0,0x69,0x42,0x7a,0x8b,0xdf,0x19,0x36,0x3c,0x75,0xa5,0xb9,0xc9,0x34,0xa9,
		0x4a,0xf0,0x78,0xae,0x7f,0x43,0x42,0xbb,0xc0,0x16,0xf0,0x20,0x62,0xdc,0x52,0x51,
		0x45,0x1a,0x2a,0x36,0x25,0xb1,0x0f,0x04,0x0d,0x92,0x8e,0x6f,0x9e,0xf2,0x62,0x26,
		0x46,0x41,0xba,0xf4,0x06,0xb0,0x0b,0x59,0x6a,0xe6,0xac,0x35,0xee,0xc2,0xc5,0xf0,
		0x82,0xa0,0x4d,0x3b,0x47,0x62,0x29,0x97,0x29,0x46,0xcb,0x78,0x7b,0x24,0x03,0xab,
		0xed,0x29,0x6a,0x76,0xab,0xc2,0x71,0x5a,0xf6,0x02,0xfd,0x2c,0x51,0xe4,0x22,0xdb,
		0xbe,0xae,0xc9,0xb6,0xb8,0x89,0xa0,0x59,0x54,0x14,0x67,0x3d,0x80,0x67,0x82,0xf3,
		0x70,0x08,0xc9,0x36,0x6b,0xf6,0xd5,0xc9,0xf0,0x00,0x19,0x7b,0xdf,0x14,0x6a,0x86,
		0xc4,0xd1,0x31,0xe3,0xa1,0x5d,0xfe,0x86,0x61,0xef,0x29,0x7f,0xb0,0x1e,0x54,0xa8,
		0xca,0xfe,0x54,0xd6,0x06,0x51,0x77,0xcf,0x26,0x3e,0x91,0x47,0x62,0x32,0xd2,0xfa,
		0x26,0xc5,0xe8,0x03,0x42,0x07,0x0c,0xed,0x9e,0x0d,0x99,0xc8,0x4d,0xc4,0x28,0x2e,
		0xf8,0xaa,0xb9,0x91,0xdc,0x9d,0x82,0x10,0xb1,0x4b,0xb2,0x67,0x59,0x02,0x82,0x01,
		0x01,0x00,0xb8,0x3b,0x9f,0x07,0x63,0x26,0x58,0x94,0x75,0x8a,0xbd,0x56,0x2b,0xa6,
		0xb5,0xe3,0x83,0x5e,0x1e,0xd3,0xb4,0x3d,0x94,0xac,0x2a,0x9b,0xea,0xb6,0x74,0xa4,
		0x5a,0x5d,0xd7,0xb1,0x49,0x88,0xc0,0x87,0xc6,0x3f,0xcb,0x33,0xe9,0xed,0xe6,0x2c,
		0xca,0x3f,0xf6,0xb9,0x01,0xb4,0x23,0x8a,0x6e,0x31,0xb2,0xa5,0x2a,0x74,0x25,0x34,
		0xbd,0xe1,0x78,0xe3,0x3e,0xa2,0x29,0x81,0xc2,0xbd,0x2e,0xcb,0x12,0x95,0xcd,0xa7,
		0x57,0x91,0x3f,0xce,0xf6,0xa9,0xe7,0xc5,0x4a,0x30,0x25,0x27,0x77,0x2a,0x0f,0x10,
		0x3f,0x43,0x4e,0x5d,0x21,0x06,0x30,0x40,0xa1,0xeb,0x84,0x3c,0xbf,0xf1,0xff,0x6f,
		0x20,0x18,0x3c,0x9d,0xfa,0x33,0xfc,0x68,0xcb,0x63,0xb8,0x18,0x06,0xff,0x51,0x89,
		0x17,0xc6,0xe9,0x3c,0xbd,0x47,0xba,0xec,0xe0,0x58,0x9e,0x0b,0xc0,0x22,0xaa,0x00,
		0xc6,0x67,0x95,0x56,0x4c,0x85,0xf3,0x01,0xc0,0x95,0x38,0x4f,0xcc,0x3f,0x3d,0xdf,
		0xbf,0x15,0x04,0x4a,0xf0,0xd8,0xc4,0x47,0x3a,0xa2,0xd7,0x77,0xa2,0x91,0x54,0xb7,
		0x49,0x78,0xd0,0xd0,0xe7,0xca,0x98,0x67,0xfc,0x8c,0x26,0x38,0x98,0xe3,0xc8,0x3a,
		0xa1,0x28,0x81,0xf6,0x6e,0xbe,0xb4,0x75,0x98,0x20,0x18,0x1a,0x0b,0x46,0x76,0x5c,
		0x7b,0x1e,0xbb,0x67,0x10,0x8a,0xe2,0xa7,0x47,0x3e,0xd4,0x0d,0x29,0x0d,0x93,0xc3,
		0x45,0x8d,0xbc,0xf0,0x07,0x59,0x06,0x14,0x52,0xc0,0xca,0x4c,0xc2,0x6d,0x1f,0xe1,
		0x49,0x59,0x0a,0x63,0xe9,0xfb,0xaf,0x25,0xe3,0xf7,0x8e,0xea,0x80,0x54,0xf2,0x21,
		0x67,0xe1,0x02,0x82,0x01,0x01,0x00,0xc3,0x01,0xf6,0xbb,0xe5,0xfb,0x56,0x93,0xf6,
		0x65,0xb2,0x6d,0x1a,0x61,0xe1,0xde,0x87,0xe3,0x89,0x50,0xa5,0x82,0x52,0x70,0xee,
		0x68,0xea,0x5a,0x56,0x67,0xe1,0x1a,0x3a,0xed,0x28,0xb2,0x26,0x67,0x68,0xd1,0xa3,
		0xdb,0x34,0x37,0xdb,0xda,0x68,0x1a,0xc8,0x29,0x4d,0xd5,0x0a,0xd0,0xb4,0xbc,0x5c,
		0xee,0x56,0x94,0x83,0x1b,0x8d,0xf7,0x35,0x46,0x95,0x33,0x57,0x40,0xb9,0xb7,0xda,
		0xe5,0xf7,0x88,0x15,0x36,0xda,0x6a,0x6b,0x2a,0xc4,0x30,0x8a,0x04,0x20,0xad,0x6e,
		0x99,0xcb,0x77,0x9a,0x63,0x38,0xf5,0x01,0x29,0x86,0xb1,0xc1,0xc8,0x89,0x44,0x4d,
		0x90,0x58,0x5f,0xb0,0xda,0xc9,0x95,0xad,0x6e,0x93,0xaf,0x7e,0xac,0x71,0x7c,0x64,
		0x3c,0x4b,0x8e,0x70,0x23,0xcf,0x57,0xcf,0xe2,0x84,0xca,0x91,0x1d,0x6d,0xc3,0x13,
		0x2b,0x08,0xe1,0x7f,0x4e,0x87,0x59,0xaf,0x42,0xb4,0x3a,0xc9,0x29,0xc0,0x25,0x9c,
		0x3a,0x1d,0x5e,0x5f,0x7c,0x4b,0x24,0x7e,0x2f,0x64,0x61,0xae,0xff,0x85,0x77,0xae,
		0xdc,0x71,0x0d,0x6d,0x2d,0x56,0xd9,0x43,0xc2,0x11,0xe4,0x74,0x67,0x42,0x15,0x39,
		0xdf,0xc2,0x70,0x06,0x63,0xc4,0x06,0x80,0x31,0xb6,0x95,0xe4,0x87,0xae,0x69,0x10,
		0xec,0xb9,0xc5,0x47,0xcb,0xfe,0x12,0xcc,0x6f,0x45,0xb6,0x58,0xe2,0xc6,0xf9,0xf8,
		0xfb,0xe8,0x05,0x30,0x41,0x94,0xa9,0xd1,0xd9,0xc6,0xd5,0x99,0xc5,0xac,0x5c,0x9e,
		0xe5,0xfa,0x78,0xc8,0xa4,0x58,0x32,0x18,0xf7,0xdc,0x8f,0x4c,0x8d,0x3a,0xdf,0x27,
		0x5e,0xec,0x0e,0x09,0x41,0xfa,0x69);

/**
 * RSA OAEP SHA512 decryption test vectors from https://boringssl.googlesource.com/
 */
static rsa_oaep_test_t rsa_2048_oaep_sha512_tests[] = {
	{ chunk_from_chars(                                                          /* 2 */
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00),
	  chunk_from_chars(),
	  chunk_from_chars(
		0x35,0xae,0xe1,0xc5,0x60,0x44,0xda,0x3b,0x86,0x6b,0xfe,0xd9,0x89,0x69,0x0d,0xba,
		0xf5,0x7a,0xc1,0x02,0x11,0xca,0x4c,0x36,0x4c,0x4f,0x41,0x27,0xfe,0xd0,0xa5,0x5b,
		0x58,0x12,0x17,0xc7,0xe8,0x54,0xd1,0x1f,0xd1,0xa1,0xf9,0xd5,0x43,0x1c,0x2c,0x30,
		0x9e,0x62,0xa6,0xf7,0xc3,0xc5,0x96,0x76,0x18,0x2b,0x28,0x8e,0xdc,0xcf,0xa9,0x61,
		0xc7,0x8c,0x1b,0xaa,0x53,0xf2,0xdb,0x1b,0x1b,0x9a,0x4d,0xd0,0x50,0x15,0xf4,0x18,
		0x72,0xcf,0x22,0xac,0xfe,0x3a,0x07,0x1d,0x6a,0xc1,0xe8,0x2b,0xa6,0xc3,0x1f,0x5c,
		0x2d,0x93,0x25,0x24,0x7d,0x6f,0x2c,0x9b,0x03,0xce,0x00,0xc9,0x4f,0x02,0xfe,0x33,
		0xc5,0x67,0x8a,0x41,0x49,0xcf,0x2f,0xb7,0x0b,0xbb,0xd9,0x95,0xaf,0x14,0x65,0xe3,
		0x81,0x9c,0x83,0xc9,0xab,0x8b,0x55,0x08,0x8f,0xd5,0xd7,0x50,0x36,0x61,0x3b,0x04,
		0xdf,0x30,0x21,0x13,0x94,0x87,0x00,0xd7,0x87,0x6b,0x7c,0xec,0x9d,0x73,0x37,0xbf,
		0x57,0x73,0x34,0x3d,0x51,0xa4,0x29,0x8e,0x71,0x7a,0x4f,0xae,0x09,0xe5,0x73,0xfe,
		0xa4,0x12,0xd8,0x8b,0x83,0x6e,0xcd,0x4f,0x74,0xc7,0xcc,0x75,0x00,0x60,0x97,0x23,
		0xb3,0xf3,0xa2,0xa0,0x0d,0x85,0xee,0x7c,0xcb,0xd9,0x2b,0xf6,0xc0,0x65,0x83,0x30,
		0x27,0xc5,0xe5,0x03,0x10,0xc6,0xcf,0x8f,0xe8,0xd1,0x3e,0x2d,0x82,0x18,0xe7,0x85,
		0x33,0x3a,0x2e,0x65,0xb5,0x47,0xe5,0xed,0xa2,0xf8,0xf2,0xf9,0x60,0x8f,0x36,0x6d,
		0x7e,0x43,0x63,0x6f,0xca,0x4f,0x46,0x45,0x0c,0x76,0xf0,0x6d,0xd0,0x8b,0x00,0xdb)
	},
	{ chunk_from_chars(                                                          /* 3 */
		0x54,0x65,0x73,0x74),
	  chunk_from_chars(),
	  chunk_from_chars(
		0x58,0x87,0x8d,0xc8,0xb9,0x52,0x7a,0x41,0x6e,0xc9,0xbf,0xbe,0x0f,0x07,0xfd,0xee,
		0x8d,0xc5,0xba,0xc8,0xe3,0x1c,0xa5,0x45,0xae,0x7c,0x6e,0xf4,0xa6,0x8f,0x2c,0x6b,
		0x2b,0x73,0x36,0x65,0x18,0xed,0xf8,0x5f,0x11,0x43,0xc2,0x7f,0xba,0x00,0xa5,0xd9,
		0xa9,0xb0,0x28,0x43,0xad,0x89,0x51,0x63,0x1d,0xdf,0x01,0xef,0x12,0x38,0x85,0x3b,
		0x45,0x93,0xab,0xf9,0x70,0x1c,0x62,0x19,0x41,0xb4,0xf0,0x59,0x31,0xea,0xf3,0x07,
		0xc0,0x6f,0xaa,0x7f,0xb8,0x18,0xdb,0x8f,0x85,0x9c,0x96,0xdb,0xfc,0x43,0x26,0x89,
		0x65,0x30,0x3b,0x44,0xfc,0xc6,0x9a,0x0e,0x3c,0xe6,0x19,0x62,0x49,0x07,0xbc,0xe0,
		0x74,0x20,0x5f,0x11,0x37,0x15,0xe5,0xe8,0x20,0xbc,0x8c,0x6d,0xda,0x65,0x06,0x64,
		0x53,0x21,0x57,0x02,0x41,0x6d,0xb9,0x32,0x0f,0x54,0xe6,0x7f,0xc9,0x1e,0x9d,0x37,
		0xa8,0x52,0x2d,0x70,0x1a,0xa2,0x29,0x76,0x96,0x6a,0x99,0xcb,0xc8,0xfe,0xc0,0xe1,
		0x2f,0x2e,0xb9,0xb5,0x70,0x5b,0x4d,0xc7,0x7c,0xaf,0xf8,0x2a,0x36,0x48,0x55,0x50,
		0x75,0x2a,0x3a,0x5e,0xbd,0x47,0xfc,0x67,0xd6,0x6b,0x68,0x02,0x4a,0x2c,0x5d,0xb8,
		0x09,0xd0,0x8b,0xe9,0x09,0x0b,0xb9,0x6e,0x18,0x80,0x79,0x25,0xb1,0x8a,0x75,0x3e,
		0xce,0x05,0xf1,0x62,0x4f,0xb1,0x95,0x37,0xab,0xe7,0xfd,0x66,0x28,0x30,0xd5,0x66,
		0x47,0xa4,0x16,0xdf,0x7d,0xdb,0x3e,0x6a,0x07,0x31,0x50,0xd5,0x11,0x2f,0x60,0x53,
		0x8b,0x68,0x52,0x43,0xf1,0xe4,0xfd,0xe2,0xa5,0x95,0x1c,0x9e,0x94,0x99,0xec,0xc4)
	},
	{ chunk_from_chars(                                                          /* 4 */
		0x31,0x32,0x33,0x34,0x30,0x30),
	  chunk_from_chars(),
	  chunk_from_chars(
		0x28,0x00,0xf4,0x21,0xc1,0xc0,0x78,0xb8,0xbe,0xe9,0xc4,0xa4,0xf3,0x55,0xe1,0xea,
		0x83,0x4c,0x5b,0xca,0x44,0x2e,0x99,0x86,0x79,0x2a,0x50,0xe6,0x6e,0x68,0xc0,0xb8,
		0x12,0x2c,0xb8,0x1b,0xb5,0x9e,0x00,0x70,0xca,0x04,0x4c,0x1c,0x5b,0x19,0x0f,0x90,
		0x98,0xdb,0xda,0xa9,0x77,0xa4,0x41,0xa8,0xa4,0xc6,0x28,0x97,0xed,0xb9,0x48,0x49,
		0x35,0x00,0x7a,0xad,0xb6,0x73,0x2c,0x1b,0x2b,0x21,0x71,0xae,0xa3,0xab,0x15,0x13,
		0xf2,0x25,0xeb,0xe7,0x83,0x0f,0xb8,0x23,0xec,0x3f,0x54,0x33,0xbd,0x8f,0x3c,0x3e,
		0x52,0x77,0x5b,0xb4,0x5f,0xa9,0x1a,0xa0,0xad,0x3b,0x7c,0x1b,0xc6,0x47,0xb7,0x75,
		0xe4,0xde,0x8e,0x1b,0x22,0xeb,0x97,0x10,0x41,0x26,0x78,0x78,0x42,0x1c,0xf4,0x3a,
		0x5e,0x2a,0x26,0x75,0xb2,0xc9,0x40,0xda,0xa5,0x5f,0x12,0xa7,0xc7,0x9d,0x87,0xd4,
		0x5e,0x08,0xc5,0x59,0x23,0x62,0xf5,0xe0,0xd7,0xea,0x66,0x8a,0xf9,0x9e,0xec,0xd2,
		0xf6,0x0d,0x7f,0xc3,0x79,0x1e,0x4f,0x53,0xae,0xd7,0x99,0x31,0xbd,0x0b,0xa9,0x0f,
		0x70,0x1d,0xe8,0x36,0xd8,0xc8,0xc9,0xbe,0x7f,0x7f,0x4a,0xed,0xcb,0xe5,0xc9,0x23,
		0x83,0x93,0x2f,0x76,0x2b,0xec,0x65,0xfa,0x29,0x8e,0xb6,0x44,0x87,0x7d,0xe2,0x6e,
		0xec,0x99,0x51,0x46,0xaf,0x55,0x1a,0xd7,0x7e,0xcf,0xd0,0x6a,0x36,0x70,0x72,0x1a,
		0xb4,0xc7,0x57,0x7e,0x61,0xc0,0x48,0xc5,0xdd,0x01,0xb2,0x82,0xcf,0xc0,0xfc,0x96,
		0x3b,0x92,0xc7,0x8e,0xab,0xd1,0x3f,0xba,0x64,0x19,0x5d,0x74,0xde,0x48,0x29,0xbb)
	},
	{ chunk_from_chars(                                                          /* 8 */
		0x31,0x32,0x33,0x34,0x30,0x30),
	  chunk_from_chars(
	  	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00),
	  chunk_from_chars(
		0x38,0xea,0xd5,0xce,0xc1,0x62,0x2d,0x62,0xe9,0xf2,0x7e,0xb7,0xbb,0x9d,0x36,0x9f,
		0xc1,0x3c,0xf7,0xd2,0x12,0x56,0xc5,0xdf,0x89,0x58,0xdf,0xfa,0x1d,0xf2,0xdf,0xba,
		0xe0,0x06,0xc8,0x0a,0xc4,0x5e,0xbc,0x30,0x44,0xa2,0x0f,0x8b,0xa0,0x24,0xb7,0x3c,
		0x2e,0x03,0x18,0x5a,0x9e,0x4d,0x97,0x5f,0xe3,0x07,0x5e,0x6e,0x11,0x78,0x71,0x16,
		0xd1,0xdd,0xab,0xf2,0xaf,0x65,0x90,0x4e,0xc9,0xa5,0xb1,0x45,0xdb,0xf1,0x67,0x87,
		0x2d,0x06,0x6e,0xf4,0x90,0xc4,0xb9,0xa7,0x24,0x00,0x0c,0x44,0x42,0x5c,0xd3,0x34,
		0x48,0x28,0x8e,0x88,0x3f,0xd0,0x1a,0xd9,0x15,0xb8,0xa4,0xd9,0xd3,0xc6,0x5f,0xc0,
		0xc1,0x2d,0x5c,0x5b,0xcb,0x78,0xb3,0x23,0xdb,0x20,0xba,0x07,0xe5,0x7a,0x18,0x82,
		0x0e,0x11,0x54,0xe9,0x46,0x0d,0x71,0xb9,0x2f,0x85,0xae,0xd9,0x2c,0x21,0x28,0xc8,
		0x3e,0x59,0x85,0x64,0x13,0x8a,0x97,0xe0,0x37,0x99,0x66,0x45,0x93,0x64,0xbe,0x6a,
		0xa1,0x66,0xa8,0xb6,0x2c,0xf7,0xc5,0xb8,0x06,0x2d,0x99,0xe9,0x8f,0xad,0x15,0x5c,
		0x9f,0x0f,0x1c,0x86,0x29,0xe4,0x3a,0x45,0x67,0x45,0x63,0xf0,0xd1,0x42,0xc3,0x09,
		0x60,0x5b,0xa2,0xdc,0xb0,0x48,0xa9,0xd5,0xc5,0x8f,0xeb,0xa1,0x6b,0x5b,0x2c,0x98,
		0x8d,0x93,0x74,0x1e,0x84,0xec,0x47,0xf1,0xcb,0xfe,0xee,0x54,0x0f,0x10,0xda,0xc1,
		0x20,0x73,0x41,0x43,0xc8,0x0e,0x98,0x72,0x5c,0x60,0x9a,0xc2,0x49,0x55,0x8f,0x8a,
		0xc5,0x8c,0xb2,0x17,0x69,0x94,0x11,0x02,0xaf,0x34,0xaa,0xf0,0x2d,0x53,0x8c,0x55)
	},
	{ chunk_from_chars(                                                          /* 9 */
		0x31,0x32,0x33,0x34,0x30,0x30),
	  chunk_from_chars(
		0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
		0x10,0x11,0x12,0x13),
	  chunk_from_chars(
		0xa4,0x58,0x2c,0x4d,0xbd,0x1e,0x60,0x06,0x2e,0x51,0x73,0x31,0xf4,0xd4,0x9a,0x67,
		0x49,0x1c,0x97,0x5b,0xbe,0xeb,0x58,0xc5,0x3c,0x21,0xc1,0xaa,0x35,0x0c,0x63,0xd7,
		0x49,0x40,0xeb,0xb3,0xe6,0xd8,0x06,0x2c,0xef,0xb2,0xf0,0xcc,0x64,0x5b,0x07,0xe7,
		0x7e,0x6b,0xd3,0x50,0xba,0xab,0x08,0x86,0x26,0x65,0xb8,0x0f,0xcb,0xb5,0xc3,0x86,
		0xbf,0xe3,0x30,0xea,0xe7,0xc4,0x3a,0x45,0x1d,0x68,0xe7,0x5d,0xa6,0xa0,0x23,0x0a,
		0x5f,0xfc,0x45,0xc9,0x70,0x6c,0xb5,0xbf,0xf4,0x95,0x2a,0xba,0x08,0x23,0x0a,0x62,
		0x69,0x29,0x72,0x6c,0xee,0xa0,0x68,0xd5,0x2c,0x18,0xc5,0x25,0xde,0xc9,0xd9,0x48,
		0x84,0xcd,0x93,0xa5,0xb3,0x9a,0xcb,0xcf,0x31,0xa0,0xa3,0xc1,0xd2,0x8b,0xc2,0xff,
		0x35,0x2f,0xf4,0x09,0x72,0x24,0x66,0x41,0x02,0x01,0x5a,0x14,0xd6,0xd9,0x66,0x3d,
		0x91,0x48,0x9f,0x9c,0xa4,0xe5,0xe2,0x40,0xa4,0xd9,0xc9,0x37,0x07,0xe0,0x15,0xf0,
		0x7d,0xd6,0x39,0x8b,0x30,0x69,0x59,0xd6,0xa5,0x45,0x61,0x6a,0x31,0x24,0xb3,0xa8,
		0x7c,0x8a,0x17,0x29,0x3b,0xa3,0x6f,0x3c,0x8a,0xf4,0xbe,0x8b,0xfc,0xcb,0xcc,0x0f,
		0xda,0x06,0x88,0x1e,0x05,0x04,0x6b,0x80,0x88,0xfa,0x09,0xc5,0x42,0xf6,0xbc,0x7a,
		0x39,0x7a,0xb8,0x2f,0x47,0xe0,0x5d,0x51,0x7e,0x79,0xb4,0x62,0xfa,0x77,0xbe,0x7f,
		0xa1,0xaf,0x05,0xa0,0x9b,0xaa,0x17,0xeb,0xff,0xe7,0x3e,0x38,0xc3,0x10,0x7f,0x46,
		0x00,0xd7,0x5f,0x9b,0xec,0xaa,0x8a,0xf6,0x8e,0x37,0xa4,0xde,0xed,0xfd,0x9f,0x10)
	},
	{ chunk_from_chars(                                                         /* 10 */
		0x31,0x32,0x33,0x34,0x30,0x30),
	  chunk_from_chars(
		0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
		0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f),
	  chunk_from_chars(
		0x1b,0xb7,0xa6,0xd1,0xdb,0xab,0x99,0x46,0x19,0xf2,0x5b,0xd1,0x65,0x9c,0x21,0x5d,
		0xfc,0x12,0xcc,0xde,0x9f,0x91,0xec,0xdb,0xce,0xbe,0xbd,0x9c,0x9d,0x13,0x99,0xab,
		0x82,0x96,0x03,0x5f,0x43,0xf0,0xac,0x65,0xc5,0x6f,0x56,0x70,0x7a,0xa4,0xa3,0x01,
		0x93,0x9b,0x74,0x5a,0x0d,0x00,0x00,0x65,0x20,0x72,0xab,0xa5,0xc5,0x14,0xca,0x33,
		0x1c,0x9d,0xd0,0x6a,0x2f,0x1c,0x01,0x22,0xb1,0xba,0x6f,0x93,0x89,0xc6,0xea,0x69,
		0x04,0xf3,0x6c,0xac,0x57,0x88,0xd3,0x39,0x69,0x1f,0xea,0xbd,0x34,0xb6,0x5b,0xfa,
		0x45,0x05,0xc6,0x0e,0x43,0x97,0x13,0x59,0x1a,0x8d,0xdc,0x6e,0xbe,0x85,0x13,0x1b,
		0xcf,0xb3,0x7f,0x74,0x76,0x12,0x0d,0x58,0x7f,0x12,0x7c,0xc5,0x2f,0x89,0x14,0xf0,
		0xc7,0x8a,0x2e,0xdd,0xdd,0x1c,0x6c,0x52,0x80,0xb7,0x45,0xde,0x59,0x5b,0xc6,0xbe,
		0x42,0x4d,0x01,0xd9,0x9e,0x58,0xa8,0x83,0x47,0x42,0xcd,0x2f,0x08,0x5b,0x33,0x49,
		0x66,0xb6,0x92,0xc3,0xbd,0x37,0x2b,0x94,0xc8,0x46,0x58,0x15,0x48,0xed,0x22,0x80,
		0xc6,0x4b,0x32,0x0e,0xc1,0x34,0x1a,0xb5,0x4a,0x70,0x2e,0xf7,0x04,0x0f,0xf6,0x70,
		0x94,0xd5,0x40,0xdc,0xb0,0x80,0xfd,0xee,0xb2,0x05,0x0f,0xff,0x66,0xea,0xab,0xfd,
		0x5b,0x66,0xc9,0x9a,0xb4,0x9d,0xb5,0xe6,0xc7,0x2c,0xb2,0xd5,0x30,0xd5,0x03,0xa8,
		0x7d,0x69,0x1d,0xcd,0xbf,0xf8,0x5c,0x5e,0x8c,0x9f,0xe2,0x8a,0x1f,0x32,0xfc,0x4a,
		0x22,0xa2,0xa6,0x7a,0xe9,0x58,0x4a,0x44,0x11,0xf8,0xdc,0x03,0xd3,0xe7,0x6b,0x55)
	},
	{ chunk_from_chars(                                                         /* 11 */
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78),
	  chunk_from_chars(),
	  chunk_from_chars(
		0x89,0xbc,0x06,0xf1,0xf1,0x2c,0x0b,0x68,0x83,0x52,0xd3,0x1d,0xdb,0xe2,0x2d,0xe9,
		0x2b,0x3e,0x8c,0xe8,0xe0,0xf7,0xd3,0x4e,0x56,0x63,0xce,0xf1,0xb4,0x73,0x40,0x8c,
		0x93,0x2a,0xad,0xe4,0xf0,0x6b,0x05,0x6a,0x52,0xa4,0x8a,0x0b,0x7c,0x80,0xc7,0x63,
		0xcc,0xd3,0x15,0x5f,0x9f,0x42,0x82,0xaa,0x35,0x0e,0x9c,0x49,0x4d,0xcd,0x99,0xdc,
		0x2f,0x4c,0x17,0xd5,0x3a,0xbb,0xf2,0x4a,0x37,0x19,0x4d,0xb5,0xf9,0x87,0xaa,0xa1,
		0x76,0x02,0x8b,0x25,0x70,0xc8,0xe7,0x4a,0xab,0x35,0x6e,0x23,0x3e,0x40,0x68,0x12,
		0xa1,0x7f,0xac,0x0b,0x92,0xd2,0x7f,0x50,0x3e,0x6d,0xcb,0xa5,0x57,0x87,0x55,0xad,
		0x33,0xa1,0x05,0xcc,0xd9,0x12,0x04,0xc8,0xed,0x22,0xe9,0x23,0x49,0x2f,0xf0,0x7d,
		0x5a,0xa7,0x02,0x39,0x4b,0x5b,0x8c,0xc4,0x17,0xe8,0xe3,0x90,0xfc,0x82,0x68,0xca,
		0xb2,0x46,0x8a,0x42,0x85,0xa4,0xfc,0x32,0x7a,0x83,0x03,0x8e,0x59,0x11,0x46,0x54,
		0xdf,0x7d,0x4d,0xd3,0x29,0x10,0xf0,0xfc,0x2e,0x90,0x01,0x77,0xd4,0x6a,0xea,0x50,
		0xa6,0x1f,0xb0,0xe2,0x06,0x69,0x47,0xfc,0x64,0x8e,0xf4,0x0e,0x22,0xc2,0x15,0x64,
		0x64,0xfa,0xd8,0xbf,0xab,0x19,0xd8,0xdd,0x9a,0x4a,0xaa,0x88,0x04,0x02,0x46,0x93,
		0xfd,0x2c,0xd4,0x5c,0x23,0x3c,0x59,0xec,0x67,0xbe,0x03,0xa8,0xb2,0x3f,0xd8,0x59,
		0x00,0x3b,0x2d,0x01,0x54,0x02,0x14,0xb3,0xc0,0x66,0x33,0xce,0x27,0x3a,0x9a,0x99,
		0x2d,0x11,0xbe,0xfc,0x23,0xef,0x6b,0xe3,0x47,0x98,0x52,0x2c,0x07,0x4f,0x4f,0xfd)
	}
};

static rsa_oaep_test_t rsa_4096_oaep_sha512_tests[] = {
	{ chunk_from_chars(                                                          /* 2 */
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00),
	  chunk_from_chars(),
	  chunk_from_chars(
		0x77,0xc6,0x34,0xe7,0xac,0x8d,0xc0,0xd2,0x71,0xf8,0xd9,0x70,0xc3,0xd5,0x9e,0xcd,
		0xc1,0x9a,0x09,0xad,0x50,0x76,0xf5,0x86,0x94,0x21,0x16,0xe7,0x12,0x5b,0x6d,0xf2,
		0x07,0xf8,0xaa,0x21,0x21,0x7c,0x47,0x86,0x24,0x19,0xcf,0xd6,0x4f,0x8c,0xf8,0x33,
		0x02,0x66,0x0c,0xae,0x99,0x3c,0x45,0xbd,0xed,0x25,0x2c,0x6e,0x61,0x8f,0xf2,0x25,
		0xd2,0x51,0xb0,0x05,0x70,0x99,0xb3,0xbb,0xa4,0xfb,0xf9,0x48,0x0b,0x53,0x6e,0x5e,
		0xb6,0xf3,0x9f,0x64,0xf2,0xc9,0xb3,0x2c,0x7d,0x07,0xed,0xbe,0xdc,0x4a,0x64,0x2a,
		0x7d,0x69,0xd2,0x63,0xd8,0x8a,0x62,0x47,0x57,0x69,0xb6,0x53,0xe5,0x50,0xdb,0xab,
		0xc1,0xd2,0xfc,0x0d,0x14,0xe2,0x7b,0xec,0x77,0x2b,0x26,0x43,0xf4,0x6b,0xc6,0xc8,
		0x95,0x04,0x15,0x97,0x7f,0xe2,0x1b,0x2f,0x33,0xa4,0x32,0x61,0x71,0x34,0xbc,0x20,
		0x8a,0x61,0x3c,0x3e,0xcf,0xcd,0x53,0x19,0x50,0xd7,0xed,0x44,0xb9,0x25,0xb3,0xf1,
		0x6c,0xaa,0x87,0x04,0x19,0xde,0x62,0x05,0x3c,0x44,0x98,0x4f,0xed,0xe8,0x9b,0x85,
		0x03,0x21,0x25,0x31,0xc1,0x33,0x45,0x86,0x82,0x65,0xd1,0xfb,0x13,0x9d,0x22,0x72,
		0xa9,0xf6,0x59,0xe6,0xa9,0x88,0xb9,0xf5,0x41,0x55,0x25,0x16,0x01,0x25,0x9b,0x2c,
		0x01,0x59,0xb3,0xdd,0xa4,0x91,0x0b,0x51,0x90,0x69,0x4d,0x98,0xae,0x84,0x7b,0x05,
		0xb1,0x52,0xfb,0x63,0xc1,0xfe,0xfa,0x31,0xab,0xae,0xe9,0x92,0xa4,0x6f,0xa7,0x40,
		0x74,0x99,0xba,0x1f,0x59,0xb6,0xdc,0x69,0xc3,0x48,0x50,0x2f,0xcd,0xdc,0x58,0xfb,
		0x2c,0x60,0xfb,0xe3,0x0f,0x74,0x71,0x82,0x1b,0x75,0x57,0x2f,0x14,0x91,0x38,0x84,
		0x19,0x72,0xd0,0x85,0x15,0xd8,0x5e,0xcf,0x03,0x90,0xad,0xe2,0x0b,0x16,0x30,0xc9,
		0xf7,0xcf,0xf1,0x6b,0xb1,0xc0,0xc0,0xc5,0x66,0xfd,0x0e,0x55,0xc1,0x09,0x0d,0xd2,
		0x8f,0x18,0xb5,0x01,0x93,0x47,0x46,0x1e,0x4e,0x53,0x3a,0x1d,0x97,0xe5,0x53,0x58,
		0x3a,0xf0,0xbe,0xec,0x3f,0x1d,0xc3,0xa5,0x95,0xf8,0x55,0xba,0xa7,0x58,0x34,0xee,
		0xda,0x16,0xf6,0xad,0xbb,0x43,0x5b,0xe7,0x04,0x40,0x50,0xf1,0x64,0xb6,0xba,0x4e,
		0xe4,0x20,0xba,0x91,0x86,0x02,0x7b,0x16,0x6b,0x50,0x53,0x4d,0x56,0x07,0xf2,0x63,
		0x5c,0x33,0x17,0xca,0x87,0xac,0xb9,0xfa,0x9d,0x08,0x27,0x2f,0xc1,0xb6,0x9e,0xaf,
		0xe2,0xd0,0xb1,0x7b,0x81,0xde,0xf0,0x88,0x51,0xe9,0xf6,0x23,0xe1,0x46,0x74,0x01,
		0x6d,0xda,0xd1,0x4a,0x86,0x12,0x5f,0x62,0x9d,0x36,0x42,0xf5,0x54,0x9c,0x1b,0xc6,
		0x98,0x45,0xfb,0x7f,0xe0,0x1b,0x9b,0xe3,0xc7,0x70,0x51,0x78,0x16,0x35,0xf4,0x38,
		0xc6,0x84,0x6a,0x17,0xa1,0xc1,0x56,0x69,0xf0,0xa1,0x61,0xed,0xef,0x0c,0x13,0xd0,
		0x1e,0xe2,0xf5,0x39,0x02,0x58,0x5d,0xd0,0x2d,0x2f,0x13,0x9b,0xb9,0x17,0x02,0xad,
		0x29,0xf9,0x3b,0x62,0x75,0xde,0x15,0xbc,0x7e,0x53,0x7a,0x1d,0x2a,0x4f,0x8d,0xf4,
		0x7f,0xd7,0x75,0x1a,0x4f,0x9a,0xc2,0x5d,0xcb,0xc9,0xb2,0xe4,0x3d,0x21,0xac,0xca,
		0xcc,0x6c,0x3f,0x71,0x55,0x84,0x54,0x35,0xfa,0xf5,0x0c,0x27,0x5c,0x3d,0x45,0x72)
	},
	{ chunk_from_chars(                                                          /* 3 */
		0x54,0x65,0x73,0x74),
	  chunk_from_chars(),
	  chunk_from_chars(
		0x1d,0xda,0x78,0x16,0x88,0x38,0xf4,0x3a,0x71,0xaa,0x61,0x15,0x1b,0xb8,0xbb,0x95,
		0x3c,0x20,0x4d,0x0a,0xf5,0x26,0x23,0x1c,0xb8,0x04,0x95,0x2d,0x4e,0x95,0x8e,0xd4,
		0x7d,0x2b,0x51,0xaa,0xd7,0xc3,0xdd,0xf0,0xcf,0x5a,0xf7,0x0b,0x87,0xb5,0xa5,0xc8,
		0x0d,0x99,0x63,0xe2,0x61,0x30,0x96,0x92,0xa8,0x22,0x29,0x4b,0x40,0xee,0x3a,0xd6,
		0x7a,0xf6,0x44,0x08,0x50,0x8b,0xbb,0x18,0xdd,0x2b,0x61,0x09,0x08,0x82,0x86,0x9a,
		0x52,0x07,0x19,0x7f,0xfe,0x0d,0xf3,0x9f,0x27,0x8c,0x2f,0x3a,0x71,0x0e,0x0f,0x8e,
		0xa4,0x51,0xb6,0x55,0xfc,0xd8,0x54,0x2e,0x07,0x60,0x6a,0xf8,0x8a,0x44,0xa7,0xbd,
		0xec,0xf5,0xa5,0x23,0xc3,0x12,0xff,0x73,0x94,0x2e,0xf4,0xe8,0x10,0x5a,0x5c,0xc6,
		0x9f,0xc1,0xbb,0x31,0x5f,0x77,0xf3,0x6b,0x87,0x47,0x7f,0xf6,0x93,0x28,0x99,0x63,
		0xd7,0x2f,0x2f,0xf0,0xb6,0xde,0xd1,0x8a,0x0d,0x56,0xd7,0x97,0x87,0x92,0x8c,0xcd,
		0x72,0xb7,0xd5,0xd7,0xac,0xd6,0x1d,0x37,0xd6,0x32,0xcb,0xdc,0xe6,0x6e,0x2c,0xbf,
		0xe9,0x90,0xcb,0x6e,0xe2,0x50,0xb8,0x26,0x12,0x48,0xe8,0x10,0x13,0xdf,0x77,0x44,
		0x8d,0xfe,0x1c,0xdc,0x5b,0x81,0x2c,0x83,0x80,0xaa,0xa0,0xc1,0x9e,0x6c,0xb1,0x17,
		0x81,0xc0,0xe3,0x08,0x00,0x17,0xee,0x25,0x4b,0x89,0xfa,0xb5,0xd5,0x34,0xcc,0x41,
		0x92,0x94,0x62,0x17,0x71,0x8d,0x31,0x61,0xc8,0x72,0x31,0xd9,0x55,0xd4,0xfb,0xec,
		0xaa,0x81,0x7f,0xa9,0x28,0x00,0x10,0x4f,0xbd,0x0b,0xdf,0xf0,0x88,0xfd,0x65,0xe9,
		0xad,0x9f,0x85,0x13,0xc8,0x8f,0xa6,0x13,0xd9,0x52,0x63,0x4e,0xe8,0x30,0x61,0x66,
		0x22,0x5a,0x2f,0x37,0xeb,0x7e,0xd7,0x79,0xfd,0x6a,0x79,0x9f,0x0e,0x56,0x00,0xef,
		0x91,0x58,0x67,0xd8,0x8e,0x99,0x64,0x5b,0xd7,0x97,0xe2,0x61,0xcf,0xc9,0xe4,0x62,
		0x77,0x3f,0xb5,0x2e,0xb5,0x39,0x8e,0x4e,0x6e,0xfc,0x18,0x97,0x59,0xc2,0x40,0x5f,
		0x95,0x06,0xed,0x48,0xe6,0x12,0x33,0x79,0xba,0x47,0x7b,0xbd,0x02,0x9e,0x8b,0xbd,
		0x11,0xba,0x86,0x23,0x9e,0x13,0x84,0x87,0xba,0x48,0x88,0x2b,0x0c,0x3e,0xf3,0x56,
		0xcc,0x1b,0x3c,0xb2,0xcf,0xfb,0x0d,0x2d,0x0c,0x91,0x61,0xf8,0xdb,0xab,0x0a,0x91,
		0x27,0x6a,0x24,0x27,0x62,0xd1,0x8b,0xa3,0x6b,0x2d,0xaa,0xd8,0x52,0x7c,0x78,0x1a,
		0x23,0x43,0xa1,0x10,0xc4,0xac,0xce,0x2f,0x2a,0x4c,0x29,0x40,0x57,0x76,0x5d,0x82,
		0xe8,0x6a,0xbe,0x6f,0xf0,0x36,0xd9,0x33,0x1f,0x19,0x86,0x11,0x5b,0x8a,0x22,0xd7,
		0xe4,0x25,0xb8,0x1f,0x7c,0x0f,0x0e,0x32,0xfb,0x57,0xb2,0x97,0x1e,0x8a,0x70,0x32,
		0xd1,0x55,0xfc,0xf6,0x1d,0x0d,0xf5,0xe9,0x41,0x53,0x44,0x51,0x98,0x91,0xa7,0x12,
		0x90,0x77,0x27,0xbf,0xf0,0xb3,0x1c,0xf6,0x52,0x35,0x7e,0x77,0x55,0xc6,0x8d,0x35,
		0xe2,0x2d,0xab,0xde,0xe8,0x3f,0x8b,0x46,0xef,0x4f,0x4c,0xba,0x34,0xf1,0x80,0xb9,
		0x57,0xd5,0x24,0x88,0xc0,0x33,0xf4,0xf2,0xfe,0x41,0x3b,0xbd,0x6d,0x83,0xe7,0x0c,
		0x52,0x78,0x3d,0x78,0xbd,0x98,0x68,0x9b,0xd6,0xd8,0x22,0x61,0x8f,0xbd,0x46,0x4c)
	},
	{ chunk_from_chars(                                                          /* 4 */
		0x31,0x32,0x33,0x34,0x30,0x30),
	  chunk_from_chars(),
	  chunk_from_chars(
		0x20,0x13,0xa5,0x50,0x4d,0xd5,0x53,0xe9,0xff,0x2d,0x0c,0x42,0xee,0xfb,0x6f,0x69,
		0x78,0xcd,0xfe,0xe9,0x46,0xeb,0xac,0xb6,0x9a,0xa0,0x07,0x16,0x40,0xf4,0x2b,0x1c,
		0x6d,0x01,0x9a,0xb2,0xc5,0x03,0x62,0xc7,0xe2,0x71,0x38,0x2d,0x54,0x6a,0x9a,0xb5,
		0x3a,0xed,0x7c,0xb6,0x25,0xfd,0xc6,0x92,0xa6,0x0b,0x41,0x12,0xdf,0x16,0xd8,0x5d,
		0xb4,0xa7,0x48,0x93,0x5d,0xf6,0x06,0xe4,0x80,0x54,0x19,0xd4,0xcd,0x4a,0x59,0x52,
		0x85,0xf3,0x69,0xe2,0x0c,0x7b,0x47,0x4a,0x2f,0x71,0xa6,0xc4,0x06,0x42,0xc4,0xe8,
		0x4f,0x6f,0xf8,0x70,0xcd,0x45,0x46,0xa4,0xbb,0x2b,0x9f,0x92,0xa7,0x7d,0x69,0xbf,
		0xa8,0x57,0x24,0xca,0xa7,0xc3,0x72,0x4a,0xee,0xa1,0x31,0xd9,0xe2,0xf6,0x1b,0x5c,
		0x24,0xab,0x19,0xa3,0xff,0x46,0xef,0x9b,0x25,0xe8,0x95,0x1a,0x16,0x5b,0x2a,0x79,
		0x5e,0x8d,0x73,0x4c,0x99,0x6f,0x0d,0x3c,0xdf,0xc9,0x79,0x95,0x95,0x21,0x95,0xb6,
		0x0c,0x65,0x97,0x9f,0x15,0x4f,0xf1,0x85,0xe8,0x80,0xbe,0x39,0x48,0xeb,0x95,0xe4,
		0x49,0xf5,0x42,0x7f,0xc3,0xce,0xbb,0x80,0x5b,0xc9,0x71,0xdd,0x32,0xf5,0x77,0x98,
		0xe1,0x1d,0x44,0x11,0xc7,0xf2,0xca,0xe6,0xba,0x40,0xc7,0x11,0xa5,0x74,0x8c,0x68,
		0xd3,0x7f,0xc7,0xf4,0x93,0xe5,0xd3,0x89,0x66,0x61,0x59,0xa5,0x5c,0x57,0xb1,0xed,
		0xb9,0x9f,0xa9,0xc3,0x0b,0xc7,0xee,0xd5,0x61,0x91,0x77,0xa9,0x01,0x75,0xcd,0x0c,
		0xb2,0x90,0xb9,0x3b,0x75,0xa4,0x72,0x58,0x67,0xba,0xac,0x40,0xed,0xc7,0x03,0x3a,
		0xcb,0x3b,0x31,0xe8,0x90,0x63,0x54,0x6d,0x9c,0x5b,0x0a,0x5d,0x4c,0x4f,0x90,0x62,
		0x29,0x52,0x69,0xc5,0x1e,0x72,0x30,0xb3,0x5f,0xb2,0x00,0x3c,0x2e,0x91,0x3f,0x4c,
		0x23,0x4a,0xc9,0xda,0x3c,0x46,0x7e,0x6d,0x52,0x28,0x72,0xfe,0xf1,0xd2,0x84,0x93,
		0xe4,0x69,0xb8,0xe9,0xef,0xc1,0xf6,0xc3,0x89,0xe6,0x99,0x41,0xb5,0x19,0x77,0xc4,
		0xf4,0xbb,0x21,0xc0,0x2a,0x66,0x92,0x66,0x62,0x89,0x9b,0xf3,0xdd,0x63,0x8d,0xe3,
		0x1d,0x47,0xf8,0xff,0xa9,0xd8,0xee,0x34,0x04,0xd8,0xfa,0x10,0x29,0x85,0xd2,0xf8,
		0xec,0x1e,0x68,0x4a,0xcd,0x5c,0xa0,0x46,0xe8,0xb9,0x6d,0x12,0x26,0x30,0xb3,0xa7,
		0x05,0x9e,0xf8,0xe7,0xdc,0x93,0x0c,0x81,0xc9,0x7b,0xd8,0x1a,0x3e,0x3b,0x9e,0x98,
		0x46,0x02,0xd7,0x1c,0xdf,0x99,0x85,0x77,0x8f,0x5f,0x3b,0x04,0xd3,0xf3,0x0f,0xaf,
		0x4b,0xd8,0xa3,0x23,0xce,0x6a,0xad,0xce,0xdc,0x43,0xe3,0x02,0x7a,0xba,0xd8,0x3e,
		0x92,0x66,0x7a,0xfe,0x96,0x2b,0x07,0xed,0xfb,0x21,0x82,0x67,0xf5,0x15,0xc4,0x4b,
		0xe8,0x50,0x9f,0x1e,0x26,0x55,0x82,0x20,0x20,0x74,0x68,0xa3,0x18,0xfe,0x23,0xe0,
		0x7f,0xe2,0xfd,0xa0,0x41,0x14,0xdb,0x17,0xe7,0x54,0xd9,0x77,0x5d,0x2c,0x49,0x51,
		0xdc,0x1c,0x7f,0x8d,0x1b,0x44,0x76,0xaa,0x13,0xef,0x50,0xda,0x04,0x38,0x15,0xa2,
		0xa1,0xc6,0x45,0x35,0x46,0x06,0x7e,0xb4,0x63,0xdb,0x08,0x77,0xf7,0x17,0xec,0x70,
		0xc1,0x76,0xe3,0xfd,0x73,0xc8,0x37,0x7a,0xc3,0xa8,0xfd,0x19,0xdd,0x2b,0xb8,0x0f)
	},
	{ chunk_from_chars(                                                          /* 8 */
		0x31,0x32,0x33,0x34,0x30,0x30),
	  chunk_from_chars(
	  	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00),
	  chunk_from_chars(
		0x63,0xa3,0xfa,0xbc,0x60,0xb9,0x42,0x67,0xd3,0x18,0xb3,0x77,0x32,0x7e,0xe6,0x54,
		0x8f,0x59,0x47,0x77,0x84,0x26,0x81,0xfe,0x21,0xba,0xaa,0x2e,0x92,0x78,0xf0,0x01,
		0xa5,0x75,0xba,0x38,0xa2,0x07,0xa3,0xde,0xee,0xb2,0x25,0x8d,0xe8,0xf6,0xbf,0x11,
		0x27,0x60,0x90,0xf8,0x69,0xef,0xe8,0x17,0xfe,0xc6,0x29,0x92,0x47,0xc0,0x95,0x50,
		0xba,0xfe,0x7b,0xad,0x02,0xd0,0xd7,0xe0,0xbe,0x51,0xf8,0x13,0x4b,0xab,0x13,0x0d,
		0x4a,0x9c,0x59,0x3e,0x3f,0xba,0xb7,0xb2,0x76,0x03,0x4f,0x22,0xba,0x07,0x17,0x92,
		0xa4,0x03,0x1e,0x59,0x1e,0xbf,0x2d,0x67,0x04,0x8e,0xf0,0x7c,0x6a,0x01,0x7d,0x2f,
		0x71,0xc7,0x2f,0x8d,0xb0,0xd3,0x2a,0xcc,0x16,0x78,0x89,0x76,0xf0,0x2f,0xca,0xad,
		0x20,0x97,0xaa,0x83,0x84,0x37,0x73,0xe5,0x9e,0xf4,0xc0,0x4f,0x38,0x3f,0x01,0x3f,
		0x86,0xe2,0x33,0x4f,0x21,0x5c,0xfb,0xfe,0x64,0x25,0x7f,0x60,0xd0,0x79,0x7e,0x5a,
		0x56,0xbe,0xa3,0x5b,0x5d,0xff,0x98,0x34,0x14,0xac,0x68,0x6d,0x0d,0x80,0xd5,0xae,
		0x14,0x57,0x28,0x69,0xd0,0x2d,0x44,0x2b,0x6a,0x7b,0x88,0x95,0x4a,0x9c,0x0b,0xd5,
		0x6a,0x87,0x2f,0xed,0x20,0xdc,0x45,0xfc,0x0c,0xa5,0x11,0xdb,0x19,0x52,0x32,0x02,
		0x1f,0xca,0x52,0xab,0x99,0x71,0x91,0xa0,0x8d,0x1c,0x02,0xd0,0xed,0x41,0xde,0x86,
		0xb4,0x9d,0x05,0x71,0x59,0x74,0x77,0x6d,0x8b,0x0f,0xcf,0xc5,0xa7,0x84,0x32,0xf1,
		0x22,0x48,0x2e,0x28,0x81,0x2a,0x06,0x08,0xad,0x15,0x70,0xde,0x40,0xc5,0x53,0x97,
		0xab,0xd5,0xc2,0xa5,0x80,0x46,0x51,0x9a,0x05,0x2c,0xd3,0xe2,0xf0,0x3c,0xd9,0xe9,
		0x1f,0x48,0x88,0xbd,0xa9,0x64,0xe7,0xe5,0x2d,0x12,0x96,0xce,0x1b,0x41,0xb3,0x12,
		0xd2,0x0f,0x64,0x02,0x76,0xb9,0x1a,0x73,0x7e,0x9d,0xb0,0xbf,0x4f,0xd4,0x49,0xdd,
		0xec,0x6d,0xa6,0x42,0x55,0x9b,0x92,0xd0,0xa6,0x04,0x05,0xe8,0x68,0x79,0x36,0x81,
		0xa2,0x36,0x69,0x04,0xe8,0xfa,0x4e,0xee,0xe0,0x36,0x8a,0x2d,0x0a,0x60,0x61,0x73,
		0xc9,0x47,0x0e,0x26,0xbf,0xd4,0x62,0xd9,0x7a,0x8e,0x40,0xd0,0x6c,0x31,0xa4,0x33,
		0x0a,0x9e,0xc0,0x2d,0xe5,0x89,0x20,0xc6,0xac,0x90,0xdc,0xd2,0x0d,0xeb,0xe6,0xfc,
		0x14,0x35,0x78,0x42,0x64,0x0b,0x44,0xb8,0xd0,0xbe,0x5b,0xf0,0x3d,0x73,0x7c,0x4f,
		0xc0,0x8f,0xd3,0x7e,0xd2,0x49,0x01,0x76,0x82,0xb6,0x27,0x35,0x96,0x4a,0x24,0x68,
		0x13,0x32,0xb2,0x10,0xfa,0x88,0x25,0xbc,0x60,0xed,0x85,0xe8,0x57,0x82,0x80,0x04,
		0xb6,0xcc,0x42,0xe8,0xcf,0x8b,0x7d,0x08,0x30,0x82,0x80,0xb0,0xf6,0xda,0xba,0x6e,
		0xc9,0x6c,0xb5,0xa3,0x00,0xdb,0xf3,0xed,0x26,0x09,0x84,0x06,0x64,0x78,0xb5,0xb9,
		0x32,0x74,0xe1,0xb6,0x27,0xd6,0xa2,0xa1,0x26,0xd9,0xe8,0xd2,0xdb,0x8b,0x88,0x66,
		0x86,0xcc,0xcf,0x63,0x61,0x48,0x7f,0x5a,0x0d,0x62,0xaa,0x00,0x27,0xf1,0x60,0x8e,
		0x1d,0xa7,0xf5,0xb9,0x09,0xf2,0x47,0xac,0x42,0x37,0x55,0x51,0xaf,0x7c,0x3f,0xa5,
		0x36,0x73,0x47,0x0c,0x1c,0x15,0x6b,0xd9,0x53,0xcf,0x18,0x8f,0x62,0xbc,0x69,0x6a)
	},
	{ chunk_from_chars(                                                          /* 9 */
		0x31,0x32,0x33,0x34,0x30,0x30),
	  chunk_from_chars(
		0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
		0x10,0x11,0x12,0x13),
	  chunk_from_chars(
		0x21,0xf1,0xf6,0xcc,0x2d,0xdd,0xc3,0xf1,0xd4,0x1d,0x48,0x2a,0x0e,0x11,0x61,0x76,
		0x9b,0x84,0x68,0xf2,0x34,0x0e,0x32,0x18,0x73,0x49,0xd8,0x09,0x55,0xe7,0x00,0x3c,
		0x57,0x38,0x6a,0x85,0xb2,0x97,0xaa,0xe0,0x86,0xac,0x15,0x50,0xf9,0x0f,0x8a,0x5b,
		0xa7,0x31,0x92,0x81,0x8c,0x68,0xf0,0xcd,0xc9,0xf1,0xa6,0x9c,0xa5,0x18,0xd1,0xbb,
		0x84,0xc3,0x45,0x38,0xd9,0xb0,0xfd,0xcf,0xaf,0x2a,0xb8,0x59,0xbd,0x24,0x74,0x8b,
		0x32,0x6c,0x8f,0x8e,0x1f,0x0b,0xdf,0xe2,0xd3,0x2f,0xa7,0xa5,0xa6,0xe5,0x6d,0xbf,
		0x69,0xb0,0x7c,0x41,0xeb,0x81,0xec,0x69,0x9c,0x79,0xbe,0x15,0xf3,0x4c,0xef,0xea,
		0xac,0x05,0x31,0x92,0x35,0x56,0x29,0x6b,0x7f,0x9c,0x29,0xb0,0x6c,0x2f,0x8c,0x4c,
		0x36,0xf5,0xad,0xee,0x50,0x5c,0x95,0xdb,0x14,0x96,0xbc,0xf9,0x23,0xb2,0x7d,0x4a,
		0xf4,0xe0,0x83,0xe9,0x86,0xb0,0xbd,0x04,0xcd,0xa3,0x73,0x12,0xa9,0x9b,0xc0,0x91,
		0xa8,0x14,0x85,0xbd,0x33,0x5f,0xa7,0xe6,0x37,0x72,0xd8,0x51,0x2b,0x4f,0xba,0x1d,
		0xf0,0x3c,0xda,0x8c,0xdb,0xfa,0xfb,0x26,0x47,0x95,0x18,0xa7,0x56,0x18,0x06,0x85,
		0x79,0xbe,0xc0,0x68,0x09,0xc3,0x10,0x7c,0xde,0xa7,0xfa,0x5a,0x26,0x4c,0x9d,0xc0,
		0xf4,0x3e,0xa9,0xdb,0x33,0xb3,0x2d,0x46,0x37,0xb6,0x5b,0x7f,0xcb,0xde,0x0d,0x0c,
		0x95,0x9b,0x2c,0x5b,0xea,0x85,0x18,0xf2,0x4f,0x7f,0x60,0x0d,0x33,0xd8,0x9e,0xd2,
		0x86,0x04,0x4d,0x45,0x94,0xa4,0x46,0xae,0xa1,0x13,0xf8,0x6b,0x19,0x76,0x4f,0x68,
		0xed,0xa9,0xce,0x15,0x50,0x4f,0x77,0x93,0x16,0x52,0x9b,0xef,0x78,0xd1,0xa8,0x3a,
		0xad,0xaa,0xb2,0x6e,0x8a,0xac,0x19,0x94,0x7b,0x85,0xd9,0x49,0xd2,0x53,0x71,0x30,
		0x36,0xd7,0xc0,0x4f,0x40,0x50,0x51,0xfd,0x33,0xdd,0x8c,0xca,0x36,0xbb,0x65,0x7b,
		0x35,0x19,0xf4,0xe4,0xa1,0x72,0x24,0x76,0xb0,0x25,0x77,0xdb,0x94,0x5b,0x86,0xc3,
		0x9f,0x86,0x14,0xdf,0x57,0x82,0xfa,0x3e,0x1c,0xc7,0x07,0x4c,0xc5,0xb5,0xb7,0x1c,
		0x9c,0xb1,0x07,0x7d,0x8e,0x88,0xed,0x3a,0xaa,0x9b,0xe3,0x74,0x58,0x59,0xc4,0x64,
		0x9d,0xd2,0x84,0x5b,0x4c,0x66,0x06,0xc8,0xf6,0x89,0xcc,0x52,0x99,0xcc,0xe1,0x57,
		0x21,0xeb,0x0a,0x66,0xe7,0xb6,0xf9,0xa9,0x10,0x51,0x91,0xbf,0x17,0x86,0x7e,0xca,
		0x2a,0x26,0x68,0xea,0x0e,0x95,0x98,0x45,0x4d,0xce,0x6a,0x10,0x84,0x6f,0x49,0xe6,
		0x80,0xc4,0xbe,0xd4,0xa9,0xdb,0x06,0xc5,0xb9,0x2f,0x92,0x73,0x5b,0x4d,0xcf,0xd6,
		0x35,0x06,0xff,0xea,0xc5,0xb3,0x54,0xa0,0x9d,0x16,0xad,0xbf,0xe6,0x37,0x5f,0x9b,
		0x6a,0xc8,0x8f,0xbd,0x54,0x02,0x19,0x9f,0x68,0xd3,0x12,0x54,0xca,0xd7,0x65,0xa5,
		0x54,0xd6,0x57,0x57,0xf4,0xec,0xae,0xaa,0x55,0xb0,0xd3,0xa4,0x93,0x4e,0x24,0xbb,
		0x12,0xf8,0xfe,0xa4,0x6b,0x18,0x29,0x1e,0x9a,0xa7,0xda,0xec,0x97,0xae,0x67,0x57,
		0x07,0xa3,0x91,0x3c,0xb0,0x8b,0x30,0x68,0x76,0xce,0x15,0xa0,0x25,0xe3,0x86,0xcb,
		0x03,0xb1,0x63,0x8a,0xe4,0xd4,0xcc,0xc7,0x6b,0x8e,0xbe,0xd2,0x3b,0x92,0xa0,0x04)
	},
	{ chunk_from_chars(                                                         /* 10 */
		0x31,0x32,0x33,0x34,0x30,0x30),
	  chunk_from_chars(
		0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
		0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f),
	  chunk_from_chars(
		0x55,0x59,0x05,0x3e,0x25,0x66,0x12,0x7d,0xd1,0xaa,0x6e,0xe3,0xee,0xcf,0xde,0xe1,
		0x1f,0xa8,0x1f,0x68,0x96,0x56,0x9d,0x8a,0x4f,0x85,0xc3,0x50,0xc4,0xf2,0x58,0x12,
		0x68,0x94,0xf6,0x82,0x6a,0xe4,0x66,0xad,0x93,0x93,0x14,0xb2,0x67,0x43,0x97,0xf4,
		0xaa,0xe2,0xbb,0x6a,0x6d,0x53,0xff,0x89,0xf5,0x80,0x6c,0xc2,0x9e,0xe6,0xc3,0x90,
		0x43,0x4a,0x4e,0xec,0x14,0x45,0x47,0x60,0x37,0x42,0xbb,0xef,0xf4,0x58,0x4b,0x88,
		0x48,0x88,0xb9,0xaf,0x89,0x88,0xec,0x8f,0xa2,0x56,0x7c,0xb6,0x74,0x9b,0x63,0x6b,
		0x4a,0x2a,0x61,0x96,0xd2,0x75,0x18,0x40,0xae,0xb6,0x4d,0xee,0x7d,0xbd,0x25,0xc3,
		0x2b,0x42,0x77,0x6d,0x04,0xa2,0x79,0x7b,0xac,0xf5,0xe2,0x74,0x89,0x57,0x71,0xf4,
		0x3b,0x51,0x9a,0x89,0x66,0x9f,0x56,0x23,0x3c,0x0b,0x9a,0x34,0xc8,0xa8,0xe8,0x7b,
		0x70,0xec,0xbd,0x5a,0xa7,0x93,0x37,0xba,0xe4,0x43,0x64,0xaf,0x66,0x38,0xe3,0xd5,
		0x7b,0x86,0x94,0x6e,0x3d,0x26,0x79,0x44,0x34,0xf8,0x81,0x6b,0x53,0x3a,0xed,0x1b,
		0xe5,0x91,0x08,0x74,0x48,0xa1,0x3a,0x1b,0x24,0x7a,0x64,0xbb,0xdf,0xa9,0x89,0xb1,
		0xca,0xc0,0x04,0x7c,0x96,0x6a,0xf7,0x4d,0x0c,0x90,0x93,0xa4,0x10,0xcf,0xbf,0xdd,
		0x82,0x83,0x85,0x59,0x70,0x06,0xb5,0x56,0x27,0x6e,0x6a,0x46,0x6f,0x9f,0x3c,0xfd,
		0x38,0xcc,0xae,0xa3,0x6d,0x0a,0x3b,0xcc,0x5a,0xcc,0x63,0xed,0x8f,0x65,0xae,0x5c,
		0x3a,0xec,0x30,0x91,0xdc,0xda,0x79,0x1e,0x79,0x31,0x22,0x1c,0x09,0x39,0x9c,0xa5,
		0x6b,0xfc,0x3c,0x27,0x10,0xc0,0x21,0x1e,0x97,0x66,0xdf,0xa6,0xf6,0x5c,0xfb,0xc6,
		0x14,0x14,0x79,0x41,0x4a,0x63,0xa6,0x2d,0x7c,0x72,0x83,0x0f,0xf9,0x55,0xb1,0xcd,
		0x86,0xb3,0x88,0x02,0xd7,0x93,0x5b,0x43,0x0e,0x7a,0x80,0x26,0x14,0xd6,0x8f,0x50,
		0x15,0xef,0x90,0xad,0xee,0xaf,0x15,0xf9,0x5b,0xcd,0x77,0x0f,0xb7,0xef,0xe4,0xd9,
		0xe6,0xa0,0xef,0x8f,0x23,0xec,0x07,0x43,0xb3,0xf7,0x1a,0x95,0x20,0xe2,0x0f,0xb6,
		0x05,0x67,0x99,0x8e,0x58,0x65,0x8a,0xbf,0x6e,0xcb,0x98,0x93,0x5f,0xbc,0xd3,0x43,
		0xa9,0x49,0xf9,0x52,0xba,0xec,0x6f,0xf5,0xde,0x23,0x55,0x2c,0xa4,0x35,0x86,0x6b,
		0x98,0xe3,0x62,0x88,0x69,0x3b,0x50,0x8b,0xba,0x17,0x7c,0x09,0xdf,0xb2,0x7e,0x13,
		0xd7,0x0c,0x74,0x17,0x12,0xd6,0x63,0xf3,0x52,0x5a,0x7b,0xbf,0x92,0x91,0x62,0xd6,
		0xf4,0x50,0x31,0xea,0xd3,0x80,0xad,0x86,0x9f,0x40,0xe2,0x30,0xf7,0x8d,0x9c,0xc8,
		0xa8,0x91,0x89,0x64,0xca,0x0d,0x84,0x99,0xe4,0xbc,0x35,0x5b,0x38,0x51,0xa1,0xfd,
		0x1f,0x03,0x95,0x3d,0x65,0x93,0x5f,0x61,0x34,0x83,0x05,0x8f,0x6f,0x25,0x09,0x24,
		0xdb,0x78,0x07,0x33,0x23,0x9b,0x24,0xdc,0x45,0x4f,0x98,0x81,0xdf,0x76,0x48,0xe2,
		0xd1,0x9b,0x41,0x6c,0x2f,0x8a,0xf5,0x39,0x48,0xcd,0x7e,0xa0,0x6e,0x9b,0x3b,0xaa,
		0xcd,0x7f,0xbd,0x35,0xe5,0x0a,0x24,0x5c,0x8c,0x7d,0x21,0x13,0xd9,0xca,0xc4,0x38,
		0x80,0x51,0x5d,0x3a,0x0f,0xd6,0xf3,0xd7,0x6e,0x5a,0xec,0x0d,0x38,0xf0,0x2e,0x63)
	},
	{ chunk_from_chars(                                                         /* 11 */
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
		0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78,0x78),
	  chunk_from_chars(),
	  chunk_from_chars(
	  	0x59,0x2e,0x48,0x79,0x60,0xf3,0x16,0x94,0x43,0xc5,0xd6,0xf8,0x71,0x66,0xbe,0xf2,
	    0xff,0xd5,0x29,0x31,0x51,0x8f,0x3b,0x0e,0x5d,0x97,0x7f,0x3a,0x21,0x01,0x81,0x4e,
	    0x74,0x9f,0xff,0x5f,0xe8,0xeb,0xa4,0x24,0xa3,0xd4,0x39,0x60,0x98,0x57,0x94,0x0f,
	    0x5e,0x23,0xdc,0xed,0xbb,0x45,0xcd,0xe5,0x7c,0x21,0xc2,0x8b,0xf7,0x29,0xe3,0x96,
	    0x53,0x0d,0x21,0xfb,0xcb,0x96,0xc9,0x7a,0x14,0x8c,0x57,0x08,0x80,0x14,0x67,0xb1,
	    0x5b,0xe1,0xeb,0x0d,0x35,0x20,0x61,0x05,0xf5,0x43,0xd2,0x10,0x22,0xfd,0x02,0x3a,
	    0xc8,0x9b,0x61,0x6e,0xc7,0x90,0xa9,0x18,0x2a,0xa0,0x53,0xee,0x4a,0xa7,0x96,0x2f,
	    0x33,0xf4,0xb4,0x13,0xa4,0x8e,0xe3,0xd5,0x3b,0x2d,0x24,0x79,0x88,0x68,0x3d,0x4d,
	    0xb3,0x0b,0xf4,0xff,0x6d,0x80,0xb6,0xd0,0xce,0x82,0xe3,0x14,0xed,0x6d,0xd7,0x60,
	    0x7d,0xf5,0x77,0xf1,0xec,0x95,0x6a,0xcc,0xe5,0x1f,0x74,0x4f,0x89,0xe7,0xc6,0xa7,
	    0x70,0xce,0xaf,0x90,0xb2,0x06,0x65,0xdf,0x2c,0xa8,0x05,0x0a,0xc2,0x5e,0xd2,0x9c,
	    0xa8,0x0a,0x03,0x51,0xad,0x79,0x0c,0x3b,0x8f,0xd0,0x05,0x27,0x19,0x5f,0x42,0x74,
	    0x10,0xdc,0xa6,0xbb,0xba,0x37,0xa4,0x41,0xcb,0x82,0xe4,0x43,0x83,0xbb,0x4e,0x07,
	    0x7f,0xca,0x32,0xb2,0x76,0x26,0x05,0x1c,0x13,0x88,0x63,0x92,0xc1,0x0a,0x30,0x58,
	    0x90,0x45,0x45,0x88,0xf5,0x08,0xef,0x8d,0x9d,0x0a,0xea,0xdd,0x8b,0xc7,0x89,0x91,
	    0xfa,0xc9,0x6c,0x5f,0xfe,0xc8,0x92,0x38,0x1b,0x03,0x58,0x0e,0x28,0x92,0x6d,0x8b,
	    0x3a,0x51,0xda,0x86,0x29,0x51,0xa0,0x5f,0x48,0xef,0x80,0x9b,0x9c,0xe1,0x1f,0x23,
	    0x32,0x3e,0xd1,0x0f,0xd5,0x97,0xd0,0x44,0x9a,0xca,0xbb,0xa9,0x54,0x07,0x91,0x64,
	    0xd7,0x75,0xab,0xba,0x56,0xda,0x95,0x6c,0x51,0x3b,0x60,0x1d,0x18,0x46,0xc8,0x67,
	    0xc6,0xbb,0xdb,0xad,0xf1,0x95,0xdb,0x11,0x85,0x7d,0x41,0x35,0xc3,0x0c,0x2b,0x58,
	    0x98,0x78,0x2a,0xc9,0x34,0x6f,0x7f,0xea,0x4e,0x2e,0xc8,0x0b,0x39,0xb0,0xed,0x96,
	    0x2e,0x0c,0x1b,0x34,0x49,0x4a,0xf4,0x44,0x1e,0x5d,0xad,0x6d,0x05,0xfa,0x7a,0x47,
	    0x76,0x33,0x68,0xf8,0x50,0xe3,0xb8,0x14,0x51,0xb4,0x7e,0xc1,0x28,0x86,0xfb,0x31,
	    0x7f,0x5f,0x5c,0xa6,0x88,0x27,0x5f,0xf1,0xd9,0x74,0x10,0xf8,0xee,0xff,0x8e,0x21,
	    0x06,0x80,0xc7,0x99,0xf4,0x5d,0xbc,0x47,0x74,0x41,0x66,0xd5,0xb4,0x70,0xc3,0x5a,
	    0x9d,0xf5,0x74,0xdb,0xf1,0xb2,0x55,0x93,0x1e,0xc9,0x8e,0x82,0xe1,0x09,0x85,0xea,
	    0x23,0xda,0xf9,0x60,0x86,0x28,0x82,0xeb,0x3e,0xd1,0x7a,0x99,0xfe,0xf3,0x6a,0xf0,
	    0x1b,0x61,0x68,0xb2,0x2a,0xe7,0xae,0x0c,0x91,0x04,0x5f,0x79,0xda,0x51,0xfd,0x62,
	    0x31,0x76,0x30,0xe1,0x23,0xe3,0x22,0xdc,0x69,0x2c,0x38,0x6b,0xb9,0xe3,0x00,0x13,
	    0x52,0x5d,0xa3,0x28,0x93,0x21,0xf3,0x11,0xb8,0xcd,0x4e,0x90,0x17,0x55,0x73,0xde,
	    0xbf,0x08,0xf7,0x72,0xce,0x6d,0x92,0x57,0xa6,0x59,0x35,0x57,0xf9,0xed,0xd9,0x56,
	    0xc8,0x27,0xa2,0x85,0xf7,0xbc,0x62,0x0e,0x26,0x2a,0x7d,0x64,0xb8,0xc5,0x64,0x78)
	}
};

static void test_rsa_oaep(chunk_t key, encryption_scheme_t encryption_scheme,
						  rsa_oaep_test_t *test)
{
	private_key_t *privkey;
	public_key_t *pubkey;
	chunk_t msg = chunk_empty, ct = chunk_empty;
	bool success;

	privkey = lib->creds->create(lib->creds, CRED_PRIVATE_KEY, KEY_ANY,
								 BUILD_BLOB_ASN1_DER, key, BUILD_END);
	ck_assert(privkey != NULL);
	ck_assert(privkey->get_type(privkey) == KEY_RSA);

	pubkey = privkey->get_public_key(privkey);
	ck_assert(pubkey != NULL);

	/* decrypt */
	success = privkey->decrypt(privkey, encryption_scheme, &test->label,
							   test->ct, &msg);
	if (test->label.len > 0 && !success)
	{
		warn("RSA OAEP labels might not be supported");
		goto end;
	}
	ck_assert(success);
	ck_assert_chunk_eq(msg, test->msg);
	chunk_free(&msg);

	/* encrypt and decrypt again */
	ck_assert(pubkey->encrypt(pubkey, encryption_scheme, &test->label,
							  test->msg, &ct));
	ck_assert(privkey->decrypt(privkey, encryption_scheme, &test->label,
							   ct, &msg));
	ck_assert_chunk_eq(msg, test->msg);
	chunk_free(&ct);
	chunk_free(&msg);

end:
	pubkey->destroy(pubkey);
	privkey->destroy(privkey);
}

START_TEST(test_rsa_2048_oaep_sha512)
{
	test_rsa_oaep(rsa_2048_key, ENCRYPT_RSA_OAEP_SHA512,
				 &rsa_2048_oaep_sha512_tests[_i]);
}
END_TEST

START_TEST(test_rsa_4096_oaep_sha512)
{
	test_rsa_oaep(rsa_4096_key, ENCRYPT_RSA_OAEP_SHA512,
				 &rsa_4096_oaep_sha512_tests[_i]);
}
END_TEST

Suite *rsa_oaep_sha512_suite_create()
{
	Suite *s;
	TCase *tc;

	s = suite_create("rsa_oaep_sha512");

	tc = tcase_create("rsa_2048_oaep_sha512");
	tcase_add_loop_test(tc, test_rsa_2048_oaep_sha512, 0, countof(rsa_2048_oaep_sha512_tests));
	suite_add_tcase(s, tc);
	tc = tcase_create("rsa_4096_oaep_sha512");
	tcase_add_loop_test(tc, test_rsa_4096_oaep_sha512, 0, countof(rsa_4096_oaep_sha512_tests));
	suite_add_tcase(s, tc);

	return s;
}
