use crate::{faker::impls::address::CityNameGenFn, locales::Data};

#[allow(non_camel_case_types)]
#[derive(Copy, Clone)]
pub struct FR_FR;

impl Data for FR_FR {
    //
    // Sources:
    // https://www.insee.fr/fr/statistiques/3532172
    // https://www.oise.gouv.fr/contenu/telechargement/68118/413742/file/liste_alphabetique_des_prenoms_masculins_acceptes_pour_une_demande_de_francisation.pdf
    // https://www.herault.gouv.fr/content/download/39729/260550/file/Pr%C3%A9noms%20f%C3%A9minin%20pdf.pdf
    //
    const NAME_FIRST_NAME: &'static [&'static str] = &[
        "Aaron",
        "Abel",
        "Abigaëlle",
        "Achille",
        "Adam",
        "Adélaïde",
        "Adèle",
        "Adélie",
        "Adeline",
        "Adolphe",
        "Adrien",
        "Adrienne",
        "Agathe",
        "Agénor",
        "Aglaé",
        "Agnès",
        "Agrippine",
        "Aimable",
        "Aimé",
        "Aimée",
        "Alain",
        "Alan",
        "Alba",
        "Alban",
        "Albane",
        "Albert",
        "Alberte",
        "Albertine",
        "Albin",
        "Alessio",
        "Alex",
        "Alexandra",
        "Alexandre",
        "Alexandrine",
        "Alexane",
        "Alexia",
        "Alexis",
        "Alfred",
        "Ali",
        "Aliaume",
        "Alice",
        "Alicia",
        "Alida",
        "Aliénor",
        "Aliette",
        "Aline",
        "Alix",
        "Alizée",
        "Alma",
        "Aloïs",
        "Alphonse",
        "Alphonsine",
        "Alya",
        "Amandine",
        "Amaury",
        "Ambre",
        "Ambroise",
        "Amédée",
        "Amélia",
        "Amélie",
        "Ameline",
        "Amir",
        "Amour",
        "Anaëlle",
        "Anaïs",
        "Ananie",
        "Anas",
        "Anastase",
        "Anastasie",
        "Anatole",
        "André",
        "Andrea",
        "Andréa",
        "Andrée",
        "Anémone",
        "Ange",
        "Angèle",
        "Angeline",
        "Angélique",
        "Anicet",
        "Anita",
        "Anna",
        "Annabelle",
        "Anne",
        "Annette",
        "Annicette",
        "Annick",
        "Annie",
        "Anouk",
        "Anselme",
        "Antelme",
        "Anthelme",
        "Anthony",
        "Antoine",
        "Antoinette",
        "Antonin",
        "Antonine",
        "Apollinaire",
        "Apolline",
        "Ariane",
        "Ariel",
        "Arielle",
        "Aristide",
        "Arlette",
        "Armand",
        "Armande",
        "Armel",
        "Armelle",
        "Arnaud",
        "Arsène",
        "Arthur",
        "Arya",
        "Assia",
        "Astrid",
        "Athénaïs",
        "Aube",
        "Aubin",
        "Aude",
        "Audrey",
        "Auguste",
        "Augustin",
        "Augustine",
        "Aurélie",
        "Aurélien",
        "Auriane",
        "Aurore",
        "Ava",
        "Axel",
        "Axelle",
        "Aya",
        "Ayden",
        "Aylan",
        "Aymard",
        "Aymeric",
        "Balthazar",
        "Baptiste",
        "Baptistin",
        "Baptistine",
        "Barbara",
        "Barnabé",
        "Barnard",
        "Barthélémy",
        "Basile",
        "Bastien",
        "Bastienne",
        "Baudouin",
        "Béatrice",
        "Bénédicte",
        "Benjamin",
        "Benjamine",
        "Benoît",
        "Benoîte",
        "Berangère",
        "Bérenger",
        "Bérengère",
        "Bérénice",
        "Bernadette",
        "Bernard",
        "Bernardin",
        "Bernardine",
        "Berthe",
        "Bertille",
        "Bertrand",
        "Bétanie",
        "Betty",
        "Bienvenu",
        "Blaise",
        "Blanche",
        "Blandine",
        "Boris",
        "Briac",
        "Brice",
        "Brigitte",
        "Brune",
        "Bruno",
        "Calie",
        "Calixte",
        "Calliopée",
        "Camélia",
        "Camille",
        "Candice",
        "Canelle",
        "Capucine",
        "Carine",
        "Carole",
        "Caroline",
        "Casimir",
        "Cassandre",
        "Cassiopée",
        "Cathel",
        "Catherine",
        "Cathy",
        "Cécile",
        "Cécilia",
        "Cédric",
        "Céleste",
        "Célestin",
        "Célestine",
        "Célia",
        "Célimène",
        "Céline",
        "Cerise",
        "César",
        "Césarine",
        "Chantal",
        "Charlène",
        "Charles",
        "Charlie",
        "Charline",
        "Charlotte",
        "Charly",
        "Chimène",
        "Chloé",
        "Christèle",
        "Christelle",
        "Christian",
        "Christiane",
        "Christine",
        "Christophe",
        "Cindy",
        "Claire",
        "Clara",
        "Clarisse",
        "Claude",
        "Claudette",
        "Claudie",
        "Claudine",
        "Cléa",
        "Clémence",
        "Clément",
        "Clémentine",
        "Cléo",
        "Clothilde",
        "Clotilde",
        "Clovis",
        "Colette",
        "Colin",
        "Coline",
        "Colombe",
        "Colombine",
        "Côme",
        "Constance",
        "Constant",
        "Constantin",
        "Coralie",
        "Corentin",
        "Corentine",
        "Corine",
        "Corinne",
        "Crépin",
        "Cybille",
        "Cynthia",
        "Cyprien",
        "Cyrielle",
        "Cyril",
        "Cyrille",
        "Damien",
        "Daniel",
        "Danièle",
        "Danielle",
        "Dany",
        "Daphné",
        "David",
        "Davy",
        "Deborah",
        "Delphine",
        "Denis",
        "Denise",
        "Désiré",
        "Désirée",
        "Diane",
        "Didier",
        "Diego",
        "Dimitri",
        "Dominique",
        "Domitille",
        "Donald",
        "Donatien",
        "Dorian",
        "Doriane",
        "Dorine",
        "Dorothée",
        "Douce",
        "Eden",
        "Edgar",
        "Edgard",
        "Edith",
        "Edmée",
        "Edmond",
        "Edouard",
        "Edwige",
        "Eglantine",
        "Eléa",
        "Eléanore",
        "Elena",
        "Eléonore",
        "Eliane",
        "Elias",
        "Elie",
        "Eliette",
        "Elina",
        "Eline",
        "Elio",
        "Eliott",
        "Elisa",
        "Elisabeth",
        "Elise",
        "Ella",
        "Elodie",
        "Eloi",
        "Eloïse",
        "Elsa",
        "Elvire",
        "Elya",
        "Emeline",
        "Emile",
        "Emilie",
        "Emilien",
        "Emilienne",
        "Emma",
        "Emmanuel",
        "Emmanuelle",
        "Emmy",
        "Emy",
        "Enola",
        "Enora",
        "Enzo",
        "Eric",
        "Ernest",
        "Ernestine",
        "Erwan",
        "Erwann",
        "Estelle",
        "Esther",
        "Ethan",
        "Etienne",
        "Eudes",
        "Eugène",
        "Eugénie",
        "Eulalie",
        "Eurydice",
        "Eva",
        "Evan",
        "Eve",
        "Eveline",
        "Evelyne",
        "Evrard",
        "Ezio",
        "Fabien",
        "Fabienne",
        "Fabrice",
        "Fanny",
        "Faustin",
        "Faustine",
        "Félicie",
        "Félicien",
        "Félicienne",
        "Félicité",
        "Félix",
        "Ferdinand",
        "Fernand",
        "Fernande",
        "Fiacre",
        "Fidèle",
        "Firmin",
        "Flavie",
        "Flavien",
        "Fleur",
        "Flora",
        "Flore",
        "Florence",
        "Florent",
        "Florentin",
        "Florentine",
        "Florian",
        "Floriane",
        "Floribert",
        "Florine",
        "Fortuné",
        "France",
        "Francine",
        "Francis",
        "Franck",
        "François",
        "Françoise",
        "Frédéric",
        "Frédérique",
        "Fulbert",
        "Gabin",
        "Gabriel",
        "Gabrielle",
        "Gaël",
        "Gaëlle",
        "Gaétan",
        "Gaëtan",
        "Gaétane",
        "Garance",
        "Gaspard",
        "Gaston",
        "Gatien",
        "Gauthier",
        "Gautier",
        "Geneviève",
        "Geoffroy",
        "Georges",
        "Georgette",
        "Gérald",
        "Géraldine",
        "Gérard",
        "Géraud",
        "Germain",
        "Germaine",
        "Gertrude",
        "Gervais",
        "Ghislain",
        "Ghislaine",
        "Gilbert",
        "Gilberte",
        "Gildas",
        "Gilles",
        "Ginette",
        "Gisèle",
        "Giulia",
        "Gladys",
        "Godefroy",
        "Goeffrey",
        "Gontran",
        "Gonzague",
        "Grace",
        "Gratien",
        "Grégoire",
        "Gregory",
        "Guénolé",
        "Guilain",
        "Guilaine",
        "Guilem",
        "Guillaume",
        "Guillemette",
        "Gustave",
        "Guy",
        "Guylain",
        "Guylaine",
        "Guylène",
        "Gwenaël",
        "Gwenaëlle",
        "Gwendal",
        "Gwendoline",
        "Gwladys",
        "Habib",
        "Hadrien",
        "Harmonie",
        "Hector",
        "Hélèna",
        "Hélène",
        "Héloïse",
        "Henri",
        "Henriette",
        "Herbert",
        "Hercule",
        "Hermann",
        "Hermine",
        "Hervé",
        "Hippolythe",
        "Honoré",
        "Honorin",
        "Honorine",
        "Horace",
        "Hortense",
        "Hubert",
        "Hugo",
        "Hugues",
        "Huguette",
        "Hyacinthe",
        "Ibrahim",
        "Ida",
        "Ignace",
        "Igor",
        "Ilona",
        "Ilyan",
        "Imogène",
        "Imran",
        "Inaya",
        "Inès",
        "Ingrid",
        "Irène",
        "Irénée",
        "Iris",
        "Isaac",
        "Isabelle",
        "Isaure",
        "Isidore",
        "Ismaël",
        "Issa",
        "Jacinte",
        "Jacinthe",
        "Jacky",
        "Jacob",
        "Jacqueline",
        "Jacques",
        "Jade",
        "Janine",
        "Jannick",
        "Jasmine",
        "Jean",
        "Jeanne",
        "Jeannette",
        "Jeannine",
        "Jennifer",
        "Jérémie",
        "Jérémy",
        "Jérôme",
        "Jessica",
        "Joachim",
        "Joanne",
        "Jocelyn",
        "Jocelyne",
        "Joël",
        "Joëlle",
        "Johan",
        "Johanna",
        "Johanne",
        "Jonas",
        "Jonathan",
        "Jordan",
        "José",
        "Josée",
        "Joseph",
        "Josephe",
        "Joséphine",
        "Josette",
        "Joshua",
        "Josiane",
        "Josselin",
        "Josué",
        "Joy",
        "Jude",
        "Judicaël",
        "Judith",
        "Jules",
        "Julia",
        "Julian",
        "Julie",
        "Julien",
        "Julienne",
        "Juliette",
        "Juste",
        "Justin",
        "Justine",
        "Kaïs",
        "Karine",
        "Kayden",
        "Kévin",
        "Laetitia",
        "Laly",
        "Lambert",
        "Lana",
        "Lancelot",
        "Landry",
        "Larissa",
        "Laura",
        "Laure",
        "Laurence",
        "Laurène",
        "Laurent",
        "Laurette",
        "Lauriane",
        "Laurie",
        "Lazare",
        "Léa",
        "Léana",
        "Léandre",
        "Léane",
        "Léger",
        "Léna",
        "LÉNA",
        "Lenny",
        "Léo",
        "Léon",
        "LÉON",
        "Léonard",
        "Léonce",
        "Léone",
        "Léonie",
        "Léontine",
        "Léopold",
        "Léopoldine",
        "Liam",
        "Lila",
        "Lilian",
        "Liliane",
        "Lilou",
        "Lily",
        "Lina",
        "Line",
        "Lionel",
        "Lisa",
        "Lise",
        "Lison",
        "Livia",
        "Livio",
        "Loan",
        "Loane",
        "Loïc",
        "Loïck",
        "Lola",
        "Lolita",
        "Lorette",
        "Lorine",
        "Loris",
        "Lorraine",
        "Lou",
        "Louane",
        "Louis",
        "Louisa",
        "Louise",
        "Louisette",
        "Louison",
        "Louna",
        "Loup",
        "Luc",
        "Luca",
        "Lucas",
        "Luce",
        "Lucette",
        "Lucie",
        "Lucien",
        "Lucienne",
        "Lucile",
        "Lucy",
        "Ludivine",
        "Ludovic",
        "Luna",
        "Lya",
        "Lyam",
        "Lyana",
        "Lydia",
        "Lydie",
        "Lylou",
        "Lyna",
        "Lysandre",
        "Madeleine",
        "Maé",
        "Maël",
        "Maëlle",
        "Maëlys",
        "Maéva",
        "Magali",
        "Magalie",
        "Mahé",
        "Maïa",
        "Maïlys",
        "Maïté",
        "Maïwenn",
        "Maixent",
        "Malaurie",
        "Malo",
        "Malorie",
        "Manon",
        "Manuel",
        "Marc",
        "Marceau",
        "Marcel",
        "Marcelin",
        "Marceline",
        "Marcelle",
        "Marcellin",
        "Marcelline",
        "Margaux",
        "Margot",
        "Marguerite",
        "Maria",
        "Marianne",
        "Marie",
        "Marielle",
        "Mariette",
        "Marin",
        "Marina",
        "Marine",
        "Marinette",
        "Marion",
        "Marius",
        "Marjolaine",
        "Marjorie",
        "Marlène",
        "Marthe",
        "Martial",
        "Martin",
        "Martine",
        "Martinien",
        "Marylène",
        "Maryline",
        "Marylise",
        "Maryse",
        "Maryvonne",
        "Matéo",
        "Mathéo",
        "Mathias",
        "Mathieu",
        "Mathilde",
        "Mathis",
        "Mathurin",
        "Mathys",
        "Mattéo",
        "Matthias",
        "Matthieu",
        "Maud",
        "Maurice",
        "Mauricette",
        "Maxence",
        "Maxime",
        "Maximilien",
        "Maximilienne",
        "Maya",
        "Maylis",
        "Médard",
        "Mégane",
        "Mélaine",
        "Mélanie",
        "Melchior",
        "Mélina",
        "Méline",
        "Mélissa",
        "Mélodie",
        "Merlin",
        "Mia",
        "Michael",
        "Michel",
        "Michèle",
        "Micheline",
        "Mila",
        "Milan",
        "Milène",
        "Milo",
        "Mireille",
        "Modeste",
        "Mohamed",
        "Monique",
        "Morgan",
        "Morgane",
        "Muguette",
        "Muriel",
        "Murielle",
        "Mya",
        "Mylène",
        "Myriam",
        "Nadège",
        "Nadia",
        "Nadine",
        "Naël",
        "Naëlle",
        "Naïm",
        "Narcisse",
        "Natacha",
        "Nathalie",
        "Nathan",
        "Nathanaël",
        "Nathanaëlle",
        "Nelly",
        "Nestor",
        "Nicolas",
        "Nicole",
        "Nina",
        "Nine",
        "Nino",
        "Ninon",
        "Noa",
        "Noah",
        "Noam",
        "Noé",
        "Noël",
        "Noélie",
        "Noëlle",
        "Noémie",
        "Nolan",
        "Nolwenn",
        "Nora",
        "Norbert",
        "Nour",
        "Océane",
        "Octave",
        "Octavie",
        "Octavien",
        "Odette",
        "Odile",
        "Odilon",
        "Olga",
        "Olive",
        "Olivia",
        "Olivier",
        "Olympe",
        "Omer",
        "Ondine",
        "Ophélie",
        "Oriane",
        "Orlane",
        "Oscar",
        "Owen",
        "Pablo",
        "Pacôme",
        "Parfait",
        "Pascal",
        "Pascale",
        "Pascaline",
        "Patrice",
        "Patricia",
        "Patrick",
        "Paul",
        "Paule",
        "Paulette",
        "Paulin",
        "Pauline",
        "Pélagie",
        "Pénélope",
        "Perceval",
        "Perrine",
        "Pétronille",
        "Philémon",
        "Philibert",
        "Philippe",
        "Philippine",
        "Philomène",
        "Pierre",
        "Pierrette",
        "Pierrick",
        "Prisca",
        "Priscille",
        "Prosper",
        "Prudence",
        "Prune",
        "Quentin",
        "Quitterie",
        "Rachel",
        "Rafaël",
        "Raïssa",
        "Raoul",
        "Raphaël",
        "Raphaëlle",
        "Rayan",
        "Raymond",
        "Raymonde",
        "Rebecca",
        "Réginald",
        "Régine",
        "Régis",
        "Reine",
        "Réjane",
        "Rémi",
        "Rémy",
        "Renaud",
        "René",
        "Renée",
        "Reynald",
        "Richard",
        "Rita",
        "Robert",
        "Robin",
        "Rodolphe",
        "Rodrigue",
        "Roger",
        "Roland",
        "Rolande",
        "Romain",
        "Romane",
        "Romaric",
        "Roméo",
        "Romuald",
        "Romy",
        "Ronan",
        "Rosalie",
        "Rose",
        "Roseline",
        "Rosette",
        "Rosine",
        "Roxane",
        "Roxanne",
        "Sabine",
        "Sabrina",
        "Sacha",
        "Salomé",
        "Salomon",
        "Sam",
        "Sami",
        "Samson",
        "Samuel",
        "Samy",
        "Sandra",
        "Sandrine",
        "Sara",
        "Sarah",
        "Sasha",
        "Saturnin",
        "Sébastien",
        "Ségolène",
        "Séléna",
        "Séraphin",
        "Séraphine",
        "Séréna",
        "Serge",
        "Servane",
        "Séverin",
        "Séverine",
        "Sibylle",
        "Sidoine",
        "Sidonie",
        "Siméon",
        "Simon",
        "Simone",
        "Sixte",
        "Sixtine",
        "Soan",
        "Soazic",
        "Sofia",
        "Sohan",
        "Soizic",
        "Solange",
        "Solène",
        "Solenne",
        "Soline",
        "Sonia",
        "Sophia",
        "Sophie",
        "Stanislas",
        "Stella",
        "Stéphane",
        "Stéphanie",
        "Suzanne",
        "Suzette",
        "Suzon",
        "Sybille",
        "Sylvain",
        "Sylvaine",
        "Sylvère",
        "Sylvestre",
        "Sylviane",
        "Sylvie",
        "Tancrède",
        "Tanguy",
        "Tatiana",
        "Tessa",
        "Thaïs",
        "Théa",
        "Thècle",
        "Théo",
        "Théodore",
        "Théophane",
        "Théophile",
        "Thérèse",
        "Thibaud",
        "Thibaut",
        "Thierry",
        "Thilbault",
        "Thomas",
        "Tiago",
        "Tibère",
        "Tiffany",
        "Timéo",
        "Timothé",
        "Timothée",
        "Tiphaine",
        "Tiphanie",
        "Titouan",
        "Tom",
        "Tristan",
        "Tristane",
        "Tyméo",
        "Ulrich",
        "Ulysse",
        "Urbain",
        "Uriel",
        "Urielle",
        "Valentin",
        "Valentina",
        "Valentine",
        "Valère",
        "Valériane",
        "Valérie",
        "Valérien",
        "Valéry",
        "Valmont",
        "Vanessa",
        "Venceslas",
        "Véronique",
        "Vianney",
        "Victoire",
        "Victor",
        "Victoria",
        "Victorien",
        "Victorine",
        "Vincent",
        "Violaine",
        "Violette",
        "Virgile",
        "Virginie",
        "Viviane",
        "Vivien",
        "Vivienne",
        "Wilfrid",
        "William",
        "Xavier",
        "Xavière",
        "Yaël",
        "Yaëlle",
        "Yanis",
        "Yann",
        "Yannick",
        "Yasmine",
        "Yohan",
        "Yolaine",
        "Ysaure",
        "Yveline",
        "Yves",
        "Yvette",
        "Yvon",
        "Yvonne",
        "Yvonnick",
        "Zacharie",
        "Zélie",
        "Zéphirin",
        "Zoé",
    ];

    // Source:
    // https://www.data.gouv.fr/fr/datasets/liste-de-prenoms-et-patronymes/
    const NAME_LAST_NAME: &'static [&'static str] = &[
        "Abadie",
        "Adam",
        "Albert",
        "Alexandre",
        "Allain",
        "Allard",
        "Alvarez",
        "Alves",
        "Amar",
        "Andre",
        "Andrieu",
        "Andrieux",
        "Antoine",
        "Armand",
        "Arnal",
        "Arnaud",
        "Arnould",
        "Arnoux",
        "Astier",
        "Aubert",
        "Aubin",
        "Aubry",
        "Aubry",
        "Auger",
        "Auvray",
        "Avril",
        "Babin",
        "Bailly",
        "Baptiste",
        "Barbe",
        "Barbier",
        "Barbier",
        "Bardet",
        "Baron",
        "Barre",
        "Barreau",
        "Barret",
        "Barriere",
        "Barthe",
        "Barthelemy",
        "Basset",
        "Bastide",
        "Bastien",
        "Bataille",
        "Baud",
        "Baudet",
        "Baudin",
        "Baudoin",
        "Baudouin",
        "Baudry",
        "Bauer",
        "Bayle",
        "Bazin",
        "Beau",
        "Beaufils",
        "Beaumont",
        "Beck",
        "Becker",
        "Begue",
        "Belin",
        "Bellanger",
        "Benard",
        "Benhamou",
        "Benoist",
        "Benoit",
        "Berard",
        "Berger",
        "Bernard",
        "Bernier",
        "Berthelot",
        "Berthet",
        "Berthier",
        "Bertin",
        "Berton",
        "Bertrand",
        "Besnard",
        "Besse",
        "Besson",
        "Bianchi",
        "Bigot",
        "Billard",
        "Billon",
        "Binet",
        "Bisson",
        "Blaise",
        "Blanc",
        "Blanchard",
        "Blanchet",
        "Blandin",
        "Blin",
        "Blondeau",
        "Blondel",
        "Blot",
        "Bocquet",
        "Bodin",
        "Bois",
        "Boisseau",
        "Boisson",
        "Boivin",
        "Bon",
        "Bonhomme",
        "Bonin",
        "Bonnard",
        "Bonneau",
        "Bonnefoy",
        "Bonnet",
        "Bonnin",
        "Bontemps",
        "Bordes",
        "Borel",
        "Bosc",
        "Bouchard",
        "Bouche",
        "Boucher",
        "Bouchet",
        "Boudet",
        "Bouillon",
        "Boulanger",
        "Boulay",
        "Boulet",
        "Bouquet",
        "Bourdin",
        "Bourdon",
        "Bourgeois",
        "Bourgoin",
        "Bourguignon",
        "Bousquet",
        "Boutet",
        "Boutin",
        "Bouvet",
        "Bouvier",
        "Bouyer",
        "Boyer",
        "Brault",
        "Bresson",
        "Breton",
        "Briand",
        "Brochard",
        "Brossard",
        "Brousse",
        "Brun",
        "Bruneau",
        "Brunel",
        "Brunet",
        "Bruno",
        "Buisson",
        "Bureau",
        "Burel",
        "Cadet",
        "Caillaud",
        "Caillet",
        "Calvet",
        "Camara",
        "Camus",
        "Cannet",
        "Cardon",
        "Carlier",
        "Caron",
        "Carpentier",
        "Carre",
        "Carrere",
        "Carriere",
        "Cartier",
        "Casanova",
        "Castel",
        "Cazenave",
        "Chabert",
        "Chabot",
        "Chambon",
        "Champion",
        "Chapuis",
        "Charbonnier",
        "Charles",
        "Charlot",
        "Charpentier",
        "Charrier",
        "Charron",
        "Chartier",
        "Chateau",
        "Chatelain",
        "Chauveau",
        "Chauvet",
        "Chauvin",
        "Chen",
        "Chevalier",
        "Chevallier",
        "Chevrier",
        "Chollet",
        "Chretien",
        "Cisse",
        "Claude",
        "Clavel",
        "Clement",
        "Clerc",
        "Cochet",
        "Cohen",
        "Colas",
        "Colin",
        "Collet",
        "Collin",
        "Combe",
        "Combes",
        "Comte",
        "Constant",
        "Constantin",
        "Conte",
        "Cordier",
        "Cornet",
        "Cornu",
        "Corre",
        "Cortes",
        "Costa",
        "Coste",
        "Costes",
        "Couderc",
        "Coudert",
        "Coulon",
        "Courtois",
        "Cousin",
        "Couturier",
        "Crepin",
        "Cros",
        "Crouzet",
        "Da Costa",
        "Dahan",
        "Daniel",
        "Da Silva",
        "David",
        "Dejean",
        "Delage",
        "Delahaye",
        "Delannoy",
        "Delaporte",
        "Delattre",
        "Delaunay",
        "Delmas",
        "Delorme",
        "Delpech",
        "Denis",
        "De Oliveira",
        "Descamps",
        "Deschamps",
        "Deshayes",
        "De Sousa",
        "Devaux",
        "Diallo",
        "Dias",
        "Diaz",
        "Didier",
        "Dijoux",
        "Diop",
        "Dore",
        "Dos Santos",
        "Doucet",
        "Drouet",
        "Dubois",
        "Dubos",
        "Dubourg",
        "Dubreuil",
        "Duchemin",
        "Duchene",
        "Duclos",
        "Ducrocq",
        "Dufour",
        "Duhamel",
        "Dujardin",
        "Dumas",
        "Dumont",
        "Dumoulin",
        "Dupin",
        "Dupond",
        "Dupont",
        "Dupouy",
        "Duprat",
        "Dupre",
        "Dupuis",
        "Dupuy",
        "Durand",
        "Duret",
        "Duval",
        "Esnault",
        "Esteve",
        "Etienne",
        "Evrard",
        "Évrat",
        "Fabre",
        "Faivre",
        "Faucher",
        "Faure",
        "Favier",
        "Favre",
        "Faye",
        "Fayolle",
        "Felix",
        "Fernandes",
        "Fernandez",
        "Ferrand",
        "Ferrari",
        "Ferre",
        "Ferreira",
        "Ferrer",
        "Ferrier",
        "Ferry",
        "Ferry",
        "Fischer",
        "Flament",
        "Fleury",
        "Flores",
        "Fontaine",
        "Forest",
        "Forestier",
        "Fort",
        "Fortin",
        "Foucault",
        "Foucher",
        "Foulon",
        "Fouquet",
        "Fourcade",
        "Fournier",
        "Francois",
        "Froment",
        "Gabriel",
        "Gaillard",
        "Galland",
        "Gallet",
        "Garcia",
        "Garcin",
        "Garnier",
        "Gaubert",
        "Gaudin",
        "Gauthier",
        "Gautier",
        "Gay",
        "Geneau",
        "Genin",
        "Geoffroy",
        "George",
        "Georges",
        "Gerard",
        "Germain",
        "Gervais",
        "Gibert",
        "Gicquel",
        "Gil",
        "Gilbert",
        "Gilles",
        "Gillet",
        "Gimenez",
        "Giordano",
        "Girard",
        "Giraud",
        "Girault",
        "Godard",
        "Godefroy",
        "Godet",
        "Godin",
        "Gomes",
        "Gomez",
        "Goncalves",
        "Gonthier",
        "Gonzales",
        "Gonzalez",
        "Gosselin",
        "Goujon",
        "Grand",
        "Grandjean",
        "Grange",
        "Granger",
        "Granier",
        "Gras",
        "Gregoire",
        "Grenier",
        "Grimaud",
        "Grondin",
        "Gros",
        "Grosjean",
        "Guegan",
        "Gueguen",
        "Guerin",
        "Guibert",
        "Guichard",
        "Guignard",
        "Guilbaud",
        "Guilbert",
        "Guillard",
        "Guillaume",
        "Guillemin",
        "Guillemot",
        "Guillet",
        "Guillon",
        "Guillot",
        "Guillou",
        "Guiraud",
        "Guitton",
        "Guy",
        "Guyon",
        "Guyot",
        "Haddad",
        "Hamel",
        "Hamon",
        "Hardy",
        "Hebert",
        "Hénaut",
        "Henry",
        "Hernandez",
        "Herve",
        "Hoarau",
        "Hoareau",
        "Hoffmann",
        "Hubert",
        "Hue",
        "Huet",
        "Huguet",
        "Humbert",
        "Husson",
        "Imbert",
        "Ivanov",
        "Jacob",
        "Jacquemin",
        "Jacques",
        "Jacquet",
        "Jacquin",
        "Jacquot",
        "Jamet",
        "Janel",
        "Janin",
        "Jarry",
        "Jean",
        "Jeanne",
        "Jimenez",
        "Jolivet",
        "Jolly",
        "Joly",
        "Joseph",
        "Josse",
        "Jouan",
        "Joubert",
        "Jourdain",
        "Jourdan",
        "Jouve",
        "Julien",
        "Jullien",
        "Jung",
        "Keller",
        "Kieffer",
        "Kléber",
        "Klein",
        "Labat",
        "Labbe",
        "Laborde",
        "Lacaze",
        "Lacombe",
        "Lacoste",
        "Lacour",
        "Lacroix",
        "Laffont",
        "Lafon",
        "Lafont",
        "Lagarde",
        "Lagrange",
        "Laine",
        "Lalanne",
        "Lallemand",
        "Lamarque",
        "Lambert",
        "Lamotte",
        "Lamy",
        "Lang",
        "Langlois",
        "Lapeyre",
        "Lapierre",
        "Laporte",
        "Laroche",
        "Lassalle",
        "Lasserre",
        "Latour",
        "Launay",
        "Laurent",
        "Lauret",
        "Laval",
        "Lavergne",
        "Lavigne",
        "Le",
        "Lebeau",
        "Le Berre",
        "Le Bihan",
        "Leblanc",
        "Leblond",
        "Lebon",
        "Le Borgne",
        "Le Bras",
        "Lebreton",
        "Le Bris",
        "Lebrun",
        "Leclerc",
        "Leclercq",
        "Leclere",
        "Lecocq",
        "Lecomte",
        "Leconte",
        "Lecoq",
        "Le Corre",
        "Lecuyer",
        "Ledoux",
        "Leduc",
        "Lefebvre",
        "Lefeuvre",
        "Lefevre",
        "Le Floch",
        "Lefort",
        "Lefranc",
        "Lefrancois",
        "Le Gal",
        "Le Gall",
        "Legendre",
        "Leger",
        "Le Goff",
        "Legrand",
        "Legros",
        "Le Guen",
        "Lejeune",
        "Leleu",
        "Lelievre",
        "Lelong",
        "Lemaire",
        "Lemaitre",
        "Lemarchand",
        "Lemoine",
        "Lemonnier",
        "Lenfant",
        "Lenoir",
        "Leon",
        "Leonard",
        "Lepage",
        "Leray",
        "Leroux",
        "Le Roux",
        "Leroy",
        "Le Roy",
        "Lesage",
        "Lesueur",
        "Letellier",
        "Levasseur",
        "Leveque",
        "Levy",
        "Li",
        "Loiseau",
        "Lombard",
        "Lombard",
        "Lopes",
        "Lopez",
        "Louis",
        "Louvet",
        "Lucas",
        "Ly",
        "Mace",
        "Magne",
        "Magnier",
        "Mahe",
        "Maillard",
        "Maillet",
        "Maillot",
        "Maire",
        "Maitre",
        "Mallet",
        "Mangin",
        "Marais",
        "Marc",
        "Marchal",
        "Marchand",
        "Marechal",
        "Marie",
        "Marin",
        "Marion",
        "Marques",
        "Marquet",
        "Marteau",
        "Martel",
        "Martin",
        "Martin",
        "Martineau",
        "Martinet",
        "Martinez",
        "Martins",
        "Marty",
        "Mary",
        "Mas",
        "Masse",
        "Masson",
        "Mathieu",
        "Mauger",
        "Maurel",
        "Maurice",
        "Maurin",
        "Maury",
        "Mayer",
        "Menard",
        "Mendes",
        "Mercier",
        "Merle",
        "Merlin",
        "Meunier",
        "Meyer",
        "Michaud",
        "Michel",
        "Michelet",
        "Michon",
        "Mignot",
        "Millet",
        "Millot",
        "Miquel",
        "Mohamed",
        "Moine",
        "Molina",
        "Monier",
        "Monnet",
        "Monnier",
        "Montagne",
        "Monteil",
        "Morand",
        "Moreau",
        "Morel",
        "Moreno",
        "Morice",
        "Morin",
        "Morvan",
        "Moulin",
        "Mounier",
        "Mouton",
        "Muller",
        "Munier",
        "Munoz",
        "Navarro",
        "Ndiaye",
        "Neveu",
        "Nguyen",
        "Nicolas",
        "Nicolle",
        "Niels",
        "Noel",
        "Normand",
        "Oger",
        "Ogier",
        "Olivier",
        "Ollier",
        "Ollivier",
        "Page",
        "Pages",
        "Pain",
        "Papin",
        "Paquet",
        "Parent",
        "Paris",
        "Parisot",
        "Parmentier",
        "Parmentier",
        "Pascal",
        "Pasquet",
        "Pasquier",
        "Pastor",
        "Paul",
        "Payen",
        "Payet",
        "Pelissier",
        "Pellerin",
        "Pelletier",
        "Peltier",
        "Pepin",
        "Pereira",
        "Perez",
        "Peron",
        "Perret",
        "Perrier",
        "Perrin",
        "Perron",
        "Perrot",
        "Petit",
        "Petitjean",
        "Pham",
        "Philippe",
        "Picard",
        "Pichon",
        "Picot",
        "Pierre",
        "Pierron",
        "Pineau",
        "Pinel",
        "Pinto",
        "Piquet",
        "Poirier",
        "Poisson",
        "Pollet",
        "Pommier",
        "Poncet",
        "Pons",
        "Porte",
        "Portier",
        "Potier",
        "Pottier",
        "Pouget",
        "Poulain",
        "Poulet",
        "Prat",
        "Prevost",
        "Prevot",
        "Prieur",
        "Prigent",
        "Prost",
        "Proust",
        "Provost",
        "Pruvost",
        "Puech",
        "Pujol",
        "Quere",
        "Quesada",
        "Ragot",
        "Rambaud",
        "Ramos",
        "Rault",
        "Raymond",
        "Raynal",
        "Raynaud",
        "Reboul",
        "Redon",
        "Regnier",
        "Remy",
        "Renard",
        "Renaud",
        "Renault",
        "Renou",
        "Rey",
        "Reynaud",
        "Ribeiro",
        "Ricard",
        "Richard",
        "Rigal",
        "Rigaud",
        "Riou",
        "Rivet",
        "Riviere",
        "Robert",
        "Robin",
        "Roche",
        "Rocher",
        "Rodrigues",
        "Rodriguez",
        "Roger",
        "Roland",
        "Rolland",
        "Rollin",
        "Romain",
        "Roman",
        "Romero",
        "Roques",
        "Rose",
        "Rossi",
        "Rossignol",
        "Roth",
        "Rougier",
        "Rousseau",
        "Roussel",
        "Rousset",
        "Roux",
        "Rouxel",
        "Roy",
        "Royer",
        "Ruiz",
        "Sabatier",
        "Sablonnière",
        "Saidi",
        "Salaun",
        "Salles",
        "Salmon",
        "Salomon",
        "Samson",
        "Sanchez",
        "Santiago",
        "Sarrazin",
        "Saunier",
        "Sauvage",
        "Savary",
        "Schmidt",
        "Schmitt",
        "Schneider",
        "Schwartz",
        "Seguin",
        "Sellier",
        "Sergent",
        "Serra",
        "Serrano",
        "Serre",
        "Serres",
        "Sicard",
        "Simon",
        "Simonet",
        "Simonin",
        "Smith",
        "Soler",
        "Soulie",
        "Soulier",
        "Stephan",
        "Tanguy",
        "Tardy",
        "Tavernier",
        "Techer",
        "Teixeira",
        "Tellier",
        "Terrier",
        "Tessier",
        "Texier",
        "Teyssier",
        "Thebault",
        "Thery",
        "Thevenet",
        "Thevenin",
        "Thibault",
        "Thiebaut",
        "Thierry",
        "Thiery",
        "Thomas",
        "Tisserand",
        "Tissier",
        "Tissot",
        "Torres",
        "Toure",
        "Tournier",
        "Toussaint",
        "Tran",
        "Traore",
        "Truchot",
        "Turpin",
        "Urbain",
        "Vacher",
        "Vaillant",
        "Valentin",
        "Valette",
        "Vallee",
        "Vallet",
        "Vannier",
        "Vasseur",
        "Verdier",
        "Verger",
        "Vergez",
        "Vernet",
        "Verrier",
        "Vial",
        "Viala",
        "Vidal",
        "Vigier",
        "Vigneron",
        "Vigouroux",
        "Villain",
        "Villard",
        "Villeneuve",
        "Vincent",
        "Vivier",
        "Voisin",
        "Wagner",
        "Walliand",
        "Walter",
        "Wang",
        "Weber",
        "Weiss",
        "Winterstein",
        "Wolff",
        "Xharde",
        "Yilmaz",
        "Yvars",
        "Zimmermann",
        "Zola",
    ];

    const NAME_TITLE: &'static [&'static str] = &["Mme", "M."];

    const ADDRESS_CITY_TPL: &'static str = "{CityName}";

    const ADDRESS_STREET_SUFFIX: &'static [&'static str] = &[
        "Allée", "Avenue", "Rue", "Cours", "Venelle", "Impasse", "Place",
    ];

    const ADDRESS_STREET_TPL: &'static str = "{StreetSuffix} {StreetName}";

    const ADDRESS_TIME_ZONE: &'static [&'static str] = &["Europe/Paris"];

    // Source https://en.wikipedia.org/wiki/Postal_codes_in_France
    const ADDRESS_ZIP_FORMATS: &'static [&'static str] = &["#####"];
    const ADDRESS_POSTCODE_FORMATS: &'static [&'static str] = &["#####"];

    // Country list in french:
    // https://sql.sh/514-liste-pays-csv-xml
    const ADDRESS_COUNTRY: &'static [&'static str] = &[
        "Afghanistan",
        "Albanie",
        "Antarctique",
        "Algérie",
        "Samoa Américaines",
        "Andorre",
        "Angola",
        "Antigua-et-Barbuda",
        "Azerbaïdjan",
        "Argentine",
        "Australie",
        "Autriche",
        "Bahamas",
        "Bahreïn",
        "Bangladesh",
        "Arménie",
        "Barbade",
        "Belgique",
        "Bermudes",
        "Bhoutan",
        "Bolivie",
        "Bosnie-Herzégovine",
        "Botswana",
        "Île Bouvet",
        "Brésil",
        "Belize",
        "Territoire Britannique de l'Océan Indien",
        "Îles Salomon",
        "Îles Vierges Britanniques",
        "Brunéi Darussalam",
        "Bulgarie",
        "Myanmar",
        "Burundi",
        "Bélarus",
        "Cambodge",
        "Cameroun",
        "Canada",
        "Cap-vert",
        "Îles Caïmanes",
        "République Centrafricaine",
        "Sri Lanka",
        "Tchad",
        "Chili",
        "Chine",
        "Taïwan",
        "Île Christmas",
        "Îles Cocos (Keeling)",
        "Colombie",
        "Comores",
        "Mayotte",
        "République du Congo",
        "République Démocratique du Congo",
        "Îles Cook",
        "Costa Rica",
        "Croatie",
        "Cuba",
        "Chypre",
        "République Tchèque",
        "Bénin",
        "Danemark",
        "Dominique",
        "République Dominicaine",
        "Équateur",
        "El Salvador",
        "Guinée Équatoriale",
        "Éthiopie",
        "Érythrée",
        "Estonie",
        "Îles Féroé",
        "Îles (malvinas) Falkland",
        "Géorgie du Sud et les Îles Sandwich du Sud",
        "Fidji",
        "Finlande",
        "Îles Åland",
        "France",
        "Guyane Française",
        "Polynésie Française",
        "Terres Australes Françaises",
        "Djibouti",
        "Gabon",
        "Géorgie",
        "Gambie",
        "Territoire Palestinien Occupé",
        "Allemagne",
        "Ghana",
        "Gibraltar",
        "Kiribati",
        "Grèce",
        "Groenland",
        "Grenade",
        "Guadeloupe",
        "Guam",
        "Guatemala",
        "Guinée",
        "Guyana",
        "Haïti",
        "Îles Heard et Mcdonald",
        "Saint-Siège (état de la Cité du Vatican)",
        "Honduras",
        "Hong-Kong",
        "Hongrie",
        "Islande",
        "Inde",
        "Indonésie",
        "République Islamique d'Iran",
        "Iraq",
        "Irlande",
        "Israël",
        "Italie",
        "Côte d'Ivoire",
        "Jamaïque",
        "Japon",
        "Kazakhstan",
        "Jordanie",
        "Kenya",
        "République Populaire Démocratique de Corée",
        "République de Corée",
        "Koweït",
        "Kirghizistan",
        "République Démocratique Populaire Lao",
        "Liban",
        "Lesotho",
        "Lettonie",
        "Libéria",
        "Jamahiriya Arabe Libyenne",
        "Liechtenstein",
        "Lituanie",
        "Luxembourg",
        "Macao",
        "Madagascar",
        "Malawi",
        "Malaisie",
        "Maldives",
        "Mali",
        "Malte",
        "Martinique",
        "Mauritanie",
        "Maurice",
        "Mexique",
        "Monaco",
        "Mongolie",
        "République de Moldova",
        "Montserrat",
        "Maroc",
        "Mozambique",
        "Oman",
        "Namibie",
        "Nauru",
        "Népal",
        "Pays-Bas",
        "Antilles Néerlandaises",
        "Aruba",
        "Nouvelle-Calédonie",
        "Vanuatu",
        "Nouvelle-Zélande",
        "Nicaragua",
        "Niger",
        "Nigéria",
        "Niué",
        "Île Norfolk",
        "Norvège",
        "Îles Mariannes du Nord",
        "Îles Mineures Éloignées des États-Unis",
        "États Fédérés de Micronésie",
        "Îles Marshall",
        "Palaos",
        "Pakistan",
        "Panama",
        "Papouasie-Nouvelle-Guinée",
        "Paraguay",
        "Pérou",
        "Philippines",
        "Pitcairn",
        "Pologne",
        "Portugal",
        "Guinée-Bissau",
        "Timor-Leste",
        "Porto Rico",
        "Qatar",
        "Réunion",
        "Roumanie",
        "Fédération de Russie",
        "Rwanda",
        "Sainte-Hélène",
        "Saint-Kitts-et-Nevis",
        "Anguilla",
        "Sainte-Lucie",
        "Saint-Pierre-et-Miquelon",
        "Saint-Vincent-et-les Grenadines",
        "Saint-Marin",
        "Sao Tomé-et-Principe",
        "Arabie Saoudite",
        "Sénégal",
        "Seychelles",
        "Sierra Leone",
        "Singapour",
        "Slovaquie",
        "Viet Nam",
        "Slovénie",
        "Somalie",
        "Afrique du Sud",
        "Zimbabwe",
        "Espagne",
        "Sahara Occidental",
        "Soudan",
        "Suriname",
        "Svalbard etÎle Jan Mayen",
        "Swaziland",
        "Suède",
        "Suisse",
        "République Arabe Syrienne",
        "Tadjikistan",
        "Thaïlande",
        "Togo",
        "Tokelau",
        "Tonga",
        "Trinité-et-Tobago",
        "Émirats Arabes Unis",
        "Tunisie",
        "Turquie",
        "Turkménistan",
        "Îles Turks et Caïques",
        "Tuvalu",
        "Ouganda",
        "Ukraine",
        "L'ex-République Yougoslave de Macédoine",
        "Égypte",
        "Royaume-Uni",
        "Île de Man",
        "République-Unie de Tanzanie",
        "États-Unis",
        "Îles Vierges des États-Unis",
        "Burkina Faso",
        "Uruguay",
        "Ouzbékistan",
        "Venezuela",
        "Wallis et Futuna",
        "Samoa",
        "Yémen",
        "Serbie-et-Monténégro",
        "Zambie",
    ];

    const INTERNET_FREE_EMAIL_PROVIDER: &'static [&'static str] = &[
        "free.fr",
        "sfr.fr",
        "laposte.fr",
        "outlook.fr",
        "hotmail.fr",
        "orange.fr",
    ];

    const PHONE_NUMBER_FORMATS: &'static [&'static str] = &[
        "01 ## ## ## ##",
        "02 ## ## ## ##",
        "03 ## ## ## ##",
        "04 ## ## ## ##",
        "05 ## ## ## ##",
        "08 ## ## ## ##",
        "09 ## ## ## ##",
    ];
    const PHONE_CELL_NUMBER_FORMATS: &'static [&'static str] =
        &["06 ## ## ## ##", "07 ## ## ## ##", "09 ## ## ## ##"];
}

impl CityNameGenFn for FR_FR {}
