// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, Layer, MapSource, State, Viewport};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "ShumateMap")]
    pub struct Map(Object<ffi::ShumateMap, ffi::ShumateMapClass>) @extends gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget;

    match fn {
        type_ => || ffi::shumate_map_get_type(),
    }
}

impl Map {
    #[doc(alias = "shumate_map_new")]
    pub fn new() -> Map {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::shumate_map_new()) }
    }

    #[doc(alias = "shumate_map_new_simple")]
    pub fn new_simple() -> Map {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::shumate_map_new_simple()) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Map`] objects.
    ///
    /// This method returns an instance of [`MapBuilder`](crate::builders::MapBuilder) which can be used to create [`Map`] objects.
    pub fn builder() -> MapBuilder {
        MapBuilder::new()
    }

    #[doc(alias = "shumate_map_add_layer")]
    pub fn add_layer(&self, layer: &impl IsA<Layer>) {
        unsafe {
            ffi::shumate_map_add_layer(self.to_glib_none().0, layer.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "shumate_map_center_on")]
    pub fn center_on(&self, latitude: f64, longitude: f64) {
        unsafe {
            ffi::shumate_map_center_on(self.to_glib_none().0, latitude, longitude);
        }
    }

    #[doc(alias = "shumate_map_get_animate_zoom")]
    #[doc(alias = "get_animate_zoom")]
    #[doc(alias = "animate-zoom")]
    pub fn is_animate_zoom(&self) -> bool {
        unsafe { from_glib(ffi::shumate_map_get_animate_zoom(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_map_get_go_to_duration")]
    #[doc(alias = "get_go_to_duration")]
    #[doc(alias = "go-to-duration")]
    pub fn go_to_duration(&self) -> u32 {
        unsafe { ffi::shumate_map_get_go_to_duration(self.to_glib_none().0) }
    }

    #[doc(alias = "shumate_map_get_state")]
    #[doc(alias = "get_state")]
    pub fn state(&self) -> State {
        unsafe { from_glib(ffi::shumate_map_get_state(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_map_get_viewport")]
    #[doc(alias = "get_viewport")]
    pub fn viewport(&self) -> Option<Viewport> {
        unsafe { from_glib_none(ffi::shumate_map_get_viewport(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_map_get_zoom_on_double_click")]
    #[doc(alias = "get_zoom_on_double_click")]
    #[doc(alias = "zoom-on-double-click")]
    pub fn is_zoom_on_double_click(&self) -> bool {
        unsafe {
            from_glib(ffi::shumate_map_get_zoom_on_double_click(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_map_go_to")]
    pub fn go_to(&self, latitude: f64, longitude: f64) {
        unsafe {
            ffi::shumate_map_go_to(self.to_glib_none().0, latitude, longitude);
        }
    }

    #[doc(alias = "shumate_map_go_to_full")]
    pub fn go_to_full(&self, latitude: f64, longitude: f64, zoom_level: f64) {
        unsafe {
            ffi::shumate_map_go_to_full(self.to_glib_none().0, latitude, longitude, zoom_level);
        }
    }

    #[doc(alias = "shumate_map_go_to_full_with_duration")]
    pub fn go_to_full_with_duration(
        &self,
        latitude: f64,
        longitude: f64,
        zoom_level: f64,
        duration_ms: u32,
    ) {
        unsafe {
            ffi::shumate_map_go_to_full_with_duration(
                self.to_glib_none().0,
                latitude,
                longitude,
                zoom_level,
                duration_ms,
            );
        }
    }

    #[doc(alias = "shumate_map_insert_layer_above")]
    pub fn insert_layer_above(
        &self,
        layer: &impl IsA<Layer>,
        next_sibling: Option<&impl IsA<Layer>>,
    ) {
        unsafe {
            ffi::shumate_map_insert_layer_above(
                self.to_glib_none().0,
                layer.as_ref().to_glib_none().0,
                next_sibling.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_map_insert_layer_behind")]
    pub fn insert_layer_behind(
        &self,
        layer: &impl IsA<Layer>,
        next_sibling: Option<&impl IsA<Layer>>,
    ) {
        unsafe {
            ffi::shumate_map_insert_layer_behind(
                self.to_glib_none().0,
                layer.as_ref().to_glib_none().0,
                next_sibling.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_map_remove_layer")]
    pub fn remove_layer(&self, layer: &impl IsA<Layer>) {
        unsafe {
            ffi::shumate_map_remove_layer(self.to_glib_none().0, layer.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "shumate_map_set_animate_zoom")]
    #[doc(alias = "animate-zoom")]
    pub fn set_animate_zoom(&self, value: bool) {
        unsafe {
            ffi::shumate_map_set_animate_zoom(self.to_glib_none().0, value.into_glib());
        }
    }

    #[doc(alias = "shumate_map_set_go_to_duration")]
    #[doc(alias = "go-to-duration")]
    pub fn set_go_to_duration(&self, duration: u32) {
        unsafe {
            ffi::shumate_map_set_go_to_duration(self.to_glib_none().0, duration);
        }
    }

    #[doc(alias = "shumate_map_set_map_source")]
    pub fn set_map_source(&self, map_source: &impl IsA<MapSource>) {
        unsafe {
            ffi::shumate_map_set_map_source(
                self.to_glib_none().0,
                map_source.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_map_set_zoom_on_double_click")]
    #[doc(alias = "zoom-on-double-click")]
    pub fn set_zoom_on_double_click(&self, value: bool) {
        unsafe {
            ffi::shumate_map_set_zoom_on_double_click(self.to_glib_none().0, value.into_glib());
        }
    }

    #[doc(alias = "shumate_map_stop_go_to")]
    pub fn stop_go_to(&self) {
        unsafe {
            ffi::shumate_map_stop_go_to(self.to_glib_none().0);
        }
    }

    #[doc(alias = "shumate_map_zoom_in")]
    pub fn zoom_in(&self) {
        unsafe {
            ffi::shumate_map_zoom_in(self.to_glib_none().0);
        }
    }

    #[doc(alias = "shumate_map_zoom_out")]
    pub fn zoom_out(&self) {
        unsafe {
            ffi::shumate_map_zoom_out(self.to_glib_none().0);
        }
    }

    #[doc(alias = "animation-completed")]
    pub fn connect_animation_completed<F: Fn(&Self) + 'static>(
        &self,
        detail: Option<&str>,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn animation_completed_trampoline<F: Fn(&Map) + 'static>(
            this: *mut ffi::ShumateMap,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            let detailed_signal_name = detail.map(|name| format!("animation-completed::{name}\0"));
            let signal_name: &[u8] = detailed_signal_name
                .as_ref()
                .map_or(c"animation-completed".to_bytes(), |n| n.as_bytes());
            connect_raw(
                self.as_ptr() as *mut _,
                signal_name.as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    animation_completed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "animate-zoom")]
    pub fn connect_animate_zoom_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_animate_zoom_trampoline<F: Fn(&Map) + 'static>(
            this: *mut ffi::ShumateMap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::animate-zoom".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_animate_zoom_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "go-to-duration")]
    pub fn connect_go_to_duration_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_go_to_duration_trampoline<F: Fn(&Map) + 'static>(
            this: *mut ffi::ShumateMap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::go-to-duration".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_go_to_duration_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "state")]
    pub fn connect_state_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_state_trampoline<F: Fn(&Map) + 'static>(
            this: *mut ffi::ShumateMap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::state".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_state_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "viewport")]
    pub fn connect_viewport_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_viewport_trampoline<F: Fn(&Map) + 'static>(
            this: *mut ffi::ShumateMap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::viewport".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_viewport_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "zoom-on-double-click")]
    pub fn connect_zoom_on_double_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_zoom_on_double_click_trampoline<F: Fn(&Map) + 'static>(
            this: *mut ffi::ShumateMap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::zoom-on-double-click".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_zoom_on_double_click_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for Map {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Map`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct MapBuilder {
    builder: glib::object::ObjectBuilder<'static, Map>,
}

impl MapBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn animate_zoom(self, animate_zoom: bool) -> Self {
        Self {
            builder: self.builder.property("animate-zoom", animate_zoom),
        }
    }

    pub fn go_to_duration(self, go_to_duration: u32) -> Self {
        Self {
            builder: self.builder.property("go-to-duration", go_to_duration),
        }
    }

    pub fn zoom_on_double_click(self, zoom_on_double_click: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("zoom-on-double-click", zoom_on_double_click),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    #[cfg(feature = "gtk_v4_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "gtk_v4_18")))]
    pub fn limit_events(self, limit_events: bool) -> Self {
        Self {
            builder: self.builder.property("limit-events", limit_events),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: gtk::Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: gtk::AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Map`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Map {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
