/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.diagnostic.PluginException;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class CompositeFoldingBuilder
extends FoldingBuilderEx
implements PossiblyDumbAware {
    @NotNull
    private final List<? extends FoldingBuilder> myBuilders;

    CompositeFoldingBuilder(@NotNull List<? extends FoldingBuilder> builders) {
        if (builders == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(0);
        }
        this.myBuilders = builders;
    }

    @Override
    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(2);
        }
        ArrayList<FoldingDescriptorWrapper> descriptors = new ArrayList<FoldingDescriptorWrapper>();
        HashSet<TextRange> rangesCoveredByDescriptors = new HashSet<TextRange>();
        PsiFile containingFile = PsiUtilCore.getTemplateLanguageFile(root);
        for (FoldingBuilder foldingBuilder : DumbService.getInstance(root.getProject()).filterByDumbAwareness(this.myBuilders)) {
            for (FoldingDescriptor descriptor2 : LanguageFolding.buildFoldingDescriptorsNoPlaceholderCaching(foldingBuilder, root, document, quick)) {
                PsiElement descriptorPsi = descriptor2.getElement().getPsi();
                if (descriptorPsi != null) {
                    CompositeFoldingBuilder.assertSameFile(containingFile, descriptor2, descriptorPsi, foldingBuilder);
                }
                if (!rangesCoveredByDescriptors.add(descriptor2.getRange())) continue;
                descriptors.add(new FoldingDescriptorWrapper(descriptor2, foldingBuilder));
            }
        }
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(FoldingDescriptor.EMPTY_ARRAY);
        if (foldingDescriptorArray == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(3);
        }
        return foldingDescriptorArray;
    }

    public static void assertSameFile(@NotNull PsiFile containingFile, @NotNull FoldingDescriptor descriptor2, @NotNull PsiElement descriptorPsi, @NotNull FoldingBuilder foldingBuilder) {
        PsiFile descriptorFile;
        if (containingFile == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(5);
        }
        if (descriptorPsi == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(6);
        }
        if (foldingBuilder == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(7);
        }
        if (containingFile != (descriptorFile = PsiUtilCore.getTemplateLanguageFile(descriptorPsi))) {
            throw PluginException.createByClass(new IllegalStateException("Folding descriptor " + descriptor2 + ", containing PSI element " + descriptorPsi + " of " + descriptorPsi.getClass() + ", provided by " + foldingBuilder + " (" + foldingBuilder.getClass() + ") must belong to the file " + containingFile + ", but got: " + descriptorFile), foldingBuilder.getClass());
        }
    }

    @Override
    public String getPlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(8);
        }
        if (range == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(9);
        }
        return node.getText();
    }

    @Override
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(10);
        }
        return node.getText();
    }

    @Override
    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(11);
        }
        return false;
    }

    @Override
    public boolean isCollapsedByDefault(@NotNull FoldingDescriptor foldingDescriptor) {
        if (foldingDescriptor == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(12);
        }
        FoldingBuilder builder = ((FoldingDescriptorWrapper)foldingDescriptor).myBuilder;
        return CompositeFoldingBuilder.mayUseBuilder(foldingDescriptor.getElement(), builder) && builder.isCollapsedByDefault(foldingDescriptor);
    }

    private static boolean mayUseBuilder(@NotNull ASTNode node, @Nullable FoldingBuilder builder) {
        if (node == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(13);
        }
        if (builder == null) {
            return false;
        }
        Project project = CompositeFoldingBuilder.getProjectByNode(node);
        return project == null || DumbService.getInstance(project).isUsableInCurrentContext(builder);
    }

    @Nullable
    private static Project getProjectByNode(@NotNull ASTNode node) {
        PsiElement psi;
        if (node == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(14);
        }
        if ((psi = node.getPsi()) == null) {
            ASTNode parent = node.getTreeParent();
            psi = parent == null ? null : parent.getPsi();
        }
        return psi == null ? null : psi.getProject();
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.myBuilders;
    }

    @Override
    public boolean isDumbAware() {
        for (FoldingBuilder foldingBuilder : this.myBuilders) {
            if (!DumbService.isDumbAware(foldingBuilder)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static FoldingBuilder getOriginalBuilder(@NotNull FoldingDescriptor foldingDescriptor) {
        if (foldingDescriptor == null) {
            CompositeFoldingBuilder.$$$reportNull$$$0(15);
        }
        if (foldingDescriptor instanceof FoldingDescriptorWrapper) {
            return ((FoldingDescriptorWrapper)foldingDescriptor).myBuilder;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builders";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/folding/CompositeFoldingBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorPsi";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingBuilder";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/folding/CompositeFoldingBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "assertSameFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mayUseBuilder";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getProjectByNode";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FoldingDescriptorWrapper
    extends FoldingDescriptor {
        @NotNull
        private final FoldingDescriptor myFoldingDescriptor;
        @NotNull
        private final FoldingBuilder myBuilder;

        FoldingDescriptorWrapper(@NotNull FoldingDescriptor foldingDescriptor, @NotNull FoldingBuilder builder) {
            if (foldingDescriptor == null) {
                FoldingDescriptorWrapper.$$$reportNull$$$0(0);
            }
            if (builder == null) {
                FoldingDescriptorWrapper.$$$reportNull$$$0(1);
            }
            super(foldingDescriptor.getElement(), foldingDescriptor.getRange(), foldingDescriptor.getGroup(), foldingDescriptor.getDependencies(), foldingDescriptor.isNonExpandable(), FoldingDescriptorWrapper.choosePlaceholderText(foldingDescriptor), foldingDescriptor.isCollapsedByDefault());
            this.myFoldingDescriptor = foldingDescriptor;
            this.myBuilder = builder;
        }

        private static String choosePlaceholderText(@NotNull FoldingDescriptor foldingDescriptor) {
            if (foldingDescriptor == null) {
                FoldingDescriptorWrapper.$$$reportNull$$$0(2);
            }
            String cachedText = foldingDescriptor.getCachedPlaceholderText();
            String textFromGetText = foldingDescriptor.getPlaceholderText();
            boolean placeholderTextIsFallback = Objects.equals(textFromGetText, foldingDescriptor.getElement().getText());
            return placeholderTextIsFallback ? cachedText : textFromGetText;
        }

        @Override
        @NotNull
        public @Unmodifiable Set<Object> getDependencies() {
            Set<Object> set = this.myFoldingDescriptor.getDependencies();
            if (set == null) {
                FoldingDescriptorWrapper.$$$reportNull$$$0(3);
            }
            return set;
        }

        @Override
        protected String calcPlaceholderText() {
            ASTNode element = this.getElement();
            return !CompositeFoldingBuilder.mayUseBuilder(element, this.myBuilder) ? element.getText() : (this.myBuilder instanceof FoldingBuilderEx ? ((FoldingBuilderEx)this.myBuilder).getPlaceholderText(element, this.getRange()) : this.myBuilder.getPlaceholderText(element));
        }

        @Override
        public boolean canBeRemovedWhenCollapsed() {
            return this.myFoldingDescriptor.canBeRemovedWhenCollapsed();
        }

        @Override
        public void setCanBeRemovedWhenCollapsed(boolean canBeRemovedWhenCollapsed) {
            this.myFoldingDescriptor.setCanBeRemovedWhenCollapsed(canBeRemovedWhenCollapsed);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foldingDescriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/folding/CompositeFoldingBuilder$FoldingDescriptorWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/folding/CompositeFoldingBuilder$FoldingDescriptorWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "choosePlaceholderText";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

