/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class PathEnvironmentVariableUtil {
    private static final String PATH = "PATH";

    private PathEnvironmentVariableUtil() {
    }

    @Nullable
    public static File findInPath(@NotNull @NonNls String fileBaseName) {
        if (fileBaseName == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(0);
        }
        return PathEnvironmentVariableUtil.findInPath(fileBaseName, null);
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName, @Nullable FileFilter filter) {
        if (fileBaseName == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(1);
        }
        return PathEnvironmentVariableUtil.findInPath(fileBaseName, PathEnvironmentVariableUtil.getPathVariableValue(), filter);
    }

    @Nullable
    public static File findInPath(@NotNull String fileBaseName, @Nullable String pathVariableValue, @Nullable FileFilter filter) {
        if (fileBaseName == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(2);
        }
        List<File> exeFiles = PathEnvironmentVariableUtil.findExeFilesInPath(true, filter, pathVariableValue, fileBaseName);
        return (File)ContainerUtil.getFirstItem(exeFiles);
    }

    @NotNull
    public static List<File> findAllExeFilesInPath(@NotNull String fileBaseName) {
        if (fileBaseName == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(3);
        }
        return PathEnvironmentVariableUtil.findAllExeFilesInPath(fileBaseName, null);
    }

    @NotNull
    public static List<File> findAllExeFilesInPath(@NotNull String fileBaseName, @Nullable FileFilter filter) {
        if (fileBaseName == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(4);
        }
        return PathEnvironmentVariableUtil.findExeFilesInPath(false, filter, PathEnvironmentVariableUtil.getPathVariableValue(), fileBaseName);
    }

    @NotNull
    private static List<File> findExeFilesInPath(boolean stopAfterFirstMatch, @Nullable FileFilter filter, @Nullable String pathEnvVarValue, String ... fileBaseNames) {
        if (fileBaseNames == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(5);
        }
        if (pathEnvVarValue == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                PathEnvironmentVariableUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        SmartList result = new SmartList();
        List<String> dirPaths = PathEnvironmentVariableUtil.getPathDirs(pathEnvVarValue);
        for (String dirPath : dirPaths) {
            File dir = new File(dirPath);
            if (!dir.isAbsolute() || !dir.isDirectory()) continue;
            for (String fileBaseName : fileBaseNames) {
                File exeFile = new File(dir, fileBaseName);
                if (!exeFile.isFile() || !exeFile.canExecute() || filter != null && !filter.accept(exeFile)) continue;
                result.add(exeFile);
                if (!stopAfterFirstMatch) continue;
                SmartList smartList = result;
                if (smartList == null) {
                    PathEnvironmentVariableUtil.$$$reportNull$$$0(7);
                }
                return smartList;
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(8);
        }
        return smartList;
    }

    @NotNull
    public static @Unmodifiable List<String> getPathDirs(@NotNull String pathEnvVarValue) {
        if (pathEnvVarValue == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(9);
        }
        List list = StringUtil.split((String)pathEnvVarValue, (String)File.pathSeparator, (boolean)true, (boolean)true);
        if (list == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public static @Unmodifiable List<String> getWindowsExecutableFileExtensions() {
        String allExtensions;
        if (SystemInfo.isWindows && (allExtensions = System.getenv("PATHEXT")) != null) {
            List extensions = StringUtil.split((String)allExtensions, (String)";", (boolean)true, (boolean)true);
            extensions = ContainerUtil.filter((Collection)extensions, s -> !StringUtil.isEmpty((String)s) && s.startsWith("."));
            List list = ContainerUtil.map((Collection)extensions, s -> StringUtil.toLowerCase((String)s));
            if (list == null) {
                PathEnvironmentVariableUtil.$$$reportNull$$$0(11);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public static String findExecutableInWindowsPath(@NotNull String exePath) {
        if (exePath == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(13);
        }
        String string = PathEnvironmentVariableUtil.findExecutableInWindowsPath(exePath, exePath);
        if (string == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Contract(value="_, !null -> !null")
    public static String findExecutableInWindowsPath(@NotNull String exePath, @Nullable String defaultPath) {
        if (exePath == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(15);
        }
        if (SystemInfo.isWindows && !StringUtil.containsChar((String)exePath, (char)'/') && !StringUtil.containsChar((String)exePath, (char)'\\')) {
            List<String> executableFileExtensions = PathEnvironmentVariableUtil.getWindowsExecutableFileExtensions();
            String[] baseNames = (String[])ContainerUtil.map2Array(executableFileExtensions, String.class, s -> exePath + s);
            List<File> exeFiles = PathEnvironmentVariableUtil.findExeFilesInPath(true, null, PathEnvironmentVariableUtil.getPathVariableValue(), baseNames);
            File foundFile = (File)ContainerUtil.getFirstItem(exeFiles);
            if (foundFile != null) {
                return foundFile.getAbsolutePath();
            }
        }
        return defaultPath;
    }

    @Nullable
    public static String getPathVariableValue() {
        return EnvironmentUtil.getValue((String)PATH);
    }

    @Nullable
    public static File findExecutableInPathOnAnyOS(@NotNull @NonNls String fileBaseName) {
        if (fileBaseName == null) {
            PathEnvironmentVariableUtil.$$$reportNull$$$0(16);
        }
        if (SystemInfo.isWindows) {
            String[] fileNames = (String[])ContainerUtil.map2Array(PathEnvironmentVariableUtil.getWindowsExecutableFileExtensions(), String.class, extension -> fileBaseName + extension);
            List<File> exeFiles = PathEnvironmentVariableUtil.findExeFilesInPath(true, null, PathEnvironmentVariableUtil.getPathVariableValue(), fileNames);
            return (File)ContainerUtil.getFirstItem(exeFiles);
        }
        return PathEnvironmentVariableUtil.findInPath(fileBaseName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 10, 11, 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBaseName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBaseNames";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/PathEnvironmentVariableUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathEnvVarValue";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/PathEnvironmentVariableUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findExeFilesInPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathDirs";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowsExecutableFileExtensions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findExecutableInWindowsPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInPath";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findAllExeFilesInPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findExeFilesInPath";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPathDirs";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findExecutableInWindowsPath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findExecutableInPathOnAnyOS";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 10, 11, 12, 14 -> new IllegalStateException(string);
        };
    }
}

