/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows.conpty;

import com.pty4j.Command;
import com.pty4j.PtyProcess;
import com.pty4j.PtyProcessOptions;
import com.pty4j.WinSize;
import com.pty4j.windows.WinHelper;
import com.pty4j.windows.conpty.ConPtyLibrary;
import com.pty4j.windows.conpty.ConsoleProcessListFetcher;
import com.pty4j.windows.conpty.LastErrorExceptionEx;
import com.pty4j.windows.conpty.NullInputStream;
import com.pty4j.windows.conpty.Pipe;
import com.pty4j.windows.conpty.ProcessUtils;
import com.pty4j.windows.conpty.PseudoConsole;
import com.pty4j.windows.conpty.WinHandleInputStream;
import com.pty4j.windows.conpty.WinHandleOutputStream;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WinConPtyProcess
extends PtyProcess {
    private static final Logger LOG = LoggerFactory.getLogger((String)("#" + WinConPtyProcess.class.getName()));
    private final boolean myIsBundledConPtyLibrary;
    private final PseudoConsole pseudoConsole;
    private final WinBase.PROCESS_INFORMATION processInformation;
    private final WinHandleInputStream myInputStream;
    private final WinHandleOutputStream myOutputStream;
    private final ExitCodeInfo myExitCodeInfo = new ExitCodeInfo();
    private final Command myCommand;

    public WinConPtyProcess(@NotNull PtyProcessOptions options, @Nullable LongConsumer winSuspendedProcessCallback) throws IOException {
        this.myCommand = options.getCommandWrapper();
        this.myIsBundledConPtyLibrary = ConPtyLibrary.isBundled();
        Pipe inPipe = new Pipe();
        Pipe outPipe = new Pipe();
        this.pseudoConsole = new PseudoConsole(WinConPtyProcess.getInitialSize(options), inPipe.getReadPipe(), outPipe.getWritePipe());
        this.processInformation = ProcessUtils.startProcess(this.pseudoConsole, this.myCommand, options.getDirectory(), options.getEnvironment(), winSuspendedProcessCallback);
        if (!Kernel32.INSTANCE.CloseHandle(inPipe.getReadPipe())) {
            throw new LastErrorExceptionEx("CloseHandle stdin after process creation");
        }
        if (!Kernel32.INSTANCE.CloseHandle(outPipe.getWritePipe())) {
            throw new LastErrorExceptionEx("CloseHandle stdout after process creation");
        }
        this.myInputStream = new WinHandleInputStream(outPipe.getReadPipe());
        this.myOutputStream = new WinHandleOutputStream(inPipe.getWritePipe());
        this.startAwaitingThread(options.getCommandWrapper());
    }

    public boolean isBundledConPtyLibrary() {
        return this.myIsBundledConPtyLibrary;
    }

    @Deprecated
    @NotNull
    public List<String> getCommand() {
        return this.myCommand.toList();
    }

    @NotNull
    public Command getCommandWrapper() {
        return this.myCommand;
    }

    @NotNull
    private static WinSize getInitialSize(@NotNull PtyProcessOptions options) {
        return new WinSize(Objects.requireNonNullElse(options.getInitialColumns(), 80), Objects.requireNonNullElse(options.getInitialRows(), 25));
    }

    private void startAwaitingThread(@NotNull Command command) {
        String commandLine = command.toCommandLine();
        Thread t = new Thread(() -> {
            int result = Kernel32.INSTANCE.WaitForSingleObject(this.processInformation.hProcess, -1);
            int exitCode = -100;
            if (result == 0) {
                IntByReference exitCodeRef = new IntByReference();
                if (!Kernel32.INSTANCE.GetExitCodeProcess(this.processInformation.hProcess, exitCodeRef)) {
                    LOG.info(LastErrorExceptionEx.getErrorMessage("GetExitCodeProcess(" + commandLine + ")"));
                } else {
                    exitCode = exitCodeRef.getValue();
                }
            } else if (result == -1) {
                LOG.info(LastErrorExceptionEx.getErrorMessage("WaitForSingleObject(" + commandLine + ")"));
            } else {
                LOG.info("WaitForSingleObject(" + commandLine + ") returned " + result);
            }
            this.myExitCodeInfo.setExitCode(exitCode);
            this.myInputStream.awaitAvailableOutputIsRead();
            this.cleanup();
        }, "WinConPtyProcess WaitFor " + commandLine);
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void setWinSize(@NotNull WinSize winSize) {
        try {
            this.pseudoConsole.resize(winSize);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    @NotNull
    public WinSize getWinSize() throws IOException {
        return this.pseudoConsole.getWinSize();
    }

    @Override
    public long pid() {
        return this.processInformation.dwProcessId.longValue();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.myOutputStream;
    }

    @Override
    public InputStream getInputStream() {
        return this.myInputStream;
    }

    @Override
    public InputStream getErrorStream() {
        return NullInputStream.INSTANCE;
    }

    @Override
    public int waitFor() throws InterruptedException {
        return this.myExitCodeInfo.waitFor();
    }

    @Override
    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        return this.myExitCodeInfo.waitFor(timeout, unit);
    }

    @Override
    public int exitValue() {
        Integer exitCode = this.myExitCodeInfo.getExitCodeNow();
        if (exitCode != null) {
            return exitCode;
        }
        throw new IllegalThreadStateException("Process is still alive");
    }

    @Override
    public boolean isAlive() {
        return this.myExitCodeInfo.getExitCodeNow() == null;
    }

    @Override
    public boolean supportsNormalTermination() {
        return false;
    }

    @Override
    public void destroy() {
        if (!this.isAlive()) {
            return;
        }
        if (!Kernel32.INSTANCE.TerminateProcess(this.processInformation.hProcess, 1)) {
            LOG.info("Failed to terminate process with pid {}. {}", (Object)this.processInformation.dwProcessId, (Object)LastErrorExceptionEx.getErrorMessage("TerminateProcess"));
        }
    }

    @NotNull
    public String getWorkingDirectory() throws IOException {
        return WinHelper.getCurrentDirectory(this.pid());
    }

    public int getConsoleProcessCount() throws IOException {
        return ConsoleProcessListFetcher.getConsoleProcessCount(this.pid());
    }

    private void cleanup() {
        try {
            ProcessUtils.closeHandles(this.processInformation);
        }
        catch (IOException e) {
            LOG.info("Cannot close handle", (Throwable)e);
        }
        this.pseudoConsole.close();
        try {
            this.myInputStream.close(false);
        }
        catch (IOException e) {
            LOG.info("Cannot close input stream", (Throwable)e);
        }
        try {
            this.myOutputStream.close(false);
        }
        catch (IOException e) {
            LOG.info("Cannot close output stream", (Throwable)e);
        }
    }

    private static class ExitCodeInfo {
        private Integer myExitCode = null;
        private final ReentrantLock myLock = new ReentrantLock();
        private final Condition myCondition = this.myLock.newCondition();

        private ExitCodeInfo() {
        }

        public void setExitCode(int exitCode) {
            this.myLock.lock();
            try {
                this.myExitCode = exitCode;
                this.myCondition.signalAll();
            }
            finally {
                this.myLock.unlock();
            }
        }

        public int waitFor() throws InterruptedException {
            this.myLock.lock();
            try {
                while (this.myExitCode == null) {
                    this.myCondition.await();
                }
                int n = this.myExitCode;
                return n;
            }
            finally {
                this.myLock.unlock();
            }
        }

        Integer getExitCodeNow() {
            this.myLock.lock();
            try {
                Integer n = this.myExitCode;
                return n;
            }
            finally {
                this.myLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
            long startTime = System.nanoTime();
            long remaining = unit.toNanos(timeout);
            this.myLock.lock();
            try {
                while (this.myExitCode == null && remaining > 0L) {
                    this.myCondition.awaitNanos(remaining);
                    remaining = unit.toNanos(timeout) - (System.nanoTime() - startTime);
                }
                boolean bl = this.myExitCode != null;
                return bl;
            }
            finally {
                this.myLock.unlock();
            }
        }
    }
}

