/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows.conpty;

import com.pty4j.windows.conpty.LastErrorExceptionEx;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class WinHandleOutputStream
extends OutputStream {
    private final WinNT.HANDLE myWritePipe;
    private volatile boolean myClosed;
    private volatile boolean myClosedExplicitly;

    public WinHandleOutputStream(@NotNull WinNT.HANDLE writePipe) {
        this.myWritePipe = writePipe;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte @NotNull [] b, int off, int len) throws IOException {
        IntByReference lpNumberOfBytesWritten;
        Objects.checkFromIndexSize(off, len, b.length);
        if (len == 0) {
            return;
        }
        if (this.myClosed) {
            if (this.myClosedExplicitly) {
                throw new IOException("Closed stdout");
            }
            return;
        }
        byte[] buffer = Arrays.copyOfRange(b, off, off + len);
        if (!Kernel32.INSTANCE.WriteFile(this.myWritePipe, buffer, buffer.length, lpNumberOfBytesWritten = new IntByReference(0), null)) {
            throw new LastErrorExceptionEx("WriteFile stdout");
        }
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    void close(boolean explicit) throws IOException {
        if (explicit) {
            this.myClosedExplicitly = true;
        }
        if (!this.myClosed) {
            this.myClosed = true;
            if (!Kernel32.INSTANCE.CloseHandle(this.myWritePipe)) {
                throw new LastErrorExceptionEx("CloseHandle stdout");
            }
        }
    }
}

