/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.qodana.sarif.model.streaming;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.jetbrains.qodana.sarif.SarifUtil;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.streaming.GeneratingIterator;
import com.jetbrains.qodana.sarif.model.streaming.ResultLocation;
import com.jetbrains.qodana.sarif.model.streaming.StreamingUtil;
import java.io.IOException;
import java.io.Reader;

public class ResultIterator
extends GeneratingIterator<Result> {
    private Gson gson = null;
    private final JsonReader resultsReader;
    private final ResultLocation resultLocation;

    public ResultIterator(Reader reader, int runIndexInReport) {
        this(reader, new ResultLocation.InRun(runIndexInReport));
    }

    public ResultIterator(Reader reader, ResultLocation resultLocation) {
        this.resultsReader = new JsonReader(reader);
        this.resultLocation = resultLocation;
    }

    private Gson getGson() {
        if (this.gson == null) {
            this.gson = SarifUtil.createGson();
        }
        return this.gson;
    }

    @Override
    protected Result makeInitial() {
        try {
            if (!this.findResult()) {
                return null;
            }
            this.resultsReader.beginArray();
            return this.tryReadResult(this.resultsReader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Result makeNext(Result prev) {
        return this.tryReadResult(this.resultsReader);
    }

    private Result tryReadResult(JsonReader reader) {
        try {
            if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                return null;
            }
            return (Result)this.getGson().fromJson(reader, Result.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean findResult() throws IOException {
        if (this.resultLocation instanceof ResultLocation.InRun) {
            int runIndex = ((ResultLocation.InRun)this.resultLocation).getRunIndex();
            return this.findRun(runIndex) && StreamingUtil.find(this.resultsReader, "results");
        }
        if (this.resultLocation instanceof ResultLocation.InProperties) {
            int runIndex = ((ResultLocation.InProperties)this.resultLocation).getRunIndex();
            String propertyName = ((ResultLocation.InProperties)this.resultLocation).getPropertyName();
            return this.findRun(runIndex) && StreamingUtil.find(this.resultsReader, "properties") && StreamingUtil.find(this.resultsReader, propertyName);
        }
        throw new UnsupportedOperationException("Unhandled ResultLocation");
    }

    private boolean findRun(int runIndex) throws IOException {
        if (!StreamingUtil.find(this.resultsReader, "runs")) {
            return false;
        }
        this.resultsReader.beginArray();
        StreamingUtil.skipObjects(this.resultsReader, runIndex);
        return true;
    }
}

