/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.description.Description;
import org.assertj.core.error.AssertionErrorMessagesAggregator;
import org.assertj.core.error.DescriptionFormatter;

public class MultipleAssertionsError
extends AssertionError {
    private static final long serialVersionUID = -5547434453993413952L;
    private final List<? extends AssertionError> errors;

    public MultipleAssertionsError(List<? extends AssertionError> errors) {
        super((Object)MultipleAssertionsError.createMessage(errors));
        this.errors = errors;
    }

    public MultipleAssertionsError(Description description, List<? extends AssertionError> errors) {
        super((Object)(MultipleAssertionsError.formatDescription(description) + MultipleAssertionsError.createMessage(errors)));
        this.errors = errors;
    }

    public List<? extends AssertionError> getErrors() {
        return this.errors;
    }

    private static String formatDescription(Description description) {
        return DescriptionFormatter.instance().format(description);
    }

    private static String createMessage(List<? extends AssertionError> errors) {
        List<String> errorsMessage = errors.stream().map(Throwable::getMessage).collect(Collectors.toList());
        return AssertionErrorMessagesAggregator.aggregateErrorMessages(errorsMessage);
    }
}

