/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.Random;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.CheckSession;
import org.jetbrains.jetCheck.DataSerializer;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.ImperativeCommand;
import org.jetbrains.jetCheck.IntSource;
import org.jetbrains.jetCheck.Scenario;
import org.jetbrains.jetCheck.StatusNotifier;

public class PropertyChecker {
    static final int DEFAULT_MAX_SIZE_HINT = 100;

    public static <T> void forAll(Generator<T> generator, @NotNull Predicate<T> property) {
        PropertyChecker.customized().forAll(generator, property);
    }

    public static void checkScenarios(@NotNull Supplier<? extends ImperativeCommand> command) {
        PropertyChecker.customized().checkScenarios(command);
    }

    public static Parameters customized() {
        return new Parameters(new Random().nextLong(), null, iteration -> (iteration - 1) % 100 + 1, null, false, false, false);
    }

    public static class Parameters {
        final long globalSeed;
        @Nullable
        final IntSource serializedData;
        final IntUnaryOperator sizeHintFun;
        @Nullable
        private final Integer iterationCount;
        final boolean silent;
        final boolean printValues;
        final boolean printData;

        Parameters(long globalSeed, @Nullable IntSource serializedData, IntUnaryOperator sizeHintFun, @Nullable Integer iterationCount, boolean silent, boolean printValues, boolean printData) {
            this.globalSeed = globalSeed;
            this.serializedData = serializedData;
            this.sizeHintFun = sizeHintFun;
            this.iterationCount = iterationCount;
            this.silent = silent;
            this.printValues = printValues;
            this.printData = printData;
        }

        @Deprecated
        public Parameters withSeed(long seed) {
            if (this.serializedData != null) {
                System.err.println("withSeed ignored, because 'rechecking' is used");
                return this;
            }
            return new Parameters(seed, this.serializedData, this.sizeHintFun, this.iterationCount, this.silent, this.printValues, this.printData);
        }

        public Parameters withIterationCount(int iterationCount) {
            if (this.serializedData != null) {
                if (!this.silent) {
                    System.err.println("withIterationCount ignored, because 'rechecking' is used");
                }
                return this;
            }
            if (this.iterationCount != null) {
                if (!this.silent) {
                    System.err.println("withIterationCount ignored, because iteration count is already set to " + this.iterationCount);
                }
                return this;
            }
            return this.withForcedIterationCount(iterationCount);
        }

        @NotNull
        private Parameters withForcedIterationCount(int iterationCount) {
            return new Parameters(this.globalSeed, this.serializedData, this.sizeHintFun, iterationCount, this.silent, this.printValues, this.printData);
        }

        public Parameters withSizeHint(@NotNull IntUnaryOperator sizeHintFun) {
            if (this.serializedData != null) {
                System.err.println("withSizeHint ignored, because 'rechecking' is used");
                return this;
            }
            return new Parameters(this.globalSeed, this.serializedData, sizeHintFun, this.iterationCount, this.silent, this.printValues, this.printData);
        }

        public Parameters silent() {
            if (this.printValues) {
                throw new IllegalStateException("'silent' is incompatible with 'printGeneratedValues'");
            }
            if (this.printData) {
                throw new IllegalStateException("'silent' is incompatible with 'printRawData'");
            }
            return new Parameters(this.globalSeed, this.serializedData, this.sizeHintFun, this.iterationCount, true, this.printValues, this.printData);
        }

        public Parameters printGeneratedValues() {
            if (this.silent) {
                throw new IllegalStateException("'printGeneratedValues' is incompatible with 'silent'");
            }
            return new Parameters(this.globalSeed, this.serializedData, this.sizeHintFun, this.iterationCount, this.silent, true, this.printData);
        }

        public Parameters printRawData() {
            if (this.silent) {
                throw new IllegalStateException("'printRawData' is incompatible with 'silent'");
            }
            return new Parameters(this.globalSeed, this.serializedData, this.sizeHintFun, this.iterationCount, this.silent, this.printValues, true);
        }

        @Deprecated
        public Parameters recheckingIteration(long seed, int sizeHint) {
            return this.withForcedIterationCount(1).withSeed(seed).withSizeHint(whatever -> sizeHint);
        }

        @Deprecated
        public Parameters rechecking(@NotNull String serializedData) {
            return DataSerializer.deserializeInto(serializedData, this);
        }

        public <T> void forAll(Generator<T> generator, Predicate<T> property) {
            this.createSession(generator, property).run();
        }

        private <T> CheckSession<T> createSession(Generator<T> generator, Predicate<T> property) {
            return new CheckSession<T>(this.serializedData == null ? generator : generator.noShrink(), property, this);
        }

        public void checkScenarios(@NotNull Supplier<? extends ImperativeCommand> command) {
            StatusNotifier[] notifier = new StatusNotifier[1];
            Generator<Scenario> generator = Scenario.scenarios(command, s -> notifier[0].logEntryReceived((String)s));
            CheckSession<Scenario> session = this.createSession(generator, Scenario::ensureSuccessful);
            notifier[0] = session.notifier;
            session.run();
        }

        int getIterationCount() {
            return this.iterationCount != null ? this.iterationCount : 100;
        }
    }
}

