/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.database.csv.GridCsvBundle;
import com.intellij.openapi.util.NotNullLazyValue;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public interface CsvFormats {
    public static final NotNullLazyValue<CsvFormat> TSV_FORMAT = NotNullLazyValue.lazy(() -> CsvFormats.xsvFormat(GridCsvBundle.message("csv.format.tsv.default.name", new Object[0]), "Tab-separated (TSV)_id", "\t"));
    public static final NotNullLazyValue<CsvFormat> CSV_FORMAT = NotNullLazyValue.lazy(() -> CsvFormats.xsvFormat(GridCsvBundle.message("csv.format.csv.default.name", new Object[0]), "Comma-separated (CSV)_id", ","));
    public static final NotNullLazyValue<CsvFormat> PIPE_SEPARATED_FORMAT = NotNullLazyValue.lazy(() -> CsvFormats.xsvFormat(GridCsvBundle.message("csv.format.pipe.separated.default.name", new Object[0]), "Pipe-separated_id", "|"));
    public static final NotNullLazyValue<CsvFormat> SEMICOLON_SEPARATED_FORMAT = NotNullLazyValue.lazy(() -> CsvFormats.xsvFormat(GridCsvBundle.message("csv.format.semicolon.separated.default.name", new Object[0]), "Semicolon-separated_id", ";"));

    private static CsvFormat xsvFormat(@NotNull String name, @NonNls @NotNull String id, @NotNull String valueSeparator) {
        if (name == null) {
            CsvFormats.$$$reportNull$$$0(0);
        }
        if (id == null) {
            CsvFormats.$$$reportNull$$$0(1);
        }
        if (valueSeparator == null) {
            CsvFormats.$$$reportNull$$$0(2);
        }
        List<CsvRecordFormat.Quotes> quotes = List.of(new CsvRecordFormat.Quotes("\"", "\"", "\"\"", "\"\""), new CsvRecordFormat.Quotes("'", "'", "''", "''"));
        CsvRecordFormat.QuotationPolicy quotationPolicy = CsvRecordFormat.QuotationPolicy.AS_NEEDED;
        CsvRecordFormat dataFormat = new CsvRecordFormat("", "", "", quotes, quotationPolicy, valueSeparator, "\n", false);
        return new CsvFormat(name, dataFormat, null, id, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "id";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "valueSeparator";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/csv/CsvFormats";
        objectArray[2] = "xsvFormat";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

