/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.util;

import org.assertj.core.util.Preconditions;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.util.Arrays;
import org.assertj.swing.util.Strings;
import org.assertj.swing.util.TextMatcher;

public class StringTextMatcher
implements TextMatcher {
    private final String[] values;

    public StringTextMatcher(String ... values) {
        this.values = (String[])Preconditions.checkNotNullOrEmpty((Object[])values);
    }

    @Override
    public boolean isMatching(@Nullable String text) {
        for (String value : this.values) {
            if (!Strings.areEqualOrMatch(value, text)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public String description() {
        return this.onlyOneValue() ? "value" : "values";
    }

    @Override
    @Nonnull
    public String formattedValues() {
        String s = this.onlyOneValue() ? org.assertj.core.util.Strings.quote((String)this.values[0]) : Arrays.format(this.values);
        return (String)Preconditions.checkNotNull((Object)s);
    }

    private boolean onlyOneValue() {
        return this.values.length == 1;
    }
}

