/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.editor;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.json.editor.JsonEditorOptions;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        if (!JsonEditorOptions.getInstance().ESCAPE_PASTED_TEXT) {
            return null;
        }
        if (!JsonCopyPasteProcessor.isSupportedFile(file) || startOffsets.length > 1 || endOffsets.length > 1) {
            return null;
        }
        int selectionStart = startOffsets[0];
        int selectionEnd = endOffsets[0];
        JsonStringLiteral literalExpression = JsonCopyPasteProcessor.getSingleElementFromSelectionOrNull(file, selectionStart, selectionEnd);
        if (literalExpression == null) {
            return null;
        }
        return StringUtil.unescapeStringCharacters((String)StringUtil.replaceUnicodeEscapeSequences((String)text));
    }

    @Nullable
    private static JsonStringLiteral getSingleElementFromSelectionOrNull(PsiFile file, int start, int end) {
        PsiElement element = file.findElementAt(start);
        JsonStringLiteral literalExpression = (JsonStringLiteral)PsiTreeUtil.getParentOfType((PsiElement)element, JsonStringLiteral.class);
        if (literalExpression == null) {
            return null;
        }
        TextRange textRange = literalExpression.getTextRange();
        if (start <= textRange.getStartOffset() || end >= textRange.getEndOffset()) {
            return null;
        }
        String text = literalExpression.getText();
        if (!text.startsWith("\"") || !text.endsWith("\"")) {
            return null;
        }
        return literalExpression;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        int selectionEnd;
        if (!JsonEditorOptions.getInstance().ESCAPE_PASTED_TEXT) {
            String string = text;
            if (string == null) {
                JsonCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (!JsonCopyPasteProcessor.isSupportedFile(file)) {
            String string = text;
            if (string == null) {
                JsonCopyPasteProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        JsonStringLiteral literalExpression = JsonCopyPasteProcessor.getSingleElementFromSelectionOrNull(file, selectionStart, selectionEnd = selectionModel.getSelectionEnd());
        if (literalExpression == null) {
            String string = text;
            if (string == null) {
                JsonCopyPasteProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = StringUtil.escapeStringCharacters((String)text);
        if (string == null) {
            JsonCopyPasteProcessor.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static boolean isSupportedFile(PsiFile file) {
        return file instanceof JsonFile && file.isPhysical();
    }

    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            JsonCopyPasteProcessor.$$$reportNull$$$0(4);
        }
        if (project == null) {
            JsonCopyPasteProcessor.$$$reportNull$$$0(5);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/editor/JsonCopyPasteProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/editor/JsonCopyPasteProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "requiresAllDocumentsToBeCommitted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

