/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.format;

import java.math.BigInteger;
import java.util.Formattable;
import java.util.Formatter;
import javax.measure.UnitConverter;
import tech.units.indriya.AbstractConverter;
import tech.units.indriya.format.SymbolMap;
import tech.units.indriya.function.AddConverter;
import tech.units.indriya.function.ExpConverter;
import tech.units.indriya.function.LogConverter;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.function.PowersOfIntConverter;
import tech.units.indriya.function.RationalConverter;
import tech.units.indriya.unit.Prefix;

class ConverterFormatter {
    private static final String LOCAL_FORMAT_PATTERN = "%s";

    ConverterFormatter() {
    }

    static int formatConverter(UnitConverter converter, boolean continued, int unitPrecedence, StringBuilder buffer, SymbolMap symbolMap) {
        Prefix prefix = symbolMap.getPrefix((PowersOfIntConverter)converter);
        if (prefix != null && unitPrecedence == Integer.MAX_VALUE) {
            return ConverterFormatter.noopPrecedence(buffer, symbolMap, prefix);
        }
        if (converter instanceof AddConverter) {
            return ConverterFormatter.additionPrecedence((AddConverter)converter, continued, unitPrecedence, buffer);
        }
        if (converter instanceof LogConverter) {
            return ConverterFormatter.exponentPrecedenceLogConveter((LogConverter)converter, buffer);
        }
        if (converter instanceof ExpConverter) {
            return ConverterFormatter.exponentPrecedenceExpConveter((ExpConverter)converter, unitPrecedence, buffer);
        }
        if (converter instanceof MultiplyConverter) {
            return ConverterFormatter.productPrecedence((MultiplyConverter)converter, continued, unitPrecedence, buffer);
        }
        if (converter instanceof RationalConverter) {
            return ConverterFormatter.productPrecedence((RationalConverter)converter, continued, unitPrecedence, buffer);
        }
        if (converter instanceof PowersOfIntConverter) {
            return ConverterFormatter.productPrecedence((PowersOfIntConverter)converter, continued, unitPrecedence, buffer);
        }
        if (converter instanceof AbstractConverter.Pair) {
            AbstractConverter.Pair compound = (AbstractConverter.Pair)converter;
            if (compound.getLeft() == AbstractConverter.IDENTITY) {
                return ConverterFormatter.formatConverter(compound.getRight(), true, unitPrecedence, buffer, symbolMap);
            }
            if (compound.getLeft() instanceof Formattable) {
                return ConverterFormatter.formatFormattable((Formattable)compound.getLeft(), unitPrecedence, buffer);
            }
            if (compound.getRight() instanceof Formattable) {
                return ConverterFormatter.formatFormattable((Formattable)compound.getRight(), unitPrecedence, buffer);
            }
            return ConverterFormatter.formatConverter(compound.getLeft(), true, unitPrecedence, buffer, symbolMap);
        }
        if (converter != null) {
            buffer.replace(0, 1, converter.toString());
            return Integer.MAX_VALUE;
        }
        throw new IllegalArgumentException("Unable to format, no UnitConverter given");
    }

    private static int productPrecedence(PowersOfIntConverter converter, boolean continued, int unitPrecedence, StringBuilder buffer) {
        PowersOfIntConverter powerConverter;
        if (unitPrecedence < 2) {
            buffer.insert(0, '(');
            buffer.append(')');
        }
        if (!(powerConverter = converter).isIdentity()) {
            if (continued) {
                buffer.append('\u00b7');
            }
            buffer.append(powerConverter.getBase()).append("^").append(powerConverter.getExponent());
        }
        return 2;
    }

    private static int productPrecedence(RationalConverter converter, boolean continued, int unitPrecedence, StringBuilder buffer) {
        RationalConverter rationalConverter;
        if (unitPrecedence < 2) {
            buffer.insert(0, '(');
            buffer.append(')');
        }
        if ((rationalConverter = converter).getDividend() != BigInteger.ONE) {
            if (continued) {
                buffer.append('\u00b7');
            }
            buffer.append(rationalConverter.getDividend());
        }
        if (rationalConverter.getDivisor() != BigInteger.ONE) {
            buffer.append('/');
            buffer.append(rationalConverter.getDivisor());
        }
        return 2;
    }

    private static int productPrecedence(MultiplyConverter converter, boolean continued, int unitPrecedence, StringBuilder buffer) {
        double factor;
        long lFactor;
        if (unitPrecedence < 2) {
            buffer.insert(0, '(');
            buffer.append(')');
        }
        if (continued) {
            buffer.append('\u00b7');
        }
        if ((double)(lFactor = (long)(factor = converter.getFactor())) == factor) {
            buffer.append(lFactor);
        } else {
            buffer.append(factor);
        }
        return 2;
    }

    private static int exponentPrecedenceExpConveter(ExpConverter converter, int unitPrecedence, StringBuilder buffer) {
        if (unitPrecedence < 4) {
            buffer.insert(0, '(');
            buffer.append(')');
        }
        StringBuilder expr = new StringBuilder();
        double base = converter.getBase();
        if (base == Math.E) {
            expr.append('e');
        } else {
            expr.append((int)base);
        }
        expr.append('^');
        buffer.insert(0, expr);
        return 4;
    }

    private static int exponentPrecedenceLogConveter(LogConverter converter, StringBuilder buffer) {
        double base = converter.getBase();
        StringBuilder expr = new StringBuilder();
        if (base == Math.E) {
            expr.append("ln");
        } else {
            expr.append("log");
            if (base != 10.0) {
                expr.append((int)base);
            }
        }
        expr.append("(");
        buffer.insert(0, expr);
        buffer.append(")");
        return 4;
    }

    private static int additionPrecedence(AddConverter converter, boolean continued, int unitPrecedence, StringBuilder buffer) {
        double offset;
        if (unitPrecedence < 0) {
            buffer.insert(0, '(');
            buffer.append(')');
        }
        if ((offset = converter.getOffset()) < 0.0) {
            buffer.append("-");
            offset = -offset;
        } else if (continued) {
            buffer.append("+");
        }
        long lOffset = (long)offset;
        if ((double)lOffset == offset) {
            buffer.append(lOffset);
        } else {
            buffer.append(offset);
        }
        return 0;
    }

    private static int noopPrecedence(StringBuilder buffer, SymbolMap symbolMap, Prefix prefix) {
        buffer.insert(0, symbolMap.getSymbol(prefix));
        return Integer.MAX_VALUE;
    }

    private static int formatFormattable(Formattable f, int unitPrecedence, StringBuilder buffer) {
        Formatter fmt = new Formatter();
        fmt.format(LOCAL_FORMAT_PATTERN, f);
        buffer.replace(0, 1, fmt.toString());
        fmt.close();
        return unitPrecedence;
    }
}

