/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Objects;
import java.util.logging.Logger;

public final class Calculus {
    private static final String MSG_NUMBER_NON_NULL = "number cannot be null";
    private static final Logger logger = Logger.getLogger(Calculus.class.getName());
    public static final MathContext DEFAULT_MATH_CONTEXT;
    public static MathContext MATH_CONTEXT;

    public static BigDecimal toBigDecimal(Number number) {
        Objects.requireNonNull(number, MSG_NUMBER_NON_NULL);
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        if (number instanceof Double) {
            return BigDecimal.valueOf(number.doubleValue());
        }
        logger.fine(() -> String.format("WARNING: possibly loosing precision, when converting from Number type '%s' to double.", number.getClass().getName()));
        return BigDecimal.valueOf(number.doubleValue());
    }

    public static BigInteger toBigInteger(Number number) {
        Objects.requireNonNull(number, MSG_NUMBER_NON_NULL);
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof BigDecimal) {
            try {
                return ((BigDecimal)number).toBigIntegerExact();
            }
            catch (ArithmeticException e) {
                logger.fine(() -> String.format("WARNING: loosing precision, when converting from BigDecimal to BigInteger.", number.getClass().getName()));
                return ((BigDecimal)number).toBigInteger();
            }
        }
        if (number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte) {
            return BigInteger.valueOf(number.longValue());
        }
        logger.fine(() -> String.format("WARNING: possibly loosing precision, when converting from Number type '%s' to long.", number.getClass().getName()));
        return BigInteger.valueOf(number.longValue());
    }

    public static Number abs(Number number) {
        Objects.requireNonNull(number, MSG_NUMBER_NON_NULL);
        if (number instanceof BigInteger) {
            return ((BigInteger)number).abs();
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).abs();
        }
        if (number instanceof Double) {
            return Math.abs((Double)number);
        }
        if (number instanceof Long) {
            return Math.abs((Long)number);
        }
        if (number instanceof Integer) {
            return Math.abs((Integer)number);
        }
        if (number instanceof Short) {
            return Math.abs(((Short)number).shortValue());
        }
        if (number instanceof Byte) {
            return Math.abs(((Byte)number).byteValue());
        }
        logger.fine(() -> String.format("WARNING: possibly loosing precision, when converting from Number type '%s' to double.", number.getClass().getName()));
        return Math.abs(number.doubleValue());
    }

    public static Number negate(Number number) {
        Objects.requireNonNull(number, MSG_NUMBER_NON_NULL);
        if (number instanceof BigInteger) {
            return ((BigInteger)number).negate();
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).negate();
        }
        if (number instanceof Double) {
            return -((Double)number).doubleValue();
        }
        if (number instanceof Long) {
            return -((Long)number).longValue();
        }
        if (number instanceof Integer) {
            return -((Integer)number).intValue();
        }
        if (number instanceof Short) {
            return (int)(-((Short)number).shortValue());
        }
        if (number instanceof Byte) {
            return (int)(-((Byte)number).byteValue());
        }
        logger.fine(() -> String.format("WARNING: possibly loosing precision, when converting from Number type '%s' to double.", number.getClass().getName()));
        return -number.doubleValue();
    }

    public static boolean isLessThanOne(Number number) {
        Objects.requireNonNull(number, MSG_NUMBER_NON_NULL);
        if (number instanceof BigInteger) {
            return ((BigInteger)number).compareTo(BigInteger.ONE) == -1;
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).compareTo(BigDecimal.ONE) == -1;
        }
        if (number instanceof Double) {
            return (Double)number < 1.0;
        }
        if (number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte) {
            return number.longValue() < 1L;
        }
        logger.fine(() -> String.format("WARNING: possibly loosing precision, when converting from Number type '%s' to double.", number.getClass().getName()));
        return number.doubleValue() < 1.0;
    }

    static {
        MATH_CONTEXT = DEFAULT_MATH_CONTEXT = MathContext.DECIMAL128;
    }
}

