/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.model.ClientData;
import com.intellij.packageChecker.model.GeneralRepositoryServer;
import com.intellij.packageChecker.model.GeneralRepositoryServerKt;
import com.intellij.packageChecker.model.HttpClientApi;
import com.intellij.packageChecker.model.HttpClientHeadersService;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.ResourceUrl;
import com.intellij.packageChecker.model.dto.HashesDto;
import com.intellij.packageChecker.model.dto.RequestDto;
import com.intellij.packageChecker.model.exceptions.AnalysisException;
import com.intellij.packageChecker.util.GzipUtils;
import com.intellij.packageChecker.util.SerializationUtils;
import com.intellij.util.LineSeparator;
import java.io.IOException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJx\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u001e\"\u0004\b\u0000\u0010\u001f\"\u0004\b\u0001\u0010 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0012\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0\u001e0'2\u0018\u0010(\u001a\u0014\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002H\u001f0)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u0002H\u001f0+H\u0084@\u00a2\u0006\u0002\u0010,J\u0016\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020%0\u001eH\u0002J>\u00100\u001a\b\u0012\u0004\u0012\u0002H 0\u001e\"\u0004\b\u0000\u0010 2\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020.2\u0012\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0\u001e0'H\u0082@\u00a2\u0006\u0002\u00103R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\u00020\u00158DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u001a\u001a\u00020\u00158DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0019\u001a\u0004\b\u001b\u0010\u0017\u00a8\u00064"}, d2={"Lcom/intellij/packageChecker/model/GeneralRepositoryServer;", "", "clientData", "Lcom/intellij/packageChecker/model/ClientData;", "packagesUrlString", "", "dbBaseUrl", "Lcom/intellij/packageChecker/model/ResourceUrl;", "attemptsToCheck", "", "requestTimeout", "Ljava/time/Duration;", "<init>", "(Lcom/intellij/packageChecker/model/ClientData;Ljava/lang/String;Lcom/intellij/packageChecker/model/ResourceUrl;ILjava/time/Duration;)V", "chunkSize", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "httpClient", "Lcom/intellij/packageChecker/model/HttpClientApi;", "getHttpClient", "()Lcom/intellij/packageChecker/model/HttpClientApi;", "httpClient$delegate", "Lkotlin/Lazy;", "gzipHttpClient", "getGzipHttpClient", "gzipHttpClient$delegate", "getStatusForPackages", "", "T", "DTO", "project", "Lcom/intellij/openapi/project/Project;", "pkgs", "", "Lcom/intellij/packageChecker/model/Package;", "bodyHandler", "Ljava/net/http/HttpResponse$BodyHandler;", "transform", "Lkotlin/Function2;", "allAttemptsFailed", "Lkotlin/Function1;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Iterable;Ljava/net/http/HttpResponse$BodyHandler;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createRequestDto", "Lcom/intellij/packageChecker/model/dto/RequestDto;", "packageChunk", "getPackagesFromServer", "url", "requestData", "(Ljava/lang/String;Lcom/intellij/packageChecker/model/dto/RequestDto;Ljava/net/http/HttpResponse$BodyHandler;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nGeneralRepositoryServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneralRepositoryServer.kt\ncom/intellij/packageChecker/model/GeneralRepositoryServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n*L\n1#1,108:1\n1374#2:109\n1460#2,2:110\n1563#2:113\n1634#2,3:114\n1563#2:117\n1634#2,3:118\n1462#2,3:121\n1563#2:124\n1634#2,3:125\n374#3:112\n*S KotlinDebug\n*F\n+ 1 GeneralRepositoryServer.kt\ncom/intellij/packageChecker/model/GeneralRepositoryServer\n*L\n53#1:109\n53#1:110,2\n62#1:113\n62#1:114,3\n85#1:117\n85#1:118,3\n53#1:121,3\n90#1:124\n90#1:125,3\n54#1:112\n*E\n"})
public class GeneralRepositoryServer {
    @NotNull
    private final ClientData clientData;
    @NotNull
    private final String packagesUrlString;
    @NotNull
    private final ResourceUrl dbBaseUrl;
    private final int attemptsToCheck;
    @NotNull
    private final Duration requestTimeout;
    private final int chunkSize;
    private final ObjectMapper objectMapper;
    @NotNull
    private final Lazy httpClient$delegate;
    @NotNull
    private final Lazy gzipHttpClient$delegate;

    public GeneralRepositoryServer(@NotNull ClientData clientData, @NotNull String packagesUrlString, @NotNull ResourceUrl dbBaseUrl, int attemptsToCheck, @NotNull Duration requestTimeout) {
        Intrinsics.checkNotNullParameter((Object)clientData, (String)"clientData");
        Intrinsics.checkNotNullParameter((Object)packagesUrlString, (String)"packagesUrlString");
        Intrinsics.checkNotNullParameter((Object)dbBaseUrl, (String)"dbBaseUrl");
        Intrinsics.checkNotNullParameter((Object)requestTimeout, (String)"requestTimeout");
        this.clientData = clientData;
        this.packagesUrlString = packagesUrlString;
        this.dbBaseUrl = dbBaseUrl;
        this.attemptsToCheck = attemptsToCheck;
        this.requestTimeout = requestTimeout;
        this.chunkSize = 4096;
        this.objectMapper = SerializationUtils.INSTANCE.getOm();
        this.httpClient$delegate = LazyKt.lazy(() -> GeneralRepositoryServer.httpClient_delegate$lambda$0(this));
        this.gzipHttpClient$delegate = LazyKt.lazy(() -> GeneralRepositoryServer.gzipHttpClient_delegate$lambda$1(this));
    }

    public /* synthetic */ GeneralRepositoryServer(ClientData clientData, String string, ResourceUrl resourceUrl, int n, Duration duration, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 3;
        }
        if ((n2 & 0x10) != 0) {
            Duration duration2 = Duration.ofMinutes(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
            duration = duration2;
        }
        this(clientData, string, resourceUrl, n, duration);
    }

    protected final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @NotNull
    protected final HttpClientApi getHttpClient() {
        Lazy lazy = this.httpClient$delegate;
        return (HttpClientApi)lazy.getValue();
    }

    @NotNull
    protected final HttpClientApi getGzipHttpClient() {
        Lazy lazy = this.gzipHttpClient$delegate;
        return (HttpClientApi)lazy.getValue();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected final <T, DTO> Object getStatusForPackages(@NotNull Project project, @NotNull Iterable<Package> pkgs, @NotNull HttpResponse.BodyHandler<List<DTO>> bodyHandler, @NotNull Function2<? super DTO, ? super Project, ? extends T> transform, @NotNull Function1<? super Package, ? extends T> allAttemptsFailed, @NotNull Continuation<? super List<? extends T>> $completion) {
        block20: {
            block19: {
                if (!($completion instanceof getStatusForPackages.1)) ** GOTO lbl-1000
                var30_7 = $completion;
                if ((var30_7.label & -2147483648) != 0) {
                    var30_7.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        Object L$5;
                        Object L$6;
                        Object L$7;
                        Object L$8;
                        Object L$9;
                        Object L$10;
                        Object L$11;
                        int I$0;
                        int I$1;
                        int I$2;
                        int I$3;
                        /* synthetic */ Object result;
                        final /* synthetic */ GeneralRepositoryServer this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.getStatusForPackages(null, null, null, null, null, (Continuation)this);
                        }
                    };
                }
                $result = $continuation.result;
                var31_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block2 : switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!(this.attemptsToCheck > 0)) {
                            var8_10 = "Failed requirement.";
                            throw new IllegalArgumentException(var8_10.toString());
                        }
                        $this$flatMap$iv = CollectionsKt.chunked(pkgs, (int)this.chunkSize);
                        $i$f$flatMap = 0;
                        var9_13 = $this$flatMap$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$flatMapTo = 0;
                        var12_16 = $this$flatMapTo$iv$iv.iterator();
lbl21:
                        // 2 sources

                        while (var12_16.hasNext()) {
                            element$iv$iv = var12_16.next();
                            pkgChunk = (List)element$iv$iv;
                            $i$a$-flatMap-GeneralRepositoryServer$getStatusForPackages$2 = 0;
                            var16_21 = $continuation;
                            $i$f$currentCoroutineContext = false;
                            JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                            attempt = 0;
                            exception = null;
lbl32:
                            // 3 sources

                            while (attempt < this.attemptsToCheck) {
                                ++attempt;
                                if (pkgChunk.isEmpty()) {
                                    v0 = CollectionsKt.emptyList();
                                    break block19;
                                }
                                $continuation.L$0 = project;
                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)pkgs);
                                $continuation.L$2 = bodyHandler;
                                $continuation.L$3 = transform;
                                $continuation.L$4 = allAttemptsFailed;
                                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)$this$flatMap$iv);
                                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)$this$flatMapTo$iv$iv);
                                $continuation.L$7 = destination$iv$iv;
                                $continuation.L$8 = var12_16;
                                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)element$iv$iv);
                                $continuation.L$10 = pkgChunk;
                                $continuation.L$11 = exception;
                                $continuation.I$0 = $i$f$flatMap;
                                $continuation.I$1 = $i$f$flatMapTo;
                                $continuation.I$2 = $i$a$-flatMap-GeneralRepositoryServer$getStatusForPackages$2;
                                $continuation.I$3 = attempt;
                                $continuation.label = 1;
                                v1 = this.getPackagesFromServer(this.dbBaseUrl.url + this.packagesUrlString, this.createRequestDto(pkgChunk), bodyHandler, (Continuation<? super List<? extends DTO>>)$continuation);
                                ** if (v1 != var31_9) goto lbl59
lbl58:
                                // 1 sources

                                return var31_9;
lbl59:
                                // 1 sources

                                ** GOTO lbl83
                            }
                            break block2;
                        }
                        break block20;
                    }
                    case 1: {
                        attempt = $continuation.I$3;
                        $i$a$-flatMap-GeneralRepositoryServer$getStatusForPackages$2 = $continuation.I$2;
                        $i$f$flatMapTo = $continuation.I$1;
                        $i$f$flatMap = $continuation.I$0;
                        exception = (AnalysisException)$continuation.L$11;
                        pkgChunk = (List)$continuation.L$10;
                        element$iv$iv = $continuation.L$9;
                        var12_16 = (Iterator)$continuation.L$8;
                        destination$iv$iv = (Collection)$continuation.L$7;
                        $this$flatMapTo$iv$iv = (Iterable)$continuation.L$6;
                        $this$flatMap$iv = (Iterable)$continuation.L$5;
                        allAttemptsFailed = (Function1)$continuation.L$4;
                        transform = (Function2)$continuation.L$3;
                        bodyHandler = (HttpResponse.BodyHandler)$continuation.L$2;
                        pkgs = (Iterable)$continuation.L$1;
                        project = (Project)$continuation.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl83:
                            // 2 sources

                            $this$map$iv = (Iterable)v1;
                            $i$f$map = false;
                            var20_29 = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            var23_32 = $this$mapTo$iv$iv.iterator();
                            while (var23_32.hasNext()) {
                                var25_34 = item$iv$iv = var23_32.next();
                                var26_35 = destination$iv$iv;
                                $i$a$-map-GeneralRepositoryServer$getStatusForPackages$2$1 = false;
                                var26_35.add(transform.invoke((Object)dto, (Object)project));
                            }
                            v0 = (List)destination$iv$iv;
                            break block19;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            message = "Failed to check dependencies on server: " + this.dbBaseUrl.url;
                            $this$mapTo$iv$iv = e;
                            if ($this$mapTo$iv$iv instanceof IOException || $this$mapTo$iv$iv instanceof IllegalArgumentException || $this$mapTo$iv$iv instanceof AnalysisException) {
                                GeneralRepositoryServerKt.access$getLogger$p().warn(message);
                                GeneralRepositoryServerKt.access$getLogger$p().debug((Throwable)e);
                                exception = e instanceof AnalysisException != false ? (AnalysisException)e : new AnalysisException(message);
                            }
                            $continuation.L$0 = project;
                            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)pkgs);
                            $continuation.L$2 = bodyHandler;
                            $continuation.L$3 = transform;
                            $continuation.L$4 = allAttemptsFailed;
                            $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)$this$flatMap$iv);
                            $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)$this$flatMapTo$iv$iv);
                            $continuation.L$7 = destination$iv$iv;
                            $continuation.L$8 = var12_16;
                            $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)element$iv$iv);
                            $continuation.L$10 = pkgChunk;
                            $continuation.L$11 = exception;
                            $continuation.I$0 = $i$f$flatMap;
                            $continuation.I$1 = $i$f$flatMapTo;
                            $continuation.I$2 = $i$a$-flatMap-GeneralRepositoryServer$getStatusForPackages$2;
                            $continuation.I$3 = attempt;
                            $continuation.label = 2;
                            v2 = DelayKt.delay((long)(attempt * 200), $continuation);
                            if (v2 != var31_9) ** GOTO lbl32
                            return var31_9;
                        }
                    }
                    case 2: {
                        attempt = $continuation.I$3;
                        $i$a$-flatMap-GeneralRepositoryServer$getStatusForPackages$2 = $continuation.I$2;
                        $i$f$flatMapTo = $continuation.I$1;
                        $i$f$flatMap = $continuation.I$0;
                        exception = (AnalysisException)$continuation.L$11;
                        pkgChunk = (List)$continuation.L$10;
                        element$iv$iv = $continuation.L$9;
                        var12_16 = (Iterator)$continuation.L$8;
                        destination$iv$iv = (Collection)$continuation.L$7;
                        $this$flatMapTo$iv$iv = (Iterable)$continuation.L$6;
                        $this$flatMap$iv = (Iterable)$continuation.L$5;
                        allAttemptsFailed = (Function1)$continuation.L$4;
                        transform = (Function2)$continuation.L$3;
                        bodyHandler = (HttpResponse.BodyHandler)$continuation.L$2;
                        pkgs = (Iterable)$continuation.L$1;
                        project = (Project)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        ** GOTO lbl32
                    }
                }
                if (exception != null) {
                    v3 = GeneralRepositoryServerKt.access$getLogger$p();
                    v4 = exception.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getStackTrace(...)");
                    v5 = v4;
                    v6 = LineSeparator.getSystemLineSeparator().getSeparatorString();
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getSeparatorString(...)");
                    v3.warn(ArraysKt.joinToString$default((Object[])v5, (CharSequence)v6, null, null, (int)0, null, null, (int)62, null));
                }
                $this$map$iv = pkgChunk;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var23_32 = $this$mapTo$iv$iv.iterator();
                while (var23_32.hasNext()) {
                    item$iv$iv = var23_32.next();
                    dto = (Package)item$iv$iv;
                    var26_35 = destination$iv$iv;
                    $i$a$-map-GeneralRepositoryServer$getStatusForPackages$2$2 = false;
                    var26_35.add(allAttemptsFailed.invoke((Object)it));
                }
                v0 = (List)destination$iv$iv;
            }
            list$iv$iv = v0;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            ** GOTO lbl21
        }
        return (List)destination$iv$iv;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final RequestDto createRequestDto(List<Package> packageChunk) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = packageChunk;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Package package_ = (Package)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSearchKey());
        }
        List packageDTOs = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        return new HashesDto(packageDTOs, this.clientData.getAnonymousToken(), this.clientData.getApplicationMode());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final <DTO> Object getPackagesFromServer(String url, RequestDto requestData, HttpResponse.BodyHandler<List<DTO>> bodyHandler, Continuation<? super List<? extends DTO>> $completion) {
        if (!($completion instanceof getPackagesFromServer.1)) ** GOTO lbl-1000
        var8_5 = $completion;
        if ((var8_5.label & -2147483648) != 0) {
            var8_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ GeneralRepositoryServer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GeneralRepositoryServer.access$getPackagesFromServer(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                requestDataJson = this.objectMapper.writeValueAsBytes((Object)requestData);
                v0 = this.getGzipHttpClient();
                Intrinsics.checkNotNull((Object)requestDataJson);
                v1 = HttpRequest.BodyPublishers.ofByteArray(GzipUtils.INSTANCE.compressToGzip(requestDataJson));
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"ofByteArray(...)");
                $continuation.L$0 = url;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)requestData);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)bodyHandler);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)requestDataJson);
                $continuation.label = 1;
                v2 = v0.post(url, v1, bodyHandler, $continuation);
                ** if (v2 != var9_7) goto lbl27
lbl26:
                // 1 sources

                return var9_7;
lbl27:
                // 1 sources

                ** GOTO lbl37
            }
            case 1: {
                requestDataJson = (byte[])$continuation.L$3;
                bodyHandler = (HttpResponse.BodyHandler)$continuation.L$2;
                requestData = (RequestDto)$continuation.L$1;
                url = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl37:
                    // 2 sources

                    var5_11 /* !! */  = ((HttpResponse)v2).body();
                    Intrinsics.checkNotNull(var5_11 /* !! */ );
                    var5_11 /* !! */  = (List)var5_11 /* !! */ ;
                }
                catch (Exception <unused var>) {
                    throw new AnalysisException("Failed to check dependencies on server: " + url);
                }
                return var5_11 /* !! */ ;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final HttpClientApi httpClient_delegate$lambda$0(GeneralRepositoryServer this$0) {
        return new HttpClientApi(HttpClientHeadersService.Companion.getInstance().getHeaderParams(), this$0.requestTimeout);
    }

    private static final HttpClientApi gzipHttpClient_delegate$lambda$1(GeneralRepositoryServer this$0) {
        return new HttpClientApi(HttpClientHeadersService.Companion.getInstance().getGzipHeadersParam(), this$0.requestTimeout);
    }

    public static final /* synthetic */ Object access$getPackagesFromServer(GeneralRepositoryServer $this, String url, RequestDto requestData, HttpResponse.BodyHandler bodyHandler2, Continuation $completion) {
        return $this.getPackagesFromServer(url, requestData, bodyHandler2, $completion);
    }
}

