/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.controllers;

import com.intellij.ide.startup.importSettings.controllers.TransferSettingsController;
import com.intellij.ide.startup.importSettings.controllers.TransferSettingsListener;
import com.intellij.ide.startup.importSettings.fus.TransferSettingsCollector;
import com.intellij.ide.startup.importSettings.models.BaseIdeVersion;
import com.intellij.ide.startup.importSettings.models.FailedIdeVersion;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.TransferSettingsPerformContext;
import com.intellij.ide.startup.importSettings.providers.TransferSettingsPerformImportTask;
import com.intellij.ide.startup.importSettings.transfer.backend.models.IdeVersion;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.DefaultImportPerformer;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ide/startup/importSettings/controllers/TransferSettingsControllerImpl;", "Lcom/intellij/ide/startup/importSettings/controllers/TransferSettingsController;", "<init>", "()V", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/ide/startup/importSettings/controllers/TransferSettingsListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "previouslySelected", "Lcom/intellij/ide/startup/importSettings/models/BaseIdeVersion;", "timesSwitchedBetweenInstances", "", "updateCheckboxes", "", "ideVersion", "Lcom/intellij/ide/startup/importSettings/transfer/backend/models/IdeVersion;", "performImport", "project", "Lcom/intellij/openapi/project/Project;", "pi", "Lcom/intellij/openapi/progress/ProgressIndicator;", "performReload", "Lcom/intellij/ide/startup/importSettings/models/FailedIdeVersion;", "addListener", "listener", "itemSelected", "getImportPerformer", "Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/DefaultImportPerformer;", "intellij.ide.startup.importSettings"})
public final class TransferSettingsControllerImpl
implements TransferSettingsController {
    @NotNull
    private final EventDispatcher<TransferSettingsListener> eventDispatcher;
    @Nullable
    private BaseIdeVersion previouslySelected;
    private int timesSwitchedBetweenInstances;

    public TransferSettingsControllerImpl() {
        EventDispatcher eventDispatcher = EventDispatcher.create(TransferSettingsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        this.timesSwitchedBetweenInstances = -1;
    }

    @Override
    public void updateCheckboxes(@NotNull IdeVersion ideVersion) {
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        ((TransferSettingsListener)this.eventDispatcher.getMulticaster()).checkboxesUpdated(ideVersion);
    }

    @Override
    public void performImport(@Nullable Project project, @NotNull IdeVersion ideVersion, @NotNull ProgressIndicator pi) {
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
        TransferSettingsCollector.INSTANCE.logImportStarted(ideVersion.getSettingsCache(), this.timesSwitchedBetweenInstances);
        ((TransferSettingsListener)this.eventDispatcher.getMulticaster()).importStarted(ideVersion, ideVersion.getSettingsCache());
        DefaultImportPerformer performer = this.getImportPerformer();
        TransferSettingsPerformContext context = new TransferSettingsPerformContext(null, 1, null);
        Settings settings = ideVersion.getSettingsCache();
        TransferSettingsPerformImportTask task2 = new TransferSettingsPerformImportTask(project, performer, context, ideVersion, this, settings){
            final /* synthetic */ TransferSettingsPerformContext $context;
            final /* synthetic */ IdeVersion $ideVersion;
            final /* synthetic */ TransferSettingsControllerImpl this$0;
            {
                this.$context = $context;
                this.$ideVersion = $ideVersion;
                this.this$0 = $receiver;
                super($project, $performer, $super_call_param$1, true, $context);
            }

            public void onSuccess() {
                TransferSettingsCollector.INSTANCE.logImportSucceeded(this.$ideVersion, this.$ideVersion.getSettingsCache());
                ((TransferSettingsListener)TransferSettingsControllerImpl.access$getEventDispatcher$p(this.this$0).getMulticaster()).importPerformed(this.$ideVersion, this.$ideVersion.getSettingsCache(), this.$context);
            }

            public void onThrowable(Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                TransferSettingsCollector.INSTANCE.logImportFailed(this.$ideVersion);
                ((TransferSettingsListener)TransferSettingsControllerImpl.access$getEventDispatcher$p(this.this$0).getMulticaster()).importFailed(this.$ideVersion, this.$ideVersion.getSettingsCache(), error);
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task2, pi);
    }

    @Override
    public void performReload(@NotNull FailedIdeVersion ideVersion, @NotNull ProgressIndicator pi) {
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
        ((TransferSettingsListener)this.eventDispatcher.getMulticaster()).reloadPerformed(ideVersion);
    }

    @Override
    public void addListener(@NotNull TransferSettingsListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        BaseIdeVersion ps = this.previouslySelected;
        if (ps != null) {
            listener.itemSelected(ps);
        }
        this.eventDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void itemSelected(@NotNull BaseIdeVersion ideVersion) {
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        ((TransferSettingsListener)this.eventDispatcher.getMulticaster()).itemSelected(ideVersion);
        this.previouslySelected = ideVersion;
        int n = this.timesSwitchedBetweenInstances;
        this.timesSwitchedBetweenInstances = n + 1;
    }

    @Override
    @NotNull
    public DefaultImportPerformer getImportPerformer() {
        return new DefaultImportPerformer();
    }

    public static final /* synthetic */ EventDispatcher access$getEventDispatcher$p(TransferSettingsControllerImpl $this) {
        return $this.eventDispatcher;
    }
}

