/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.breadcrumbs;

import com.intellij.editorconfig.common.syntax.EditorConfigLanguage;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigPsiFile;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.EditorConfigRegistry;
import org.editorconfig.language.util.EditorConfigPresentationUtil;
import org.editorconfig.language.util.EditorConfigPsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\f\u001a\u00020\rH\u0016R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/editorconfig/language/breadcrumbs/EditorConfigBreadcrumbsProvider;", "Lcom/intellij/ui/breadcrumbs/BreadcrumbsProvider;", "<init>", "()V", "SUPPORTED_LANGUAGES", "", "Lcom/intellij/editorconfig/common/syntax/EditorConfigLanguage;", "[Lcom/intellij/editorconfig/common/syntax/EditorConfigLanguage;", "getLanguages", "()[Lcom/intellij/editorconfig/common/syntax/EditorConfigLanguage;", "acceptElement", "", "element", "Lcom/intellij/psi/PsiElement;", "getElementInfo", "", "getParent", "getChildren", "", "intellij.editorconfig.backend"})
public final class EditorConfigBreadcrumbsProvider
implements BreadcrumbsProvider {
    @NotNull
    private final EditorConfigLanguage[] SUPPORTED_LANGUAGES;

    public EditorConfigBreadcrumbsProvider() {
        EditorConfigLanguage[] editorConfigLanguageArray;
        boolean enabled = EditorConfigRegistry.shouldSupportBreadCrumbs();
        if (enabled) {
            EditorConfigLanguage[] editorConfigLanguageArray2 = new EditorConfigLanguage[]{EditorConfigLanguage.INSTANCE};
            editorConfigLanguageArray = editorConfigLanguageArray2;
        } else {
            editorConfigLanguageArray = new EditorConfigLanguage[]{};
        }
        this.SUPPORTED_LANGUAGES = editorConfigLanguageArray;
    }

    @NotNull
    public EditorConfigLanguage[] getLanguages() {
        return this.SUPPORTED_LANGUAGES;
    }

    public boolean acceptElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof EditorConfigPsiFile || element instanceof EditorConfigSection;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element;
        if (psiElement instanceof EditorConfigSection) {
            String string2 = ((EditorConfigSection)element).getHeader().getText();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        } else {
            string = psiElement instanceof EditorConfigPsiFile ? EditorConfigPresentationUtil.getFileName((PsiFile)element, true) : "<unknown element>";
        }
        return string;
    }

    @Nullable
    public PsiElement getParent(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof EditorConfigPsiFile ? (PsiElement)EditorConfigPsiTreeUtil.INSTANCE.findOneParentFile((EditorConfigPsiFile)element) : element.getParent();
    }

    @NotNull
    public List<PsiElement> getChildren(@NotNull PsiElement element) {
        List list;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof EditorConfigPsiFile) {
            list = EditorConfigPsiTreeUtil.INSTANCE.findAllChildrenFiles((EditorConfigPsiFile)element, false);
        } else {
            PsiElement[] psiElementArray = element.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            list = ArraysKt.toList((Object[])psiElementArray);
        }
        return list;
    }
}

