/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.frontend.TimedKeyEvent;
import com.intellij.terminal.frontend.action.SendShortcutToTerminalAction;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0017H\u0002J\u0015\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0017H \u00a2\u0006\u0002\b\u0019J\u0006\u0010\u001a\u001a\u00020\u0016J\u0006\u0010\u001b\u001a\u00020\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/terminal/frontend/TerminalEventDispatcher;", "Lcom/intellij/ide/IdeEventQueue$EventDispatcher;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lcom/intellij/openapi/Disposable;)V", "sendShortcutAction", "Lcom/intellij/terminal/frontend/action/SendShortcutToTerminalAction;", "myRegistered", "", "actionsToSkip", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "ignoreNextKeyTypedEvent", "dispatch", "e", "Ljava/awt/AWTEvent;", "dispatchKeyEvent", "", "Lcom/intellij/terminal/frontend/TimedKeyEvent;", "handleKeyEvent", "handleKeyEvent$intellij_terminal_frontend", "register", "unregister", "skipAction", "Ljava/awt/event/KeyEvent;", "getActionsToSkip", "Companion", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalEventDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalEventDispatcher.kt\ncom/intellij/terminal/frontend/TerminalEventDispatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,320:1\n1617#2,9:321\n1869#2:330\n1870#2:332\n1626#2:333\n1#3:331\n*S KotlinDebug\n*F\n+ 1 TerminalEventDispatcher.kt\ncom/intellij/terminal/frontend/TerminalEventDispatcher\n*L\n135#1:321,9\n135#1:330\n135#1:332\n135#1:333\n135#1:331\n*E\n"})
public abstract class TerminalEventDispatcher
implements IdeEventQueue.EventDispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final SendShortcutToTerminalAction sendShortcutAction;
    private boolean myRegistered;
    @NotNull
    private List<? extends AnAction> actionsToSkip;
    private boolean ignoreNextKeyTypedEvent;
    @Language(value="devkit-action-id")
    @NonNls
    @NotNull
    private static final List<String> OPTIONAL_ACTIONS;
    @Language(value="devkit-action-id")
    @NonNls
    @NotNull
    private static final List<String> TERMINAL_ACTIONS;

    public TerminalEventDispatcher(@NotNull EditorEx editor, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.editor = editor;
        this.settings = settings;
        this.parentDisposable = parentDisposable;
        this.sendShortcutAction = new SendShortcutToTerminalAction(this);
        this.actionsToSkip = CollectionsKt.emptyList();
        this.ignoreNextKeyTypedEvent = true;
    }

    public boolean dispatch(@NotNull AWTEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof KeyEvent) {
            TimedKeyEvent timedEvent = new TimedKeyEvent((KeyEvent)e, null, 2, null);
            this.dispatchKeyEvent(timedEvent);
        }
        return false;
    }

    private final void dispatchKeyEvent(TimedKeyEvent e) {
        if (!this.skipAction(e.getOriginal())) {
            if (e.getOriginal().getID() != 400 || !this.ignoreNextKeyTypedEvent) {
                this.ignoreNextKeyTypedEvent = false;
                this.handleKeyEvent$intellij_terminal_frontend(e);
            }
        } else {
            this.ignoreNextKeyTypedEvent = true;
        }
    }

    public abstract void handleKeyEvent$intellij_terminal_frontend(@NotNull TimedKeyEvent var1);

    public final void register() {
        ThreadingAssertions.assertEventDispatchThread();
        this.actionsToSkip = this.getActionsToSkip();
        if (!this.myRegistered) {
            IdeEventQueue.Companion.getInstance().addDispatcher((IdeEventQueue.EventDispatcher)this, this.parentDisposable);
            JComponent jComponent = this.editor.getContentComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
            this.sendShortcutAction.register$intellij_terminal_frontend(jComponent, this.getActionsToSkip());
            this.myRegistered = true;
        }
    }

    public final void unregister() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myRegistered) {
            IdeEventQueue.Companion.getInstance().removeDispatcher((IdeEventQueue.EventDispatcher)this);
            JComponent jComponent = this.editor.getContentComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
            this.sendShortcutAction.unregister$intellij_terminal_frontend(jComponent);
            this.actionsToSkip = CollectionsKt.emptyList();
            this.myRegistered = false;
        }
    }

    private final boolean skipAction(KeyEvent e) {
        KeyboardShortcut eventShortcut = new KeyboardShortcut(KeyStroke.getKeyStrokeForEvent(e), null);
        for (AnAction anAction : this.actionsToSkip) {
            for (Shortcut sc : anAction.getShortcutSet().getShortcuts()) {
                if (!sc.isKeyboard() || !sc.startsWith((Shortcut)eventShortcut)) continue;
                return Registry.Companion.is("terminal.Ctrl-E.opens.RecentFiles.popup", false) || !Intrinsics.areEqual((Object)"RecentFiles", (Object)ActionManager.getInstance().getId(anAction)) || e.getModifiersEx() != 128 || e.getKeyCode() != 69;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AnAction> getActionsToSkip() {
        void $this$mapNotNullTo$iv$iv;
        ActionManager actionManager = ActionManager.getInstance();
        List allowedActionIDs = this.settings.overrideIdeShortcuts() ? CollectionsKt.plus((Collection)OPTIONAL_ACTIONS, (Iterable)TERMINAL_ACTIONS) : TERMINAL_ACTIONS;
        Iterable $this$mapNotNull$iv = allowedActionIDs;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AnAction it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String actionId = (String)element$iv$iv;
            boolean bl2 = false;
            if (actionManager.getAction(actionId) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static {
        Object[] objectArray = new String[]{"ActivateTerminalToolWindow", "ActivateProjectToolWindow", "ActivateFavoritesToolWindow", "ActivateBookmarksToolWindow", "ActivateFindToolWindow", "ActivateRunToolWindow", "ActivateDebugToolWindow", "ActivateProblemsViewToolWindow", "ActivateTODOToolWindow", "ActivateStructureToolWindow", "ActivateHierarchyToolWindow", "ActivateServicesToolWindow", "ActivateCommitToolWindow", "ActivateVersionControlToolWindow", "HideActiveWindow", "HideAllWindows", "NextWindow", "PreviousWindow", "NextProjectWindow", "PreviousProjectWindow", "ShowBookmarks", "ShowTypeBookmarks", "FindInPath", "GotoBookmark0", "GotoBookmark1", "GotoBookmark2", "GotoBookmark3", "GotoBookmark4", "GotoBookmark5", "GotoBookmark6", "GotoBookmark7", "GotoBookmark8", "GotoBookmark9", "GotoAction", "GotoFile", "GotoClass", "GotoSymbol", "Vcs.Push", "ShowSettings", "RecentFiles", "Switcher", "ResizeToolWindowLeft", "ResizeToolWindowRight", "ResizeToolWindowUp", "ResizeToolWindowDown", "MaximizeToolWindow", "TerminalIncreaseFontSize", "TerminalDecreaseFontSize", "TerminalResetFontSize"};
        OPTIONAL_ACTIONS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"NextTab", "PreviousTab", "ShowContent", "Terminal.Escape", "Terminal.CopySelectedText", "Terminal.Paste", "Terminal.LineUp", "Terminal.LineDown", "Terminal.PageUp", "Terminal.PageDown", "Terminal.RenameSession", "Terminal.NewTab", "Terminal.CloseTab", "Terminal.SplitVertically", "Terminal.SplitHorizontally", "Terminal.NextSplitter", "Terminal.PrevSplitter", "Terminal.MoveToolWindowTabLeft", "Terminal.MoveToolWindowTabRight", "Terminal.ClearBuffer", "Terminal.Find", "Terminal.CommandCompletion", "Terminal.EnterCommandCompletion", "Terminal.UpCommandCompletion", "Terminal.DownCommandCompletion"};
        TERMINAL_ACTIONS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/terminal/frontend/TerminalEventDispatcher$Companion;", "", "<init>", "()V", "OPTIONAL_ACTIONS", "", "", "TERMINAL_ACTIONS", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

