/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.ui.TerminalWidget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.ShellStartupOptionsKt;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionEditor;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

final class TerminalSessionEditorProvider
implements FileEditorProvider,
DumbAware {
    TerminalSessionEditorProvider() {
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            TerminalSessionEditorProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            TerminalSessionEditorProvider.$$$reportNull$$$0(1);
        }
        return file instanceof TerminalSessionVirtualFileImpl;
    }

    public boolean acceptRequiresReadAction() {
        return false;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            TerminalSessionEditorProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            TerminalSessionEditorProvider.$$$reportNull$$$0(3);
        }
        TerminalSessionVirtualFileImpl terminalFile = (TerminalSessionVirtualFileImpl)file;
        if (file.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN) != null) {
            return new TerminalSessionEditor(project, terminalFile);
        }
        TerminalWidget widget = terminalFile.getTerminalWidget();
        String workingDirectory = TerminalWorkingDirectoryManager.getWorkingDirectory(widget);
        Disposable tempDisposable = Disposer.newDisposable();
        ShellStartupOptions options = ShellStartupOptionsKt.shellStartupOptions(workingDirectory);
        TerminalWidget newWidget = new LocalTerminalDirectRunner(project).startShellTerminalWidget(tempDisposable, options, true);
        TerminalSessionVirtualFileImpl newSessionVirtualFile = new TerminalSessionVirtualFileImpl(terminalFile.getName(), newWidget, terminalFile.getSettingsProvider());
        TerminalSessionEditor editor = new TerminalSessionEditor(project, newSessionVirtualFile);
        Disposer.dispose((Disposable)tempDisposable);
        TerminalSessionEditor terminalSessionEditor = editor;
        if (terminalSessionEditor == null) {
            TerminalSessionEditorProvider.$$$reportNull$$$0(4);
        }
        return terminalSessionEditor;
    }

    @NotNull
    public String getEditorTypeId() {
        return "terminal-session-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            TerminalSessionEditorProvider.$$$reportNull$$$0(5);
        }
        return fileEditorPolicy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/vfs/TerminalSessionEditorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/vfs/TerminalSessionEditorProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

