/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.table.VcsLogCommitSelectionUtils;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class CompareRevisionsFromFileHistoryActionProvider
implements AnActionExtensionProvider {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CompareRevisionsFromFileHistoryActionProvider.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareRevisionsFromFileHistoryActionProvider.$$$reportNull$$$0(1);
        }
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        return e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI) != null && filePath != null && !filePath.isDirectory();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareRevisionsFromFileHistoryActionProvider.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        VcsLogCommitSelection selection = (VcsLogCommitSelection)e.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        if (project == null || filePath == null || filePath.isDirectory() || selection == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        this.updateActionText(e, selection);
        e.getPresentation().setVisible(true);
        if (e.getInputEvent() instanceof KeyEvent) {
            e.getPresentation().setEnabled(true);
        } else {
            Change[] changes = (Change[])e.getData(VcsDataKeys.SELECTED_CHANGES);
            e.getPresentation().setEnabled(changes != null && changes.length == 1 && changes[0] != null);
        }
    }

    protected void updateActionText(@NotNull AnActionEvent e, @NotNull VcsLogCommitSelection selection) {
        if (e == null) {
            CompareRevisionsFromFileHistoryActionProvider.$$$reportNull$$$0(3);
        }
        if (selection == null) {
            CompareRevisionsFromFileHistoryActionProvider.$$$reportNull$$$0(4);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareRevisionsFromFileHistoryActionProvider.$$$reportNull$$$0(5);
        }
        VcsLogUsageTriggerCollector.triggerUsage(e, this);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Change[] changes = (Change[])e.getData(VcsDataKeys.SELECTED_CHANGES);
        if (changes == null || changes.length != 1 || changes[0] == null) {
            return;
        }
        ListSelection selection = ListSelection.createAt(Arrays.asList(changes), (int)0).asExplicitSelection();
        ShowDiffAction.showDiffForChange((Project)project, (ListSelection)selection);
    }

    public static void setTextAndDescription(@NotNull AnActionEvent e, @NotNull VcsLogCommitSelection selection) {
        if (e == null) {
            CompareRevisionsFromFileHistoryActionProvider.$$$reportNull$$$0(6);
        }
        if (selection == null) {
            CompareRevisionsFromFileHistoryActionProvider.$$$reportNull$$$0(7);
        }
        if (VcsLogCommitSelectionUtils.getSize(selection) >= 2) {
            e.getPresentation().setText(VcsLogBundle.messagePointer("action.presentation.CompareRevisionsFromFileHistoryActionProvider.text.compare", new Object[0]));
            e.getPresentation().setDescription(VcsLogBundle.messagePointer("action.presentation.CompareRevisionsFromFileHistoryActionProvider.description.compare", new Object[0]));
        } else {
            e.getPresentation().setText(VcsLogBundle.messagePointer("action.presentation.CompareRevisionsFromFileHistoryActionProvider.text.show.diff", new Object[0]));
            e.getPresentation().setDescription(VcsLogBundle.messagePointer("action.presentation.CompareRevisionsFromFileHistoryActionProvider.description.show.diff", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/actions/history/CompareRevisionsFromFileHistoryActionProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/actions/history/CompareRevisionsFromFileHistoryActionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateActionText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setTextAndDescription";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    static class ShowStandaloneDiff
    extends CompareRevisionsFromFileHistoryActionProvider {
        ShowStandaloneDiff() {
        }
    }

    static class ShowDiff
    extends CompareRevisionsFromFileHistoryActionProvider {
        ShowDiff() {
        }

        @Override
        protected void updateActionText(@NotNull AnActionEvent e, @NotNull VcsLogCommitSelection selection) {
            if (e == null) {
                ShowDiff.$$$reportNull$$$0(0);
            }
            if (selection == null) {
                ShowDiff.$$$reportNull$$$0(1);
            }
            ShowDiff.setTextAndDescription(e, selection);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selection";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/ui/actions/history/CompareRevisionsFromFileHistoryActionProvider$ShowDiff";
            objectArray[2] = "updateActionText";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

