/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.driver.client.impl;

import com.intellij.driver.client.impl.JmxCallException;
import com.intellij.driver.client.impl.JmxHost;
import com.intellij.driver.client.impl.JmxName;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jetbrains.annotations.NotNull;

public class JmxCallHandler
implements InvocationHandler {
    private final JmxHost hostInfo;
    private final ObjectName mbeanName;
    private JMXConnector currentConnector;

    public JmxCallHandler(JmxHost hostInfo, String objectName) {
        this.hostInfo = hostInfo;
        try {
            this.mbeanName = new ObjectName(objectName);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Incorrect JMX object name: " + objectName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("close".equals(method.getName())) {
            if (this.currentConnector != null) {
                try {
                    this.currentConnector.close();
                }
                finally {
                    this.currentConnector = null;
                }
            }
            return null;
        }
        if (this.currentConnector == null) {
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.currentConnector = this.getConnector();
            }
            catch (IOException e) {
                this.currentConnector = null;
                throw new JmxCallException("Unable to connect to JMX host: " + this.getServiceTextURL(), e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
        try {
            MBeanServerConnection mbsc = this.currentConnector.getMBeanServerConnection();
            MBeanServerInvocationHandler wrappedHandler = new MBeanServerInvocationHandler(mbsc, this.mbeanName);
            return wrappedHandler.invoke(proxy, method, args);
        }
        catch (IOException e) {
            try {
                if (this.currentConnector != null) {
                    this.currentConnector.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.currentConnector = null;
            }
            throw new JmxCallException("Unable to perform JMX call: " + String.valueOf(method) + "(" + String.valueOf(args != null ? Arrays.asList(args) : "null") + ")", e);
        }
    }

    public JMXConnector getConnector() throws IOException {
        JMXServiceURL url;
        String textUrl = this.getServiceTextURL();
        try {
            url = new JMXServiceURL(textUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Incorrect service URL: " + textUrl, e);
        }
        HashMap<String, String[]> properties = new HashMap<String, String[]>();
        if (this.hostInfo.getUser() != null) {
            properties.put("jmx.remote.credentials", new String[]{this.hostInfo.getUser(), this.hostInfo.getPassword()});
        }
        return JMXConnectorFactory.connect(url, properties);
    }

    @NotNull
    private String getServiceTextURL() {
        String string = "service:jmx:rmi:///jndi/rmi://" + this.hostInfo.getAddress() + "/jmxrmi";
        if (string == null) {
            JmxCallHandler.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static <T> T jmx(Class<T> clazz) {
        return JmxCallHandler.jmx(clazz, new JmxHost(null, null, "localhost:7777"));
    }

    public static <T> T jmx(Class<T> clazz, JmxHost hostInfo) {
        JmxName jmxName = clazz.getAnnotation(JmxName.class);
        if (jmxName == null) {
            throw new RuntimeException("There is no @JmxName annotation for " + String.valueOf(clazz));
        }
        if (jmxName.value().isEmpty()) {
            throw new RuntimeException("JmxName.value is empty for " + String.valueOf(clazz));
        }
        return (T)Proxy.newProxyInstance(JmxCallHandler.class.getClassLoader(), new Class[]{clazz, AutoCloseable.class}, (InvocationHandler)new JmxCallHandler(hostInfo, jmxName.value()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/driver/client/impl/JmxCallHandler", "getServiceTextURL"));
    }
}

