/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackCommandReporter;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.Timer;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import com.jetbrains.performancePlugin.ui.FinishScriptDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReporterWithTimer
implements PlaybackCommandReporter {
    protected final Timer timer = new Timer();
    protected boolean isCanceled;

    public void startOfScript(@Nullable Project project) {
        this.isCanceled = false;
        this.timer.start();
    }

    public void scriptCanceled() {
        this.isCanceled = true;
    }

    public void endOfScript(@Nullable Project project) {
        this.timer.stop();
        ApplicationManager.getApplication().invokeLater(() -> {
            Notifications.Bus.notify((Notification)ReporterWithTimer.getDelayNotification(this.timer.getTotalTime(), this.timer.getAverageDelay(), this.timer.getLongestDelay()), (Project)project);
            if (!this.isCanceled && ProfilersController.getInstance().isStoppedByScript()) {
                new FinishScriptDialog(project).show();
            }
        });
    }

    @NotNull
    private static Notification getDelayNotification(long totalTime, long averageDelay, long maxDelay) {
        return new Notification("PerformancePlugin", PerformanceTestingBundle.message("delay.notification.title", new Object[0]), PerformanceTestingBundle.message("delay.notification.message", totalTime, averageDelay, maxDelay), NotificationType.INFORMATION);
    }
}

