/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.gotoType;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.actions.SearchEverywhereAction;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereToggleAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.util.Processor;
import com.jetbrains.rd.ide.model.GotoKey;
import com.jetbrains.rdclient.gotoType.GotoHost;
import com.jetbrains.rdclient.gotoType.GotoPopupSession;
import com.jetbrains.rdclient.gotoType.GotoResult;
import com.jetbrains.rdclient.gotoType.ProtocolNavigationItem;
import com.jetbrains.rdclient.gotoType.ProtocolSearchEverywhereContributor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J,\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0014\u0010!\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020$0#0\"J\u000e\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0019\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lcom/jetbrains/rdclient/gotoType/ProtocolSearchEverywhereItemsProcessor;", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "project", "Lcom/intellij/openapi/project/Project;", "gotoKeyProvider", "Lkotlin/Function0;", "Lcom/jetbrains/rd/ide/model/GotoKey;", "shouldAccessVfsWhenPresentingItemsPredicate", "", "everywhereActionFetcher", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereToggleAction;", "contributorDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/diagnostic/Logger;Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lcom/intellij/openapi/Disposable;)V", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getGotoKeyProvider", "()Lkotlin/jvm/functions/Function0;", "getShouldAccessVfsWhenPresentingItemsPredicate", "getEverywhereActionFetcher", "getContributorDisposable", "()Lcom/intellij/openapi/Disposable;", "fetchWeightedElements", "", "pattern", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/ide/actions/searcheverywhere/FoundItemDescriptor;", "Lcom/jetbrains/rdclient/gotoType/ProtocolNavigationItem;", "processSelectedItem", "selected", "intellij.rd.client"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nProtocolSearchEverywhereItemsProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolSearchEverywhereItemsProcessor.kt\ncom/jetbrains/rdclient/gotoType/ProtocolSearchEverywhereItemsProcessor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n10557#2,5:85\n1011#3,2:90\n1869#3,2:92\n1869#3,2:94\n*S KotlinDebug\n*F\n+ 1 ProtocolSearchEverywhereItemsProcessor.kt\ncom/jetbrains/rdclient/gotoType/ProtocolSearchEverywhereItemsProcessor\n*L\n43#1:85,5\n44#1:90,2\n49#1:92,2\n59#1:94,2\n*E\n"})
public final class ProtocolSearchEverywhereItemsProcessor {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Project project;
    @NotNull
    private final Function0<GotoKey> gotoKeyProvider;
    @NotNull
    private final Function0<Boolean> shouldAccessVfsWhenPresentingItemsPredicate;
    @NotNull
    private final Function0<SearchEverywhereToggleAction> everywhereActionFetcher;
    @NotNull
    private final Disposable contributorDisposable;

    public ProtocolSearchEverywhereItemsProcessor(@NotNull Logger logger, @NotNull Project project, @NotNull Function0<? extends GotoKey> gotoKeyProvider, @NotNull Function0<Boolean> shouldAccessVfsWhenPresentingItemsPredicate, @NotNull Function0<? extends SearchEverywhereToggleAction> everywhereActionFetcher, @NotNull Disposable contributorDisposable) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(gotoKeyProvider, (String)"gotoKeyProvider");
        Intrinsics.checkNotNullParameter(shouldAccessVfsWhenPresentingItemsPredicate, (String)"shouldAccessVfsWhenPresentingItemsPredicate");
        Intrinsics.checkNotNullParameter(everywhereActionFetcher, (String)"everywhereActionFetcher");
        Intrinsics.checkNotNullParameter((Object)contributorDisposable, (String)"contributorDisposable");
        this.logger = logger;
        this.project = project;
        this.gotoKeyProvider = gotoKeyProvider;
        this.shouldAccessVfsWhenPresentingItemsPredicate = shouldAccessVfsWhenPresentingItemsPredicate;
        this.everywhereActionFetcher = everywhereActionFetcher;
        this.contributorDisposable = contributorDisposable;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Function0<GotoKey> getGotoKeyProvider() {
        return this.gotoKeyProvider;
    }

    @NotNull
    public final Function0<Boolean> getShouldAccessVfsWhenPresentingItemsPredicate() {
        return this.shouldAccessVfsWhenPresentingItemsPredicate;
    }

    @NotNull
    public final Function0<SearchEverywhereToggleAction> getEverywhereActionFetcher() {
        return this.everywhereActionFetcher;
    }

    @NotNull
    public final Disposable getContributorDisposable() {
        return this.contributorDisposable;
    }

    /*
     * WARNING - void declaration
     */
    public final void fetchWeightedElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super FoundItemDescriptor<ProtocolNavigationItem>> consumer) {
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (progressIndicator.isCanceled()) {
            this.logger.info("Progress is canceled. Aborting protocol search");
            return;
        }
        GotoHost gotoHost = GotoHost.Companion.getInstance(this.project);
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)this.project.getUserData(SearchEverywhereAction.SEARCH_EVERYWHERE_POPUP);
        JBPopup jBPopup = concurrentHashMap != null ? (JBPopup)concurrentHashMap.get(ClientId.Companion.getCurrent()) : null;
        Disposable popup = jBPopup instanceof Disposable ? (Disposable)jBPopup : null;
        Disposable tempDisposable = popup == null ? this.contributorDisposable : null;
        Disposable disposable = popup;
        if (disposable == null && (disposable = tempDisposable) == null) {
            throw new IllegalStateException("Can't find session lifetime".toString());
        }
        Disposable actualPopup = disposable;
        GotoPopupSession session = gotoHost.getSessionForPopup(actualPopup, (GotoKey)this.gotoKeyProvider.invoke());
        SearchEverywhereToggleAction searchEverywhereToggleAction = (SearchEverywhereToggleAction)this.everywhereActionFetcher.invoke();
        String[] names = session.getItemsSync(pattern, searchEverywhereToggleAction != null ? Boolean.valueOf(searchEverywhereToggleAction.isEverywhere()) : null, progressIndicator);
        ArrayList items = new ArrayList();
        String[] stringArray = names;
        Collection destination$iv = items;
        boolean $i$f$flatMapTo = false;
        for (Iterator element$iv : $this$flatMapTo$iv) {
            void it = element$iv;
            boolean bl = false;
            Iterable list$iv = session.getItemByShortName((String)it);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        Object $this$sortBy$iv = items;
        boolean $i$f$sortBy2 = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    GotoResult it = (GotoResult)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(-it.getSearchItemData().getMatchScore());
                    it = (GotoResult)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(-it.getSearchItemData().getMatchScore()));
                }
            });
        }
        if (this.logger.isTraceEnabled()) {
            void $this$fetchWeightedElements_u24lambda_u243;
            Object $i$f$sortBy2 = $this$sortBy$iv = new StringBuilder();
            Logger logger = this.logger;
            boolean bl = false;
            $this$fetchWeightedElements_u24lambda_u243.append("(" + $this$fetchWeightedElements_u24lambda_u243.getClass().getSimpleName() + ") Got " + items.size() + " items for " + this.gotoKeyProvider.invoke() + " contributor. Items: \n");
            Iterable $this$forEach$iv = items;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GotoResult it = (GotoResult)element$iv;
                boolean bl2 = false;
                $this$fetchWeightedElements_u24lambda_u243.append("(" + it.getClass().getSimpleName() + ") " + it.getSearchItemData().getShortName() + " ");
                if (it.getSearchItemData().getClrName() != null) {
                    $this$fetchWeightedElements_u24lambda_u243.append("CLR: " + it.getSearchItemData().getClrName());
                }
                $this$fetchWeightedElements_u24lambda_u243.append("\n");
            }
            logger.trace(((StringBuilder)$this$sortBy$iv).toString());
        }
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GotoResult it = (GotoResult)element$iv;
            boolean bl = false;
            progressIndicator.checkCanceled();
            ProtocolNavigationItem navigationItem = ProtocolSearchEverywhereContributor.Companion.createNavigationItem(this.project, (Boolean)this.shouldAccessVfsWhenPresentingItemsPredicate.invoke(), pattern, it, session);
            if (consumer.process((Object)new FoundItemDescriptor((Object)navigationItem, it.getSearchItemData().getMatchScore()))) continue;
        }
    }

    public final boolean processSelectedItem(@NotNull ProtocolNavigationItem selected) {
        Intrinsics.checkNotNullParameter((Object)((Object)selected), (String)"selected");
        ApplicationManager.getApplication().invokeLater(() -> ProtocolSearchEverywhereItemsProcessor.processSelectedItem$lambda$5(selected));
        return true;
    }

    private static final void processSelectedItem$lambda$5(ProtocolNavigationItem $selected) {
        $selected.getSearchPopup().getItemExecutedSignal().fire((Object)$selected.getSearchItemData());
    }
}

