/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.frontend.split.debugger.breakpoint;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.execution.frontend.split.debugger.ThinClientBreakpointConditionEditorsProvider;
import com.intellij.platform.execution.frontend.split.debugger.breakpoint.ThinClientBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.jetbrains.codeWithMe.model.LineBreakpointTypeModel;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ui.icons.UtilKt;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0016\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0016J\b\u0010\u001a\u001a\u00020\u000eH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u001c\u001a\u00020\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u000eH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010\u00022\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u001e\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00020)2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/platform/execution/frontend/split/debugger/breakpoint/ThinClientLineBreakpointType;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "Lcom/intellij/platform/execution/frontend/split/debugger/breakpoint/ThinClientBreakpointProperties;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/jetbrains/codeWithMe/model/LineBreakpointTypeModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/codeWithMe/model/LineBreakpointTypeModel;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getModel", "()Lcom/jetbrains/codeWithMe/model/LineBreakpointTypeModel;", "enabledIcon", "Ljavax/swing/Icon;", "disabledIcon", "suspendNoneIcon", "mutedEnabledIcon", "mutedDisabledIcon", "pendingIcon", "inactiveDependentIcon", "temporaryIcon", "getEnabledIcon", "getDisabledIcon", "getSuspendNoneIcon", "getMutedEnabledIcon", "getMutedDisabledIcon", "getPendingIcon", "getInactiveDependentIcon", "getTemporaryIcon", "isSuspendThreadSupported", "", "createBreakpointProperties", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "canPutAt", "getEditorsProvider", "Lcom/intellij/platform/execution/frontend/split/debugger/ThinClientBreakpointConditionEditorsProvider;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "intellij.platform.execution.frontend.split"})
public abstract class ThinClientLineBreakpointType
extends XLineBreakpointType<ThinClientBreakpointProperties> {
    @NotNull
    private final Project project;
    @NotNull
    private final LineBreakpointTypeModel model;
    @Nullable
    private final Icon enabledIcon;
    @Nullable
    private final Icon disabledIcon;
    @Nullable
    private final Icon suspendNoneIcon;
    @Nullable
    private final Icon mutedEnabledIcon;
    @Nullable
    private final Icon mutedDisabledIcon;
    @Nullable
    private final Icon pendingIcon;
    @Nullable
    private final Icon inactiveDependentIcon;
    @Nullable
    private final Icon temporaryIcon;

    public ThinClientLineBreakpointType(@NotNull Project project, @NotNull LineBreakpointTypeModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(model.getId(), model.getTitle());
        this.project = project;
        this.model = model;
        IconModel iconModel = this.model.getEnabledIcon();
        this.enabledIcon = iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null;
        IconModel iconModel2 = this.model.getDisabledIcon();
        this.disabledIcon = iconModel2 != null ? UtilKt.fromModel((IconModel)iconModel2) : null;
        IconModel iconModel3 = this.model.getSuspendNoneIcon();
        this.suspendNoneIcon = iconModel3 != null ? UtilKt.fromModel((IconModel)iconModel3) : null;
        IconModel iconModel4 = this.model.getMutedEnabledIcon();
        this.mutedEnabledIcon = iconModel4 != null ? UtilKt.fromModel((IconModel)iconModel4) : null;
        IconModel iconModel5 = this.model.getMutedDisabledIcon();
        this.mutedDisabledIcon = iconModel5 != null ? UtilKt.fromModel((IconModel)iconModel5) : null;
        IconModel iconModel6 = this.model.getPendingIcon();
        this.pendingIcon = iconModel6 != null ? UtilKt.fromModel((IconModel)iconModel6) : null;
        IconModel iconModel7 = this.model.getInactiveDependentIcon();
        this.inactiveDependentIcon = iconModel7 != null ? UtilKt.fromModel((IconModel)iconModel7) : null;
        IconModel iconModel8 = this.model.getTemporaryIcon();
        this.temporaryIcon = iconModel8 != null ? UtilKt.fromModel((IconModel)iconModel8) : null;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final LineBreakpointTypeModel getModel() {
        return this.model;
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = this.enabledIcon;
        if (icon == null) {
            Icon icon2 = super.getEnabledIcon();
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getEnabledIcon(...)");
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = this.disabledIcon;
        if (icon == null) {
            Icon icon2 = super.getDisabledIcon();
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getDisabledIcon(...)");
        }
        return icon;
    }

    @NotNull
    public Icon getSuspendNoneIcon() {
        Icon icon = this.suspendNoneIcon;
        if (icon == null) {
            Icon icon2 = super.getSuspendNoneIcon();
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getSuspendNoneIcon(...)");
        }
        return icon;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        Icon icon = this.mutedEnabledIcon;
        if (icon == null) {
            Icon icon2 = super.getMutedEnabledIcon();
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getMutedEnabledIcon(...)");
        }
        return icon;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        Icon icon = this.mutedDisabledIcon;
        if (icon == null) {
            Icon icon2 = super.getMutedDisabledIcon();
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getMutedDisabledIcon(...)");
        }
        return icon;
    }

    @Nullable
    public Icon getPendingIcon() {
        return this.pendingIcon;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        Icon icon = this.inactiveDependentIcon;
        if (icon == null) {
            Icon icon2 = super.getInactiveDependentIcon();
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getInactiveDependentIcon(...)");
        }
        return icon;
    }

    @NotNull
    public Icon getTemporaryIcon() {
        Icon icon = this.temporaryIcon;
        if (icon == null) {
            Icon icon2 = super.getTemporaryIcon();
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getTemporaryIcon(...)");
        }
        return icon;
    }

    public boolean isSuspendThreadSupported() {
        return this.model.isSuspendThreadSupported();
    }

    @Nullable
    public ThinClientBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return null;
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return false;
    }

    @NotNull
    public ThinClientBreakpointConditionEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<ThinClientBreakpointProperties> breakpoint, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new ThinClientBreakpointConditionEditorsProvider(project, breakpoint);
    }
}

