/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config.gpg;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import git4idea.commands.GitImpl;
import git4idea.config.GitConfigUtil;
import git4idea.config.gpg.GpgKey;
import git4idea.config.gpg.RepoConfig;
import git4idea.config.gpg.SecretKeys;
import git4idea.repo.GitProjectConfigurationCache;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.StringScanner;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0016\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0018\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u0018\b\u0002\u0010\u0018\"\b\u0012\u0004\u0012\u00020\u00150\u00192\b\u0012\u0004\u0012\u00020\u00150\u0019\u00a8\u0006\u001a"}, d2={"readGitGpgConfig", "Lgit4idea/config/gpg/RepoConfig;", "repository", "Lgit4idea/repo/GitRepository;", "readAvailableSecretKeys", "Lgit4idea/config/gpg/SecretKeys;", "project", "Lcom/intellij/openapi/project/Project;", "parseSecretKeys", "output", "", "checkKeyCapabilities", "", "capabilities", "isGpgSignEnabledCached", "isGpgSignEnabled", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "getGpgSignKeyCached", "getGpgSignKey", "writeGitGpgConfig", "", "gpgKey", "Lgit4idea/config/gpg/GpgKey;", "ValueListener", "Lkotlin/Function0;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitGpgConfigUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitGpgConfigUtils.kt\ngit4idea/config/gpg/GitGpgConfigUtilsKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,210:1\n14#2:211\n14#2:212\n*S KotlinDebug\n*F\n+ 1 GitGpgConfigUtils.kt\ngit4idea/config/gpg/GitGpgConfigUtilsKt\n*L\n97#1:211\n112#1:212\n*E\n"})
public final class GitGpgConfigUtilsKt {
    private static final RepoConfig readGitGpgConfig(GitRepository repository2) throws VcsException {
        Project project = repository2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile = repository2.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        boolean isEnabled = GitGpgConfigUtilsKt.isGpgSignEnabled(project, virtualFile);
        if (!isEnabled) {
            return new RepoConfig(null);
        }
        Project project2 = repository2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        VirtualFile virtualFile2 = repository2.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getRoot(...)");
        String keyValue = GitGpgConfigUtilsKt.getGpgSignKey(project2, virtualFile2);
        if (keyValue == null) {
            return new RepoConfig(null);
        }
        return new RepoConfig(new GpgKey(((Object)StringsKt.trim((CharSequence)keyValue)).toString()));
    }

    private static final SecretKeys readAvailableSecretKeys(Project project) throws VcsException {
        List<GitRepository> list = GitRepositoryManager.getInstance(project).getRepositories();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
        GitRepository repository2 = (GitRepository)CollectionsKt.firstOrNull(list);
        if (repository2 == null) {
            return new SecretKeys(CollectionsKt.emptyList(), MapsKt.emptyMap());
        }
        String string = GitConfigUtil.getValue(project, repository2.getRoot(), "gpg.program");
        if (string == null) {
            string = "gpg";
        }
        String gpgCommand = string;
        String[] stringArray = new String[]{gpgCommand, "--list-secret-keys", "--with-colons", "--fixed-list-mode", "--batch", "--no-tty"};
        String string2 = GitImpl.runBundledCommand(project, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"runBundledCommand(...)");
        String output2 = string2;
        return GitGpgConfigUtilsKt.parseSecretKeys(output2);
    }

    private static final SecretKeys parseSecretKeys(String output2) {
        List result2 = new ArrayList();
        Map descriptions = new LinkedHashMap();
        GpgKey lastKey = null;
        StringScanner scanner = new StringScanner(output2);
        while (scanner.hasMoreData()) {
            String line = scanner.line();
            Intrinsics.checkNotNull((Object)line);
            char[] cArray = new char[]{':'};
            List fields = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            String type = (String)CollectionsKt.getOrNull((List)fields, (int)0);
            if (Intrinsics.areEqual((Object)type, (Object)"sec")) {
                String keyId = (String)CollectionsKt.getOrNull((List)fields, (int)4);
                String capabilities = (String)CollectionsKt.getOrNull((List)fields, (int)11);
                if (keyId != null && capabilities != null && GitGpgConfigUtilsKt.checkKeyCapabilities(capabilities)) {
                    GpgKey gpgKey = new GpgKey(keyId);
                    result2.add(gpgKey);
                    lastKey = gpgKey;
                } else {
                    lastKey = null;
                }
            }
            if (!Intrinsics.areEqual((Object)type, (Object)"uid")) continue;
            String userId = (String)CollectionsKt.getOrNull((List)fields, (int)9);
            if (userId != null && lastKey != null) {
                descriptions.put(lastKey, StringUtil.unescapeAnsiStringCharacters((String)userId));
            }
            lastKey = null;
        }
        return new SecretKeys(result2, descriptions);
    }

    private static final boolean checkKeyCapabilities(String capabilities) {
        if (StringsKt.contains$default((CharSequence)capabilities, (CharSequence)"D", (boolean)false, (int)2, null)) {
            return false;
        }
        return StringsKt.contains$default((CharSequence)capabilities, (CharSequence)"s", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)capabilities, (CharSequence)"S", (boolean)false, (int)2, null);
    }

    @RequiresBackgroundThread
    public static final boolean isGpgSignEnabledCached(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Project project = repository2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return Intrinsics.areEqual((Object)GitConfigUtil.getBooleanValue(GitProjectConfigurationCache.Companion.getInstance(project).readRepositoryConfig(repository2, "commit.gpgSign")), (Object)true);
    }

    public static final boolean isGpgSignEnabled(@NotNull Project project, @NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        try {
            return Intrinsics.areEqual((Object)GitConfigUtil.getBooleanValue(GitConfigUtil.getValue(project, root, "commit.gpgSign")), (Object)true);
        }
        catch (VcsException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(GitConfigUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot get commit.gpgSign config value", (Throwable)e);
            return false;
        }
    }

    @RequiresBackgroundThread
    @Nullable
    public static final String getGpgSignKeyCached(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Project project = repository2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return GitProjectConfigurationCache.Companion.getInstance(project).readRepositoryConfig(repository2, "user.signingkey");
    }

    @Nullable
    public static final String getGpgSignKey(@NotNull Project project, @NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        try {
            return GitConfigUtil.getValue(project, root, "user.signingkey");
        }
        catch (VcsException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(GitConfigUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot get user.signingkey config value", (Throwable)e);
            return null;
        }
    }

    public static final void writeGitGpgConfig(@NotNull GitRepository repository2, @Nullable GpgKey gpgKey) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        if (gpgKey != null) {
            GitConfigUtil.setValue(repository2.getProject(), repository2.getRoot(), "commit.gpgSign", "true", new String[0]);
            GitConfigUtil.setValue(repository2.getProject(), repository2.getRoot(), "user.signingkey", gpgKey.getId(), new String[0]);
        } else {
            GitConfigUtil.setValue(repository2.getProject(), repository2.getRoot(), "commit.gpgSign", "false", new String[0]);
        }
    }

    public static final /* synthetic */ RepoConfig access$readGitGpgConfig(GitRepository repository2) {
        return GitGpgConfigUtilsKt.readGitGpgConfig(repository2);
    }

    public static final /* synthetic */ SecretKeys access$readAvailableSecretKeys(Project project) {
        return GitGpgConfigUtilsKt.readAvailableSecretKeys(project);
    }
}

