/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.vfs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.LineStatusTrackerBaseContentUtil;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.index.ContentVersion;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt;
import git4idea.index.GitStageTracker;
import git4idea.index.GitStageTrackerKt;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgit4idea/index/vfs/GitIndexVirtualFileBaseContentProvider;", "Lcom/intellij/openapi/vcs/impl/VcsBaseContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isSupported", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBaseRevision", "Lcom/intellij/openapi/vcs/impl/VcsBaseContentProvider$BaseContent;", "currentRevisionNumber", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "root", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitIndexVirtualFileBaseContentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitIndexVirtualFileBaseContentProvider.kt\ngit4idea/index/vfs/GitIndexVirtualFileBaseContentProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,33:1\n1#2:34\n*E\n"})
public final class GitIndexVirtualFileBaseContentProvider
implements VcsBaseContentProvider {
    @NotNull
    private final Project project;

    public GitIndexVirtualFileBaseContentProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public boolean isSupported(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof GitIndexVirtualFile;
    }

    @Nullable
    public VcsBaseContentProvider.BaseContent getBaseRevision(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GitIndexVirtualFile gitIndexVirtualFile = file instanceof GitIndexVirtualFile ? (GitIndexVirtualFile)file : null;
        if (gitIndexVirtualFile == null) {
            return null;
        }
        GitIndexVirtualFile indexFile = gitIndexVirtualFile;
        GitStageTracker gitStageTracker = GitStageTracker.Companion.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)gitStageTracker, (String)"getInstance(...)");
        GitFileStatus gitFileStatus = GitStageTrackerKt.status(gitStageTracker, indexFile);
        if (gitFileStatus == null) {
            return null;
        }
        GitFileStatus status = gitFileStatus;
        if (!GitFileStatusKt.has(status, ContentVersion.HEAD)) {
            return null;
        }
        FilePath headPath = GitFileStatusKt.path(status, ContentVersion.HEAD);
        VcsRevisionNumber vcsRevisionNumber = this.currentRevisionNumber(indexFile.getRoot());
        if (vcsRevisionNumber == null) {
            return null;
        }
        VcsRevisionNumber currentRevisionNumber = vcsRevisionNumber;
        return LineStatusTrackerBaseContentUtil.createBaseContent((Project)this.project, (ContentRevision)GitContentRevision.createRevision(headPath, currentRevisionNumber, this.project));
    }

    private final VcsRevisionNumber currentRevisionNumber(VirtualFile root) {
        GitRevisionNumber gitRevisionNumber;
        String currentRevision;
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForRootQuick(root);
        String string = currentRevision = gitRepository != null ? gitRepository.getCurrentRevision() : null;
        if (string != null) {
            String it = string;
            boolean bl = false;
            gitRevisionNumber = new GitRevisionNumber(it);
        } else {
            gitRevisionNumber = null;
        }
        return (VcsRevisionNumber)gitRevisionNumber;
    }
}

