/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.MultiRootBranches;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.ui.VirtualFileHierarchicalComparator;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import git4idea.GitVcs;
import git4idea.config.GitVcsSettings;
import git4idea.rebase.GitRebaseSpec;
import git4idea.repo.GitRepoInfo;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryStateChangeListener;
import git4idea.repo.GitUntrackedDirtyScopeListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@Service(value={Service.Level.PROJECT})
public final class GitRepositoryManager
extends AbstractRepositoryManager<GitRepository> {
    public static final Comparator<GitRepository> DEPENDENCY_COMPARATOR = (repo1, repo2) -> -VirtualFileHierarchicalComparator.getInstance().compare(repo1.getRoot(), repo2.getRoot());
    private final ExecutorService myUpdateExecutor;
    @Nullable
    private volatile GitRebaseSpec myOngoingRebaseSpec;

    public GitRepositoryManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        if (project == null) {
            GitRepositoryManager.$$$reportNull$$$0(0);
        }
        if (coroutineScope == null) {
            GitRepositoryManager.$$$reportNull$$$0(1);
        }
        super(project, GitVcs.getKey(), ".git");
        this.myUpdateExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"GitRepositoryManager");
        AsyncVfsEventsPostProcessor.getInstance().addListener((AsyncVfsEventsListener)new GitUntrackedDirtyScopeListener(this), coroutineScope);
    }

    @NotNull
    public static GitRepositoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            GitRepositoryManager.$$$reportNull$$$0(2);
        }
        GitRepositoryManager gitRepositoryManager = (GitRepositoryManager)((Object)project.getService(GitRepositoryManager.class));
        if (gitRepositoryManager == null) {
            GitRepositoryManager.$$$reportNull$$$0(3);
        }
        return gitRepositoryManager;
    }

    public boolean isSyncEnabled() {
        return GitVcsSettings.getInstance((Project)this.getVcs().getProject()).getSyncSetting() == DvcsSyncSettings.Value.SYNC && !MultiRootBranches.diverged(this.getRepositories());
    }

    @NotNull
    public List<GitRepository> getRepositories() {
        List list = this.getRepositories(GitRepository.class);
        if (list == null) {
            GitRepositoryManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    public boolean shouldProposeSyncControl() {
        return !this.thereAreSubmodulesInProject() && super.shouldProposeSyncControl();
    }

    private boolean thereAreSubmodulesInProject() {
        return this.getRepositories().stream().anyMatch(repo -> !repo.getSubmodules().isEmpty());
    }

    @Nullable
    public GitRebaseSpec getOngoingRebaseSpec() {
        GitRebaseSpec rebaseSpec = this.myOngoingRebaseSpec;
        return rebaseSpec != null && rebaseSpec.isValid() ? rebaseSpec : null;
    }

    public boolean hasOngoingRebase() {
        return this.getOngoingRebaseSpec() != null;
    }

    public void setOngoingRebaseSpec(@Nullable GitRebaseSpec ongoingRebaseSpec) {
        this.myOngoingRebaseSpec = ongoingRebaseSpec != null && ongoingRebaseSpec.isValid() ? ongoingRebaseSpec : null;
    }

    void notifyListenersAsync(@NotNull GitRepository repository2, @Nullable GitRepoInfo previousInfo, @NotNull GitRepoInfo info) {
        if (repository2 == null) {
            GitRepositoryManager.$$$reportNull$$$0(5);
        }
        if (info == null) {
            GitRepositoryManager.$$$reportNull$$$0(6);
        }
        this.myUpdateExecutor.execute(() -> {
            if (!Disposer.isDisposed((Disposable)repository2)) {
                ((GitRepositoryChangeListener)BackgroundTaskUtil.syncPublisher((Project)repository2.getProject(), GitRepository.GIT_REPO_CHANGE)).repositoryChanged(repository2);
                if (previousInfo != null) {
                    ((GitRepositoryStateChangeListener)BackgroundTaskUtil.syncPublisher((Project)repository2.getProject(), GitRepository.GIT_REPO_STATE_CHANGE)).repositoryChanged(repository2, previousInfo, info);
                } else {
                    ((GitRepositoryStateChangeListener)BackgroundTaskUtil.syncPublisher((Project)repository2.getProject(), GitRepository.GIT_REPO_STATE_CHANGE)).repositoryCreated(repository2, info);
                }
            }
        });
    }

    public @Unmodifiable @NotNull List<GitRepository> sortByDependency(@NotNull @Unmodifiable Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitRepositoryManager.$$$reportNull$$$0(7);
        }
        List list = ContainerUtil.sorted(repositories, DEPENDENCY_COMPARATOR);
        if (list == null) {
            GitRepositoryManager.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitRepositoryManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitRepositoryManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sortByDependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersAsync";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sortByDependency";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 8 -> new IllegalStateException(string);
        };
    }
}

