/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitLocalBranch;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.reset.GitResetMode;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lgit4idea/reset/GitNewResetDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "commits", "", "Lgit4idea/repo/GitRepository;", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "defaultMode", "Lgit4idea/reset/GitResetMode;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;Lgit4idea/reset/GitResetMode;)V", "value", "resetMode", "getResetMode", "()Lgit4idea/reset/GitResetMode;", "createCenterPanel", "Ljavax/swing/JComponent;", "getHelpId", "", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitNewResetDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitNewResetDialog.kt\ngit4idea/reset/GitNewResetDialog\n+ 2 ButtonsGroup.kt\ncom/intellij/ui/dsl/builder/ButtonsGroupKt\n*L\n1#1,116:1\n31#2:117\n*S KotlinDebug\n*F\n+ 1 GitNewResetDialog.kt\ngit4idea/reset/GitNewResetDialog\n*L\n67#1:117\n*E\n"})
public final class GitNewResetDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<GitRepository, VcsFullCommitDetails> commits;
    @NotNull
    private GitResetMode resetMode;
    @NotNull
    private static final String DIALOG_ID = "git.new.reset.dialog";

    public GitNewResetDialog(@NotNull Project project, @NotNull Map<GitRepository, ? extends VcsFullCommitDetails> commits, @NotNull GitResetMode defaultMode) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        Intrinsics.checkNotNullParameter((Object)defaultMode, (String)"defaultMode");
        super(project);
        this.project = project;
        this.commits = commits;
        this.resetMode = defaultMode;
        this.init();
        this.setTitle(GitBundle.message((String)"git.reset.dialog.title", (Object[])new Object[0]));
        this.setOKButtonText(GitBundle.message((String)"git.reset.button", (Object[])new Object[0]));
    }

    @NotNull
    public final GitResetMode getResetMode() {
        return this.resetMode;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> GitNewResetDialog.createCenterPanel$lambda$5(this, arg_0));
    }

    @NotNull
    protected String getHelpId() {
        return DIALOG_ID;
    }

    private static final Unit createCenterPanel$lambda$5$lambda$0(GitNewResetDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = XmlStringUtil.wrapInHtml((CharSequence)GitNewResetDialog.Companion.prepareDescription(this$0.project, this$0.commits));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrapInHtml(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$5$lambda$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = XmlStringUtil.wrapInHtml((CharSequence)GitBundle.message((String)"git.reset.dialog.description", (Object[])new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrapInHtml(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$5$lambda$4$lambda$3$lambda$2(String $name, JBRadioButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setMnemonic((int)$name.charAt(0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$5$lambda$4$lambda$3(String $name, GitResetMode $mode, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell.comment$default((Cell)$this$row.radioButton($name, (Object)$mode).applyToComponent(arg_0 -> GitNewResetDialog.createCenterPanel$lambda$5$lambda$4$lambda$3$lambda$2($name, arg_0)), (String)$mode.getDescription(), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$5$lambda$4(Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        for (GitResetMode mode : GitResetMode.values()) {
            String name;
            Intrinsics.checkNotNullExpressionValue((Object)mode.getName(), (String)"getName(...)");
            Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> GitNewResetDialog.createCenterPanel$lambda$5$lambda$4$lambda$3(name, mode, arg_0), (int)1, null);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$5(GitNewResetDialog this$0, Panel $this$panel) {
        void $this$bind$iv;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GitNewResetDialog.createCenterPanel$lambda$5$lambda$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, GitNewResetDialog::createCenterPanel$lambda$5$lambda$1, (int)1, null);
        ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)false, GitNewResetDialog::createCenterPanel$lambda$5$lambda$4, (int)3, null);
        KMutableProperty0 prop$iv = (KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return ((GitNewResetDialog)((Object)this.receiver)).getResetMode();
            }

            public void set(Object value) {
                GitNewResetDialog.access$setResetMode$p((GitNewResetDialog)((Object)this.receiver), (GitResetMode)value);
            }
        };
        boolean $i$f$bind = false;
        $this$bind$iv.bind(MutablePropertyKt.toMutableProperty((KMutableProperty0)prop$iv), GitResetMode.class);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$setResetMode$p(GitNewResetDialog $this, GitResetMode gitResetMode) {
        $this.resetMode = gitResetMode;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0006\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0002J\u0015\u0010\u000e\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00072\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0015\u0010\u0010\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lgit4idea/reset/GitNewResetDialog$Companion;", "", "<init>", "()V", "DIALOG_ID", "", "prepareDescription", "Lorg/jetbrains/annotations/Nls;", "project", "Lcom/intellij/openapi/project/Project;", "commits", "", "Lgit4idea/repo/GitRepository;", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "getTargetText", "commit", "getSourceText", "Lorg/jetbrains/annotations/NonNls;", "repository", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        private final String prepareDescription(Project project, Map<GitRepository, ? extends VcsFullCommitDetails> commits) {
            boolean isMultiRepo = GitRepositoryManager.getInstance(project).moreThanOneRoot();
            Map.Entry onlyCommit = (Map.Entry)CollectionsKt.singleOrNull((Iterable)commits.entrySet());
            if (onlyCommit != null && !isMultiRepo) {
                GitRepository key = (GitRepository)onlyCommit.getKey();
                VcsFullCommitDetails value = (VcsFullCommitDetails)onlyCommit.getValue();
                return this.getSourceText(key) + " -> " + this.getTargetText(value);
            }
            StringBuilder desc = new StringBuilder();
            for (Map.Entry<GitRepository, ? extends VcsFullCommitDetails> entry : commits.entrySet()) {
                String sourceInRepo;
                GitRepository repository2 = entry.getKey();
                VcsFullCommitDetails commit = entry.getValue();
                Object[] objectArray = new Object[]{this.getSourceText(repository2), DvcsUtil.getShortRepositoryName((Repository)repository2)};
                Intrinsics.checkNotNullExpressionValue((Object)GitBundle.message((String)"git.reset.dialog.description.source.in.repository", (Object[])objectArray), (String)"message(...)");
                desc.append(sourceInRepo + " -> " + this.getTargetText(commit) + "<br/>");
            }
            String string = desc.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final String getTargetText(VcsFullCommitDetails commit) {
            String string = StringUtil.shortenTextWithEllipsis((String)commit.getSubject(), (int)40, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
            String commitMessage = string;
            String string2 = StringUtil.shortenTextWithEllipsis((String)VcsUserUtil.getShortPresentation((VcsUser)commit.getAuthor()), (int)40, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"shortenTextWithEllipsis(...)");
            String author = string2;
            Object[] objectArray = new Object[]{new HtmlBuilder().append((HtmlChunk)HtmlChunk.text((String)((Hash)commit.getId()).toShortString()).bold()).append(HtmlChunk.text((String)(" \"" + commitMessage + "\""))).toString(), HtmlChunk.tag((String)"code").addText(author)};
            String string3 = GitBundle.message((String)"git.reset.dialog.description.commit.details.by.author", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            return string3;
        }

        private final String getSourceText(GitRepository repository2) {
            Object object;
            GitLocalBranch currentBranch = repository2.getCurrentBranch();
            String currentRevision = repository2.getCurrentRevision();
            GitLocalBranch gitLocalBranch = currentBranch;
            if (gitLocalBranch != null) {
                object = gitLocalBranch.getName();
            } else {
                String string = currentRevision;
                object = string != null ? "HEAD (" + DvcsUtil.getShortHash((String)string) + ")" : "HEAD";
            }
            String text2 = object;
            String string = HtmlChunk.text((String)text2).bold().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

