/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.json.JsonBundle;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/jsonSchema/extension/JsonSchemaProjectSelfProviderFactory;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaProviderFactory;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getProviders", "", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "BundledJsonSchemaInfo", "MyJsonSchemaFileProvider", "intellij.json.backend"})
public final class JsonSchemaProjectSelfProviderFactory
implements JsonSchemaProviderFactory,
DumbAware {
    @Override
    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new MyJsonSchemaFileProvider[]{new MyJsonSchemaFileProvider(project, new BundledJsonSchemaInfo(JsonSchemaVersion.SCHEMA_4, "schema.json", "4", "http://json-schema.org/draft-04/schema")), new MyJsonSchemaFileProvider(project, new BundledJsonSchemaInfo(JsonSchemaVersion.SCHEMA_6, "schema06.json", "6", "http://json-schema.org/draft-06/schema")), new MyJsonSchemaFileProvider(project, new BundledJsonSchemaInfo(JsonSchemaVersion.SCHEMA_7, "schema07.json", "7", "http://json-schema.org/draft-07/schema")), new MyJsonSchemaFileProvider(project, new BundledJsonSchemaInfo(JsonSchemaVersion.SCHEMA_2019_09, "schema201909.json", "2019-09", "https://json-schema.org/draft/2019-09/schema")), new MyJsonSchemaFileProvider(project, new BundledJsonSchemaInfo(JsonSchemaVersion.SCHEMA_2020_12, "schema202012.json", "2020-12", "https://json-schema.org/draft/2020-12/schema"))};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B,\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000b\u0010\u0006\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000e\u0010\u0013\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J6\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\r\b\u0002\u0010\u0006\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0006\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/jsonSchema/extension/JsonSchemaProjectSelfProviderFactory$BundledJsonSchemaInfo;", "", "version", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaVersion;", "bundledResourceFileName", "", "presentableSchemaId", "Lorg/jetbrains/annotations/Nls;", "remoteSourceUrl", "<init>", "(Lcom/jetbrains/jsonSchema/impl/JsonSchemaVersion;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getVersion", "()Lcom/jetbrains/jsonSchema/impl/JsonSchemaVersion;", "getBundledResourceFileName", "()Ljava/lang/String;", "getPresentableSchemaId", "getRemoteSourceUrl", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.json.backend"})
    public static final class BundledJsonSchemaInfo {
        @NotNull
        private final JsonSchemaVersion version;
        @NotNull
        private final String bundledResourceFileName;
        @NotNull
        private final String presentableSchemaId;
        @NotNull
        private final String remoteSourceUrl;

        public BundledJsonSchemaInfo(@NotNull JsonSchemaVersion version, @NotNull String bundledResourceFileName, @NotNull String presentableSchemaId, @NotNull String remoteSourceUrl) {
            Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
            Intrinsics.checkNotNullParameter((Object)bundledResourceFileName, (String)"bundledResourceFileName");
            Intrinsics.checkNotNullParameter((Object)presentableSchemaId, (String)"presentableSchemaId");
            Intrinsics.checkNotNullParameter((Object)remoteSourceUrl, (String)"remoteSourceUrl");
            this.version = version;
            this.bundledResourceFileName = bundledResourceFileName;
            this.presentableSchemaId = presentableSchemaId;
            this.remoteSourceUrl = remoteSourceUrl;
        }

        @NotNull
        public final JsonSchemaVersion getVersion() {
            return this.version;
        }

        @NotNull
        public final String getBundledResourceFileName() {
            return this.bundledResourceFileName;
        }

        @NotNull
        public final String getPresentableSchemaId() {
            return this.presentableSchemaId;
        }

        @NotNull
        public final String getRemoteSourceUrl() {
            return this.remoteSourceUrl;
        }

        @NotNull
        public final JsonSchemaVersion component1() {
            return this.version;
        }

        @NotNull
        public final String component2() {
            return this.bundledResourceFileName;
        }

        @NotNull
        public final String component3() {
            return this.presentableSchemaId;
        }

        @NotNull
        public final String component4() {
            return this.remoteSourceUrl;
        }

        @NotNull
        public final BundledJsonSchemaInfo copy(@NotNull JsonSchemaVersion version, @NotNull String bundledResourceFileName, @NotNull String presentableSchemaId, @NotNull String remoteSourceUrl) {
            Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
            Intrinsics.checkNotNullParameter((Object)bundledResourceFileName, (String)"bundledResourceFileName");
            Intrinsics.checkNotNullParameter((Object)presentableSchemaId, (String)"presentableSchemaId");
            Intrinsics.checkNotNullParameter((Object)remoteSourceUrl, (String)"remoteSourceUrl");
            return new BundledJsonSchemaInfo(version, bundledResourceFileName, presentableSchemaId, remoteSourceUrl);
        }

        public static /* synthetic */ BundledJsonSchemaInfo copy$default(BundledJsonSchemaInfo bundledJsonSchemaInfo, JsonSchemaVersion jsonSchemaVersion, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                jsonSchemaVersion = bundledJsonSchemaInfo.version;
            }
            if ((n & 2) != 0) {
                string = bundledJsonSchemaInfo.bundledResourceFileName;
            }
            if ((n & 4) != 0) {
                string2 = bundledJsonSchemaInfo.presentableSchemaId;
            }
            if ((n & 8) != 0) {
                string3 = bundledJsonSchemaInfo.remoteSourceUrl;
            }
            return bundledJsonSchemaInfo.copy(jsonSchemaVersion, string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "BundledJsonSchemaInfo(version=" + this.version + ", bundledResourceFileName=" + this.bundledResourceFileName + ", presentableSchemaId=" + this.presentableSchemaId + ", remoteSourceUrl=" + this.remoteSourceUrl + ")";
        }

        public int hashCode() {
            int result = this.version.hashCode();
            result = result * 31 + this.bundledResourceFileName.hashCode();
            result = result * 31 + this.presentableSchemaId.hashCode();
            result = result * 31 + this.remoteSourceUrl.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BundledJsonSchemaInfo)) {
                return false;
            }
            BundledJsonSchemaInfo bundledJsonSchemaInfo = (BundledJsonSchemaInfo)other;
            if (this.version != bundledJsonSchemaInfo.version) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.bundledResourceFileName, (Object)bundledJsonSchemaInfo.bundledResourceFileName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.presentableSchemaId, (Object)bundledJsonSchemaInfo.presentableSchemaId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.remoteSourceUrl, (Object)bundledJsonSchemaInfo.remoteSourceUrl);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/jsonSchema/extension/JsonSchemaProjectSelfProviderFactory$MyJsonSchemaFileProvider;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "myProject", "Lcom/intellij/openapi/project/Project;", "myBundledSchema", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaProjectSelfProviderFactory$BundledJsonSchemaInfo;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/jsonSchema/extension/JsonSchemaProjectSelfProviderFactory$BundledJsonSchemaInfo;)V", "isAvailable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getSchemaVersion", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaVersion;", "getSchemaFile", "getSchemaType", "Lcom/jetbrains/jsonSchema/extension/SchemaType;", "getRemoteSource", "", "getPresentableName", "getName", "intellij.json.backend"})
    public static final class MyJsonSchemaFileProvider
    implements JsonSchemaFileProvider {
        @NotNull
        private final Project myProject;
        @NotNull
        private final BundledJsonSchemaInfo myBundledSchema;

        public MyJsonSchemaFileProvider(@NotNull Project myProject, @NotNull BundledJsonSchemaInfo myBundledSchema) {
            Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
            Intrinsics.checkNotNullParameter((Object)myBundledSchema, (String)"myBundledSchema");
            this.myProject = myProject;
            this.myBundledSchema = myBundledSchema;
        }

        @Override
        public boolean isAvailable(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (this.myProject.isDisposed()) {
                return false;
            }
            JsonSchemaService service = JsonSchemaService.Impl.get(this.myProject);
            if (!service.isApplicableToFile(file)) {
                return false;
            }
            JsonSchemaVersion instanceSchemaVersion = service.getSchemaVersion(file);
            if (instanceSchemaVersion == null) {
                return false;
            }
            return instanceSchemaVersion == this.myBundledSchema.getVersion();
        }

        @Override
        @NotNull
        public JsonSchemaVersion getSchemaVersion() {
            return this.myBundledSchema.getVersion();
        }

        @Override
        @Nullable
        public VirtualFile getSchemaFile() {
            return JsonSchemaProviderFactory.getResourceFile(JsonSchemaProjectSelfProviderFactory.class, "/jsonSchema/" + this.myBundledSchema.getBundledResourceFileName());
        }

        @Override
        @NotNull
        public SchemaType getSchemaType() {
            return SchemaType.schema;
        }

        @Override
        @NotNull
        public String getRemoteSource() {
            return this.myBundledSchema.getRemoteSourceUrl();
        }

        @Override
        @NotNull
        public String getPresentableName() {
            Object[] objectArray = new Object[]{this.myBundledSchema.getPresentableSchemaId()};
            String string = JsonBundle.message((String)"schema.of.version", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            return this.getPresentableName();
        }
    }
}

