/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.qt.common.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.qt.common.QtPathProvider;
import com.intellij.qt.common.settings.QtSettingsListener;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="QtSettings", storages={@Storage(value="QtSettings.xml")})
public class QtSettings
implements PersistentStateComponent<StoredState> {
    private final Project myProject;
    private String myLastQmlPath;
    @NotNull
    private final StoredState myState;

    public QtSettings(@NotNull Project project) {
        if (project == null) {
            QtSettings.$$$reportNull$$$0(0);
        }
        this.myLastQmlPath = "";
        this.myState = new StoredState();
        this.myProject = project;
    }

    @Nullable
    public StoredState getState() {
        return new StoredState(this.myState);
    }

    @NotNull
    public synchronized String getResultingQmlDir() {
        @NotNull String qmlPath = this.getCustomQmlPath(this.getCurrentProfile());
        if (!qmlPath.isEmpty()) {
            String string = qmlPath;
            if (string == null) {
                QtSettings.$$$reportNull$$$0(1);
            }
            return string;
        }
        qmlPath = this.getQmlPath(this.getCurrentProfile());
        if (!qmlPath.isEmpty()) {
            String string = qmlPath;
            if (string == null) {
                QtSettings.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = this.getDetectedQtPath();
        if (string == null) {
            QtSettings.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public synchronized String getResultingQtBinDir() {
        @NotNull String qtBinPath = this.getCustomQtBinPath(this.getCurrentProfile());
        if (!qtBinPath.isEmpty()) {
            String string = qtBinPath;
            if (string == null) {
                QtSettings.$$$reportNull$$$0(4);
            }
            return string;
        }
        qtBinPath = this.getQtBinPath(this.getCurrentProfile());
        if (!qtBinPath.isEmpty()) {
            String string = qtBinPath;
            if (string == null) {
                QtSettings.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = this.getDetectedQtPath();
        if (string == null) {
            QtSettings.$$$reportNull$$$0(6);
        }
        return string;
    }

    private synchronized void checkLastPath() {
        String currentPath = this.getResultingQmlDir();
        if (!currentPath.equals(this.myLastQmlPath)) {
            this.myLastQmlPath = currentPath;
            ((QtSettingsListener)this.myProject.getMessageBus().syncPublisher(QtSettingsListener.TOPIC)).onLastQmlPathChanged(this.myLastQmlPath);
        }
    }

    public void loadState(@NotNull StoredState state) {
        if (state == null) {
            QtSettings.$$$reportNull$$$0(7);
        }
        this.myState.myCurrentProfile = state.myCurrentProfile;
        this.myState.mySettingsPerProfile = state.mySettingsPerProfile;
    }

    private StoredState.PerProfileState getPerProfileState(@NotNull String profileName) {
        StoredState.PerProfileState state;
        if (profileName == null) {
            QtSettings.$$$reportNull$$$0(8);
        }
        return (state = this.myState.mySettingsPerProfile.get(profileName)) != null ? state : new StoredState.PerProfileState();
    }

    @NotNull
    @NlsSafe
    public synchronized String getQmlPath(@NotNull String profileName) {
        if (profileName == null) {
            QtSettings.$$$reportNull$$$0(9);
        }
        String string = this.getPerProfileState((String)profileName).myQmlPath;
        if (string == null) {
            QtSettings.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public synchronized String getQtBinPath(@NotNull String profileName) {
        if (profileName == null) {
            QtSettings.$$$reportNull$$$0(11);
        }
        String string = this.getPerProfileState((String)profileName).myQtBinPath;
        if (string == null) {
            QtSettings.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public synchronized String getCustomQmlPath(@NotNull String profileName) {
        if (profileName == null) {
            QtSettings.$$$reportNull$$$0(13);
        }
        String string = this.getPerProfileState((String)profileName).myCustomQmlPath;
        if (string == null) {
            QtSettings.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public synchronized String getCustomQtBinPath(@NotNull String profileName) {
        if (profileName == null) {
            QtSettings.$$$reportNull$$$0(15);
        }
        String string = this.getPerProfileState((String)profileName).myCustomQtBinPath;
        if (string == null) {
            QtSettings.$$$reportNull$$$0(16);
        }
        return string;
    }

    public synchronized List<String> getProfilesList() {
        return this.myState.mySettingsPerProfile.keySet().stream().toList();
    }

    public synchronized void removeProfileSettings(@NotNull String profileName) {
        StoredState.PerProfileState profileState;
        if (profileName == null) {
            QtSettings.$$$reportNull$$$0(17);
        }
        if ((profileState = this.myState.mySettingsPerProfile.get(profileName)) != null) {
            this.myState.mySettingsPerProfile.remove(profileName);
            if (this.getCurrentProfile().equals(profileName)) {
                ((QtSettingsListener)this.myProject.getMessageBus().syncPublisher(QtSettingsListener.TOPIC)).onQtBinPathChanged("");
                this.checkLastPath();
            }
        }
    }

    @NotNull
    public synchronized String getCurrentProfile() {
        String string = this.myState.myCurrentProfile;
        if (string == null) {
            QtSettings.$$$reportNull$$$0(18);
        }
        return string;
    }

    public synchronized void setProfileWithPaths(@NotNull String profileName, @NotNull String qmlPath, @NotNull String qtBinPath) {
        StoredState.PerProfileState profileState;
        if (profileName == null) {
            QtSettings.$$$reportNull$$$0(19);
        }
        if (qmlPath == null) {
            QtSettings.$$$reportNull$$$0(20);
        }
        if (qtBinPath == null) {
            QtSettings.$$$reportNull$$$0(21);
        }
        if ((profileState = this.myState.mySettingsPerProfile.get(profileName)) == null) {
            profileState = new StoredState.PerProfileState();
            this.myState.mySettingsPerProfile.put(profileName, profileState);
        }
        boolean changed = !profileState.myQmlPath.equals(qmlPath) || !profileState.myQtBinPath.equals(qtBinPath);
        profileState.myQmlPath = qmlPath;
        profileState.myQtBinPath = qtBinPath;
        if (changed && this.getCurrentProfile().equals(profileName)) {
            ((QtSettingsListener)this.myProject.getMessageBus().syncPublisher(QtSettingsListener.TOPIC)).onQmlPathChanged(qmlPath);
            ((QtSettingsListener)this.myProject.getMessageBus().syncPublisher(QtSettingsListener.TOPIC)).onQtBinPathChanged(qtBinPath);
            this.checkLastPath();
        }
    }

    public synchronized void setCurrentProfile(@NotNull String profileName) {
        if (profileName == null) {
            QtSettings.$$$reportNull$$$0(22);
        }
        boolean changed = !this.myState.myCurrentProfile.equals(profileName);
        this.myState.myCurrentProfile = profileName;
        if (changed) {
            ((QtSettingsListener)this.myProject.getMessageBus().syncPublisher(QtSettingsListener.TOPIC)).onCurrentProfileChanged(profileName);
            this.checkLastPath();
        }
    }

    public synchronized void checkForDefaultProfileAndAddWhenNeeded(@NotNull String profileName) {
        if (profileName == null) {
            QtSettings.$$$reportNull$$$0(23);
        }
        if (profileName.isEmpty() && this.myState.mySettingsPerProfile.isEmpty()) {
            this.myState.mySettingsPerProfile.put("", new StoredState.PerProfileState());
        }
    }

    public synchronized void setCustomQtBinPath(@NotNull String profileName, @NotNull String qtBinPath) {
        if (profileName == null) {
            QtSettings.$$$reportNull$$$0(24);
        }
        if (qtBinPath == null) {
            QtSettings.$$$reportNull$$$0(25);
        }
        this.checkForDefaultProfileAndAddWhenNeeded(profileName);
        if (!this.myState.mySettingsPerProfile.containsKey(profileName)) {
            return;
        }
        StoredState.PerProfileState state = this.getPerProfileState(profileName);
        boolean changed = !state.myCustomQtBinPath.equals(qtBinPath);
        state.myCustomQtBinPath = qtBinPath;
        if (changed && this.getCurrentProfile().equals(profileName)) {
            ((QtSettingsListener)this.myProject.getMessageBus().syncPublisher(QtSettingsListener.TOPIC)).onCustomQtBinPathChanged(qtBinPath);
        }
    }

    public synchronized void setCustomQmlPath(@NotNull String profileName, @NotNull String qmlPath) {
        if (profileName == null) {
            QtSettings.$$$reportNull$$$0(26);
        }
        if (qmlPath == null) {
            QtSettings.$$$reportNull$$$0(27);
        }
        this.checkForDefaultProfileAndAddWhenNeeded(profileName);
        if (!this.myState.mySettingsPerProfile.containsKey(profileName)) {
            return;
        }
        StoredState.PerProfileState state = this.getPerProfileState(profileName);
        boolean changed = !state.myCustomQmlPath.equals(qmlPath);
        state.myCustomQmlPath = qmlPath;
        if (changed && this.getCurrentProfile().equals(profileName)) {
            ((QtSettingsListener)this.myProject.getMessageBus().syncPublisher(QtSettingsListener.TOPIC)).onCustomQmlPathChanged(qmlPath);
            this.checkLastPath();
        }
    }

    @NlsSafe
    @NotNull
    public String getDetectedQtPath() {
        List qtPathProviders = QtPathProvider.EP_NAME.getExtensionsIfPointIsRegistered();
        for (QtPathProvider qtPathProvider : qtPathProviders) {
            @Nullable Path toolPath = qtPathProvider.findQtTool(this.myProject, "designer");
            if (toolPath == null || !toolPath.toFile().exists()) continue;
            String string = toolPath.getParent().toString();
            if (string == null) {
                QtSettings.$$$reportNull$$$0(28);
            }
            return string;
        }
        return "";
    }

    public static QtSettings getInstance(@NotNull Project project) {
        if (project == null) {
            QtSettings.$$$reportNull$$$0(29);
        }
        return (QtSettings)project.getService(QtSettings.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 10, 12, 14, 16, 18, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/qt/common/settings/QtSettings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileName";
                break;
            }
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qmlPath";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qtBinPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/qt/common/settings/QtSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultingQmlDir";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultingQtBinDir";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getQmlPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getQtBinPath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomQmlPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomQtBinPath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentProfile";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetectedQtPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 28: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPerProfileState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getQmlPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getQtBinPath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCustomQmlPath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCustomQtBinPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeProfileSettings";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setProfileWithPaths";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentProfile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkForDefaultProfileAndAddWhenNeeded";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setCustomQtBinPath";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setCustomQmlPath";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 10, 12, 14, 16, 18, 28 -> new IllegalStateException(string);
        };
    }

    public static class StoredState {
        @NotNull
        @NlsSafe
        public String myCurrentProfile;
        @NotNull
        @NlsSafe
        public HashMap<String, PerProfileState> mySettingsPerProfile;

        StoredState() {
            this.myCurrentProfile = "";
            this.mySettingsPerProfile = new HashMap();
        }

        StoredState(@NotNull StoredState other) {
            if (other == null) {
                StoredState.$$$reportNull$$$0(0);
            }
            this.myCurrentProfile = "";
            this.mySettingsPerProfile = new HashMap();
            this.myCurrentProfile = other.myCurrentProfile;
            this.mySettingsPerProfile = other.mySettingsPerProfile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/qt/common/settings/QtSettings$StoredState", "<init>"));
        }

        public static class PerProfileState {
            @NotNull
            @NlsSafe
            public String myQmlPath = "";
            @NotNull
            @NlsSafe
            public String myQtBinPath = "";
            @NotNull
            @NlsSafe
            public String myCustomQmlPath = "";
            @NotNull
            @NlsSafe
            public String myCustomQtBinPath = "";
        }
    }
}

