/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ssh.AuthFailSshTransportException;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshConnectionService;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.ui.SshConnectionStateListener;
import com.intellij.ssh.ui.SshLoginDialog;
import com.intellij.ssh.ui.SshPasswordPrompt;
import com.intellij.ssh.ui.SshUIUtil;
import com.intellij.ssh.ui.SshUiExtensions;
import com.intellij.ssh.ui.UISshPasswordPromptKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u001e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002J\b\u0010!\u001a\u00020\u0019H\u0002J\b\u0010\"\u001a\u00020\u0013H\u0002J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\t\u001a2\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f \u000e*\u0017\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f0\r\u00a2\u0006\u0002\b\u000b0\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/ssh/ui/UISshPasswordPrompt;", "Lcom/intellij/ssh/ui/SshPasswordPrompt;", "<init>", "()V", "requests", "Ljava/util/LinkedHashMap;", "Lcom/intellij/ssh/ui/SshPasswordPrompt$UserHostPort;", "Ljava/util/Deque;", "Lcom/intellij/ssh/ui/SshPasswordPrompt$Request;", "ignoredConnections", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "currentUserHostPort", "currentDialog", "Lcom/intellij/ssh/ui/SshLoginDialog;", "initAndShowCurrentDialog", "", "request", "showBalloon", "dialog", "Lkotlin/Function0;", "canShowBalloons", "", "handleRequest", "", "project", "Lcom/intellij/openapi/project/Project;", "ignoreUntilRestart", "userHostPort", "closeCurrentServerDialog", "isNotNonModal", "findAndExecuteRequest", "updateCurrentDialog", "intellij.platform.ssh.ui"})
@SourceDebugExtension(value={"SMAP\nUISshPasswordPrompt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UISshPasswordPrompt.kt\ncom/intellij/ssh/ui/UISshPasswordPrompt\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n40#2,3:211\n40#2,3:214\n295#3,2:217\n1#4:219\n*S KotlinDebug\n*F\n+ 1 UISshPasswordPrompt.kt\ncom/intellij/ssh/ui/UISshPasswordPrompt\n*L\n107#1:211,3\n125#1:214,3\n183#1:217,2\n*E\n"})
public final class UISshPasswordPrompt
implements SshPasswordPrompt {
    @NotNull
    private final LinkedHashMap<SshPasswordPrompt.UserHostPort, Deque<SshPasswordPrompt.Request>> requests;
    @NotNull
    private final Set<SshPasswordPrompt.UserHostPort> ignoredConnections;
    @Nullable
    private volatile SshPasswordPrompt.UserHostPort currentUserHostPort;
    @Nullable
    private volatile SshLoginDialog currentDialog;

    public UISshPasswordPrompt() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(SshConnectionStateListener.Companion.getAUTH_TOPIC(), (Object)new SshConnectionStateListener(){

            @Override
            public void authenticationFinished(String user, String host, int port) {
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                ActionsKt.invokeLater((ModalityState)ModalityState.any(), () -> 1.authenticationFinished$lambda$0(user, host, port, this));
            }

            @Override
            public void connectionCreated(SshSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            }

            private static final Unit authenticationFinished$lambda$0(String $user, String $host, int $port, UISshPasswordPrompt this$0) {
                SshPasswordPrompt.UserHostPort uhp = new SshPasswordPrompt.UserHostPort($user, $host, $port);
                Deque deque = (Deque)this$0.requests.get(uhp);
                if (deque != null) {
                    deque.add(new SshPasswordPrompt.Request.Done(uhp));
                    this$0.findAndExecuteRequest();
                }
                return Unit.INSTANCE;
            }
        });
        connection.subscribe(SshConnectionService.Companion.getTOPIC(), (Object)new SshConnectionService.Listener(){

            @Override
            public void sessionOrChannelRequested(String userName, String host, int port) {
                Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                ActionsKt.invokeLater((ModalityState)ModalityState.any(), () -> 2.sessionOrChannelRequested$lambda$0(userName, host, port, this));
            }

            private static final Unit sessionOrChannelRequested$lambda$0(String $userName, String $host, int $port, UISshPasswordPrompt this$0) {
                SshPasswordPrompt.UserHostPort uhp = new SshPasswordPrompt.UserHostPort($userName, $host, $port);
                if (this$0.currentDialog == null && this$0.currentUserHostPort == null && this$0.isNotNonModal()) {
                    SshPasswordPrompt.Request request;
                    Deque deque = (Deque)this$0.requests.get(uhp);
                    SshPasswordPrompt.Request request2 = request = deque != null ? (SshPasswordPrompt.Request)deque.poll() : null;
                    if (request != null) {
                        this$0.currentUserHostPort = uhp;
                        this$0.initAndShowCurrentDialog(request);
                    }
                }
                return Unit.INSTANCE;
            }
        });
        this.requests = new LinkedHashMap();
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.ignoredConnections = set;
    }

    private final void initAndShowCurrentDialog(SshPasswordPrompt.Request request) {
        block0: {
            SshLoginDialog sshLoginDialog;
            ThreadingAssertions.assertEventDispatchThread();
            UISshPasswordPromptKt.access$getLOG$p().debug("Showing password prompt dialog for " + request);
            SshPasswordPrompt.UserHostPort userHostPort = request.getUserHostPort();
            SshLoginDialog sshLoginDialog2 = this.currentDialog = new SshLoginDialog(null, userHostPort, (Function0<Unit>)((Function0)() -> UISshPasswordPrompt.initAndShowCurrentDialog$lambda$0(this, userHostPort)));
            Intrinsics.checkNotNull((Object)((Object)sshLoginDialog2));
            SshLoginDialog dialog = sshLoginDialog = sshLoginDialog2;
            boolean bl = false;
            dialog.repaintOnRequest$intellij_platform_ssh_ui(request);
            dialog.show();
            JComponent jComponent = dialog.getPreferredFocusedComponent();
            if (jComponent == null) break block0;
            JComponent component = jComponent;
            boolean bl2 = false;
            IdeFocusManager.getGlobalInstance().requestFocus((Component)component, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showBalloon(SshPasswordPrompt.Request request, Function0<Unit> dialog) {
        Notification notification;
        void $this$showBalloon_u24lambda_u243;
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("SSH Connections");
        SshPasswordPrompt.UserHostPort userHostPort = request.getUserHostPort();
        String string = notificationGroup.getDisplayId();
        boolean bl = false;
        Object[] objectArray = new Object[]{$this$showBalloon_u24lambda_u243.getUser(), $this$showBalloon_u24lambda_u243.getHost() + ":" + $this$showBalloon_u24lambda_u243.getPort()};
        NotificationType notificationType = NotificationType.WARNING;
        String string2 = SshBundle.message("ssh.connection.prompt.message", new Object[0]);
        String string3 = SshBundle.message("ssh.connection.notification.title", objectArray);
        String string4 = string;
        Notification $this$showBalloon_u24lambda_u246 = notification = new Notification(string4, string3, string2, notificationType).setCollapseDirection(Notification.CollapseActionsDirection.KEEP_LEFTMOST).setDropDownText(SshBundle.message("ssh.connection.notification.more.actions", new Object[0])).addAction((AnAction)NotificationAction.createSimpleExpiring((String)SshBundle.message("ssh.connection.notification.enter.password", new Object[0]), () -> UISshPasswordPrompt.showBalloon$lambda$4(dialog)));
        boolean bl2 = false;
        boolean $i$f$service = false;
        Class<SshUiExtensions> serviceClass$iv = SshUiExtensions.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        if (((SshUiExtensions)object).allowIgnoreLoginUntilRestart()) {
            $this$showBalloon_u24lambda_u246.addAction((AnAction)NotificationAction.createSimpleExpiring((String)SshBundle.message("ssh.connection.ignore.until.restart", new Object[0]), () -> UISshPasswordPrompt.showBalloon$lambda$6$lambda$5(this, request)));
        }
        Notification notification2 = notification.addAction((AnAction)NotificationAction.createSimple((String)SshBundle.message("ssh.connection.notification.manage.ssh.configurations", new Object[0]), UISshPasswordPrompt::showBalloon$lambda$7));
        Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"addAction(...)");
        Notification msg = notification2;
        UISshPasswordPromptKt.access$getLOG$p().debug("Showing password prompt balloon for " + request);
        ActionsKt.invokeLater$default(null, () -> UISshPasswordPrompt.showBalloon$lambda$8(msg), (int)1, null);
    }

    private final boolean canShowBalloons() {
        boolean $i$f$service = false;
        Class<SshUiExtensions> serviceClass$iv = SshUiExtensions.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((SshUiExtensions)object).doesSupportShowingBalloons();
    }

    @Override
    @Nullable
    public String handleRequest(@Nullable Project project, @NotNull SshPasswordPrompt.Request request) {
        String string;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.ignoredConnections.contains(request.getUserHostPort())) {
            UISshPasswordPromptKt.access$getLOG$p().info("Ignoring " + request + " which credentials were marked as ignored until restart");
            throw new AuthFailSshTransportException("Still ignoring " + request.getUserHostPort() + " until IDE restart", new Attachment[0]);
        }
        boolean showDialogImmediately = !this.canShowBalloons() || this.isNotNonModal();
        ActionsKt.invokeLater((ModalityState)ModalityState.any(), () -> UISshPasswordPrompt.handleRequest$lambda$12(this, request, showDialogImmediately));
        while (!request.getLatch().await(500L, TimeUnit.MILLISECONDS)) {
            ProgressIndicator progressIndicator2 = request.getProgressIndicator();
            if (progressIndicator2 == null) continue;
            progressIndicator2.checkCanceled();
        }
        String password = request.getResult().get();
        if (password == null) {
            this.closeCurrentServerDialog(request);
            UISshPasswordPromptKt.access$getLOG$p().info("Password request is cancelled: " + request);
            throw new AuthFailSshTransportException("Cancelled by user", new Attachment[0]);
        }
        if (Intrinsics.areEqual((Object)password, (Object)"")) {
            UISshPasswordPromptKt.access$getLOG$p().info("Password request is skipped: " + request);
            string = null;
        } else {
            UISshPasswordPromptKt.access$getLOG$p().debug("Provided a password: " + request);
            string = password;
        }
        return string;
    }

    private final void ignoreUntilRestart(SshPasswordPrompt.UserHostPort userHostPort) {
        UISshPasswordPromptKt.access$getLOG$p().info(userHostPort + " is marked as ignored until restart. Will not ask any password for the server anymore.");
        ((Collection)this.ignoredConnections).add(userHostPort);
    }

    private final void closeCurrentServerDialog(SshPasswordPrompt.Request request) {
        SwingUtilities.invokeLater(() -> UISshPasswordPrompt.closeCurrentServerDialog$lambda$13(this, request));
    }

    private final boolean isNotNonModal() {
        return (Boolean)ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.any(), UISshPasswordPrompt::isNotNonModal$lambda$14);
    }

    private final void findAndExecuteRequest() {
        block3: {
            block2: {
                Object v3;
                block1: {
                    ThreadingAssertions.assertEventDispatchThread();
                    if (this.currentUserHostPort != null) break block2;
                    Set<Map.Entry<SshPasswordPrompt.UserHostPort, Deque<SshPasswordPrompt.Request>>> set = this.requests.entrySet();
                    Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                    Iterable $this$firstOrNull$iv = set;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Map.Entry it = (Map.Entry)element$iv;
                        boolean bl = false;
                        Object v = it.getValue();
                        Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                        boolean bl2 = !((Collection)v).isEmpty();
                        if (!bl2) continue;
                        v3 = element$iv;
                        break block1;
                    }
                    v3 = null;
                }
                Map.Entry entry = v3;
                if (entry == null) break block3;
                SshPasswordPrompt.Request request = (SshPasswordPrompt.Request)((Deque)entry.getValue()).poll();
                this.currentUserHostPort = (SshPasswordPrompt.UserHostPort)entry.getKey();
                Intrinsics.checkNotNull((Object)request);
                this.initAndShowCurrentDialog(request);
                break block3;
            }
            SshPasswordPrompt.UserHostPort userHostPort = this.currentUserHostPort;
            Object object = (Deque)((Map)this.requests).get(userHostPort);
            if (object == null || (object = (SshPasswordPrompt.Request)object.poll()) == null) break block3;
            Object it = object;
            boolean bl = false;
            this.updateCurrentDialog((SshPasswordPrompt.Request)it);
        }
    }

    private final void updateCurrentDialog(SshPasswordPrompt.Request request) {
        block2: {
            block1: {
                ThreadingAssertions.assertEventDispatchThread();
                if (!(request instanceof SshPasswordPrompt.Request.Done)) break block1;
                SshLoginDialog sshLoginDialog = this.currentDialog;
                if (sshLoginDialog != null) {
                    sshLoginDialog.close(0);
                }
                this.currentDialog = null;
                this.requests.remove(((SshPasswordPrompt.Request.Done)request).getUserHostPort());
                this.currentUserHostPort = null;
                this.findAndExecuteRequest();
                break block2;
            }
            SshLoginDialog sshLoginDialog = this.currentDialog;
            if (sshLoginDialog == null) break block2;
            sshLoginDialog.repaintOnRequest$intellij_platform_ssh_ui(request);
        }
    }

    private static final Unit initAndShowCurrentDialog$lambda$0(UISshPasswordPrompt this$0, SshPasswordPrompt.UserHostPort $userHostPort) {
        this$0.ignoreUntilRestart($userHostPort);
        return Unit.INSTANCE;
    }

    private static final void showBalloon$lambda$4(Function0 $dialog) {
        $dialog.invoke();
    }

    private static final void showBalloon$lambda$6$lambda$5(UISshPasswordPrompt this$0, SshPasswordPrompt.Request $request) {
        this$0.ignoreUntilRestart($request.getUserHostPort());
        $request.getResult().set(null);
        $request.getLatch().countDown();
    }

    private static final void showBalloon$lambda$7() {
        SshUIUtil.manageSshConfiguration();
    }

    private static final Unit showBalloon$lambda$8(Notification $msg) {
        $msg.notify(null);
        return Unit.INSTANCE;
    }

    private static final Deque handleRequest$lambda$12$lambda$9(SshPasswordPrompt.UserHostPort it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayDeque();
    }

    private static final Deque handleRequest$lambda$12$lambda$10(Function1 $tmp0, Object p0) {
        return (Deque)$tmp0.invoke(p0);
    }

    private static final Unit handleRequest$lambda$12$lambda$11(UISshPasswordPrompt this$0) {
        this$0.findAndExecuteRequest();
        return Unit.INSTANCE;
    }

    private static final Unit handleRequest$lambda$12(UISshPasswordPrompt this$0, SshPasswordPrompt.Request $request, boolean $showDialogImmediately) {
        this$0.requests.computeIfAbsent($request.getUserHostPort(), arg_0 -> UISshPasswordPrompt.handleRequest$lambda$12$lambda$10(UISshPasswordPrompt::handleRequest$lambda$12$lambda$9, arg_0)).add($request);
        if ($showDialogImmediately) {
            this$0.findAndExecuteRequest();
        } else {
            this$0.showBalloon($request, (Function0<Unit>)((Function0)() -> UISshPasswordPrompt.handleRequest$lambda$12$lambda$11(this$0)));
        }
        return Unit.INSTANCE;
    }

    private static final void closeCurrentServerDialog$lambda$13(UISshPasswordPrompt this$0, SshPasswordPrompt.Request $request) {
        this$0.updateCurrentDialog(new SshPasswordPrompt.Request.Done($request.getUserHostPort()));
    }

    private static final boolean isNotNonModal$lambda$14() {
        return !Intrinsics.areEqual((Object)ModalityState.current(), (Object)ModalityState.nonModal());
    }
}

