/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.ui.ColorChooserService;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class XmlChooseColorIntentionAction
extends PsiElementBaseIntentionAction {
    public XmlChooseColorIntentionAction() {
        this.setText(XmlBundle.message("intention.color.chooser.dialog", new Object[0]));
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiElement parent;
        if (project == null) {
            XmlChooseColorIntentionAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            XmlChooseColorIntentionAction.$$$reportNull$$$0(1);
        }
        return (parent = element.getParent()) instanceof XmlAttributeValue && ColorUtil.fromHex((String)((XmlAttributeValue)parent).getValue(), null) != null;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            XmlChooseColorIntentionAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            XmlChooseColorIntentionAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            XmlChooseColorIntentionAction.$$$reportNull$$$0(4);
        }
        XmlChooseColorIntentionAction.chooseColor(editor.getComponent(), element);
    }

    public static void chooseColor(JComponent editorComponent, PsiElement element) {
        Color oldColor;
        String caption = XmlBundle.message("intention.color.chooser.dialog", new Object[0]);
        XmlAttributeValue literal = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class, (boolean)false);
        if (literal == null) {
            return;
        }
        String text = StringUtil.unquoteString((String)literal.getValue());
        try {
            oldColor = Color.decode(text);
        }
        catch (NumberFormatException e) {
            oldColor = JBColor.GRAY;
        }
        Color color = ColorChooserService.getInstance().showDialog(element.getProject(), (Component)editorComponent, caption, oldColor, true);
        if (color == null) {
            return;
        }
        if (!Comparing.equal((Object)color, (Object)oldColor)) {
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            String newText = "#" + ColorUtil.toHex((Color)color);
            PsiManager manager = literal.getManager();
            XmlAttribute newAttribute = XmlElementFactory.getInstance((Project)manager.getProject()).createAttribute("name", newText, element);
            Runnable replaceRunnable = () -> {
                XmlAttributeValue valueElement = newAttribute.getValueElement();
                assert (valueElement != null);
                literal.replace((PsiElement)valueElement);
            };
            WriteCommandAction.writeCommandAction((Project)element.getProject()).withName(caption).run(() -> replaceRunnable.run());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intentions/XmlChooseColorIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intentions/XmlChooseColorIntentionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

